/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.instasearch.indexing;

import it.unibz.instasearch.indexing.Field;
import java.util.Map;
import java.util.Set;

public class SearchQuery {
    private String searchString;
    private int maxResults = -1;
    private boolean exact = true;
    private boolean fuzzy = false;
    private boolean canceled = false;
    private String currentProject;
    private Map<Field, Set<String>> filter;
    public static final int UNLIMITED_RESULTS = -1;

    public SearchQuery(String searchString, int maxResults) {
        this.searchString = searchString;
        this.maxResults = maxResults;
    }

    public SearchQuery(SearchQuery searchQuery) {
        this.searchString = searchQuery.searchString;
        this.maxResults = searchQuery.maxResults;
        this.fuzzy = searchQuery.fuzzy;
        this.exact = searchQuery.exact;
    }

    public String getSearchString() {
        return this.searchString;
    }

    public int getMaxResults() {
        return this.maxResults;
    }

    public boolean isLimited() {
        return this.maxResults != -1;
    }

    public void setMaxResults(int maxResults) {
        this.maxResults = maxResults;
    }

    public boolean isExact() {
        return this.exact;
    }

    public void setExact(boolean exact) {
        this.exact = exact;
    }

    public boolean isFuzzy() {
        return this.fuzzy;
    }

    public void setFuzzy(boolean fuzzy) {
        this.fuzzy = fuzzy;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof SearchQuery)) {
            return false;
        }
        SearchQuery sq = (SearchQuery)obj;
        if (this.fuzzy != sq.isFuzzy()) {
            return false;
        }
        if (this.exact != sq.isExact()) {
            return false;
        }
        if (this.maxResults != sq.getMaxResults()) {
            return false;
        }
        if (!this.searchString.equals(sq.getSearchString())) {
            return false;
        }
        return !(this.filter != null && sq.filter != null ? !this.filter.equals(sq.filter) : this.filter != sq.filter);
    }

    public void setCanceled(boolean canceled) {
        this.canceled = canceled;
    }

    public void setSearchString(String searchString) {
        this.searchString = searchString;
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public String getCurrentProject() {
        return this.currentProject;
    }

    public void setCurrentProject(String currentProject) {
        this.currentProject = currentProject;
    }

    public void setFilter(Map<Field, Set<String>> filter) {
        this.filter = filter;
    }

    public Map<Field, Set<String>> getFilter() {
        return this.filter;
    }
}

