/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.instasearch.indexing;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;

public class ResourceCollector
implements IResourceVisitor {
    private Collection<IContainer> containers = new LinkedList<IContainer>();
    private List<Pattern> excludedPatterns = new ArrayList<Pattern>();

    public boolean visit(IResource resource) throws CoreException {
        if (!(resource instanceof IContainer)) {
            return false;
        }
        if (ResourceCollector.isResourceExcluded(resource, this.excludedPatterns)) {
            return false;
        }
        switch (resource.getType()) {
            case 2: {
                this.containers.add((IContainer)resource);
                break;
            }
            case 4: {
                return this.visit((IProject)resource);
            }
        }
        return true;
    }

    static boolean isResourceExcluded(IResource resource, List<Pattern> excludedDirPatterns) {
        String path = resource.getFullPath().toString();
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        for (Pattern pattern : excludedDirPatterns) {
            if (!pattern.matcher(path).matches()) continue;
            return true;
        }
        return false;
    }

    public boolean visit(IProject project) {
        if (!project.isOpen()) {
            return false;
        }
        this.containers.add((IContainer)project);
        return true;
    }

    public Collection<IContainer> getContainers() {
        return this.containers;
    }

    public void clear() {
        this.containers.clear();
        this.excludedPatterns.clear();
    }

    public void setExcludedDirRegExes(List<Pattern> excludedDirRegExes) {
        this.excludedPatterns = new ArrayList<Pattern>(excludedDirRegExes);
    }
}

