/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.instasearch.indexing;

import it.unibz.instasearch.indexing.Field;
import it.unibz.instasearch.indexing.tokenizers.CamelCaseTokenizer;
import it.unibz.instasearch.indexing.tokenizers.DotSplitTokenizer;
import it.unibz.instasearch.indexing.tokenizers.WordSplitTokenizer;
import it.unibz.instasearch.indexing.tokenizers.standard.StandardTokenizer;
import java.io.Reader;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.KeywordTokenizer;
import org.apache.lucene.analysis.LengthFilter;
import org.apache.lucene.analysis.TokenStream;

public class QueryAnalyzer
extends Analyzer {
    private static final int MAX_WORD_LENGTH = 128;
    private int minWordLength;

    public QueryAnalyzer(int minWordLength) {
        this.minWordLength = minWordLength;
    }

    public TokenStream tokenStream(String fieldName, Reader reader) {
        if (Field.CONTENTS.toString().equals(fieldName)) {
            Object result = new StandardTokenizer(reader);
            result = new WordSplitTokenizer((TokenStream)result);
            result = new DotSplitTokenizer((TokenStream)result);
            result = new CamelCaseTokenizer((TokenStream)result);
            result = new LengthFilter((TokenStream)result, this.minWordLength, 128);
            return result;
        }
        return new KeywordTokenizer(reader);
    }
}

