/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.instasearch.indexing;

import java.util.Locale;
import org.apache.lucene.index.Term;

public enum Field {
    EXT("Extension"),
    PROJ("Project"),
    WS("Working Set"),
    CONTENTS,
    FILE,
    NAME,
    JAR,
    DIR,
    MODIFIED("Modified");

    private String title;

    private Field() {
    }

    private Field(String title) {
        this.title = title;
    }

    public String getTitle() {
        if (this.title == null) {
            return this.name();
        }
        return this.title;
    }

    public Term createTerm(String text) {
        return new Term(this.name().toLowerCase(Locale.ENGLISH), text);
    }

    public static Field fromTerm(Term term) {
        return Field.getByName(term.field());
    }

    public static Field getByName(String fieldName) {
        try {
            return Field.valueOf(fieldName.toUpperCase());
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String toString() {
        return this.name().toLowerCase(Locale.ENGLISH);
    }
}

