/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.instasearch;

import it.unibz.instasearch.InstaSearch;
import java.io.File;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.net.proxy.IProxyService;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;

public final class InstaSearchPlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "it.unibz.instasearch";
    private static final String INDEX_DIR_NAME = "searchindex";
    private static InstaSearchPlugin plugin;
    private String indexDirLocation;
    private InstaSearch instaSearch;
    private ServiceTracker<IProxyService, IProxyService> proxyServiceTracker;
    private boolean debug = false;

    public InstaSearchPlugin() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        this.configureDebug();
        try {
            super.start(context);
        }
        catch (Exception e) {
            InstaSearchPlugin.log(e);
            throw e;
        }
        plugin = this;
        this.instaSearch = new InstaSearch();
    }

    public void stop(BundleContext context) throws Exception {
        this.instaSearch.cancelJobs();
        plugin = null;
        super.stop(context);
        this.instaSearch = null;
    }

    public static File getIndexDirLocation() {
        File indexDir;
        block2: {
            indexDir = null;
            try {
                indexDir = InstaSearchPlugin.getStateDir(INDEX_DIR_NAME);
                InstaSearchPlugin.plugin.indexDirLocation = indexDir.getAbsolutePath();
            }
            catch (Exception e) {
                InstaSearchPlugin.log(e);
                if (InstaSearchPlugin.plugin.indexDirLocation == null) break block2;
                indexDir = new File(InstaSearchPlugin.plugin.indexDirLocation);
            }
        }
        return indexDir;
    }

    public static List<String> getProjectNames() {
        IProject[] projects;
        ArrayList<String> projectNames = new ArrayList<String>();
        if (InstaSearchPlugin.getWorkspaceRoot() == null) {
            return projectNames;
        }
        IProject[] iProjectArray = projects = InstaSearchPlugin.getWorkspaceRoot().getProjects();
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            if (project.exists() && project.isAccessible() && project.isOpen()) {
                projectNames.add(project.getName());
            }
            ++n2;
        }
        Collections.sort(projectNames, String.CASE_INSENSITIVE_ORDER);
        return projectNames;
    }

    public static List<String> getWorkingSets() {
        ArrayList<String> workingSets = new ArrayList<String>();
        IWorkingSetManager wsManager = InstaSearchPlugin.getDefault().getWorkbench().getWorkingSetManager();
        if (wsManager == null) {
            return workingSets;
        }
        IWorkingSet[] iWorkingSetArray = wsManager.getWorkingSets();
        int n = iWorkingSetArray.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkingSet ws = iWorkingSetArray[n2];
            workingSets.add(ws.getName());
            ++n2;
        }
        Collections.sort(workingSets, String.CASE_INSENSITIVE_ORDER);
        return workingSets;
    }

    public static String[] getWorkingSetProjects(String workingSet) {
        IAdaptable[] elements;
        String[] emptyResults = new String[]{};
        IWorkingSetManager wsManager = InstaSearchPlugin.getDefault().getWorkbench().getWorkingSetManager();
        if (wsManager == null) {
            return emptyResults;
        }
        IWorkingSet ws = wsManager.getWorkingSet(workingSet);
        if (ws == null) {
            return emptyResults;
        }
        ArrayList<String> projects = new ArrayList<String>();
        IAdaptable[] iAdaptableArray = elements = ws.getElements();
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IProject proj;
            IAdaptable elem = iAdaptableArray[n2];
            if (elem instanceof IProject) {
                proj = (IProject)elem;
                projects.add(proj.getName());
            } else {
                proj = (IProject)elem.getAdapter(IProject.class);
                if (proj != null) {
                    projects.add(proj.getName());
                }
            }
            ++n2;
        }
        return projects.toArray(emptyResults);
    }

    public static InstaSearchPlugin getDefault() {
        return plugin;
    }

    public static ImageDescriptor getImageDescriptor(String imageName) {
        return InstaSearchPlugin.imageDescriptorFromPlugin((String)InstaSearchPlugin.getPluginId(), (String)("icons" + File.separator + imageName + ".gif"));
    }

    public static File getStateDir(String dirPath) {
        IPath stateLocation = plugin.getStateLocation();
        IPath path = stateLocation.append(dirPath);
        return path.toFile();
    }

    public static String getHomePageLocation() {
        return InstaSearchPlugin.getBundleHeader("Bundle-DocURL");
    }

    public static String getUpdateLocation() {
        return InstaSearchPlugin.getBundleHeader("Bundle-UpdateLocation");
    }

    public static String getErrorReportURL() {
        return InstaSearchPlugin.getBundleHeader("ErrorReportURL");
    }

    public static String getPluginName() {
        return InstaSearchPlugin.getBundleHeader("Bundle-Name");
    }

    public static String getPluginId() {
        return PLUGIN_ID;
    }

    public static String getVersion() {
        return InstaSearchPlugin.getBundleHeader("Bundle-Version");
    }

    public static String getBundleHeader(String header) {
        return (String)plugin.getBundle().getHeaders().get(header);
    }

    public static void log(IStatus status) {
        if (plugin != null) {
            plugin.getLog().log(status);
        } else {
            ResourcesPlugin.getPlugin().getLog().log(status);
        }
        if (status.getException() != null && InstaSearchPlugin.isDebug()) {
            status.getException().printStackTrace();
        }
    }

    public static boolean isDebug() {
        if (plugin == null) {
            return true;
        }
        return InstaSearchPlugin.plugin.debug;
    }

    public static void debug(Object ... msgs) {
        if (!InstaSearchPlugin.isDebug()) {
            return;
        }
        String msg = StringUtils.join((Object[])msgs, (String)", ");
        System.out.println(msg);
    }

    public static void debug(Throwable t) {
        if (!InstaSearchPlugin.isDebug()) {
            return;
        }
        t.printStackTrace();
    }

    public static void log(Exception e) {
        Status status = new Status(4, InstaSearchPlugin.getPluginId(), e.getMessage(), (Throwable)e);
        InstaSearchPlugin.log((IStatus)status);
    }

    public static InstaSearch getInstaSearch() {
        return InstaSearchPlugin.plugin.instaSearch;
    }

    public static boolean getBoolPref(String pref) {
        return plugin.getPreferenceStore().getBoolean(pref);
    }

    public static void setBoolPref(String pref, boolean value) {
        plugin.getPreferenceStore().setValue(pref, value);
    }

    public static int getIntPref(String pref) {
        return plugin.getPreferenceStore().getInt(pref);
    }

    public static IWorkspaceRoot getWorkspaceRoot() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    public static void addPreferenceChangeListener(IPropertyChangeListener listener) {
        if (plugin != null) {
            plugin.getPreferenceStore().addPropertyChangeListener(listener);
        }
    }

    public static void removePreferenceChangeListener(IPropertyChangeListener listener) {
        if (plugin != null) {
            plugin.getPreferenceStore().removePropertyChangeListener(listener);
        }
    }

    public IProxyService getProxyService() {
        try {
            if (this.proxyServiceTracker == null) {
                this.proxyServiceTracker = new ServiceTracker(this.getBundle().getBundleContext(), IProxyService.class, null);
                this.proxyServiceTracker.open();
            }
            return (IProxyService)this.proxyServiceTracker.getService();
        }
        catch (Exception e) {
            InstaSearchPlugin.log(e);
            return null;
        }
    }

    private void configureDebug() {
        try {
            this.debug = this.debug || ManagementFactory.getRuntimeMXBean().getInputArguments().toString().contains("-agentlib:jdwp");
        }
        catch (Exception e) {
            this.debug = true;
            InstaSearchPlugin.log(e);
        }
    }
}

