#ifndef QMIDIMESSAGE_H
#define QMIDIMESSAGE_H

#include <QtCore/QVector>

#include <QtMidi/qmidi.h>

QT_BEGIN_NAMESPACE

class Q_MIDI_EXPORT QMidiMessage
{
public:
    QMidiMessage();
    explicit QMidiMessage(const QVector<quint8> &m, double timestamp = 0.0);
    explicit QMidiMessage(quint8 byte0, quint8 byte1, double timestamp = 0.0);
    explicit QMidiMessage(quint8 byte0, quint8 byte1, quint8 byte2, double timestamp = 0.0);
    explicit QMidiMessage(quint8 byte0, quint8 byte1, quint8 byte2, quint8 byte3, double timestamp = 0.0);

    static QMidiMessage fromCommand(int command, int byte1 = -1, int byte2 = -1, double timestamp = 0.0);
    static QMidiMessage fromCommandChannel(int command, int channel, int byte1 = -1, int byte2 = -1, double timestamp = 0.0);

    quint8 command() const;
    void setCommand(quint8 c);
    quint8 channel() const;
    void setChannel(quint8 c);
    quint8 byte0() const;
    void setByte0(quint8 b0);
    quint8 byte1() const;
    quint8 byte2() const;

    quint32 toUInt32() const;

    void appendByte(quint8 byte);

    void setTimestamp(const double d);
    double timestamp() const;

    const QVector<quint8> message() const;
    int size() const;

    const quint8 &operator[](int i) const;
    quint8 &operator[](int i);

    QString toJson() const;
#ifndef QT_NO_DEBUG_STREAM
    friend Q_MIDI_EXPORT QDebug operator<<(QDebug dbg, const QMidiMessage& m);
#endif
private:
    QVector<quint8> mMessage;
    double mTimestamp = 0.0;
};

QT_END_NAMESPACE

Q_DECLARE_METATYPE(QMidiMessage)

#endif // QMIDIMESSAGE_H
