/* Copyright (C) 1992-2014 David Sugar, Tycho Softworks.
 *
 * This file is part of worldvu.
 *
 * worldvu is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * worldvuvu is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with worldvu.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 *  VU Terminal Database Support;
 */

#ifndef __VU_H__
#include <vu/vu.h>
#endif

#define TERMLIB_HASH_SIZE   997
#define TBOOL   char

#pragma pack(1)
typedef struct {
    /*  key name and link   */

    unsigned char term_link[4];
    char    term_id[11];
    char    term_name[33];

    /*  properties          */

    char    term_rows[4], term_cols[4];
    char    term_startup[19], term_shutdown[19];
    char    term_beep[7];
    char    term_cls[7];
    char    term_eol[7];
    char    term_eop[7];
    char    term_left[7];
    char    term_right[7];
    char    term_up[7];
    char    term_down[7];

    /*  cursor positioning  */

    char    term_cursor_beg[4];
    char    term_cursor_sep[4];
    char    term_cursor_end[4];
    char    term_cursor_vt[4];

    TBOOL   term_cursor_order;
    TBOOL   term_cursor_decimal;
    char    term_cursor_offset[3];

    char    term_cursor_hide[7];
    char    term_cursor_show[7];
    char    term_cursor_big[7];

    /*  attributes          */

    char    term_attr_beg[4];
    char    term_attr_sep[4];
    char    term_attr_end[4];
    TBOOL   term_attr_merge;

    char    term_attr_clear[7];
    char    term_attr_inverse_on[7];
    char    term_attr_inverse_off[7];
    char    term_attr_bright_on[7];
    char    term_attr_bright_off[7];
    char    term_attr_underline_on[7];
    char    term_attr_underline_off[7];
    char    term_attr_graphics_on[7];
    char    term_attr_graphics_off[7];
    char    term_attr_blink_on[7];
    char    term_attr_blink_off[7];

    /*  color               */

    char    term_color_beg[7];
    char    term_color_sep[7];
    char    term_color_end[7];
    char    term_color_fore[3];
    char    term_color_back[3];
    TBOOL   term_color_order;
    TBOOL   term_color_ansi;

    /*  charsets    */

    char    char_shade;
    char    char_solid;
    char    char_top;
    char    char_bot;

    char    char_arrows[4];
    char    char_boxset[16];
    char    char_cards[4];

    TBOOL   key_scancodes;
    char    key_table[20][7];

    char    term_stat_line[17];

    char    term_window_beg[4];
    char    term_window_sep[4];
    char    term_window_end[4];
    char    term_window_clr[17];
    char    term_window_up[7];
    char    term_window_down[7];
    char    term_window_offset[4];
    TBOOL   term_window_cursor;
    TBOOL   term_window_mode;

    char    key_alt_base[4];
    char    key_alt_prefix[7];
    char    key_move[4][7];

    TBOOL   term_color_attr;
    char    term_export_id[13];
    TBOOL   term_wrap_flag;
    TBOOL   term_ansi_keypad;

    unsigned    char    char_stty_break;
    unsigned    char    char_stty_quit;
    unsigned    char    char_stty_start;
    unsigned    char    char_stty_stop;
    unsigned    char    char_stty_eof;
    unsigned    char    char_stty_kill;
    unsigned    char    char_stty_erase;
    TBOOL   tab_stty_expand;
    TBOOL   unicode_encoding;
    char    future[127];
}   TERMDEF;

#pragma pack()

IMPORT  BOOL        OpenVUTermlib(const char *path);
IMPORT  void        CloseVUTermlib(void);
IMPORT  TERMDEF     *LoadVUTermlib(char *name);
IMPORT  char        *AliasVUTermlib(char *term);
IMPORT  TERMDEF     *SaveVUTermlib(TERMDEF *tdef);
IMPORT  TERMDEF     *FirstVUTermlib(void);
IMPORT  TERMDEF     *NextVUTermlib(void);
IMPORT  TERMDEF     *DeleteVUTermlib(char *name);
IMPORT  int         PutVUTermstr(char *str, char *out);
IMPORT  int         KeyVUTermlib(char *key);
IMPORT  void        GetVUCodepage(int cp);


