/* Copyright (C) 1992-2014 David Sugar, Tycho Softworks.
 *
 * This file is part of worldvu.
 *
 * worldvu is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * worldvuvu is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with worldvu.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __VU_H__
#include <vu/vu.h>
#endif

typedef struct
{
    short   edit_left;
    char    edit_move_v;
    char    edit_move_h;
    int     edit_base;
    int     edit_size;
    int     edit_mark_start;
    int     edit_mark_stop;
    char    **edit_idx;
    char    *edit_last;
} *EDITOR;

typedef struct
{
    short   memo_mark;                  /* editor mark line  */
    short   memo_char;                  /* editor cursor position */
    short   memo_width;                 /* editor width of line */
    short   memo_space;                 /* last space field */
    int     memo_base;                  /* current base in list */
    int     memo_size;                  /* size of memo list */
    char    **memo_idx;                 /* pointers to text  */
} *MEMO;

PORT(VUBrowsePort);

IMPORT  int VUBuildBrowseList(char **ptrs, char *text, int max);

