/* Copyright (C) 1992-2014 David Sugar, Tycho Softworks.
 *
 * This file is part of worldvu.
 *
 * worldvu is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * worldvuvu is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with worldvu.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stdio.h>
#ifndef __VU_H__
#include <vu/vu.h>
#endif

FIXEDWINDOW(UserDesktop);
FIXEDWINDOW(AdminDesktop);
WINDOW(SetupProfile);
FIXEDWINDOW(SetupDisplay);
FIXEDWINDOW(SetupAddress);
FIXEDWINDOW(SetupAddress1);
FIXEDWINDOW(SetupXferProtocol);
FIXEDWINDOW(SetupXferNewline);
FIXEDWINDOW(SetupXferArchive);
FIXEDWINDOW(SetupDesktop);
FIXEDWINDOW(SetupPassword);
FIXEDWINDOW(SetupLocation);
FIXEDWINDOW(SetupLanguage);
WINDOW(GetProfile);

PORT(LocationPort);

IMPORT  int     create_setup(char *path, char *title);
IMPORT  FILE    *rewrite_setup(char *path);
IMPORT  void    close_setup(FILE *fp);
IMPORT  FILE    *begin_rewrite(char *pwdfile, char *id);
IMPORT  void    end_rewrite(char *pwdfile);
IMPORT  void    reset_location(char **argv, char *title);
IMPORT  void    reset_session(char *msg);
IMPORT  char    *strint(int i, int z);
IMPORT  int     add_bookmark(char *bookmark);

