/* Copyright (C) 1992-2014 David Sugar, Tycho Softworks.
 *
 * This file is part of worldvu.
 *
 * worldvu is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * worldvuvu is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with worldvu.  If not, see <http://www.gnu.org/licenses/>.
 */

#define ED_PALMASK  0x3f
#define ED_READONLY 0x40
#define ED_NEWLINE  0x80

typedef struct _edlin
{
    struct  _edlin  *ed_next, *ed_prev;
    unsigned char   ed_mask;
    char    ed_data[1];
}   EDLINE;

typedef struct
{
    EDLINE  *ed_current;
    EDLINE  *ed_free;
    EDLINE  *ed_last;
    EDLINE  *ed_first;
    char    *ed_wrap;
    char    *ed_statline;
    int     ed_clineno;
    int     ed_llineno;
}   EDCTRL;

typedef struct
{
    int     ed_lineno;
    int     ed_number;
    int     ed_left;
    int     ed_width;
    BOOL    ed_scroll;
    BOOL    ed_wrap;
    BOOL    ed_dirty;
    BOOL    ed_update;
}   EDOPTS;

#define VUSetEdNbr(vu, flag)    (((EDOPTS *)vu->vuoptions)->ed_number = flag)

PORT(VUViewPad);
PORT(VUEditPad);
PORT(VUTextPad);
PORT(VUMemoPad);
PORT(VUMemoCtrlPad);
CONTROL(VUMemoControl);

#define MEMO_CONTROL(obj, r, c, l, w)   {VUMemoControl, (char *)obj, r, c, l,w, 0, 0, NULL},

IMPORT  void VUUpdatePad(VU vu);
IMPORT  int VUScrollPad(VU vu, int lines, BOOL flag);
IMPORT  int VUNewEditText(VU vu, char mode);
IMPORT  int VUAddEditText(VU vu, char mode, char *text);
IMPORT  int VURewEditText(VU vu);
IMPORT  char *VUReadEditText(VU vu);
IMPORT  int VUInsEditText(VU vu, char *text, char mode);
IMPORT  int VUDelEditText(VU vu, int lines);
IMPORT  int VURepEditText(VU vu, char *text);

