topic "1 Overview";
[ $$0,0#00000000000000000000000000000000:Default]
[{_}%EN-US 
[s0; [*R+184 ScatterDraw Overview]&]
[s0;2 &]
[s0; [2 ScatterCtrl`_Demo package does a visual review of ][^topic`:`/`/ScatterDraw`/src`/ScatterDraw`$en`-us^2 S
catterDraw][2  and ][^topic`:`/`/ScatterCtrl`/src`/ScatterCtrl`$en`-us^2 ScatterCtrl][2  
class features. Here there are some screenshots:]&]
[s0;2 &]
[s0;2 &]
[s0;i150;O0; [*2 General view]&]
[s0;2%- &]
[ {{4561:5439f0;g0;^ [s0;# [2 Demo program contains control samples listed in left table.]&]
[s0;#2 &]
[s0;# [2 All of them have different export possibilities like:]&]
[s0;#i150;O0; [2 Print Preview]&]
[s0;#i150;O0; [2 Export as PNG]&]
[s0;#i150;O0; [2 Export as JPEG]&]
[s0;#i150;O0; [2 Export as EMF]&]
[s0;#i150;O0; [2 Copy to Clipboard]&]
[s0;#2 &]
[s0;# [2 ScatterCtrl uses Painter or Draw as selected in Painting Mode.]]
::= [s0;= [*R2 
@@image:2386&1548
(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)
]]}}&]
[s0;2 &]
[s0;2 &]
[s0;i150;O0; [*2 Basic Test]&]
[s0;2%- &]
[ {{4548:5452f0;g0;^ [s0;# [2 ScatterDraw lets to show different data series changing various 
parameters like color, line width or dot style.]]
::= [s0;= [*R2 
@@image:2075&1605
(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)
]]}}&]
[s0;2 &]
[s0;2 &]
[s0;i150;O0; [*2 Functions]&]
[s0;2%- &]
[ {{4548:5452f0;g0;^ [s0;# [2 Using PlotFunction() it is possible to directly draw functions 
instead of just stored data. ]]
::= [s0;= [*R2 
@@image:2106&1633
(BBICmAEAAAAAAAAAAHic7Z0NtBXVefdRGrEiYYWIaylWa8pH23CxWvyg9VVEaw0YRUxi3qy+MSySkhjLmxbaJIhUSJolIGgIEomJoq0xhahvtLpCaxu/EoyCSILGr6CGQPi4CHiBKwh7v+c5eC7nzp05Z/aZPbP3zPz+Z/0X9wznY85/9uz5z7Of/WytAQAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAwF/ccMMNulevXpGU/3eFnTt3Vr//lltu6bG/LvcLAAAAAIfgs48I8wz4CAAAAMAf+Hxd9nnfAAAAABD/Wh31uuD22vPrrrtOzZkzRw8fPlz17dtXnXHGGeqhhx7q9t533nlHf+lLX1KnnHKK+v3f/301ZMgQtXDhwm6fE4yNRO3Hbbfdpi+66CLVr18/dfrpp6s77rgjdD/j7NePfvQj/ed//ufV///ABz6gzjvvPPX444/HFxUAAAAoCdLyEX369FFBH3DEEUeol19+ueu9H/vYx3q8RviLX/zCyEf84z/+Y+jnfO1rX+uxn83267nnntNHHnlkj9eIp3jzzTcT6w0AAAAUCY3yI+LkJUT5CLk2L1q0SG/btk2vXr1an3DCCdVr87e//e3q69atW1d93fvf/35133336d/+9rd65MiR1dcsXrw48juD29rb26vfJdf+73//+7qjo0P/4Ac/qHoB8Qy/+c1vjPZr/vz51dd99KMfVVu3btWvv/66Pu2006qv+c53vpPSUQAAAADyCVMfMXPmTFX//hkzZqgwH3H55Zd3e93EiRNVfYzgrrvuqr5u0qRJ3V4Xtm+NfMSDDz5YfT5hwoRun3PllVdWv088hcl+/fjHP+7yG2effbb6xje+oX/3u9/FVBMAAAAoF0zHNWQMoX77F77whVAfMWXKlG6v++pXv9rtdTfeeGP1dV/5ylcS+Yha/OCf/umfun2OPJftc+fONdqv2r4dd9xxXWMbv/d7v6c+9alPKcnnAAAAAMBhxPURcr8eFj8YP358qI8Ixi2C37N06dLq86uvvrqpj7j++utV1OfU4gdR8Yhly5YZ7VcN+/btq75X/EPNU9x5550NNQIAAADKhrg+4t57762+btCgQUpyESW/QHIKevfuHeojmuVR/PKXv+zKj3j22Wf1xo0btcyzqB+LqMUsxLts3rxZK6V6fI7shzyv5Ue8/fbb1X2V5zIHRD7XZL+++c1vVp+3tbWpV199tbpfl1xySXW/anNJAAAAAHAIcX3E+vXrtVyXgzkUtW2mPkIgMYTg54lPkVxJwb/92791+781a9aEfk5tbCVImd/Z7HcGt7/44ouhczqOOeYY9etf/7oFhQEAAIDiwqTW03//93/rc889Vx177LHqwx/+cDUHMSrPMo6P6Ozs1Ndee636gz/4AyVxCan/IHGKGvbs2aM//vGPV//vj//4j9UjjzwS+jkSp5A5GGPGjKm+Vmo/3H333bF+Z9h2qRUxevRo9cEPfrD6efKbn3zyyRhqAgAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAD5wOWXX6769u2rPvShD6lHH320a3t7e7seOXKkGjx4sFq/fr3DPQQAAACAr1i2bJnetm2bnjt3rj711FNVbfvUqVPV7Nmz9bx58/TEiRNVo88AAAAAQLmxdetWPXDgwC6/MGLECLV69Wq9Zs0aPWTIEHwEAAAAAEKxe/dufcMNN+jPfvazXX5hwIABauPGjXrTpk26f//++AgAAAAAhKJXr176hBNOUJs3b+7a1rt3b7Vv3z4tlL9r28eNG6fk9XVU71FDCCGEFar6+DYoPjo6OrTkQowZM6bruPfr10/JWId4C4lN1LaPHTsWzwAhhLApBV/84hf16NGjqzFv6B/l2Fx77bVWvMSWLVv0scce2+UXJCdi7dq11fyItra2SF9Zay/vfvrTSku7eY/7b75Zd3Z2xuLPf/5z9dhjj2nh6tWrVdz3+cLLL7+8Stf7gQZo4JpokF8NpO+t9cOvvPJK7H54/4IFXf2+OvFE1blrVzcfUbteAT9h4/jIfA3xENOnT1ejRo3q8guTJ09WModjzpw5etq0aU19ROfevfqAxDMC7SlOO3z77bf1T37yk1obVvLc9TkFIYRlYct9cKWPl76+6/6x4ilkOz4iP7BxfK644goleZRnnnmmeuGFF7q2b9iwQQ8bNkxJDYnt27dHvr/LR0ib2rmze5tavDh2O27VC0MIIUxG6XNbiQnvv/XWHrEI2Y6PyA98OD7dfIS0qy9/uctHHDj//Njt8c0339S1dvzTn/5U7d271/m5FZd5jWOiARqgARpIXyt9bq3/lb447nsPnHfe4fvGSt9f246PyA98OD5BH9FZaYPqyCOrbUv17q06Y7bJYFt+/fXXnZ9fRe030AAN0AANapS+tqV7uAZ9PT4iP/Dh+PTwEZ3RHjW19gwhhNCYSe7fGsWe8RGHcfnlSvXtq9SHPqRU3dIT3sCH4xPmI6LGzNJs0xBCCM3Y8r1bML8ykAsX10fcd5/8f7ZctizLK+Sh79u2Teu5c7U+9VTlXU0NX31EVA5vqu3aIfMWx0QDNEADNEgUiwiZ61n//3F8xP33d31E5nzggayvlLL2hNYDB+IjwhDqI2K0szTaNv0GGqABGrhmXjR47rnnlJVYRMh9YhwfIddyn3zEW2/JehBKtbcf3rZ7t9YnnaSU/F8SyOeIBJ/9LD4iDFE+olncqxHzGJOAEMK8cN26dV0eQvjGG2/Efu/+qVOb1gmKO64hMf+sxzVkLCUK11yj1I03Hn6+cKHWU6b0vPZH+ZPo66TWJ5ygVN3SE97Aax/R2foc0GBMQnyz6/MOQgiLQPEM9R5CPEXc977z3HNa9elz+P7wlltCX5fXPMvXXtP6lFOUOnBAa+HgwUpV5EqMjg6tZ8/WeswY4hFhaOQjeswLMvC8Sdp61sxLHBMN0AANyq1Bonu0PXv0wZEjuzzEwTPPVLIt7LV59RGC8eOVkpjF8uVaX3WVvev+li1aH3ssPiIMDX1EZ/c5oAfb2oy8QDD2ZlIfhX4DDdAADdCgO5PU+5M1k7rGM/r0Ue88/3zka/PsI558UuvRo5UaNUqpVavCX2MyriFjN+Ihpk8/9Jnp7Xlr8OH4NPMR+xct6ib0u1dfbeQl8r6GF4QQ+sKW1x8IrnkwbVrD9+bZRwjOOkupCy6wc82/4gql+vdX6swzlapbesIb+HB8mvkIWb8ryVqgrOEFIYTJmaQvNZ1/l3cfcfrpSj38sOu9yAY+HJ+mPkKYYC1Qoe9rePkcx0QDNEADNBC2uhZXK/WA8uoj9u/Xev58rS++2L/xh7Tgw/GJ5SOECdYC9X0NL1/7DTRAAzRAA2GStbhaqU+cVx9xzDFKjRun1IYNrvckO/hwfGL7iE5780DzUJsKQgh9YZKaPK2sl5RXH1FG+HB8THxEq2uBJj0PIISwrEx0H9Zin42PyA98OD5GPqKz9bVAfY5J+BjHRAM0QAM0ECa5B2s1hoyPyA98OD6mPqLVtUCTng9l6jfQAA3QAA2Eie6/EqxtgI/ID3w4PqY+IslaoD7HJCCE0De2vBZXZ+trLQrxEfmBD8fH2EckbJ++xiQghNAnJlmLK8n9nhAfEQ9KFgabNKnnHNNZs7Q6/nilBg1SesWKxh8Sd7GwCPhwfFrxEUniZT6u4eVTHBMN0AAN0CDp+kRx1vRsxNg+QhayyHrBTylU7QNefVWrc89V6uSTlX7ppW7/paZMUdVi2hX/poYObVzLogXvUI/c+ojO1vN3bJwjRew3XBMN0AAN/NAg6b1W3DU9GzGWj7j//uiFKtLmAw9kfKXsCfWJTyj9xBNa3323VldeGe4VduzQqm9ffEQUE6wFKkwUs4MQwoIy0divwZqejRjLR8i13Ccf8dZbWg0YoHR7++Ftu3drddJJSv6vFajPfU7phQsPPXnkEa0uvfSQJ1i1SqtLLjn0t1JaiebPPtvzA1au1Oqcc5r6CLmGygIe+uWXjfcx1z6iM9laoMIkOUQQQlg0Js1FN1nTsxFjj2vIGEPW4xoylhIByVfQN954eEPFA1THGHpe+OIt+Cl1nCvXNr1tm1Znn630pk2Hvueii5SuX0z0ySe1uvDCHt+jJkxQesmSyP2touLzqt9z9dVK/dVfGdfzzruPSLoWqC/zN1zHMX0gGqABGrjXIFEswnBNz0bMbZ7la69pdcopSh84oIVq8GCl33gj2Wc+8MChHIe77zZ734oVhzzIwYOHtzXyLC+9pNWxx5bORyRdCzTxeVOAfsMXogEaoIFbDRLHIhLMowsytz6iAjV+vKrGLJYv1+qqq5Kv1/Xoo4f82Q9/GP89khcxfLjS69bFf8+LL2p13HHl8xHChGuB+hKTgBBCl0x0T5VwnmeQefYR1TGG0aOVGjWq+9hDPeKOa0jOxRlnKL1hQ9f4RhxU54JWjmNsVI61+tu/Va34Hh+OT2IfIQzG0wzbsA8xCQghdEWfYhHCXPuICtRZZyl1wQWJYxHqk59UeunSQ0/uukurj3883mfKcTjqKKX69JE8leavfd/7VDXn4ne/M95HH46PFR+RsB27jkkQy0UDNEADlxr4FIsQ5t5HnH660g8/7Ho34qE+f6IF+HB8bPmIpG3ZZUyCvhMN0AANXGngWyxCmFsfsX+/1vPna3XxxcnzInICH46PNR+RsD27jklACKELJpr/nkIsQphXH6GOOUapceOq+QxlgQ/Hx6aPSFIvW0ieBISwTExajy/J+suNmFcfUUb4cHys+ojOZPWyXa29QSwXDdAADbLWwMb6APW1AKXvtbVv+Ij8wIfjY9tH9KiXXXme9bnla7/hM9EADdAgOw2s3DNV+sokfW0j4iPyAx+Oj3Uf0ZncI7P2BoSwyEw8hlt5/UGpc9Ri7LcZ8RH5gQ/HJw0f0WPMbudO489g7Q0IYRGZOKc8rI5wpc+1uY/4iPzAh+OTho8I1qU6cOGFxl45y/kbxHLRAA3QICsNksYi6tfiamVdozjER7SOa9Q1alLlEdw+q/I4Xh2vBlUeK/SKhp/RK/BoBB+OTyo+wlJbz2r+Bn0nGqABGmShQeL7Iwv3aHEY10fcV3nckPFjWeXhK16tPM5V56qTK4+X9Evd/m+KmqK26C16QeUxVA1tWN+imXeoR5F9hI01vKgpASEsEhPHIoI1eloYM47DOD7i/sojeN+c1eOBysNHfEJ9Qj2hn9B3Vx5XqitDvcKOyqOv6ouPiMuEa3jZOO8ghNAHJr4vSqnmVBjj+Ai5lvvkI96qPAaoAapdt3dt2115nKROUvJ/tvA59Tm1UC+s/v1I5XGpurTqCVZVHpeoS6p/q8pjpBqpntXP9nj/ysrjHHVOUx/RW/VWZ1YeL+uXG+5P4X2EMOEaXlnEJIjlogEaoEHaGliPRViqORXGuOMaMsaQ9biGjKVEQXITbtQ3dj2X672MJ/S47kU84mBn5dGm2tQ2vU2frc5Wm/Sm6vaL1EVKvEQNT1YeF6oLe3z3BDVBLdFLGn7HnspDvudqdbX6q8qj0WtL4SMstP+0YxL0nWiABmiQpgZ5ikUI85pn+VrlcYo6RR3Qhx6D1WD1hn4j0WeG+QyJh0iOg4xfmEDyK8WDHNSH1+Zq5GMkx+JYdSw+wsI5QJ4EhDDPTDqPPctYhDCvPkIwXo1XErNYXnlcpa5KZb2uRyuPE9WJ6of6h7HfI3kRw9VwtU6vi/2eFyuP49Rx+AhL5wF5EhDCPDJxXb2MYxHCPPsIGU8YrUarUZVH/ThDPZKMa0iuxRnqDLVBb+ga34gDmQtaaQGxf8feyuNv1d+qZl7Ih+OTlY+wHZOwufYGsVw0QAM0SEMDG3X+s45FCPPsIwRnqbPUBZVHGp/9SfVJtVQvrf59V+XxcfXxWN8jPuUodZTqo/poYbPXvk+9T0nOxe/07xq+1ofjk5mPsHA+pLX2Bn0nGqABGtjWwMq9T8I89VaZdx9xujpdPawfdr0bLaM+f6IZfDg+WfoIG/E51t6AEOaBNtbQkDpTWccihHn1Efsrj/mVx8Xq4lRiET7Ch+OTqY/otBOjY+0NCKHPTGUNDcM6fkmYVx9xjDpGjas8JHehLLBxfGbNmqWPP/54NWjQILVixeGa3e3t7XrkyJFq8ODBav369ZHvz9pH9IjTTZtmHOvbs2eP1VwJYrlogAZoYFODxPMzFi1KfQ2NRsyrjygjbByfKVOmqC1btugFlfv8oUMP1+yeOnWqmj17tp43b56eOHFiZIwncx/R2X3tDdWnj3pnzRrjzwjmSiQZ36DvRAM0QANbGtjomw6cd17XvdbBtrZMPYQQH5Ef2Dw+O3bs0H37Hq7ZPWLECLV69Wq9pnKNHjJkiFc+onPPHn1w5MjD50nlb9lm+jmMb0AIfaKV3Mo339TqyCOr/aPq3VvJ86x/Bz4iP7B5fFauXKnPOedwze4BAwaojRs36k2bNun+/fv75SMqlBiExCK6xjduuSXxOUt9KgihS9qoc7P/y18+vJ7n+ednHosQ4iPyA5vHZ8KECWrJksM1u3tXfOy+ffu0UP6ubR83bpyqtZF61sfxgnG9tJ7vnzq163xpP/rorpxLk88LO2+z2v+iPa9t82V/XPz+oBY+7V8Wz8v++5M8j7qvMfq8Sh8ofWHX/dXixU5+Dz4iP7B1fCS/sq2tTR08eHjOab9+/dTWrVv15s2bq7GJ2vaxY8d64yOi5oGafJ6cuw899FC3c9eXfiVvz4PXEtf74+L3B7Xwaf+yeF7235/kef04q/RJtViEyeeFzWdz8XvwEYcRd86CK9g4PpIXMXz4cLVuXfea3ZITsXbt2mp+hHiMqPe7Gteo0cY8UGpmQwhd0kpdGwf1r6MY10fcd999Xf+fFZctW5bommmKuHMWXMGGj5g0aVK1/QYxefJkNXfuXD1nzhw9bdo0b32EjXMnzZrZEELYiLbq7Lqofx3FOD7i/vvv7xHXzooPPPBAouumCeLOWXAFGz5CND3qqKNUnz59tLCGDRs26GHDhimJx2zfvr3h+536CEvnT5JzORjXKyPRAA3QwFwDa7VsPIpFCOP4CLmW++Qj3nrrreoYvoxD1LB792590kknKfm/VhF3zoIr+DDu5IOPsHUOBWOLcb0EfScaoAEatKKBrbnnPsUihHHHNWSMIetxDRlLicI111yjbrzxxq7nCxcurNZYirruBRmGqDkLvgAfYf88Yv0NCGEWtFYLz9FaXI2Y1zzL1157TZ9yyinqwIEDWii5kXJckiBqzoIv8OH4+OIjbMb1qE8FIUyT1nKyHK7F1Yh59RGC8ePHK4lZLF++XF911VWJr/tx5yy4gg/Hxxsf0RkSk6j4dBvneLP6VMRy0QAN0MBEAytzxByvxdWIefYRTz75pB49erQaNWqUWrVqVehrTMY14s5ZcAUfjo9PPiIY3xOf3upnmZzn9J1ogAZoEFcDW3V069cZEma9Flcj5tlHCM466yx1wQUXWLnmx52z4Ao+HB+vfITFc4ua2RDCNGglFmHxnikN5t1HnH766erhhx92vRuZwIfj45uPsBnroz4VhNAmZR5hfW5ly7EIS2O4aTGvPmL//v16/vz5+uKLL/Zu/CEt+HB8vPMRQsk9GjMmce5R3FwoYrlogAZo0EgD6Uvq70sS3Zt4VisijHn1Ecccc4ySNaRkLKIs8OH4eOkjhJbmQsWpT0XfiQZogAaNNAh6CKuxCA/mZwSZVx9RRvhwfLz1EWHnW4uxv1brU0EIYTCuWfMQNvIifIxFCPER+YEPx8dnH2EzF4n6VBDCVhiMRUiOREuf5WmtiDDiI/IDH46P1z6is+f8jSTzq6PqUxHLRQM0QIMwDWzO+7LZl6VNfER+4MPx8d1H2Mq5bNQn0HeiARqgQZgG1uZ87djh9TzPIPER+YEPx8d7HyG0OKbIXFAIYRxai0WE3Qt5Ns8zSHxEPLz88svqpZde6jHHVMbNn3rqKfWzn/0s0VqjceDD8cmFj+hMr2Z2y3XxIYSFppV1ejyufd2IcX3Etm3bqtfMLClrZvkAaQ/SRsQryN/1eOWVV5TUspD5p08//XSqtSzwEQa0mHMZnAs6c+ZMYrnEs9EADbo0kD7BRl62z7WvGzGOjxAPEZwLmxXlu11Dcvd3Vq5Lsg6o/B32mnfffVc/8cQT+AiPaPOcrL/XeOihh9SECROc/z6X5PqBBmhwiNIXSJ+QOGbpee3rRsyjj5Br9pNPPqnk3xoOHjyoJV5Qv80EMmbx29/+tvq3rK3xi1/8ouoJOjo69Nq1a7v8wapVq9Tbb7/d4/27du3Sq1evxkf4RIsxQtbfgBCG0cp4Rqf/ta8bMe64howxZD2u0SgWIfkKv/nNb7qeiweQMYbg66L8SRAHDhzQzzzzTHWMQvzAvn37qtuff/55JV6iBolLyLbg+3/5y1+qTZs2Re6vDeAjWqDF+RvW5oVDCAtBa3VmclD7uhHzmmcp+75y5cqu67nkJrzzzjuJPlN8i3yOjF+YQPIrxYMk+vIY8OH45M5HCC3N37Bapy7nJJ6NBmXXwGbd2zzUvm7EvPoIgcQA5NovsZIXXngh8XV8x44d1euESU6GjKOIh9izZ0/Sr28KH45PLn2ExfPUZt38PLPM1w80QINg7vW3vvWt1nMZch6LEObZR8gYw5o1a5SMQ9SPPdQj7riG+IFnn322GtOojW/EgeRVyH5kAR+OT159hK1z1eo6fhDC3FHuGW3OBc97LEKYZx8hkLxH8RJJP0fiGbXxjEbzMoJ4ry2pxx9/XAvThA/HJ7c+wvL5KrkR9V6CuhIQloO28iqrLEAsQph3HyExBJlfUQb4cHzy7CNsnbO1WG4wtlmmtbzKGs9Gg3JrEHbOJ9GgCLEIYV59hFKqWvspbO5EUeHD8cm1jwg7b1uYW1Xfb1i9N8kRy3b9QAM0iBrPaFmDLVu6r8OV01iEMK8+4vHHH1dS4yHpHI08wYfjk3cfYbvWi+2xUgihn7R2z9DR0e1+Ju+xCGFefUQZ4cPxyb2P6LRfe7bM4xsQloHW6kR0dvbwEHmPRQjxEfmBD8enCD4irM6liZcIi2OWbXyjTPFsNCi3Bs3qRBhpEMjR6vIQHR3Of2cS4iPyAx+OTyF8hDBBzeywfqNs4xtluH6gARoEY41htaZMNAjGIiRHwvVvtEF8RH7gw/EpjI8QWqyZHbfPgRDmg9bvDQoyxzOM+Ij8wIfjUygfIbRUM7tGm7VyIYTuaHussihzPMOIj2gd//Ef16gf/WhSyNpgs/Tcucer+fMHqddeW2Ht+3w4PoXzEWHnd5O5oM3imDZzsnxl0ePZaFBuDUxyp2NpYPl+xTfG9REvvnhfRc8bMuULLyzL8hJphO3bX9Xf+965asGCk1V7+0vd/u+RR6ao3bu36JUrF+iFC4daq2+Bj0iJhnNB4/QbRc+7LOr1Aw3QwHQ8o6kGMn5a6VOKGosQxvERv/rV/ZXtvZzwV796IOtLZSwsW/YJ9eabT+i1a+/W//7vV4Z6hc7OHfpf/qUvPiIHDM4FjZtzGcWy5V1CWBRaH8+w3Lf4yHg+4gGvfERn51v6xhsHVI5ve9e2/ft36/nzT1Lyf7bw4IOfUz//+cLq36+++oi+555Lq55g06ZV+l//9ZL3/IHSS5aMVBs3Ptvj/Rs2rNS3334OPiIPtJxzKaSuBIT5ovVzdscOq3XvfGXccQ0ZY8h6XEPGUqIguQlPPXVj13O53st4QvB1Uf4kDt55Z6devLhN7dmzreIHzlYdHZuq2++66yIlXqKGN998srLtwh7f/YMfTFCrVi2J9V1xgI9ImTHHME1iuUUd3yhiPBsNyq1Bq2vvRWoQdm/SQh3+PDCveZZvvfWavvnmU5RSB7Twm98crHbufCPRZ4b5DImHSI6DjF+YQPIrxYModTDRPnXfP/fHp9A+ojNezqVJ3xkc33j66acL4SWKdP1AAzQIxiFMPH+oBgnq0+SRefURgnvvHa8kZvHCC8v18uVXpbJe1/r1j+qbbjqx8j0/jP0eyYu49dbhauvWdVb3xYfjU3QfEZpzmfC6H9ZHvf7667oIfgLCvDM4v0oo52eSz7Rde9935tlHyHjCnXeOVt/97qhu4wz1SDKuIbkWt912htq1a0PX+EYcyFzQN954LPbviAsfjk/hfURYH1C5r0j6mWn0VRDCZEzF45ckJ6KeefYRgu985yy1dOkFqcQili//pHr++aXVv59//i69bNnHY32P+JTZs49SX/taHy20BR+OTxl8RLP1N1qN5SaJnfrGosSz0aC8Gtgac+ymQYlyIuqZdx9x222nq1deedj1bmQCH45PKXzEe/1B1Phmkr6z1Vwu35jn6wcaoIHQVg50vQZlmOMZxrz6iIMH9+uf/Wy+vvvui1OJRfgIH45PaXyEMIW5oELmg0Lolqmcg4b17IrEvPqIr3/9GHXPPeOquQtlgQ/Hp1Q+IqRvsFXPtqjzQSH0nWnViDOtr18k1vuIa6+9Vo8ePbrregX9ohwbOUb4iGwZ7B+uvPTSxLHcvNe7zHM8Gw3Kq4H4dcmDsOnh5fdLn1Dk9TOasd5HPPzww9XrlOvrJQynHJtHHnkEH5E1AzGJ5wYOVDb6zjyvM5636wcalFsD8QoyD6Peu9saz7j8ssuqfUKR189oxnofAUAzlNJHdKaXP8U64xCmT/EQwXnXVs61ktWbiiI+ApigrD4izflceAkI06PEItKIQzSbH14m4iOACUrrI4Rh9WUs5UfmzUvkJZ6NBmhQn9MslLnXNj43jXp1eSU+olyQc+j222/XZ5xxRrf5su3t7XrkyJFq8ODBav369ZHvL7WPSLnvCHoJn+eD5uH6gQZokNoc68A9xZqBA63dU+SR+IjyQOJ7o0aNUtddd50KHvOpU6eq2bNn63nz5umJEydG1uQou49IO5bJfFAI7TC1OVElrVnZiPiIciJ4zEeMGKFWr16t16xZo4cMGYKPaNKPpJVblff5oBD6wrQ8eVlrVjYiPqKcCB7zAQMGqI0bN+pNmzbp/v374yMasBrLveyy1O5J8jAf1Pd4NhqUVwPxC8GciLTGMyRHykcNsiY+opwIHvPevXurffv2aaH8Xds+btw4VWsj9aw/b4LnUWmeR6zrZ+PzFy1a1K0flOfOf2/geW2bL/vj4vcHtfBp/7J47tPvr9WIeOihh7qdO9/61reUle+LGM/w5fe7fI6PKCeCx7xfv35q69atevPmzdXYRG372LFj8RENnofFOG19ftQcDp9+P8957svzqBoRtj4/ajzDl9/v8jk+opwIHnPJiVi7dm01P6KtrY1xjbhMaS2vGvM2HxRCF0ytRkSNEbFHeIj4iHIieMwnT56s5s6dq+fMmaOnTZuGj2jAoB9Pay2vGn30Ej00KCHRwB8N0qoRUWWT+Rm+aOCS+IhyIWyMQrBhwwY9bNgwJTUktm/f3vT9rtutS4b1G/VreQk7t2yx+p2+eQn6TjTwRYNU667EmJvlgwauiY8AJsBHRHDXrm4xia64REeHte/wzUtA6JqpnhPUvY5NfAQwAT4imsGYRBZjHD7XvIQwTaY9P7pH7Vo8RCTxEcAE+IgGccyOjh5eIo1adz7UvCSWiwYuNZD8h3oPYb1eWzCvcsyYyM+nHeAjgBnwETH6jc2bu3kJ27ndwZqXTz/9dOZegr4TDVxpEIxDWPfShnWvaQf4CGAGfEQ8pl07N6wvZYwDFp3BcT2h1I2w+R3UvTYnPgKYAB8Rkxms5RPWp5J7CYvKYHsX7ywewmosgjoRLREfAUyAjzCIY2bQJ0kMIlh/JwsvQSwXDbLUIOghJB/C+lhei96fdoCPAGbAR5j1G1nESMPWJUrbS9B3okFWGmQy3znBGr60A3wEMAM+wpCBe5w0alTVyJxQWDRmsvYtdSISEx8BTICPaIGButlp5m75MCcUQhtMfW6nMMxDVJ67/u15Iz4CmAAf0VocM6xGVRr3PFnNCSWWiwZpapD63E5hlIcw/B7aAT4CmAEf0WK/8V6NqiziElnMCaXvRIO0NMhibqewR73KFjwE7eAQ8RHABPiIhNy5Ux8cOjTV+aBC5oTCPDKTuZ3CsHqVjAG2THwEMAE+wgIzmqPuak4ohK0wk7mdwgxqu5SN+AhgAnyEnThmVjXz0poTSiwXDWxqkOVatrbPPdoBPgKYAR9hqd/I+J7Idj9N34kGNjTIvPZJCmvf0A7wEcAM+AiLDIxvSN5Ell4itbgxhDGY6bhbpZ0H4xCMZ9gjPgKYAB9hl2F9m8zrkPkdaXxfWB4b9apg1sw0Dzhkfmd1PEPOMw+0KALxEcAE+AjLcUwHfZyNPpxYLhq0qkHWXjZtr047wEcAM+Aj0uk3so65Jo0p03eiQSsaZD62lsHYIe0AHwHMgI9IkSnkgDWii/W9YHmZ5ZyMKpnfmRnxEcAE+Ih02aPGXgbrBWXev8NS0YlfTbB+JzQnPgKYAB+RchzTUf9nGm8mlosGcTRwVQstSz9OO8BHADPgIzLoNxzFY03y3+g70aCZBs5qswfHB6XmNe0gVeIjgAnwERkx49oSNbIuB7RBJ/OLqRHhjPgIYAJ8RHYMna+WwRhHWCw6rTUXYbEobSTYbjKpd0aNCKfERwAT4CMyjGNG9I1Z5F6G5cbVxyaI5aJBvQbN2kuqDDlP0q7nRjvoTnwEMAE+Ivt+Q2IQ9WMcWeaeh41zyPViwoQJpe87uX4c0mDmzJmh8ausxsOCcbtqPkSGYxm0A3wEMAM+whEr/aLkSLgY9w2LVVNPGwrDfGamY2CBPKKqh2DNmMyJjwAmwEc4ZLDPlDpVGfaZ5GDCRu0hc29JnSlviI8AJsBHuI1j9pgX/+lPZ+olyMH0ox24pLNcynpW/IL4aB/qTJW1HdQTHwFMgI9w3G+E5JRlPR4s14ulS5eWPjZRtutHVC7lokWLsjvu783tDOYLZZF7TDuIJj4CmAAf4QEd56fXGJWDmel9KcyEUXGoTL1j1Pwlicl5oFGZiY8AJsBHeEJP5stH5WA+88wzqoxjHUVj2PF1NZblqp4KbE58BDBBrb3MmPFuaTls2PerdL0fwocuWditb93V70T1z1/ZnbkG99zzYmjevmx3rVEZ2kEaDDumP/7xT9WSJRsy1+CGr3RU23atnW/94LBM2jntIB7xEcAEtfYSuA2GDtm/185uG1b0+it1RK8eoYrUecUVG/Xy5T1j38IJE36rjzjCvVawMY86SulLL90UGn+46abnlfx/1vskbfk/e13U9cW/7XWi6tPrHedawXriI0B84CP85Bd7Leq24Xu9JjrxEu97n3/XIdic4vGa+UAn+1Vpw9KW6zdKW3etFwwSHwHig3ENT3ndfr3qtM9062/luWx3tU9RcfEHH3xW3Xbbb9xrBqtcsuQ3kTkQLselZNzilVMv6tamnz1tYmHHyfJMfAQwAXmWHs/zynBOaFwNGuXp5X2eqLftwIBhc25M8mRT0SBqbqen8zKK0A6SEh8BTICP8LzfiJoTKnntFudjmmoQNW8wzzWsvG4HDSjzct98881Qb2c6b9e6Bo3mdno6nziv7cAm8RHABPiIHNDTvrjR9Uv4yiuvMFc0RYq2Emfw1s818sAe6AejiY8AJsBH5Ic+x4aj1nfy5ppWIDYaW/JmfMmDOq2wdeIjgAnwETmLY4asQ2CjhrANDXJxfct5O4jya7ZqhVnRIMRDuI6dFa0dpE18BDABPiKH/UZIP500VmxTA7mWyZhGo/GO1157zbsYhY/tQDQSrRrpKWNLtmqX29DA9dpzPmiQd+IjgAnwETllTtZYbhajYMyjYLpt3qx7jGXkyEPAQ8RHABPgI3LMHTu65UscHDrUSy8hbJY/4e11MUM2y1v1enzovbmdwZxKX9sjbEx8BDABPiLfcczItY4M7wGz0CBOjN7luIeLdlDTpNG8iyw1aUkDT9aYy3M78I34CGACfETO+w1Lc0JdXUOb3XtnOX80Cw1qMYdmXspVjMZYA0/WvM9bO/Cd+AggaG9v1yNHjlSDBw9W69evj3wdPqIYDJsTWr0nnD/far2qNBjXT/ico9ns98WJOdicd5E6ZRyj0raC7Y25ncUgPgIIpk6dqmbPnq3nzZunJ06cqKJeh48oEEPmhOYpXz7uuEeYr7A5Z8HGb2jld/jyG4rezmBz4iOAYMSIEWr16tV6zZo1esiQIfiIBixUHDNinKPZfaKPGjSbPxp1L1+7jtcY9/psssZI8Dta3U/f4g4NNYhYJ6NoHsLHcyFr4iOAYMCAAWrjxo1606ZNun///k19xIwZM0rLYcOGVel6P2zy+r/+a31D5bjW85/79VPXX3KJnnHddbnT4LbbbtN33HGH/t73vhf7el3j//zPf+q77/6SWrLkf6ubb75cR/GrXx1VZYPXqKVLP6Pvuef/Vj73J0b7IJR9X7x4sZ45c6ZzPaMY2Q4qbWbmaaepYJsSSltzvd+ZaFAi4iOAoHfv3mrfvn1aKH/Xto8bN07V2giEeeUVV1yhP/OZz1T53e9+Vy1b9n11773/qOU6X8+bbhqsvvGN49QNN1SueZZ5551Xq+D31TxGZb9Ubf9kX13rBWErBOVGv8q959atW/XmzZursYna9rFjx+IjYK55xBG99Fln9dKjRx/i5z/fS/3DP/RKxSu0ysp+qdr+yb7KPrvWDUJTgnJDciLWrl1bzY9oa2tjXKPsccyvfEXPPPXUbnFpiVPXxjj81uA6ff31f61nzjyv8u//askvzJrVX/3Lv5ycaFxjwYLLEnkV2ffrrx9X+T1f9UDTcHZrByFjGfVtpqj0+1zIhvgIIJg8ebKaO3eunjNnjp42bRp5luRVNVw/yT8N9uqnnlqg//M/p8e+dt9004lq8eLT1KOPztD1fPrpxXr37l3W2oHsV/A7Wt1P+Sz5re71DmgQth5cgXIpbbSDIhMfAQQbNmwQT62khsT27dsjX4ePKBmjag9On36odpCz68TeruuzyTVZXmviFdJmvccw/R3Of4PMx6i0gYMjRqjQ9elL4CHgIeIjgAnwESVkhJdwc70Q/zA/9thAzTccuo/3QMsYrHmLxYtHKIlFxIlVZB6n8KpNQNfERwAT4CNKGsd0ft2I7x/EO2ThG7JoBxJvkLhD3FiFaJS6n4hoC11rtbhuqxmzlP1BgPgIYAJ8RLn7DYljy5hG+l4i/riFq5iDi3YQN1bRXROLxyVqnOvWW3XnLvfjRC5Y5v6gRnwEMAE+AlaZ6vVkr77vvk83vf8+dO/tgRaOeChWcWvTGIVomchLvJcHkY1/hHkkPgKYAB8Bu9gsvm18fYk3dlF2/xDG+LoZHhPn41kwD8RHABPgI4hjdtMg8XWm+XxNX3MlfWwHccaCJIYRa55HjGProwa0g+yJjwAmwEfQb4RpEDX/rzrWEboWefPYQ+J4fOnbQfT4UMN5HhFrfHeb75sbDWgHWRAfAUyAj4ANGWuN6Ob5D4xd2KORX2ONb9gC8RHABPgI2JRRa5H/Xi/9zIyPNBy/8G3sokgUbRvN83j6ihOVOvEEPAQ0Jj4CmAAfQRwzrgZdsfEjKv7hrF76poi1sfIae8hrO2g0z+Ou/9NLid/rNiZVQA1oB3aJjwAmwEfQb8TXoHEOxP+7vJfaP/8mh7W1S9wOqjkQN1WPQY/ciWlHqsWzB8WqkZlrDWgH1oiPACbAR8B4DM+BkJjEtyf3Uj8/izpGmTOiDsTPz85vriv0g/gIYAJ8BGzE3bt3RsbM77xzjNrdsSNyLqHM9Th42mmO1/8qIBvMv6jPgfjpT2/WUbkTmdTbhrklPgKYAB9BHDNcg726+XXo8PvjXNd89xK5aAcNakCE5UA0yp2o+sCKT8ydBrSD1ImPACbAR9Bv9NQgeh5ns7h4o7oT0bUn/KDX7WDnzupYUaR3CNSB6MmIcamKTxS/WDumXmtAO8iM+AhgAnwEPMzwPMruNY5iftauXU2ve+/OmKEZ84jge7kPolFTX2bwuY3yZBnrgDXiI4AJ8BHwEMPvV8Ni30aMEYf3PU6RKWPkPtgYJ4oasyIPEwrxEcAE+AjimOIT/uEfBqZ6TYlzbXQ9z8NZO2iw/mZk3qql47506YU9jvvf/d3JpfYSZe8PhPgIYAJ8RJn7jehcyrRqSdVi9Y2umbXrZdbjHpm2g5jeoSv3YfHi1PxV2FhH4jhUjlne/uAw8RHABPiIsjJ8HCPruHbsOEXK19LUWZfvEMc7tJL7YLs9BHMwYXmIjwAmwEeUjdG5lIeuGW72q9k8j7BYhdd5mi34hnjzLtJtG1HzdMjBLBfxEcAE+IgyxTGjcynHj7/UDw1knsfixUbX3vr5H0n8RUvtoM4vdH13C/vuzjv01GDSpLZS52CWpz+IJj4CmAAfUY5+IyqnrnZt8FWDOHMfTfxFFPfPuE6fv/z9avTy/kr+jvUeQ78Q3CdfvEPYudCsvbjezyw0cL0fLomPACbARxSd2edSpsb3YhVN8zSP6KW/dW3lN/5zPM68oZeqnAXdHrIt7vvlu+Q78+gbmpEczHISHwFMgI8oMv3IpUyLeyu/4Zb/maBn/vd5XZzx6Lk9PEFWD/nu+n2RfdtbAJ3JwSwf8RHABPiIosYxG/X9+dRgZ+dOvXj/Yj3j3Rl6+v7pzvyC6UP2VfZ5wf4F3vuK6HZQbE8aT4PyEB8BTICPKGK/0bPPbxaL9lEDuebKtVeuwSMOjlAnVh6tXsPjsO32tirjvr5VL+Ozr2jWDsLGyIrmJXw8F7ImPgKYAB9RNPb0EHnq52sxB9NrdNAvyDU6q32ueZ1W/YW83kdPEcWwHMw8tTHYnPgIYAJ8RHGY1/69FneIE3OQ/z/t4GnKhV8wZc1fmPiK/HiKfPtV2Jj4CGACfEQR4pjhczJM+nUXGsi1cv7++bGvrxKn2NWZXj3LtDUw9RWiTdZ+wkwD8/GzPDD//UFy4iOACfARee837OS/ZaFBfb5Do2tpfcwhy3hD1u1AflscT5GFh2pdg+LN5ch3f2CH+AhgAnxEnmk2J8MVTeIOt+6/NZPrpW+M4ylq/sq/cY/yzOUoC/ERwAT4iLwyHzFlud59+t1PN73nFp/hel99YRzPJZr65SXKMZejLMRHABPgI/IYx7Sf42ZbA5l3IbGFRrF63/IkfWsHcea82s6hSKpBXnN9fW4HLoiPACbAR+Sr30irn7ahQZx5Fz7HHXxuBzLW08yX2RjvsKNBvudy+NwOsiI+ApgAH5EXJp+TkRbj5D/4GIfPI+OME7mY59GT+Rh3g+HERwAT4CPyQH/z2Bpd1+rzAt1rWCzmw7eF5wE/9dQCvWdPh3MNYTTxEcAE+Aj/45gSh0h7ToaJBrXxi0bzC/I478L3dhBG28fBvgbhHli8hGvtitQObBMfAUyAj/C73+jo2NFtLGPhwqGpxIbjatAsru5z/kOe20EcRsUoJC508/6bY411pKVBmBf2dYwj7+3ABvERwAT4CJ+5tzqm7EPf2ywHwo84Oozj81wdp507N3fzEpIv7HpcDoYTHwFMgI/wlT3jwa7qSzW6NtXmCbjXC9az0bwZl54vGJfwIccH9iQ+ApgAH+FfHDN8bufVyoUGUgfiwgMXenUtKks7sEHT45e+Bv7PCS1iOzAlPgKYAB/hU7/RaG5ndho0qwOR5xyIfLQD+4wakwrWnchGA7/nhBa5HcQlPgKYAB/hC/2Y29loDKOIMYgy0a9jy5xQn4mPACbAR/jBLOZ2NmPUdaaW7+9aI5jeMfbFS/g+J7QsxEcAE+Aj3Mcxs5rb2YiXXX6ZPvm/Tu5xfcljHYi8toMsGVV3QtqAtIUs98W3OaFlagdRxEcAE+AjXPcb7uZ2NqonVcYxjDJeP6LiE1n7R5/mhJaxHQSJjwAmwEe4pLu5nX7Ft6FLNhvPyqothM8Jda9PGYmPKBd2796tb7/9dn3GGWeo+u3t7e165MiRavDgwWr9+vWR78dHuGLY/Ld053bWiIeAfrYJd+cE7E58RHmwd+9ePWrUKHXdddep4DGfOnWqmj17tp43b56eOHGiivgIfESnizhm1Bz69L876nox7N5hqm1Jm/NjUa524B+lDbz/1+/vMd/XpZfIOt+YdoCPKCuCx3zEiBFq9erVes2aNXrIkCH4CG/6DXd1eMI8RO36QN/J9aNeg7D6VVl6ifqcIeHOnVtoBxkSH1FOBI/5gAED1MaNG/WmTZt0//798RFe0J2HcHtdgHlkI9+Z9ndLrnGwHtuhuATtNQviI8qJ4DHv3bu32rdvnxbK37Xt48aNU7U2Us96/x304zy38fyySA+R5vdLn992W5s+uv3obtcDmd8XVcOQ5zyvbz/B+cAD1wxUl155aerfL3Ukwuqy+aRPUZ/jI4qL+ut+2P/Vo1+/fmrr1q168+bN1dhEbfvYsWPxEZk/v0z/3d+d3M1DyPPOlK/jUbkQwRoBtdfXPsO9Xm6eB+l6f1w8D/v9YbVFxJfW5nKktT9S11K8xPTpR3c7d6699mTli15FfY6PKCeCx1xyItauXVvNj2hra2NcowGD55FtZr3GYdQa343qUqatQR6IBtEaNJrPkfZa5GHr1qWZe0k7YFyjrAge88mTJ6u5c+fqOXPm6GnTpuEjHDFYq1Lyx9L2EGH9/ZgDY5TkSLjWA+ab4kPdrEXurl5bGYmPKBfCxigEGzZs0MOGDVNSQ2L79u1N3++63RaT2fZ9ZVrjG7qjq3YW9OSHal6616OIxEcAE+Aj0opjZjcPXvruqPvEuGt8E8tFA1MNwsbO0o57BccI0zinaAf4CGAGfEQa/UZ2dfmixjFM7w3pO9GgFQ3C2p/4WVm3paMzjfW/068tQTvARwAz4CNsM9talRKHiJtLCWEajPKy4iXS+L7o2hLutSgK8RHABPgIm8y2ztSOzh3dxjKGHhxKLiV0xjBPm1Z7DK8twVoctoiPACbAR9iLY2Y5v1PuAWUs2lafTSwXDWxosLlzczcvIfmYaeRe1mpLpBGXoB3gI4AZ8BF2+o0s53eGxZGTjmXQd6KBLQ2CcYk053HIGMfChUOtzomiHeAjgBnwETaY3fzOsDl3V79LPBf6w6zX5WA+qH3iI4AJ8BHJmcVctKi5ndI/u/79EAYZ5iXSnBOaxTlYJuIjgAnwEcnimDt3bu7Wf6VxL2RrbmdaGhSFaGBXg6g5obV1Oezuu72YIO0AHwHMgI9otd/Y2+MeKI3xjEZ9sXsNikU0sK9BFh64xuD4huRNtHI+0g7wEcAM+IhW2HN+p1Dyx21+T9axYQjTYlZjcmHeXs5Lmd/hWoM8ER8BTICPMGcWfVXWuWoQps1scoSz8fhFJz4CmAAfYRbHtBU7bcYs586ZalBUokH6GqQxZzmMScYcaQf4CGAGfIRJv5HN/M5gLR8Zy0g7DkHfiQZZaWC7hloUW82Bph3gI4AZ8BHxmfbcstrczqxqC0PoilnVdGc+aGvERwAT4CPiMe1aN1mvdQSha0atMWc39pZdjbgiER8BTICPiBPHTLcvyn7t5VY0KD7RIFsNGs0Jtfk9pvcAtAN8BDADPqJZv9Ez/9tmbNSXuZ30nWjgSoOwOaG253GYjG/QDvARwAz4iEYMWwfcbv+W9bwMCH1k2JxQu/M4GN8wIT4CmAAfEc3wdcDtfX4w1yyLeRkQ+sq053GEj29wvoURHwFMgI8Ij2OmvQ649I+So+7LvAxiuWjggwZBby0xCpveOs69gWsNfCA+ApgAHxHWb6QXA41atzONWjzJNCgf0cAPDYJjfXbzhZqPVfqggWviI4AJ8BE9mdac86j8dPu1gSHML9Ofv5Ru7nQRiI8AJsBHdGeadSKi5su7/s0Q+sb066mQd9mI+AhgAnxEfRwzvb4lq/p9yTVwvy9ogAY1plnfNeqewTcNXBAfAUyAjzjcb6Q5npHFegI2NHC9H2iABkEG15uR3Etbnx12zvuoQdbERwAT4CMOsdU1fZoxq/UNISwyg3EJezlFjG+EER8BTFB2H7FnT4d+6qkFLa8x3Izp9X8Qlodp+vG0187JI/ERwARl9xFBDyGUbTY+O2z9b9e/N4rEctHAdw3SHB8Mjm9ce+3J3p6rWRAfAUxQZh+xe/eubvchNQ8hMYokn5vH9b99vn6gARrUmF6+cvo18PNEfAQwQZl9RDAWsXPnlsSfyfrfEKbLMI9up7YEdSVqxEcAE5TVR0j+Q30swtZYRnp9HIRQmK5XJ+9SiI8AJiinj9hbzaWq9RXTpx+txo//aOLP9b1GRCP6Hs9GAzQIMq2xw/HjL632CWXOu8RHABOU0UcEc6omTWpL3HfmoUZEI+bp+oEGaFBjGrUl5PdLn1Dm8Q18BDBB2XxEcDzD1r1G8N6IGhEQZsN0zr2w8Y1dzn9rVsRHABOUzUfU51baGvsMW+vY9e+EsCxMKxaYVg5VHoiPACYok4+I6heSxHKlv5I8iLyOZ9SYt3g2GqBBPcO8vPiLpBr0vO8oR0wCHwFMUB4f0T23sr5PaKXvlPkXkh9e33fleTwjr9cPNECDGoPjGzKnoxUvUa9BsMZMWWIS+AhggnL4CPvzwsVDBOedUfMaQncMmw/aqpeoZxp1ZnwnPgKYoPg+wn6dOhm3KEocAsIiMcpLJPnMtOre+kx8BDBB0X1EcI5nmIcwieVKPyVjr/X91JbO/N+f5DmejQZoUM8wL2ESKwzTIM11eHwkPgKYoMg+IphXKfO44vYbUSzq/M4iXD/QAA1qTLI+aJgG0esCFzPvEh8BTFBkH2F7jifzOyHMD9OYDyq5EWWISeAjgAmK6iNs51nnvV4lhGVkGt6/DHNB8RHABEX1ESbnepxYblHHM0w0KDrRoJgamJ67zTQow1xQfAQwQRF9hGkdumb9Rho1/H1jEa8faIAGQtNYYhwN0qiL6xPxEcAExfMR0fWmTFmrNVXvIRjPgDB/tD2+kdY6Pb4QHwFMUCwfYbfeVFitKdnm/ndCCE0ZHN9IWjcuOKe8SGuC4iPKhVmzZunjjz9eDRo0SK1YsaJre3t7ux45cqQaPHiwWr9+feT7i+MjWq83FRbH3NW5q0etKfEQEqNw/1vts4jxbDRAg3rGrSsRX4OwNUGLEavER5QLU6ZMUVu2bNELFizQQ4cOVbXtU6dOVbNnz9bz5s3TEydOVFHvL4qP6FlvKn4Nu7B+IxiLKEKtKVMNykY0KL4GcepKmGjQ0bGjkOMb+IhyYseOHbpv375dfmHEiBFq9erVes2aNXrIkCGF9hHh9aZar6kfrHvNWAaExaHtOdxxaubmjfiIcmLlypX6nHPO6fILAwYMUBs3btSbNm3S/fv3L7SPsJk7Hax7LX2MjHG4/o0QQnu0m3dpfx1A18RHlBMTJkxQS5Ys6Xreu3dvtW/fPi2Uv2vbx40bp2ptpJ71cbxgXM/n5zIXY/r0o7vN8UzyeWFzzX36vWk+r23zZX9c/P6gFj7tXxbPy/T7o+pKtPZ5l3XLlZA+qTZPzJffa/IcH1Fc1F/36yH5lW1tbergwYNd2/r166e2bt2qN2/eXI1N1LaPHTu2UD4irN5Uq58XdY/i0+9N83nwWuJ6f1z8/qAWPu1fFs/L9Pujxjda/byoujW+/F6T5/iIckHyIoYPH67WrVvXbbvkRKxdu7aaHyEeI+r9eR7XMK031YjUvYawfLRdV6Io9anwEeXCpEmT1GOPPdZj++TJk9XcuXP1nDlz9LRp0wroI+zVm0qyNiCEMN+0WfO+KPWp8BHlghzro446SvXp00cLa9iwYYMeNmyYkhoS27dvb/j+PPoIWzVgxEOc/F8nN51TXnQGY5tlJBqUU4NgLPLo9qPVpVde2vLnFaE+FT4CmCCPPsLmnO3gvYjEJVz/Phcs4/UDDdCgxuD4xsDnBqq9Lc8dD6tPla85X/gIYIL8+Qh7NeSCfYfck7Ted0AI80yb9xQ2c7dcEB8BTJAvH2FvnjZ5lRDCesatmx2Xec65xEcAE+TJR9isGxe892i7rc3573PJssaz0QAN6hmWL9Vq3mWecy7xEcAEefERNs/JYN1rGQstc98pLPv1Aw3QoMbLLr9MD1wz0EpN27zWzMZHABPkxUfYjBHWr8HFeAaEMEh7a+zks2Y2PgKYIA8+QnKdbeUssQYXhDAO7d1v5G/+Bj4CmCAPPiKs9nUrnxO1BhexXOLZaIAGQQ2C9xxJal3mbf4GPgKYwHcfYSsW0ahmJX0nGqABGoRpYLPWpa37oSyIjwAm8N1H2Dj3bM/nghCWgzbnh9scn02b+AhgAp99hK3zjpqVEMJWaXMtr7zEJPARwAQ++wgb51xwjDOsZiWxXDRAAzRopEHwXqTVeGZeYhL4CGACX32ErbykODnX9J1ogAZo0EgDm2sC5yEmgY8AJvDTR9hZE5w5nhBCW7SVK5GHmAQ+ApjAPx9hp25L1BxP978PQphX2sqV8H3tDXwEMIFvPsJWHVmT+VrEctEADdAgrgY25oL6vvYGPgKYwCcfYevcMq0fQ9+JBmiABnE1CBvfaCXW6fPaG/gIYAKffIStWB/rZ0AI06Sd3Ct/197ARwAT+OIjbOUekVsJIcyCwfuV1vKv/Fx7Ax8BTOCLj7BVt7KV3EpiuWiABmhgqoH0LTbuWXxcewMfAUzgg4+wEYtIMr+bvhMN0AANWtGgPiYhjy2dW1r6Tt9qSuAjgAl88BFJzyHWz4AQumAwJlGLS3R0dhh9jm81JfARwASufYSN88dWzVoIITRlMCbR6hiHTzEJfAQwgWsfkfTcCVs/w3QfiOWiARqgQasaSOwh6CVaybv0KSaBjwAmcOkjbOQX2ZjjSd+JBmiABkk1kNyIosQk8BHABO58RPI1NGzlS0MIoQ0mnQvqS0wCHwFM4MZH2Km/Ymf+NoQQ2qGNexsf1t7ARwATuPARNurB2oxFEMtFAzRAA1saJI9JuF97Ax8BTJC1j7B1jtiMRdB3ogEaoIEtDWzc47heewMfAUyQtY+wEbOj9jWE0Gcmv89xu/YGPgKYIEsfYatuZSu1ryGEMCvaGXd1t/YGPgKYIEsfkUbdyri1rxuRWC4aoAEa2NbAxpx0V2tv4COACbLyET7XraTvRAM0QAPbGgTHXyWO2srnuKgpgY8AJsjKR9iuW9nqOQkhhFnRxr2Pi5oS+Ahggix8hI3zwEaMEEIIs6StsdisYxL4CGCCLHzE00/fajUWYXt+BrFcNEADNEhLA/ESsu5Pkvug4L3Y008vTlUDfAQwQRY+4nvfO6+r/a9Y8WWjuF4W8zPoO9EADdAgTQ12dO5IPC4rfWetH73jjvNTHdfFRwATpO0j2tvfqLT7I6vtf9as3qq9/U2j9wfHF23Mz4AQwqyZtC+TvjNJX2pCfAQwQbo+Yq++9dbhLXtocishhEVh2PiGaWw1SWzXhPgIYIL0fETPemySJ2HyGVnlVhLLRQM0QIMsNEia69Uz1yydPhEfAUyQlo9IWh8+y9rX9J1ogAZokJUGSWpmZ7WGFz4CmCANH5G0rVP7GkJYVCatmZ3FGl74CGCCNHxEkrW40qp9DSGEvjDZmG36a3jhI4AJbPuIpDWn0qp93YjEctEADdAgSw2S55Cnu4YXPgKYwLaPSFJ3zdX8DPpONEADNMhag6T3TGmu4YWPACaw6SOSxiKofQ0hLAttjOGmVS8bHwFMYNNHJGnTSXOPIIQwb0xaUyKtNbzwEcAEtnyE7VhElvMziOWiARqggSsNks5xTyMmgY8oFyrtXfXt21d96EMfUo8++mjX9vb2dj1y5Eg1ePBgtX79+sj32/IRSdbich2LoO9EAzRAA5caJKspYX8NL3xEubBs2TK9bds2PXfuXH3qqaeq2vapU6eq2bNn63nz5umJEyeqqPfb8hFJ6rW6jEVACKFrJr2Xsr2GFz6inNi6daseOHBgl18YMWKEWr16tV6zZo0eMmRIqj4iyVpcrmMREELoA5PcT9lewwsfUT7s3r270oZu0J/97Ge7/MKAAQPUxo0b9aZNm3T//v1T9BHJ1uLyIRZBLBcN0AANXGuQ9J7K5hpe+IjyQY73CSecoDZv3ty1rXfv3mrfvn1aKH/Xto8bN07V2giEEEIYRVA8RB3fjo4OLbkQY8aM6fIL/fr1UzLWId5CYhO17WPHjg36CPUenbdZCCGE/hCUC1u2bNHHHntsl1+QnIi1a9dW8yPa2tqajmuUGWiABgI0QAMBGlQ1qN5fut4PkA1kvoZ4iOnTp6tRo0Z1HffJkycrmcMxZ84cPW3aNHxEA6ABGgjQAA0EaIAGZcMVV1yhJI/yzDPPVC+88ELX9g0bNuhhw4YpqSGxffv2yPfTXtBAgAZoIEADNBCgATCB5F1KzoTr/XAJNEADARqggQAN0AAAAAAAAAAAAAAA5AN79+7VH/vYx5TMF120aJHr3XEKielJXa+y4Ve/+pX+y7/8y+p6LVdeeaXav3+/613KDHHXoykyZs2apY8//ng1aNAgtWLFCte74xTPPvtsqfMDHnzwQX3yySerk046ibENEBuf+cxn1De+8Q39zjvvuN4Vp1i1apX+wz/8w1L6iO9+97v6iSee0K+//rr+kz/5E3Xvvfe63qXMEHc9miJjypQpSuZ+LViwQA8dOrSUGtRwzTXXqCOPPLKUGrz88sv6wx/+sHr11Vdd7wrIEaR29p/+6Z+W8pwJ4lOf+pT60pe+VEofUQ+5ptx0002udyMzxF2PpgzYsWOHlpiU6/1wBWkHM2fOVGWNR3zxi19U3//+913vBsgZpAbFVVddpU477TR18cUXq3fffdf1LjmBXEO+8IUvVD1E2X2EtIMyxbbjrkdTBqxcuVKfc845pdVAxvSkLZTVR0gsUvo/GeN66KGHXO8OyAkkjvlnf/ZnSq6jUnNCYvtlxPjx49W6det02X3E888/r//oj/5IlWmMK2o9mjJiwoQJasmSJa53wwmk7UuemPxdVh8hOXK33nqrljw5yRVzvT/AP8j1sVZjpHatlJqXf/M3f1NtL5///OfV4sWLne5j2gjTQGqIn3/++ar2/0X3EWEaCA4ePKj/4i/+Qi1fvtzh3mWPqPVoygaJQUkdfWkHZYTU9fvJT35S/busPuLoo49Wv/71r6t1kgcOHFjacwGY4a677pJ1crt8xMKFC13vUuaQXPXgGjVF9xJhmD9/frf158uCuOvRFBmSFzF8+PBqTK6s6BWyZmHZIHnmEpcRH/GBD3yglOcCMIfU0D7uuOOUjIvKvLdnnnnG9S45RRniEWGQ64fEtA8cOOB6VzJH3PVoioxJkyapxx57zPVueIMyegiBtIO///u/V7fccov+yEc+UspzAbQGmfMp3lPaj+t9cY2y+gj5zZIb0KdPHy38+te/7nqXMkPc9WiKDLluHnXUUV3Hv+woq4+Qc0FicpIjVb9mEwAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAOQN/x9JVfbL)
]]}}&]
[s0;2 &]
[s0;2 &]
[s0;i150;O0; [*2 Parametric Functions]&]
[s0;2%- &]
[ {{4548:5452f0;g0;^ [s0;# [2 While PlotFunction() functions just return the vertical axis, 
PlotParaFunction() functions return the XY coordinates of every 
point.]&]
[s0;#2 &]
[s0;# [2 This options lets full freedom inserting XY series.]]
::= [s0;= [*R2 
@@image:2110&1645
(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)
]]}}&]
[s0;2 &]
[s0;*2 &]
[s0;i150;O0; [*2 Formatting]&]
[s0;2%- &]
[ {{4548:5452f0;g0;^ [s0;# [2 ScatterDraw lets to insert X and Y labels, XY scaling and 
range, point format and size and standard or user defined axis 
labels formating.]&]
[s0;#2 &]
[s0;# [2 In addition SetMouseHandling(true) lets to use the mouse to 
zoom and move the graphs in X axis.]]
::= [s0;= [*R2 
@@image:2090&1625
(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)
]]}}&]
[s0;2 &]
[s0;2 &]
[s0;i150;O0; [*2 Dynamic]&]
[s0;2%- &]
[ {{4548:5452f0;g0;^ [s0;# [2 ScatterCtrl is not a static control and it easily lets to 
include moving series.]]
::= [s0;= [*R2 
@@image:2090&1550
(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)
]]}}&]
[s0;2 &]
[s0;2 &]
[s0;i150;O0; [*2 Logarithmic]&]
[s0;2%- &]
[ {{4548:5452f0;g0;^ [s0;# [2 Versatile axis scaling and labeling through cbModifFormatX 
and cbModifFormatY lets to include not only time and date axis 
but also logarithmic ones.]]
::= [s0;= [*R2 
@@image:2087&1594
(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)
]]}}&]
[s0;2 &]
[s0;2 &]
[s0;i150;O0; [*2 Operations]&]
[s0;2%- &]
[ {{4548:5452f0;g0;^ [s0;# [2 Series dynamic handling is easy. This demo lets the user to 
add and remove series at run time.]]
::= [s0;= [*R2 
@@image:2087&1526
(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)
]]}}&]
[s0;2 &]
[s0; &]
[s0;i150;O0; [*2 Secondary Y axis]&]
[s0;2%- &]
[ {{4548:5452f0;g0;^ [s0;# [2 It is possible to add a secondary right side vertical Y axis 
and scale data series to it. All secondary axis texts are in 
][/2 italic][2 .]&]
[s0;#2 &]
[s0;# [2 In addition SetMouseHandling(true, true) lets to use the mouse 
to zoom and move the graphs in X and Y axis.]]
::= [s0;= [*R2 
@@image:2090&1633
(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)
]]}}&]
[s0; &]
[s0; &]
[s0;i150;O0; [*2 Big datasets]&]
[s0;2%- &]
[ {{4548:5452f0;g0;^ [s0;# [2 Big datasets are hard to handle. However there are two functions 
that speed up dramatically ScatterDraw/ScatterCtrl response in 
X axis sequential datasets like time series:]&]
[s0;2 &]
[s0;i150;O0; [2 SetSequentialX: Indicates that the data has been sequentially 
inserted following X axis]&]
[s0;i150;O0; [2 SetFastViewX: Indicates that it will be viewed a point 
per horizontal pixel. This point will be the average of all data 
that is in that pixel]&]
[s0;2 ]
::= [s0;= [*R2 
@@image:2098&1345
(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)
]]}}&]
[s0; &]
[s0; &]
[s0;i150;O0; [*2 User Graphs]&]
[s0;2%- &]
[ {{4548:5452f0;g0;^ [s0;# [2 It is easy to create new series and mark plotting routines.]&]
[s0;#2 &]
[s0;# [2 This a simple sample of deriving SeriesPlot and MarkPlot into 
new user plotting primitives.]&]
[s0;2 ]
::= [s0;= [*R2 
@@image:2128&1646
(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)
]]}}&]
[s0; &]
[s0; &]
[s0;i150;O0; [*2 Trend Lines]&]
[s0;2%- &]
[ {{4548:5452f0;g0;^ [s0;# [2 It is possible to fit a user data series into a known equation 
linear (LinearEquation), polynomial (PolynomialEquation), Fourier 
(FourierEquation) or others.]&]
[s0;#2 &]
[s0;# [2 Just declare the equation type and fit it to the data series. 
This equation behaves as any other DataSeries so you can have 
full access to it including adding it to ScatterDraw and ScatterCtrl.]&]
[s0;2 ]
::= [s0;= [*R2 
@@image:2149&1235
(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)
]]}}&]
[s0; &]
[s0; &]
[s0;i150;O0; [*2 User equation]&]
[s0;2%- &]
[ {{4548:5452f0;g0;^ [s0;# [2 User entered equations by text can be plotted. In addition, 
as they are also Dataset, raw data series can be Fit() to user 
equations.]&]
[s0;#2 &]
[s0;# [2 UserEquation is based on ][^topic`:`/`/ScatterDraw`/src`/EvalExpr`$en`-us^2 Eval
Expr class][2 .]&]
[s0;2 ]
::= [s0;= [*R2 
@@image:1461&1098
(BCADWAIAAAAAAAAAAHic7J0NtB1Vefcjl4iSxEgMFCS0QJNglcRKSRtcaq804dVa+QjQrKIWI5QASmoNVQIKmta2CX5VaFpKbW2tCvRtpdoX9a2toXWVLmiE8EJMpAY05pOkxEICAbPnZZ/TuZlz7vnYM7Nn7+eZ+T1r/VYy59577sz/7r2f57/3njlJQhAEQRAEQRAEQRAEQRAEQRAEQRAEQRAEQRAEQRAEQRAEQRAEQRAEQRAEQRAEQRAEQRBEiPjwhz+cTJgwofVvka83Nfbu3dvS5FOf+tTYa2hFEARBEARBEIMD/1EseumCVgRBEARBEAQxOPAfxQJdCIIgCIIgCCJ/FPEff//3f5/83M/9nJk0aZI56qijzBve8AZz9913d/zcM888k1x55ZXmJ37iJ8yMGTPMFVdcYZ5++ulx7/u+973PLFq0yBx//PHmrrvu6nkOw94r/Z5ly5aZl7/85eaYY44x73rXu8wHPvABkz33ftfa6/UHHnggOeuss8xLX/pSM23aNPP617/efOELX+j4/iz2tX7v/yd/8ifJggULzJQpU8xrXvMa8+d//uc9f/91111nVq1alZx66qktbU877TTzla98pacmBEEQBEEQBKEx8vqPb3/728lhhx1muutvWy9///vfH/u5xYsXj/uec88913S/b/a9/v3f/73nOQx7LxsXXHDBuO+ZOHFiIf/xX//1X4n1MN3v9zzmP/7jP3L5j9/+7d/u9T7J7/zO74z7/UccccS4733BC15gNm3a5PCXJAiCIAiCIAj5kdd/fPzjH28dv/WtbzW7du1KHn300eTVr351q27+0z/909b3fOc732nV6vZ1+3XrS+x6iX3Nfi37vrbmXrduXbJ+/frkueeeG/f7Xd7rwQcfbL3XyMiIueOOO5Inn3wyufPOOwv7j8997nOt4zlz5pgtW7Yk9jp/5Vd+pfVen/3sZ/u+V/dru3fvbvkH67Hs2ok9r9tuu63luex1/+AHP+j4Ofu9N998c/L4448nVpPjjjuu9Tv/+I//uMBfliAIgiAIgiDkxUc/+tFW7fvBD37Q9Pr6hz70oVYNbL/Pxte+9rWxWvkXfuEXzO/93u8l27dv7/iZv/qrvxo335/y13/9163vSWvuc845p+fvzfNef/EXf9E6vvDCCzve69d+7dd6+o/rr7++4/vstffyJY899ljr+VZ2H1a6NrFy5cqO9xrkP7785S+3ju3+suz7nn/++a33sl5kkBZLliwx3WslBEEQBEEQBKE5brnlllbt+973vrenD7D3VHTPwf/BH/xBMn369LG9Qocffri56KKLjL0Hw8bv//7v9/UMH/vYx1rfk9bcl1xyyUD/4fJe9p4Je2zv98j+bLr3qdt/2Nez32fvJ8l+38GDB8dq/177rLLvNch/pGtF73//+zt+nz22r69evbrj56zW2e9bsWJFT19EEARBEARBEFrj7/7u71q171ve8paePiDdd5TO1adx4MCBxO51sr4j9SJ2HcLGrbfe2npPe09Gv9+b1tzLly8f6D9c3uuLX/xi63vsuWRft3vEsvW7XUfo5XnsvSTZ77P3wdtju/9pzZo1yf3339+6T76X/7DrQ93XlH5PulbUb/3D6pf9ue51GZ6xRRAEQRAEQdQtNm/e3Lpvwt5PYWvsf/3Xf01+9KMftWpuWw9P+J97xL/73e+2vv8P//APx+6NeOSRR5KtW7cmb3rTm1rf9+lPf7r1PfZeDnv84he/2Ng9SPZ7fvZnf7b1PfbZWTb61dzd4fJe//mf/9k6R3u/h/2e//7v/07+7M/+rHXfSLZ+T32KfdaWvY/e3mdh13X+5/rHrVu88Y1vNDt37kzuu+++ZNasWa3vsRrZ77FrQKmX2bFjR2KMGecX7Pun+tn7P+x52XOwx/Z67LVktXB5LhdBEARBEARBaI9rr722516jFPvs2/R7N2zY0PM5TUceeaT53ve+N/aeZ5999rjvsb4hvcc8T2097L1sXHrppUOff2W9lq37u78vfS39vnvvvbd1f0v2e+wes5e85CUmfe6Wvfck+3Xr13pdU7q3qxu7ZywN/AdBEARBEATRtLDPi7J1/itf+crW3PyJJ55o7H3Xn//858d9r/2sj9HRUfOyl72sVZO/7nWva62bZMPuz7rqqquMXTdI6/Yf/vCHY1/PU1sPe6/0e+w9LHbP1AknnNBay7nmmmvG3T/xT//0T4k938mTJ5tXvepVrfvne91/bv3F7NmzW99nP/vj3/7t31r3hFgfYj8bZN++fa373e35vOIVr2h9dkmva7LrIvaZVmeeeWbre+2zu+w99dnAfxAEQRAEQRCE/qB+JwiCIAiCIAgiVOA/CIIgCIIgCIIIFfgPgiAIgiAIgiAIgiAIgiAIgiAIgiAIgiAIgiAIgiAIgiAIgiAIgiAIgiAIgiAIgiAIgiAIgiAIgiAIgiAIgiAIgiAIgiAIgiAIgiAIgiAIgiAIgiAIgiAIgiAIgiAIgiAIgiAIgiAIgiAIom4xYcKEDtLYvXt3cvrpp5uZM2eazZs3RzxDgiAIgiAIgiDqElnPkY3ly5eblStXJjfeeGOyZMkSE/i0CIIgCIIgCIKoYfTzH3PnzjXr1q1L7r///mTWrFn4D4IgCIIgCIIgSof1HyMjI2bevHlm06ZNY69PmzbNbN26Ndm2bVsydepU/AdBEARBEARBEKVj3759yd69e5OLL77YLFy4cMxnWE9y4MCBxGL/n76+cePG5MMf/vAYF110UfK2t72t4zUAAAAAAJDFu9/97uSuu+6KYzp6hPUVkydPHvMZU6ZMMbt27Up27NjRWgtJX9+wYUPHdcybN8/ep5588IMfhCEsWrSoRezz0ABaoRVaoZUW0Aqt0AqttPCGN7whec973hPHbPQI6yumT58+5jPsPR/r169v3f8xZ86cvvuvrAex1/P000/DED73uc+1iH0eGkArtEIrtNICWqEVWqGVFmzNbmt3CbF///7ksssuM4sXLx7zGUuXLjWrV69OVq1alVx99dX4DwAAAAAAxUjxH/b+84kTJ5oFCxaY7du3j72+ZcuW5JRTTjH2M0D27NnT9+fxHwAAAAAA8pHiPw4ePFjq5/Ef7rA+iFZohVZaQCu0Qqv6avWlL30pueKKK6Lfi+AL7v/ozeWXX57ceeedHX97Kf6jbOA/ZIwldQOt0Aqt0EoLaIVW2rSydeno6Gj0ZzFBtdi/sfWZ2b89/gMAAAAAQlOXGpQYHL1q9Lr87fEfAAAAAHqoSw1KDA78B1hYd0YrtEIrLaAVWqFVfbWqSw1KDA78B1Q9ltQNtEIrtEIrLaAVWmnTqi41KDE48B8AAAAAIIG61KDE4MB/AAAAAIAEtNWgEya4vaY13vxm0/dzvssE/gMsrDujFVqhlRbQCq3Qqr5aaatB6+Y/XvWqavxGd+A/oOqxpG6gFVqhFVppAa3QSptWg2rQt7zFGFvbh+SXf3lwPV43/xHq3PEfAAAAACCBQTWo9QKh/Yf1PINqzWH+44tfTJITTzTmJ3/y0Pv8538mydy5xhx9tDFf+Urnz/2f/5Mkxxwz/nf2+5kf/jBJfvEXjTnqKGM++cnO3919btnjX/olY6ZPb7/fX//1oa9n6f6ZbduS5H/9L2MmTTJm/nxj7Dl1n/vJJxtz7LHGfPnL43XJBv4DAAAAACSgrQYd5j9e8hJjvv/9zq//yq8Yc/vtSXL33Unyilcc8hr25667zpjnZRgX/X7mV3/VmPe8x5g9e5Lk2mvb/qzfufU6169+NUmOO67zHPr9zIUXGvObv2nMf/93kqxYYUx2bch+37vfbcwPfpAkH/qQMTNnDvZt+A+wsO6MVmiFVlpAK7RCq/pqpa0GPfxwY5599tDxc88lyRFHHKq9/+VfkuSP/ihJfvSjQ98zdeqhdZyRkc4a/pFHev+efj/zspcZ853vtP//5JPu6x8PPZQk553XXv9w/Zlp04z57nfb///e99rnlP2+LVva/9+1K0le8AL8R+x+qgHGXbRCK7TSAlqhFVrVVyttNehP/VTnPqTHHkuS7rn/Bx9Mkte+9tBrU6YY08tnDLr3ot/PHHnkofUVW/9n3+Oww4x5/PH2/+26RPZr8+YZc9NNSWJ/1tV/2LUc6ztsPPpo24+4/FyvwH8AAAAAgAS01aB2P9Kllxpz4EB77cPuQfrgBzv9x+bNSTJ58qHXFiww5r3vNeaZZzrfa1DN3u9nRkeNufzytje56KLOtYzZs42xe7KsV7DnmP3ajBnG3Hdfknz6052/9yd+wph//MckSc82+7Wzz26fg91/Zd/X7sfqd+74D/wHAAAAgAa01aB2X9U73mGMXQuw911feaUx+/cf+rpdCzn+eGM++9lDr23YkCSvfrUxL32pMWed1b+Gz0a/n/l//6/9zNyXv7x9f0j2Pe66K0lOOKF977u9Hzz7tf/9v9trN93+w36ffb/0npDs1+wair3X3XqphQuNsfej9zt3/Af+wwXWndEKrdBKC2iFVmhVX63qUoPGCi3P/sV/QNVjSd1AK7RCK7TSAlqhlTat6lKDxgr8R/zAfwAAAADooS41aKzAf8QP/AcAAACAHq644opkdHS0VcNBfbF/48svv7zjb4//aB6sO6MVWqGVFtAKrdCqvlp96UtfatWltn6rA4sWLWoR+zykYX3mnXfe2fG3x380D8ZdtEIrtNICWqEVWqGVFtDKHfwHAAAAAACEAv8BAAAAAAChwH80D9YH0Qqt0EoLaIVWaIVWWkArd/AfzYP+gVZohVZaQCu0Qiu00gJauYP/AAAAAACAUOA/AAAAAAAgFPiP5sH6IFqhFVppAa3QCq3QSgto5Q7+o3nQP9AKrdBKC2iFVmiFVlpAK3fwHwAAAAAAEAr8BwAAAAAAhAL/0TxYH0QrtEIrLaAVWqEVWmkBrdzBfzQP+gdaoRVaaQGt0Aqt0EoLaOUO/gMAAAAAAEKB/wAAAAAAgFDgP5oH64NohVZopQW0Qiu0QistoJU7+I/mQf9AK7RCKy2gFVqhFVppAa3cwX8AAAAAAEAo8B8AAAAAABAK/EfzYH0QrdAKrbSAVmiFVmilBbRyB//RPOgfaIVWaKUFtEIrtEIrLaCVO/gPAAAAAAAIBf4DAAAAAABCIc1/3HfffcmECRPGju3/s/QL/Ic7rA+iFVqhlRbQCq3QCq20gFbuSPMfV155pTnssMNMejzIc2QD/+EO/QOt0AqttIBWaIVWaKUFtHJHkv9Yt25dcv3115vu9Q+XwH8AAAAAAMhHkv84//zzzdatW8ftvxoZGTHz5s0zmzZt6vuz+A8AAAAAAPlI8R8PPPBAcsEFF7T2XWX9x759+5K9e/cmF198sVm4cOHYvqyNGze2zjtldHQ0ef7rHete3etgHH+uJ7HPR/LxihUrxl6TcD6Sj61WFinnI/m4u23FPh/Jx93EPh/Jx4xXjFdVHHe3rdjnI/m4m9jnI/l40aJFIvzHeeedZ775zW+2/t9rz5X1G5MnTx7zHxs2bMB/0D8qPyafk8+rOO5uW7HPR/JxN7HPR/Ix4xXjVRXH3W0r9vlIPu4m9vlIPpbiP573HGbQs66s35g+fbrp8+PsvwIAAAAAUICU/VfZ6PYe+/fvTy677DKzePFi/AcAAAAAgGKk+w/7/4kTJ5oFCxaY7du39/0Z/Ic73etggFZohVZSQSu0Qiu00gJauSPRf2Tj4MGDTt+H/3CH/oFWaIVWWkArtEIrtNICWrkj3X+4Bv4DAAAAAEA++A8AAAAAAAgF/qN5sD6IVmiFVlpAK7RCK7TSAlq5g/9oHvQPtEIrtNICWqEVWqGVFtDKHfwHAAAAAACEAv8BAAAAAAChwH80D9YH0Qqt0EoLaIVWaIVWWkArd/AfzYP+gVZohVZaQCu0Qiu00gJauYP/AAAAAACAUOA/AAAAAAAgFPiP5sH6IFqhFVppAa3QCq3QSgto5Q7+o3nQP9AKrdBKC2iFVmiFVlpAK3fwHwAAAAAAEAr8BwAAAAAAhAL/0TxYH0QrtEIrLaAVWqEVWmkBrdzBfzQP+gdaoRVaaQGt0Aqt0EoLaOUO/gMAAAAAAEKB/wAAAAAAgFDgP5oH64NohVZopQW0Qiu0QistoJU7+I/mQf9AK7RCKy2gFVqhFVppAa3cwX8AAAAAAEAo8B8AAAAAABAK/EfzYH0QrdAKrbSAVmiFVmilBbRyB//RPOgfaIVWaKUFtEIrtEIrLaCVO/gPAAAAAAAIBf4DAAAAAABCgf9oHqwPohVaoZUW0Aqt0AqttIBW7uA/mgf9A63QCq20gFZohVZopQW0cgf/AQAAAAAAocB/AAAAAABAKPAfzYP1QbRCK7TSAlqhFVqhlRbQyh38R/Ogf6AVWqGVFtAKrdAKrbSAVu7gPwAAAAAAIBT4DwAAAAAACAX+o3mwPohWaIVWWkArtEIrtNICWrmD/2ge9A+0Qiu00gJaoRVaoZUW0Mod/AcAAAAAAIQC/wEAAAAAAKHAfzQP1gfRCq3QSgtohVZohVZaQCt38B/Ng/6BVmiFVlpAK7RCK7TSAlq5g/8AAAAAAIBQ4D8AAAAAACAU+I/mwfogWqEVWmkBrdAKrdBKC2jlDv6jedA/0Aqt0EoLaIVWaIVWWkArd6T5j/vuuy+ZMGHC2PHu3buT008/3cycOdNs3ry578/hPwAAAAAA5CPNf1x55ZXmsMMOM+nx8uXLzcqVK5Mbb7wxWbJkien3c/gPAAAAAAD5SPIf69atS66//nqTXf+YO3eusa/ff//9yaxZs/AfHmB9EK3QCq20gFZohVZopQW0ckeS/zj//PPN1q1bO/ZfTZs2rfXatm3bkqlTp+I/PED/QCu0QistoBVaoRVaaQGt3JHiPx544IHkggsuaPmLrP8YGRkxBw4cSCz2/+nrGzdubJ13yujoaLJw4cKOv3t3O+CYY4455phjjjnmmGOO4x4vWrRIhP8477zzzDe/+c3W/7P+Y8qUKWbXrl3Jjh07Wmsh6esbNmzAf3DMMcccc8wxxxxzzLGyYyn+43nP0brvI4sNe8/H+vXrW/d/zJkzh/1XHuhuB4BWaIVWUkErtEIrtNICWrkjZf9VNrLrH0uXLjWrV69OVq1alVx99dX4Dw/QP9AKrdBKC2iFVmiFVlpAK3ek+48tW7Ykp5xyirGfAbJnz56+P4P/AAAAAACQj0T/USTwHwAAAAAA8sF/NA/WB9EKrdBKC2iFVmiFVlpAK3fwH82D/oFWaIVWWkArtEIrtNICWrmD/wAAAAAAgFDgPwAAAAAAIBT4j+bB+iBaoRVaaQGt0Aqt0EoLaOUO/qN50D/QCq3QSgtohVZohVZaQCt38B8AAAAAABAK/AcAAAAAAIQC/9E8WB9EK7RCKy2gFVqhFVppAa3cwX80D/oHWqEVWmkBrdAKrdBKC2jlDv4DAAAAAABCgf8AAAAAAIBQ4D+aB+uDaIVWaKUFtEIrtEIrLaCVO/iP5kH/QCu0QistoBVaoRVaaQGt3MF/AAAAAABAKPAfAAAAAAAQCvxH82B9EK3QCq20gFZohVZopQW0cgf/0TzoH2iFVmilBbRCK7RCKy2glTv4DwAAAAAACAX+AwAAAAAAQoH/aB6sD6IVWqGVFtAKrdAKrbSAVu7gP5oH/QOt0AqttIBWaIVWaKUFtHIH/wEAAAAAAKHAfwAAAAAAQCjwH82D9UG0Qiu00gJaoRVaoZUW0Mod/EfzoH+gFVqhlRbQCq3QCq20gFbu4D8AAAAAACAU+A8AAAAAAAgF/qN5sD6IVmiFVlpAK7RCK7TSAlq5g/9oHvQPtEIrtNICWqEVWqGVFtDKHfwHAAAAAACEAv8BAAAAAAChwH80D9YH0Qqt0EoLaIVWaIVWWkArd/AfzYP+gVZohVZaQCu0Qiu00gJauYP/AAAAAACAUOA/AAAAAAAgFPiP5sH6IFqhFVppAa3QCq3QSgto5Q7+o3nQP9AKrdBKC2iFVmiFVlpAK3fwHwAAAAAAEAr8BwAAAAAAhAL/0TxYH0QrtEIrLaAVWqEVWmkBrdzBfzQP+gdaoRVaaQGt0Aqt0EoLaOUO/gMAAAAAAEIhxX+cc845ZtKkSebkk0823/jGN8ZenzBhQgf9Av8BAAAAACAfKf7jjjvuSB5//PFk9erVyUknnWTS1wd5jmzgP9xhfRCt0AqttIBWaIVWaKUFtHJHiv9IY9euXcnRRx+N/6gQ+gdaoRVaaQGt0Aqt0EoLaOWOJP/x1FNPtc7l0ksv7fAfIyMjZt68eWbTpk19fxb/AQAAAAAgH0n+w3qN4447zuzYsWPstX379iV79+5NLr74YrNw4cIxX7Jx48bWeaeMjo4mz3+9w3d2+9DYx2vW3JHMmPGEsUs6Fvt/+5qU86vr8ZYtTyevfOVBk2pujyWdX52PbfvOak97D3Ns23g61lj97bGk86vrcba9M97Ey6/2b2CPJZ1fXY/Jr7T3oseLFi0S4z+efPLJZOXKlcmZZ55pur9m/cbkyZPHXt+wYYMq/5GtB7LE6K/dSNCnquPueiBl5syD5i//cvjPr1ixYuw1Cdcj+dhqZbH/37fv6eTYY38kor1LPO5uWz7fP1sPpGjNT72IfT79jrvnl1Je/eqDxvaHEOfT1PGqV34dNt+RHa9in7/04+62lb5WNr/W8bgb3+9vxxKrb6/cqm1+T5L/sLFz584On5GG9RvTp08f93oakvdfZeuBdC4y+1qan0KdT3c7qCtWU6ttqvu3v/1Mx1j5mc88i1YeyWpltc3WvlntQ7d3iVTVrrrHmqzu6dgT+9qlaOWT7rEmHePzjDVN0co3g9r8oLGmiVoVpZdWg3QP2ealUXW7qlNulbL/yj7/ynqPa6+91pxxxhkdPmP//v3JZZddZhYvXqzOf/TKS+nXYuSnJpHtp1nd09ftHIKmvqqFfu2a9l4t/caamHMdTWHYWNP9OvhhUJtnrKmOXnOq6dfIr9XqXqfcKsV/nHfeeWbq1Kmt+8wffvjhsdftPSETJ040CxYsMNu3b+/781L9x7D8Q1+thuwaZXd/HPQ1KM/cuf1rXdp7dQwaa7TmJw0MG2vS+tj2i9jnWjcGtXnGmmoYNKeafp38Wg0uuVXTXIcU/9EvDh486PR9Ev2HSz+M0VebsO48LPe45qYmaOULq9MNN3x14BhIbjqkle92NWvWYF3TNm+/L/b1x9bKJ8PGkqz3u/vuZxqtlU+GjSXDvt4krcrSb29tvzq3yd6vqna1du0zQ3PrIF8oEen+wzUk+g/XPhi6r9Z93PXp++qulU+sTm9608MtTZcte7Zvjau1Dvatlc92leamSZNM3zHEvm6/HqIOlqyVb4b5PstVVz07tF80QSufuOTNQd/TJK3K0uve50HtvcnzTFW1K5cxJLsvTsN6K/6jOlzykqXJfbUK8vq+JtfBPnGtb7XWwZJxrW9D1cFNwcX35fk+cMclv5Jb/ZJnrpT86o88OTPkemtZ8B/VkDff0Ff9kcf3UQf7I08bpg72y4wZB53aMXWwX/K0Y9dxCYaTpx2TW/2Rpw2TX/2Rtw1rya/4j2rI+/cP2VfrvO6ct74a9neqs1a+OfbYvc65Kf07nXBCM2sCn+0qr5ba6mDJfdDV91lC1MGStfJJnvzaL7c2RSsfZO/tyzN3oaUO9q1V6Hv7utGSX/Ef1ZAnL6WwR7g8eTUc1k/rrJVPUh2POOJZ59xUpI/UBZ/tKm+b1zYfLLUP5s3xIeaYpGrlm7xjR68+0hStfOB6b183Wupg31qFvrevFxryK/7DP0X7XBP7qm+K9DkN/VQ6RbxzE+fGqiBv+7U5LN0f/OCDtPmi0ObjUCRPklvLUzRPkl/LUXTM0DDW4D/ktBcLfbU469e3c8zUqaZ2/VQ6RdotNUF5imp4wQXPtf5eN9+sYw+WRGjzcSg6XpNbi1M0t5b5e0Gbou1Ww1iD/5DTXiwh+mpd151vuqm9r+TCC5/ztu5UV618kuamI488YPJq1dSawFe7KjpeFO0rmrXySZnc/pKXtPdgVbH2JFEr3xQdM7r7ShO08sWSJf9eeLzQUAf7xGe7KuP7LNLzK/7DL2XbS4i+Wtdxt8ycbr+aoK5a+SStZefP35zbfzR1bsxXuyqaX8qOUxq18kmZdlvl2pNErXxSpt1259a6a+WT+fMfLdVmq/Tc0vDZrsrOE0nPr/gPv/iYV2xSX/VJGd3Yj1KcMto1bW7MJ3WfG5NMGe00rT1Jo6x25NZilNWN/FqMsrpJz6/4D1ntxdd7NI2y/YyaoDjHHlsuN1ETFKPuc2NSKev70p8/7jj5a0/SKJsbya358VHDkl+LUTa3WiTnV/yHvPZSdV+t47pz2VrqgQeeGXsmUPYZd3XUyifZWqqoVk2sCXy0q7rPjfnUyic+xmcfeUKDVr4pq1v2b1d3rXyR5tY3v/nhwu29SZ7bV7vypZnk/Ir/8Iev9lJ1X63juOtjL0mvz/ipo1Y+8ZHPmzg35qNd+ahhDz+8/R6PPCJvbsynVj6RvMYtTSuf+MiL6XvYvlNnrXyS5tYbbrir1PtU5bml4atd+cqLkvMr/sMfPv/OTemrPvjud9s5xdZSZd4n/Vy2mTMP5vqcnybjo45q0tyYL3xptnDhj1t/v9tvPxD9mrSgYY27jvjSLN2PItlzS8FXbrVInoeXiC+9JOdX/Ie89uL7verObbcdaPWvs876can+ZT2H9R7dayDQH18+Gb+dD1+12Pvf395b8YEPcA+IC2k9ZmvYMu8juSaQiq+ciOd2x1duteC58+EzJ0rNr/gPme2lyr5at3VnnzVUugZi92LVUSufdNdiZbRqmt8u26586eWzvpCqlU986lVFTSBJK9/40ivNF2efvT7388Kbhk+tmuK5ffRBX/McKVLzK/7DD777Vnafqu9zrVuO8jmfZddA0vvQbZ6rm1Y+6a7FymjVtLmxsu3KVy3mO89J1MonPuc6qqgJJGnlE5/5NR235s79If5jCGlufe9713ppV1Ln4X3iow/6nheSml/xH36o4u/LPtU4OkmdK5CGz1qsSr9dN3zPdTShJvCFz7kOqTWBRHxqpcFzS4HcGgff+2Kl5lf8hx+q6FfsUx1OFf2KusAN3+0Tv+2G7/ZJTeCOzzYqtSaQiO82iuceDrk1HlXUfhLzK/7DD1WMZ1XdG1qnNfoqxjOe0ehG93hWVqsm+W1J98pIrwmk9MEq6jHfNYEUrXzjO7+mfehd7/r36NcmlSo+K6UJntuHVlV4BYn5Ff9RnqrWc6u6N7ROOaqqudu0/3/qU39bG6180iuPlG1XTXoWUxmtfNdi0msCKeNVFT7Nd00gRSufVJFf07/l/PmbRbZ5CWRzq892JXEe3idltapqPJaYX/Ef5anKJ6Tj7tFHy6wLJFDVOrrEuQJJVFGLaXgWU2yqmuuoe03ggyrmOiTWBNKoYlyQ7rklQG6NQ1Xr0RLzK/6jPFXmkOnTqQv6UeV9hNQFg6miFsNvD6eqHEJNMJwq6jGJNYE0qhqL8dz9IbfGo6o9HRLzK/6jPFXm7ireuy5r9FXmbp7ROJhetZiPdtUUv11Uq6pyt+SaQMJ4VVU95rsmkKCVb6rKr3Pm/BDP3Qefz1Yf9t51Q8qz1XshLb/iP2T/TauoC+qSo6qsmQ7VG0/jP/pq01kz+WhXTZmHL6pVVfpIrgkkjFdV6uMzf0jQyjeHH15Nfj377AfFeu7YdOdWn+1K4jy8T8poVfWzoaXlV/xHOR59tP15dVOmVNNeJNcFsam6L0mbK5BClW1S8jy8BKpqk3WvCcpSZbuUVhNIYu3adrs84YSDla1xk1vHQ26NQ9VtUlp+xX+U46672u3lta+tpr1QF/Sn6jGMuqA3VY5h1AT9qXqug5qgP1WOBdJqAklcdVVbm2XLqlvjJreOh9wah6rHAmn5Ff9Rjo99rP2sgksuqe7Z+b7Hgjqs0Vddi1nSseDss9eL6KtS6Jc7fLSrptQERbSqeq5Dak0gYbyqsh7zWRNI0MonM2YcbOl+993+dbc6TZnyNJ67i1651Xe7qrPnLqNV1WOwtPyK/yiH9R327/nxj1f32cE8I348Vddiluw96LGvVxL9ajFf7crmPfv+Ng/GvtaqKKJV1XMdUmuC2ONV1XMdPmuC2Fr5pMq9V6lW3IM+nl651Xe7kjYP75MyWoVYg5aUX/Ef5TjjjLY3+OpXqxu/pNYFMQmx7iRtrkACIdadQvQpjVQ911HnmqAMIeY6JNUEUqhy71UKuXU85NY4hMitFkn5Ff9RjhB5g7pgPCHWnUL9fTURohYL9bfVRtV5g5qgNyHqMUk1gRSq3HuVQm4dD7k1DiFya8i/rwv4j+KEytc8I348ofL17Nk7qQsyDKrFfLWrEPVebIpoFSJfS6wJYo9XIfK1r98RWytfpDnPPnu3qt9hdfrkJ/8Wz91Fr9xaRbuqq+cuqlWovCcpv+I/ihNy7sRnXVCHHBWqTnrjGzeJmSuQwKA6yVe7CjUPFJO8WoWa65BYE8Qer0Jo4qsmiK2VL0Lk1lQriZ47Jr30qKJdSZqH90lRrULpISm/4j+KE3LvqMS6IBYh94lImiuQQIh2GGofrCZCzXXUtSYow1FHVV+fSqoJJEBujQO5NR6h2qGk/Ir/KE7I51VSFxwi5LoTdUEnIWoxC59F0UmoeoyaoJM0V9t2X4ffowVyaxzIrfEIlVstUvIr/kPH39BnXaB9jT7k3NhNN/0NdcH/MKxG8tmupH4WhS/yahVKD4k1QczxKqQePuoP7WN7SojcmmqF5z5Ev9xaRbuqq+cuolVoLaTkV/xHMUKvYfnMg9pzVMi+Y3WaNOkZ9gc/PbwN+mxXdX8uZl6tQs11SKwJYo5XIWtTH/svtI/tllC5NdVKoueORZWfLduLkHP+oZD42bLdSMmv+I9ihG4vEuuCWIReO2R/cJuQtRjPxTxE6LmOOtYERQm5N4d9QG3IrfEgt8Yh9BqclPyK/9DRXizUBXHunaIuCK8Dn0VxiND1GDVBHC3YBxRPB3IruTUmoXWQkl/xHzrai8VXLtS8Rh+6FrM6vf3t91IXPD28/fluV+lzIB97LP61+yaPVqHrMWk1QczxKmRd6mNs0zy2p4Rqf1mt8NyD219V7aqOnruIVjHan4T8iv8oRoz2wmdUhR+vrE7XXPOP7A9+engt5rtd1bkmyKNVaD8grSaINV6F3pfj4/dpHttTQvX7rFbSPHcMQny2bDd1vPemiFYx1t8k5Ff8RzFitBdpdUEMYuQJ9gfH0YCaoE3oPFHHmkCLDuwDIrfGgtwah1gaSMiv+A897YW6IJ5nb3pdEKPtpTXBpZc2tyawhG571ARtYtSkEuYkY0JujQe5NQ6x2p6E/Ir/0NNefI3NmtfoQ49VqVZNrwtcajHf7arONYGrVrHqsbSfSbj3JtZ4FWN+sOzv1Dy2W0L2+axWeO7BubXKdlW33JpXq1hrbxLyqxT/cc4555hJkyaZk08+2XzjG98Ye3337t3J6aefbmbOnGk2b97c9+dD+o+Ya7U+6gKtOWrLlvDP50i1krBWGROX6/fdrtKaYNq0+tUErlrFyhGSaoJY41UMDcrmFq1ju6/rL6OVJM8dmmG5tcp2VbfcmlerWNcvIb9K8R933HFH8vjjjyerV69OTjrpJJO+vnz5crNy5crkxhtvTJYsWWL6/XxI/xGzv0iqC0Kzdm27Fvu5nzsYvL80fX9wrHY3eXK7JvjhD+NrEINY7a5uNUERYuwLkTAnGRNyaxzIrfGI2e5i51cp/iONXbt2JUcfffSYz5g7d65Zt25dcv/99yezZs0S4T9itpcm1wWf+Ux7nPrVXw0/TjW9Loi1R/e00w62fu/dd4f5PCxpxOrvEvYGxyTWfpym7wMit8aB3BqPmPe/xM6vkvzHU0891TqXSy+9dMxnTJs2zWzdujXZtm1bMnXqVBH+I2Z78VEXaF2jv+aaZ1u6X3vts8H3XzW5LnC99ira1YUXtmuCP//zetUErlrFqsck1QQxxquY118mv2gd231ce1mtmuy5h+XWKttV3XJrHq1iX3vs/CrJf0x4XojjjjvO7NixY+y1kZERc+DAgcRi/5++vnHjxtZ5p4yOjiYLFy7s+Lt3twMfx2vW3DG2T7KK9x92nP0siqLv103I8y9zPH/+5o6+EuL3r1ixYuy1SZOe6dgfHFuPUMdpLTZ79g4z6PutVhafv/+cc9aP5UUpevg47m5b/b4/bXM2T4U8vzQvTp78jImhT/a4mxC/P61F3/jGTcGvP/Wc11zzf3P/fLZNSWrvLsfZ3Bri93WPV92f8xRbj5DHaR16+eXf6vn17rbl+/envvPmm/9GhB5ljrsZ9P0+6rkyx7Hz66JFi8T4jyeffDKx93qceeaZYz5jyvODkd2TZT2JXQtJX9+wYUMU/3H99V8d2ycZ4+91001/M3bPkJT+Fur4pJN2d6wVhv79s2fv7JiLjq1HqONsLRb69y9d+q2xfQFS9Ah1HLoe6z5+0Yue7dgbHFuPkMfpXpx3vOPe4L8/+7ul6BHiOJtbY/z+bG6VoEfI43Qfzg033BXl92c9twQ9Qh2//e33jt37EuP3x86vkvyHjZ07dyaTJ08e8xn2no/169e37v+YM2dO9P1XMfdJpsS+Z6ip193U/cExr3vt2mei3RcZm5j3hFpi7w2OScz7EJp6Py65NR6xr5vcGue6Y+cYKfuv7POvrPe49tprzRlnnDHmM5YuXWrsM7FWrVqVXH311dH9R4x7ELqxbaVMXdDtQzUQ61lxWa2auj/YtRarol2lz4W0xNbBJy5axa7HYu8NzqOVb2Le41fm3hONY3tK6NzaS6uyuVUjLrm16nZVp9yaR6vYz1yL8ZkGWaT4j/POO8/Y+8vnzZtnHn744bHXt2zZkpxyyinGfgbInj17+v58KP8hISeXPQeNOSrW/aBZrSTdkxsS11qsqnY1Y0b9agIXrWLPdcT+/Xm08knse0LL/H6NY3tK6NzaSysJ+T00Lnmt6nZVp9yaRysJn/0e83NvpPiPshHKf0jYk7BihYy6ICQS5kckfF5PaGLPj1iuuqrd3pcta057t8SuhWKvv8RCQi3UxM/CI7fGgdwaBwm51RJzDQb/kY/Y+yQtTawLYu+TlPT3D0ns/aHtc2jfA3LCCc26ByR2PSbhbx8DCfdfxN6XEQMJYyu5tdl//5BIGV9j/v3xH+5I8ehl78nVuEYfKx93a9W0/cF58nGV7apue7BctIqdj6XMz4UeryTUY0XPQePYbomRW3tp1cTnXbjk1hDtqi651VUrKV435voX/sMdCevylrQueOlLi43VGnNUrP0I3VrF3hMTmjz3AFTZruq2B2uYVlLmOiTsAwo9XklYeyhaE2gc2y0xcmsvrcrmVo249PEQ7aouudVVKyn318Wsa/Ef7kjYJ5lix8emrFVKmYe1NG1/sJSc0LQ9WFLmOiTU4qGRcE+olL9/KMitcSC3xkNKbo0514X/cEfCunxK7L3hIZGyT9IiZc00FJLaWfoc3ibUBVLqMUljXgik1GNS1r9CIamdSRrzqobcGg9J7SzWXl/8hzuS5gLLeGdta/Qxx6VurZq2PzjPXGDV7aou+4NdtJJSj0nwQSHHK0n1WJGaQNvYnhIjt/bTSsq8dAhcc2uIdlWX3OqqlaR1tli5Ff/hjoS90Cll9g5qy1Ex90l2a9Wk/cF5r7XqdlWnumCYVlLmOiTsAwo5Xkmagy1SE2gb21Ni5NZ+WknZlx8C12sN0a7qkltdtJJ2rbFyK/7DDSnr8imS8mTVSKs7Jc1bVIm0+agm7Q+WMtfRtH1AkmpPaeNeVZBb4yGtjZFb4xArt+I/XNuLnHV5iedTJZL2SVrqtA9oENLysLTzqQpp9Vjs5wCHRFI91hS/LS2XSTufKiG3xkFaLot1PvgP2X+ffpSpUbSt0cecE+mllaQapUry1j9Vtytpc0ZlGKSVtPondk0QcrySVI8VyTnaxvai1+mDflpJ8/9V4ppbQ7WrOuRWF62kzS3Eyq34DzckrcunFN2joSlHxd4n2UsraWNHVeTNBVW3q9htwSeDtJI21xG7Jgg5Xkna/1GkJtA0tqfEyq2DtJKy/7FK8oynodpVHXKri1axx9QybcEn+A83pLUXi5R7VKtE4py3tPqwKmLPe/dCUn1YFdLmOupQE7ggzd9KO5+qILfGgdwaD3JrG/yHG5LW5VOkPKOzSiSORxLH7SqQuO9f4rjtG2n1mMQ+WAUS+3UT/Da5NQ4S+7XEPlgF5NY2+A83JOaBos/m17RGH3vutZdWTZiXLPLcoxDtSlptXpRBWkmrx2LXBKHGK4n1WN6aQNPYnhIrtw7SSsLn3lRNntwaql3VIbcO00rqMwVj5Fb8x3Ck9omiz+bXlKNi15v9tJLoR31SpG2FaFex/agvBmklrW3FHv+avPdc2j1YvonZtgZpJeFzb6omT9tq6j1YRRimldS2FWP8w38MJ/b8Xz+k+mifSN1vI/W8fCF1/k/iHLVPYtf6/dBeE7gQe66jFxI9kU/IrfGQmsOknpcvyK2HwH/I/Lu4InEfoU+k1j0SaxWfSN3/LLVeqfv11b0mkHqNknNP3a+P3BoHcmscYuQe/MdwJM9BFcmZWtboJcwF99NKcpvwQZHnv4RoVxLahA/6aSW1HotZE4Qar+z1SavH8tYEWsb2lJjj6DCtJPpRX+QdR0O2K+25dZhWUp+tFiO34j+GI9mPFzk3LTlKwlywtjrRF0Wefx+qXUmdt8uDNl8ruU70wb33tsea44+X5Wsl14k+kOxrJef9skj2tdpz6zCtJH+2TOjciv8YjuR5EKn1ig8kj0MSvFFVbNvWrnle/GJZtViK5P5YFqk1j+S+6IPf/d3nWtf3znfKu746+O1+SO7L5NY4kFvjEbo/4j+GI3n8lzyOlEXy+F+XfUC9uOee9vh/6qkyx3+pNboPpNZjda4JLK97XXtPxBe/KGtPhOQ24QNyaxzIrXEgt3aC/xiM9L5QpC7QskYvoc7U9JxUX9x2W/v5gG95i8znOkvOnWW1ktqmpD4n1Qc7dz6dHH64MRMnGrNrV3ytu5H6nNSyxM6tw7Sqs+eW/lxnqeNgWa2K5tZQhM6t+I/BSB+DiozhWnKUhHm/QVpJOL8qWLWqPe935ZUyP9eyDvOSGj/XUuLnxPnArnnY63r96/XXBFrGdkvs3DpMK+n9sQzSP9dSc24dpFXR3BqK0LkV/yHr71EEzXMFmq9LwvpMFdix0V6XHStjn0svYtctTb0uzTXBIOw9H/a6PvrR56KfSy805KC6Xpf0HFTX6yK3xiF0DsJ/DEbDXo861gUa5p40tI0i2LVhe112rTj2uWhtG0WQXo/VtSawz7yy13XffTLHT+m+tCgaxk9yK23DJ+TWTvAfg9GQc6Xv5SyClJw7SCvp9WJR7L1x9rrsvXK+tPKN9Pm7IlpJz7mxzq/KdpXmW0tsfYedo0tNoGFsT4mdW120in2OVaDhnlHNuXWQVkVza0hC5lb8x2A0zH+kdYH91+X7NeQoKePPIK2keCTfpJ/7a58V6Esr32jol3m1kl7rxOqTVbartWsPqOjDrjWBhrE9JXYfdtEqb27VQJF+HLpdac6tg7QqmltDErJf4j8Go2GeVUqt7hPpc8EWDevYRa9p6lTZ1yS9Vi9C7HpsGJprgn5oGTult40ikFvjQG6Ne03k1kPgP/T3gTrWBVrqSw05NA9a2pKGHJoXm5cktyUt42EerrlGRzvSMh66oqUtaRkP86ClLZFb4xAyt+I/9LeXvL5awxq9lPm+YVpJOU9flJnvC9mutM9Ldmu1dWu7D9v1+djnNogYNUGV7UpLLea6D0jD2G6RkFtdtNIyZ52HIjkrRrvSmlv7aaUlZ4U8T/yHjL9DWSZNct9XqCFHSZn7GKaVlvrFlTL7nUO2Kwn1Sxm6tfq3f5P9ubgpMWqCKtvVaafpqHFcc5GGsT3P9VSJq1Z5cqsGiuTWGO1Ka27tp5WWe4lC5lb8R3807fF41avkP1fBFS1r89raiAtaxnxNbcSF9DPwpH4urrb24YqUeY5haPfb3WgaN8mttBEfaBk7Q7YR/If+9mL55V+W/VzpPGjKtRLm8Xyiac1bS+3owqpVz4n+XNyUOtUEmmqxuu0DIrfGgdwaD3LrePAf9WgvV1zh/rma0tfoJY07w7TSNJ67UGbcCd2uNPXPYVrl6b8xidE3q2pX2vquyz4g6WN7ioS+66qVlr7pQtH+G6Ndaeufw7TSNF8Wqn/iP/qjqb3kmT+VnqMkzbEO00rTHOowyl5L6HalaQ51mFZa5lhj1ARVtStJ8xwuuOwDkj62p0jIra5aaVmbdKFobo3RrrTm1l5aabuWULkV/1GPtq9l/7gL2upKCbnUB9rmmyT51LJo2WOubVwchLb2o8WjDkNbGyK3xoPcGodQYyP+ox7tRcvzc1yQsDZf5/Pth7b5YG3nOwhNz9ipS02grRaryz4gcms8tOUqbefbD225KtT54j/q0V7yfH6A9DV6SfWNi1ba6ph+lJ3zCN2utNUx/bTSdm9x6GfWVtWutNU2LvuApI/tFim51VUrLZ/N40LR3BqrXWnMrb200rbWGiq34j96o629WFw/P1lyjpK2Nu+ilca20ouyY33odiWtrRTVSpuPCl0TVNWupH/efDcu+4Akj+0pUsbLPFppayu9KDNexmpXUtpKWa20+ahQuRX/0Rtt7cWibT6vF9pqMYuU+byyaGw/ktbKiqKt/Vxzjb6aoBuNc9p12QdEbo0DuTUeGttPiNyK/6hPe9E4rnejcbzROK73QmMtr7GfdqPlc3FTNPbRbjTW8ho9Uy809llyaxzIrfEI0U/xH73RuN7qulYpeY1e2nqri1aa9wH5vIYY7UprXZDVSts1rF17IGhNUEW70vpMo2F5SfLY7noNocijlbS8VIQy1xCrXWnMrd1aabwGS4i8hP8Yj9Z5Jtf5Dck5Slot5qqVxvmNLD7mmWK0K21rB7200jYfnObTkZEw42MV7UrrZzoMayuSx3aLpNyaRyuNawfdlMmtMduVttzarZXWNZwQuVWK//jIRz6SHHPMMeb44483X//618den/C8AFn6hU//oXFtXnM7z6KtFtN+3ila86vW886iLb9ajj22fc4PPqizvWt9lq20+Zm8kFvjoTVHaT3vFK05KsR5S/Efy5YtMzt37kw+8YlPJLNnzzbp64M8RzZ8+g+ta/Na1/mySFmbz4v2ukDr/gLtdYHWPnvBBe32fvPNOtu71s/y09pPU8it8SC3xkFrnw2RW6X4jzSeeOKJZNKkSVH9h9a1eYvLXKrUNXpJa/N5tdK6DyjFxxgfo11p++yMbq20+qebbmrPjdl2E0orn++p5fPmuxk2Jyl1bE+RlFvzaqVxnTKlbG6N2a605dZurbT6pxC5VZr/uOeee5L58+d3+I+RkREzb948s2nTpr4/59N/aF2bt7isVUrNURLX5l210rrGmuJjjTtWu9L02eHdWmltN+vXt/vqccdV7/uqaFca24xlmF+VOranSMqtebXSvA+obG6N2a60jZHdWmluN1WPk9L8x6JFi8wtt9wydrxv375k7969ycUXX2wWLlw45ks2btzYOu+U0dHR5Pmvd/zdu9uB63G6Nv+bv7nWy/uFPJ4/f/OY15ZwPnmOly1b27E2H/t88hyndcFJJz1uJJxP3uN0bm/NmttFnE+e43Qu+3d+5x9EnE+e43PPXT+2Ni/hfPIcT526r+MekNjn43qczusdeeQBI+F88hyvWXPH2D4gCeeT9/g1r9kytu9NwvnkOc7mVgnnk+c43ff2mtf8QF1+yuZWCeeT9zibWyWcT57jGTP+a2yduIr3f77eF+M/7H3nc+bMMQcPHhz3Nes3Jk+ePOY/NmzYUJn/oJ6Jc3zRRf/RsTYf+3zyHGdrGgnnk+f40Lk/o3J8Z74gVj32aMc9ILHPx/WYeqa+9UyVx9ncKuF88hyn+97OOus7ivMT8wWhj6ueL5DiP+x9H6eeeqp56KGHen7d+o3p06ebnl9M/O6/0ro2b3FZq+xuB1KQtDZfRCut7cbXPQix2pXEduOqlea1+fQeEHsvegitfL2ftv0c3QxqM1LH9hRJY2RerTS3m7JjZOx2Jand5NFK6/19KVXnVin7ry655BKzdu3anl/bv39/ctlll5nFixdX7j+03s+a4tLeY48l/ZD4TJo8WtX1ntYqtPKJpHta82ql+Z7W9B4Q+yzeEFr5ej9t97N2M+h+Vqlju0Vabs2rleZasmxujd2uNOXWrFaaPaul6twqxX/Y+8xf+MIXmiOOOCKxZF+fOHGiWbBggdm+fXvfn/flPzSPMRbNzwnUNMb0QqJ/ckHr8wFTeKZnPA47TJ9/0vo8mhSt/ZXcGg9yaxy09tWUqnOrFP/RL3rdC9IrfPkP7X7VonVOVdMaay807gOyaK/HJD43zQXt9ZhF4/4xjeecRWuO0nreWcitcSC3xqHq3Crdf7iGL/+hfW3eMiy/xl5L7YW0tfkiWmncB+TSXqrQyicSPzfGRaulS7+lvh4LkV99tyutNWTKIN8qcWxPkZZbi2il0bv6yK2x25Wm3JrVSmN7yVJ1bsV/dKLdr7pcQ+yxpBdS54LzaKV1H5Cvz8WN2a60fbav1an7eToaCbG/wGe70ryHxuUaJI7tKdJyaxGtpF2DCz5ya+x2pSm3ZrXSlpd6UeU14D860e5XLdLmmVyow9q8xn1AGtcOeqGx32qsZbrR1m+lznPkReMajsY+2g25NQ7k1nhU2W/xH51oHNe70TjeaBzXu9E43mgc13uhsZavQz2mrZ7XODb2QmPbIbfGgdwaB3LrcPAfh6jD2rxlWE0Qey01dBsvQ16ttK23+lzXjtmutD1nxOpkP09LU1vpRYgx02e70tZO+tFvvJQ4todqJ3kpopU2vz2orVStlW+05NZUK017xgZR5ZiJ/ziExrGlF8PuN5MwlnQjdT4vr1ZSr6MfPu/ri9mutM1L/vEf365uPq8fVc9r+2xXUuc58tKvJpA4tlsk5tYiWkl9TsogfOQkCe1KS25NtdJ0z/wgqsyt+I8wOodG2/P26rA2b9FW32h9rmE3EuubQdRlbd6ipS7Qdq6D0JartJ3vIMitcSC3xqHK3Ir/OERd1uYtmj5vSOLafFG0tSGtn+vUjbY2VJe1eYumuqAutZg2v61tXBwEuTUO2toQuXU4+I9DaMqjwxjU9iWspWaRnEvzaqVtns9nLo3drjTVlhdd9B+1WJu3VF0X+GpXdarF+l1L7D7YD4m5tahWmupKX7lVQrvSkltTrTT51GFUlVvxH4eoy9q8ZdDan4SxJIvkcSWvVpK9VC987iWI3a409d+FC79Ti7V5S9X911e70tY3h9GrJojdB/shsW8W1UrTvhpffVNCu9LSf1OttO3TG0RV/Rf/cQhN86fD0HTvk7Z11UFommPVeC/lICTOsfZD0xzqMLTUBZLnOYogsabvB7k1DuTWuOdKbh0M/kNf23ZB0/5yTXWjC1pyrZa60RVNubZOa/Naxk5N7cMFLeOmlvbhCrk1HuTWOFQ1duI/6tleBj1fR8JaahbJ83hFtJJ8PVl8zwfHblea5rePOOLZ2qzNW6qsC3y1q7rVYr0+Vy52H+yF1NxaVCtNz67zlYuktCsNudXqtHTpt9TkIheqyq34j2r1jcWgzwuVMpakSJ7TKKKVljrH9+fixm5XUuucbtL5YPv5g7HPxRdV1gW+2pWG2iUPvXJW7D7oep4SKKqVps/i9pVbpbQrDbnV6nTuuevVf+Z8lqpyK/6jTd3W5i0aPi+0bmvzFi1tScNYngctbUmLT8qDhrYkeZ6jCFrakZbxMA/k1jhoaUsaxsM8VNWW8B/1bC8WDfN9WnJoHqTO92lsH3nRUGNqaR95kF4X1LEW03KPK7k1DuRW2odPqsit+I/6tpd+476UtVSL9PGkiFZaxn3f44mEdqWhH6e1ul2jj30uvqiyH/toV1r6ZF7sHqDsfUQS+mA3UvtkGa00eCqffVJKu9LQj61ORx75jPh5sLxU0Y/xH200zJvmpd+cpJSxZNA5SqGIVhrmWqs4RwntSkNdkJ7j5Zd/K/q5+KLKusBHu5I+z1EUew909jlqEvpgN1JzaxmtpOct3+copV1pyK1r1twh/hyLUEVuxX/oaNNF0JBzNdSLRZCac1M0zCMVQUNdIHU+uAzSx1AN7aII9hmw9rqkfo6M9HZRFHJrPMitcahiDMV/1Le9aLiuOtZiGq5LQ/6s63XZ85OcP4siuS6oay1mPwPPXpfUz+LWkIPqel3Sc1Bdr0tDDpJyXfiP+raXfnNPUtZSLZJrljJaSa93qpjLkNCupNcF997bPr+jjnrKxNbKN1XVBT7alfSapSjWd9jrSj+LW0IfzCI5t5bRSsO6js/cKqldSc+t6bN367bWWkVuxX/Ud23e0msMkjKWaBjDi2olvU1VMYZLaFfS29Tv/u5zrfP7xV/8bu38R1V1gY92JX2eoyh235W9rvSzuCX0wSySx8GyWkluU77HQUntSnKbssyfv1m0PypKFbkV/yHfT5dB8ryf9LnqMkie95PeLsoiuS543eva+/W/+EWZ+/XLILUukO5Jy2DvO7fXJvWzuMmtcSC30i6qwHduxX/Uu71IHv+ljyNlkD7+S67RyyK1P+/c+XRy+OHGTJxozK5d8c/HN1L7s/S+WAb73F17bS9+sUxvJbUv+oDcGgfp/Znc6g7+o97tpdecpJS1VKnzpVmKaiV5zrWqc5PSrqTWBXbNw57X61//YyNFK59UVReU1arOtZjlqKPa+euxx+T0wRTJubWsVpLzl+9zk9SuNORW+/kfsc+lCnzn1qb7D8lt2Qe9cq+UsURqnZiljFZSc6/UOtEXUuuCd76z3d4/+tHnxGjlE6m+Vmp78MUZZ7T39H31qwdEtSvpubXOvtZ3bpXUrizSc+tJJz0urk34wPdY2nT/IX0tryySr6/Oa/OSr09y3qzz9R1/fDtn3nefrPbgE4l1gYZ5jjJcckn7+j7+cVnXJzn31P36pOaeul+f1Nwj9fqa7j/q3l4kz0FJrFV8IrXuqft8sMS64NFH2/1wZEReP/SJxLpA4jn55GMfa+ewSy+VlcPIrfEgt8aB3JqPpvuPurcXS/dYJGEtVfLYnaWMVlLbluTnpPpAYtu66672vR+vfa3M56T6QuJznetei2XblqR2JXX8S6nrc52rGP8ktSuL1LaVjn+XX/6t6OdSBb7bVtP9h1Qf7ZPTTuuc/5Mwlkico+5FGa2kzv9J/pw4X0irC+zeGHs+dq+MNK18Iu1zLSV6Ud+ka2vTphlR/kN6bvWhVXdulUAVuVVSu7JIz6033HBX9HOpCp+5ten+o+5r8xaJeUDq+OETqR5LWm1eBdLqAql79H0jrV9L7YO+mTxZXp8mt8ZBWh+sAqn9ugm51We/brr/aEJ7ueYaeWuVUtdPfSJx7lXiOVWBtLog+4yi2OdSJdLqgibUYhaJtT65NQ7kVs6pSnzm1ib7j6a0l+4cLGEtVVp92I+67T2vsj6U0K5SpNUF6Wc02L0y0rTyibS9502oxSzZfecS2pWG3OqjD0r0txLvwaoCqbnVPntXmlY+8TmmNtl/SJurq4q1aw90XKeEsUTifF0vymolbR9QlflSQrsKcZ15SWuxKVMO1WKStPKN77qgjFZa5jnKktYE5577gIjaR0Nu9dEHu3OrBKrIrRLHK6m59YwzNovog1Vfp4/c2mT/IalGqZJe9U9sJO5XrgJp9U9T5oMl1QWSziUEkuoCLfMcZZGWy6SdT1WQW+NBbo2Dz7mFJvuPprQXS7r/47HH4p9L9nktsc+laqTtA5I2ZleFpLqgKbVYiqQ2Jm2PRlVIW28gt8aB3BoPSeNelfjcW9lk/9GU9mLJ3v8aey21+7MQJFNWK2m1Z5XzwbHbVTdS6oJeeVKaVlVfbxmKaqXhHgRfpNd65JHPiNj7oSG3+uqDkp4tUVVulTheSc2t9tm70rTyja95nSb7j6aszVuyz/+MPZZI/bzeXpTVStremyrX5mO3q26k1AW9ajFpWvnEd11QVCtpawJVk9YEa9bcHv1cNORWX31Q0rO1q8qtEscrqbnV9j9pWvnG1x7bJvuPpuyTtEiq+SWN11UjaR9Qk9bmLVLamaT7IUIgpS6QNj9aNZLaGbk1DlLGvBCQW+Pha32zqf6jae1F0p4nKfPSoeh+9iptIAxS6oKm3IOQIqUuaNI9CBYpe57IrfEgt9IGQuBrj21T/UfT2ks2J8ReS5WyL98FH1pJyQlV1+Ox21U3Evp4v3sQpGnlG599vKhWUurxUKQ1gX0Gb8zzkNDvXPDVByX5rapyq9TxSmJulaqVT3ytLTfVf0iZGw2JhP2JUuZGXfExlkhZE6/6PKSNuxLqgn73IEjTyjc+64KiWmm4B8En2c8fiHkeWnKrzz4oYb9ZlblV6nglMbdK1convvbYNtV/SGm3IZGwP1jK3vCQpPnYtrmY5yFlrigkseuCpt2DkCJhfI39tw+NlPvtJfztQ0NujQO5NQ6+vK4U//GRj3wkOeaYY8zxxx9vvv71r4+9vnv37uT00083M2fONJs3b+7783n9R9Pai0XCfoQm1mNS9iNo2vfmi9h1QdPuQUiJPQcuYe0rNGlNYIl5HuTWOOdAbo13Hk3MrT7uvZHiP5YtW2Z27tyZfOITn0hmz55t0teXL19uVq5cmdx4443JkiVLTL+fz+s/mthesvuDY60PSvvMoGH4WEtNayHb5mJdR4hzkLjuHLsu6Pf7JWrlE591QRGtpNQloXnZy56KPg+vJbf67IMS8lqV5yB1vJKYW6Vq5Rsf8wxS/EcaTzzxRDJp0qQxnzF37lyzbt265P77709mzZrlxX9ouwfBF9n9wbH6R+x6MC++xpLYz+kIUY9JHHdj1wX97kGQqJVPfK4/FNEq9vpLLN70podb7W3ZsjjtXVNu9dkHJaw9VJlbJY9X0nKrZK184mOfpTT/cc899yTz588f8xnTnk9gW7duTbZt25ZMnTrVi/9o4j5JKdcdez9MLGLvSZCyTzY0seuCpt2DIOXam3gPgiW9B+SEE+KM8RJyTFOvm9xKbtV23dL8x6JFi8wtt9wydjwyMmIOHDiQWOz/09c3btzYOu+U0dHRZOHChR2+s9uHpsf91gH6fX9djtesuaNjbirG+bzoRc+O1SSx9Qh5nNZD73jHvY38/bGOr7/+q2N1Qejff9NNf9OxBiBBj5DHJ520u6MeCvn705rkmmv+rxg9Qh3PmNGuQ2+44a7gv3/p0m+N+X0peoQ4Ttd9XvSiAybW+WRza2w9Qh5nc1sTf3+s42uu+ceB6z4ux8/X+2L8h73vfM6cOebgwYNjr015vljetWtXsmPHjtZaSPr6hg0bCvuPfvdBxP57hjieNOmZ1rXb2ij079dYj61YsWLstTLvl84VvPGNm6LkpxD1mNXKIunvl/XcoX//oPG5u21J0cvn8fz5mzv2gxR9v25cfj7dk3HzzX8jRo8Qx7ZNpXuw3vzmh4Pnt3POWT+231GCHoOOfY9XaW5N9wGFvJ50v+Pkyc9Ukl/StiXp75ceZ3NrjN+fza3pa1li61PVcVrP9bvvxeVYiv+w932ceuqp5qGHHup43d7zsX79+tb9H9ab9Pv5PPuvtN2D4JNedWgoNN4T2t1ntF57iD2yvrTSeO29GHQPglStfOLr3pu8Wkm4JzUWVqcbbvhqtD1YmnKr7z4Ycx9Q1flF8nglLbdK1qrqa8+LlP1Xl1xyiVm7du2415cuXWpWr16drFq1Krn66qu9+I+m7pO0xNwX3dR7Qi0xa6Im12OWWHVBU+9BSIl1703sekQC6XN4Q3tuciu5NTTk1niUza1S/MeE5y/ihS98oTniiCMSSxpbtmxJTjnlFGM/A2TPnj19fz6P/2jyPaEx75Vqej0Wax6+6fVYrHYX+77I2MS6J7ep94NmidX2yK3k1hiQW+NQtt1J8R9lw9V/NPFzqbKk/WX27B3Br19jPeZzLTXW9YfKi1LXnWPVBYM+B0GqVj7x9SzWvFo1uRZLtYqhgbbc6rsPxqxFq84t0scrSblVulZVX38emuY/mu5X0xxh75UL/bu1fC5VFp9jSay6KNTvlTruxujzw9blpWrlGx/zknm10jjP4Yvue3JDem5tudV3H4y5F6fq3Cp9vJKUW6Vr5ZOyfb5p/qPJ+yRTYqxVNn2fpCXWPHyT6zFLjLanrRarihhtL/bnkUkgRvsjt5JbY0FujUPZttc0/9HktfmUGH2GeiyeBtRj4TXgHoQ2ocdbarF4OpBbya2xILfGo4wGTfMfTferFvuc7NB5Qms95nMtNUZNEPJ3Sl53Dt3vh9VikrXyiY9+n0erptdiWa1C10bacmsVfTCGBwuRW6WPV5Jyq3StfFOm3zfNf9h7IbXdg+Cbt7/93uBeQOvcmO+xJHRNELIekzzuhm5/w8ZkyVr5xEf7y6OV1nkOX2S1Cu0HtOXWKvpgjPYXYmzTMF5Jya0atPJJmfbXJP/x3e8+02ovRx/d7LX5GHOE2ubG6qJD0+uxWDqwLt8mnSMs+wwsV7TOc2jXgtzahtwaD3JrHMro0CT/cdtt7bHhrLOauTafEromsFCPtQldH1GPtQlZF3APQifTp7f7/iOPVP+ZdNRihwhZH5Fb25Bb40FujUOZ3Nok//H+9z/bai8f+MCzjR4j7drglClPB6sJNNdjvtdSQ8+ZhKzHJK87h6wLXMZjyVr5ZuHCdhu8/fZibTCPVk2vxbJahfTcGnNrVX0wpN8OlVs1jFdScqsGrXxSJrc2yX+UzYN1wfaNOXN+GEwLzfeEav+MKvu7QtVj0sfdUHWBSx6UrpVPytamrlppnufwRVarkHpozK1V9cGQWoTKJxrGq9C5td9chwatfFM0tzbJf4Scl5BOyPkq9kkeImRNsHZte0/2CSccbLzullB1AevynYTam6N5nqMqQq0HkVsPQW6NQ8jcylxHJ0Vza1P8R4x9mZIJuV+XeqyTUDXBVVe18+CyZXr2RFRJqLqAexA6CXVvMrXYeEK0RXJrJ+TWeITKrcx1dFI0tzbFf9BeDmHXBj/5yb8N9rwSzfVYFWupofSYMeNg6/fcfXeYOUnp686h6oL0OaSDcqB0rWJoUlYrarHxWoXQRGturaoPhnwWWKhcomW8CqXHoLkOLVr5pGhubYr/YG7sEGn/KFMT5CHU76lSK5/vGaImiLH3Svq4G6IucP0d0rXyTZm6wFUrzfMcvujWKkTe05pbq+yDdcutWsarUHMQg36PFq18UjS3NsV/MDc2nhD5mufCjydEvmbvVW+qztc8h7Q3IcZfzfMcVRFibYLcOh5yaxxCeWHmOsZTZPxtiv+gvYwnRN6gHhtPiJog9N4rLVQ9Dmh8DmkIqq4LqMV6E+LeDHLreMitcQi1F5C5jvEUGQea4j9oL4dI1wdDzBVor8eqWEutuiZIa7HDDw9bi2lYd666LnB9DogGrXxSpi5w0YparL9WVT+bSmturbIP1i23ahmvQvjtYXMdWrTyTZHc2gT/wdxYJ2n/CDFXoPG58L208v2+VdYEsWoxDeNu1XWB699Vg1Y+KVMXuGilfZ7DF720qnIM1pxbq+yDdcutmsarqv32sPyqSSufFMmtTfAfzI31JsRcAc+F702VuYNarD9V1gWaa7EQVDkWaJ/nqJIqxwNya2/IrfGoeiwgv/amSG5tgv+gvfSnyjGMeqw/VbZJarH+VFkXUIsNpsp2SS3WnyrbJbm1P+TWOFTdJsmvvSmSW5vgP2gvnWTXB6vUpg71WFVrqVVqE6sW07LuXJU+efKeFq1i6ZNHK2qxwVql+rzkJf710Zxbq+6DdcqtmsarqrUZlj80aRVam26a4D+YG+sk2z+qnCuow9xY1Z9R5bsmiFmLaRl3q6oL8ryvFq18UrQuGKZVHeY5fNFPq2OPbefABx/0mwM159aq+2Cdcqum8apKv+2SXzVp5Zu8ubXu/oO5scFUmbs1z42FoIqagFpsOFXlbpvvtNZiIaiqLqjDPEfVXHBB+9k0N9/s77lv5NbBkFvjUZXfJr8OJu9YXHf/QXsZTJVzBdRjg6miJqAWG04VY8L69e1+ZPNe7OuTTBV1AbXYcG66qf1smgsv9PfcN3LrYMit8agit1rIr4PJOybU3X/QXsbTvT5YRU1Ql3qsyrXUKmqCmLWYlnXnKuqCvH9LLVr5pkhdMEwrarHhWlUxHmvPrSH6YF1yq7bxqorcanHJr9q08kne3Fp3/8Hc2Hi6+0cVcwVV9f/YWvmkijwSsxbTNO76rgvy9iFNWvmkyLgwSKu6zHP4YpBWvscG7bk1RB+sS27VNl5VNS649CFtWvkmT26tu/9gbmw4VYxnVa1/1g2f7ZNazB3f7bOq/cZ1w3cbrcs8Rwh8+wVy63DIrfHw3T7Jr27kaZ919h+0FzdSnY47zp9O1GNu+KwJqMXiaFXlPu864rMuoBZzx+d+KXJrPp3IreHx7bfJr/51qrP/oL30ptf6oM8xrU71mKZnNMauxTStO/usC4rch6tJK9/krQsGaUUt5q6Vz/vF65BbQ/XBOuRWjeOV7/uTXPOrRq18kie31tl/xK7HpNKrf/jUqk7PRal6LPGpVexaTNu460uvInlOm1Y+yavXsHuqfc4ta2dQu/JZu9Yht4bqg3XIrRrHK99aueYLjVr5xlWrOvuP2PWYJnzOZ2l/LkpIfNUE1GL58VUXaL8PNzS+6oI6zMGHxldOJLe6Q26Ng0+/TX7Nh2turav/oL3kw6de1GP58JHLqcXiacZ9uPlI64LDDy831tRhDj40PjQjt+bjgQfaeln27Sv3XuTWfPjyyeTXavSqq/+gvfSn3/qgr75q64q61GNantEooRbTtu7so44qeh+uNq18M2PGwVZ7vfvu4WNE1eNVnRjWrnzkxbrk1pB9cNasdnv/zGfKjc+xcqvW8cpXXszzPlq18olrbq2r/5BQj0mlX//wodnate12d8IJB1XnpmFa+cRHPpdQi2kcd8vqVvRvp1Ern1x1VXsfybJlw/eR9NKKOXh3rXzrVpfcGrIPWt9hNZs586ApugYSM7dqHa98eeU8eUKrVr5x0ayu/iPdE8HcmDs++mqeugLapDXB1KnFagJqseKUraXqUouFpmwtVZc5+BiU9dzk1vxYz2G9R5k1EHJrfsrm1ux7kF/z4ZIb6+g/6jYHHwoffTXPvgrwoxu1WHHKakctVpwy2uH7ilNGO3JrcdI1ELsXq8jPk1uLUVY38msxXHSro/9gnmAwg9YHy/RVH/5FGqHWUsu0WSm1mMZ15zJttkwtplEr35R5nj6+z12rbsrUU3XKraH7oF0DmTTJFMqvsXOr5vGqbJvNm181a+UTlzZbR//BPMFgBvWPMn21jvMEocaSMrWslFpM67hbdLwo01e0auUT1/GiWyvm4N216kWZWrZOuTVGHyw6ZsTOrZrHq7LjRd78qlkr3wwbL+rmP8hN5Sijn5R5eK0Uye209/IUrQnqVIvFoGgdXKc5+Fgw1sShqIbk1nIUHatp8+UYNlbXzX+Qm8pTpK/ateX0Geex5+G1UqTt0t7LUyTHkJf8UGSswfeVh7EmHnnbL7m1PEXbLm2+HMPyZN38B7lpOMPWB4v0ubL31kkl5Fpq3pq2zH5i7Vr5Ju+4UTYvadbKJy46ZrXC9w3GtV2lOtrxw/V5sHXLrbH6YN6xQ0Ju1T5eFRk3iuZX7Vr5ZtC4USf/8c53fpDc5MCw/pG3r/7oR08n06cbL5+vJI3QY0meHC8hL8XUyid5agIfvk+zVj5xqYOzWjEfOZg87SrPZ+LV0ffF6oN5tfT12YUatfJJXv9cNL/WQSufDBqz6+Q/fv7nP0Ru8kSevvq+97Xb18/8TPHPVoI2eeorCXmpLuSZD5bm+7Tj2o6lrfdpJ087xvf5xTW/Flmngt7kbcPkVz8MasN18h8TJ95AbvKEa1/9l395JhkZMcbyr/+K7mVxzTfkJf+45BsfnyMGnbh+NjS+zy+ufg7f5x/X/Irv80eenEl+9Uu/3Fon/zFhwofJTQ64rA+69D/7ul3zsN+3fHk9x8cYa6kudbDEvKR93dmlDnatleuulU+GeTqr01/+5efwfQ7kbVcu40hdfV/MPuiaX6X4vrqMV65rGjxb3S/98qYU//HUU08lt956a3LaaaeZ7OsTnj/pLP0i9R/kpuG49o9hffXP/qzdpuy9H/YekNjXFVMrnwyrcbdsOfQ8lNh5KbZWPhlWB/tc+9CulW8GtXmr09Kl3/Li++pO3naV1sEWO650f73O632x++Cw/CrJ98XWyhcu80dl82tdtPJJv3FEgv/Yv39/csYZZ5jrrrvOdHuMQZ4jG/Yapk27gdzkkbSv9spN2T5at7wUm0E5337t1a9uf23u3Ph5qW4MavO+1j5gPMPafF1rYAnYccRqa8eV7nZNm68O8mt4XOaYyK/V0Ku9S/Af2SjjP84550PRNa4T2b74ylceNGmbsf/a4345C8rTLzcNyllQnkFtnnqgWoa1eWrgaujXtmnz1UJ+jYPLHBP51T+92rsG/zEyMmLmzZtnNm3a1Pfn7DVcd90Ho2usgTzrg9mx0P777W8/03Fc9z4aay21V1+VXg/UZd15UJv3VQ/URSufdLf5rO5S27w0irarbN1VVZuXhoQ+qCW/StDKF1XPMdVJK990t/elS2X7j3379iV79+5NLr74YrNw4cKxe0M2btzYOu+U0dHR5Pmvd/zdu9sBx5/rybDvz7aZbI5as+YOEddT5fGKFSvGXgv9+62+M2Y80aF7th6QoE/22GplkXI+ZY5tm+/W3h7bv4mP9+9uW7GvV8qx1bd7rLEce+yPjL0HPfb5ST8uOl7Z8cRq3K27bfNpfSbh+nweSxmvNOTX7rYV+3zKHvca333l124kXK+k4872/mHR/iMN6zcmT5485j82bNiA/4jUX9M5A0nnV9fj7nqszvWAtOOs/5NWD9T5OJufaO/xxhuffptj8qu0417ze4w3odu7Dv9h/cb06dNNzy8m7f1Xdi9Zeq0AAAAAACAP6fd/2LDPx7rsssvM4sWL8R8e6PalgFZohVZSQSu0Qiu00gJauSPFf3R/zkfqQ+y/EydONAsWLDDbt2/v+/P4D3foH2iFVmilBbRCK7RCKy2glTtS/Ee/OHjwoNP34T8AAAAAAOQj3X+4Bv4DAAAAAEA++I/mwfogWqEVWmkBrdAKrdBKC2jlDv6jedA/0Aqt0EoLaIVWaIVWWkArd/AfAAAAAAAQCvwHAAAAAACEAv/RPFgfRCu0QistoBVaoRVaaQGt3MF/NA/6B1qhFVppAa3QCq3QSgto5Q7+AwAAAAAAQoH/AAAAAACAUOA/mgfrg2iFVmilBbRCK7RCKy2glTv4j+ZB/0ArtEIrLaAVWqEVWmkBrdzBfwAAAAAAQCjwHwAAAAAAEAr8R/NgfRCt0AqttIBWaIVWaKUFtHIH/9E86B9ohVZopQW0Qiu0QistoJU7+A8AAAAAAAgF/gMAAAAAAEKB/2gerA+iFVqhlRbQCq3QCq20gFbu4D+aB/0DrdAKrbSAVmiFVmilBbRyB/8BAAAAAAChwH8AAAAAAEAo8B/Ng/VBtEIrtNICWqEVWqGVFtDKHfxH86B/oBVaoZUW0Aqt0AqttIBW7uA/AAAAAAAgFPgPAAAAAAAIBf6jebA+iFZohVZaQCu0Qiu00gJauYP/aB70D7RCK7TSAlqhFVqhlRbQyh38BwAAAAAAhAL/AQAAAAAAocB/NA/WB9EKrdBKC2iFVmiFVlpAK3fwH82D/oFWaIVWWkArtEIrtNICWrmD/wAAAAAAgFDgPwAAAAAAIBT4j+bB+iBaoRVaaQGt0Aqt0EoLaOUO/qN50D/QCq3QSgtohVZohVZaQCt38B8AAAAAABAK/AcAAAAAAIQC/9E8WB9EK7RCKy2gFVqhFVppAa3cwX80D/oHWqEVWmkBrdAKrdBKC2jlDv4DAAAAAABCgf8AAAAAAIBQ4D+aB+uDaIVWaKUFtEIrtEIrLaCVO/iP5kH/QCu0QistoBVaoRVaaQGt3JHiP5566qnk1ltvTU477TSTfX337t3J6aefbmbOnGk2b97c9+fxHwAAAAAA8pHgP/bv35+cccYZ5rrrrjMTJkzo+Nry5cvNypUrkxtvvDFZsmSJ6fMW+A8AAAAAAAVI8B/Z6PYfc+fONevWrUvuv//+ZNasWfgPD7A+iFZohVZaQCu0Qiu00gJauSPdf0ybNs1s3bo12bZtWzJ16lT8hwfoH2iFVmilBbRCK7RCKy2glTvS/cfIyIg5cOBAYrH/T1/fuHFj67xTRkdHk4ULF3b83bvbAcccc8wxxxxzzDHHHHMc93jRokWi/ceUKVPMrl27kh07drTWQtLXN2zYgP/gmGOOOeaYY4455phjZcfS/Ye952P9+vWt+z/mzJnD/isPdLcDQCu0QiupoBVaoRVaaQGt3JG+/2rp0qVm9erVyapVq5Krr74a/+EB+gdaoRVaaQGt0Aqt0EoLaOWOFP9hfUc3NrZs2ZKccsopxn4GyJ49e/r+PP4DAAAAAEA+UvxH2cB/AAAAAADIB//RPFgfRCu0QistoBVaoRVaaQGt3MF/NA/6B1qhFVppAa3QCq3QSgto5Q7+AwAAAAAAQoH/AAAAAACAUOA/mgfrg2iFVmilBbRCK7RCKy2glTv4j+ZB/0ArtEIrLaAVWqEVWmkBrdzBfwAAAAAAQCjwHwAAAAAAEAr8R/NgfRCt0AqttIBWaIVWaKUFtHIH/9E86B9ohVZopQW0Qiu0QistoJU7+A8AAAAAAAgF/gMAAAAAAEKB/2gerA+iFVqhlRbQCq3QCq20gFbu4D+aB/0DrdAKrbSAVmiFVmilBbRyB/8BAAAAAAChwH8AAAAAAEAo8B/Ng/VBtEIrtNICWqEVWqGVFtDKHfxH86B/oBVaoZUW0Aqt0AqttIBW7uA/AAAAAAAgFPgPAAAAAAAIBf6jebA+iFZohVZaQCu0Qiu00gJauYP/aB70D7RCK7TSAlqhFVqhlRbQyh38BwAAAAAAhAL/AQAAAAAAocB/NA/WB9EKrdBKC2iFVmiFVlpAK3fwH82D/oFWaIVWWkArtEIrtNICWrmD/wAAAAAAgFDgPwAAAAAAIBT4j+bB+iBaoRVaaQGt0Aqt0EoLaOUO/qN50D/QCq3QSgtohVZohVZaQCt38B8AAAAAABAK/AcAAAAAAIQC/9E8WB9EK7RCKy2gFVqhFVppAa3cwX80D/oHWqEVWmkBrdAKrdBKC2jlDv4DAAAAAABCgf8AAAAAAIBQ4D+aB+uDaIVWaKUFtEIrtEIrLaCVO/iP5kH/QCu0QistoBVaoRVaaQGt3MF/AAAAAABAKPAfAAAAAAAQCvxH82B9EK3QCq20gFZohVZopQW0cgf/0TzoH2iFVmilBbRCK7RCKy2glTv4DwAAAAAACAX+AwAAAAAAQiHdf0yYMKGDfoH/cIf1QbRCK7TSAlqhFVqhlRbQyh0N/sMl8B/u0D/QCq3QSgtohVZohVZaQCt38B8AAAAAABAKDf5jZGTEzJs3z2zatKnv9+E/AAAAAADkI91/7Nu3L9m7d29y8cUXm4ULF5r09Y0bN7bOO2V0dDR5/usd617d62Acf64nsc9H8vGKFSvGXpNwPpKPrVYWKecj+bi7bcU+H8nH3cQ+H8nHjFeMV1Ucd7et2Ocj+bib2Ocj+XjRokWi/Uca1m9Mnjx5zH9s2LAB/0H/qPyYfE4+r+K4u23FPh/Jx93EPh/Jx4xXjFdVHHe3rdjnI/m4m9jnI/lYi/+wfmP69Omm39fZfwUAAAAAIB/p+69s7N+/P7nsssvM4sWL8R8AAAAAAIqR7j/s/ecTJ040CxYsMNu3b+/7ffgPd7rXwQCt0AqtpIJWaIVWaKUFtHJHuv84ePCg0/fhP9yhf6AVWqGVFtAKrdAKrbSAVu5I9x+ugf8AAAAAAJAP/gMAAAAAAEKB/2gerA+iFVqhlRbQCq3QCq20gFbu4D+aB/0DrdAKrbSAVmiFVmilBbRyB/8BAAAAAAChwH8AAAAAAEAo8B/Ng/VBtEIrtNICWqEVWqGVFtDKHfxH86B/oBVaoZUW0Aqt0AqttIBW7uA/AAAAAAAgFPgPAAAAAAAIBf6jebA+iFZohVZaQCu0Qiu00gJauYP/aB70D7RCK7TSAlqhFVqhlRbQyh38BwAAAAAAhAL/AQAAAAAAocB/NA/WB9EKrdBKC2iFVmiFVlpAK3fwH82D/oFWaIVWWkArtEIrtNICWrmD/wAAAAAAgFDgPwAAAAAAIBT4j+bB+iBaoRVaaQGt0Aqt0EoLaOUO/qN50D/QCq3QSgtohVZohVZaQCt38B8AAAAAABAK/AcAAAAAAIQC/9E8WB9EK7RCKy2gFVqhFVppAa3cwX80D/oHWqEVWmkBrdAKrdBKC2jlDv4DAAAAAABCgf8AAAAAAIBQ4D+aB+uDaIVWaKUFtEIrtEIrLaCVO/iP5kH/QCu0QistoBVaoRVaaQGt3MF/AAAAAABAKPAfAAAAAAAQCvxH82B9EK3QCq20gFZohVZopQW0cgf/0TzoH2iFVmilBbRCK7RCKy2glTv4DwAAAAAACAX+AwAAAAAAQoH/aB6sD6IVWqGVFtAKrdAKrbSAVu7gP5oH/QOt0AqttIBWaIVWaKUFtHIH/wEAAAAAAKHAfwAAAAAAQCjwH82D9UG0Qiu00gJaoRVaoZUW0Mod/EfzoH+gFVqhlRbQCq3QCq20gFbu4D8AAAAAACAU+A8AAAAAAAgF/qN5sD6IVmiFVlpAK7RCK7TSAlq5I91/7N69Ozn99NPNzJkzzebNm/t+H/7DHfoHWqEVWmkBrdAKrdBKC2jljnT/sXz5crNy5crkxhtvTJYsWWL6fR/+AwAAAABAPtL9x9y5c826deuS+++/P5k1axb+AwAAAABAMdL9x7Rp08zWrVuTbdu2JVOnTsV/eID1QbRCK7TSAlqhFVqhlRbQyh3p/mNkZMQcOHAgsdj/p69v3Lixdd4pc+bMSU499dTW9cBgFixYkCxcuDD6eWgArdAKrdBKC2iFVmiFVlo4/fTTk7e97W0xLcbAmDJlitm1a1eyY8eO1lpI+vqGDRs6/If1HtaDZF+D3oyOjraIfR4aQCu0Qiu00gJaoRVaoZUWTjzxxOTnf/7nY1qMgWHv+Vi/fn3r/o/n/cXA/VcWYniglXuglXuglXuglXuglXuglXuglXuglXuglXu85z3vaSE1li5dalavXp2sWrUqufrqq/EfHgKt3AOt3AOt3AOt3AOt3AOt3AOt3AOt3AOt3EO6Vlu2bElOOeUUYz8DZM+ePX2/T/p1SAq0cg+0cg+0cg+0cg+0cg+0cg+0cg+0cg+0co+6aGXvR//Od74T+zRUBFq5B1q5B1q5B1q5B1q5B1q5B1q5B1q5B1q5B1oRBEEQBEEQBEEQBEEQBEEQBEHIi927d9vnCJuZM2eazZs3xz4dcfHUU08lt956a3Laaad13L+PbuPjIx/5SHLMMceY448/3nz9618fex2txsc555xjJk2aZE4++WTzjW98Y+x1tOof9913XzJhwoSxY7QaH1afLGmgVe/48pe/nPzkT/6kmTFjxtj4jlbjI9um7HP909fRanx87WtfS0444QQzffp0c9ttt429jlbjY9OmTckrXvEKM3v27A5N0KodeetPbbotX77crFy5MrnxxhuTJUuW9H1GVhNj//79yRlnnGGuu+46k83lNtBtfCxbtszs3Lkz+cQnPpHY8SR9Ha3Gxx133JE8/vjjiX0+3UknnYRWDnHllVeaww47DK0GRPc4lQZajQ9b+7zqVa8yjzzySMfraNU/fvzjHye//uu/Th8cENbP3n777cmdd96ZHH300Wg1IN761rcaq8eHPvQhQ7vqjCL1pzbd5s6da9atW9f6jBD7eSGxz0dqdP/90a1/PPHEE4md20+P0ap/2M8HzeYotOodVpPrr7++YxxGq/HRz3+g1fh497vfbb7whS+Mex2t+sc999yT3HzzzWPHaDU+Xv7yl7c+99nyUz/1U4ztA+Koo44y27dvT773ve+11ozS19GqM1zrT2262c9F37p1a7Jt27Zk6tSp4s83VnT//dGtf9gcNX/+/DFN0Kp32LVV+/y8Sy+9FK2GxPnnn9/SJdsP0Wp8WH1GRkbMvHnzjJ3fTwOtxsfP/MzPGNv/7J7Rr3zlK2Ovo1X/sHts7XN30kCr8fHpT386ede73mV+4zd+w3zyk58cex2txoftezt27GjNWb7oRS8iD/YJ1/pTm242Vx04cCCx2P/HPh+p0f33R7f+sWjRInPLLbeMHaNV77Bt6rjjjmuNv2mg1fh44IEHkgsuuKClRbYfotX42LdvX7J3797k4osvNgsXLhzTBK3Gh72P4Y/+6I9a8/lvectb0MohFi9e3KEHWo2P73//+639xyeeeGLHHny0Gh/nnntua//VmjVrkhe84AX0wT7hWn9q082OwXad0NZA1jvFPh+p0f33R7feYe87nzNnjjl48ODYa2jVO5588snE7tU888wzxzRBq/Fx3nnnmW9+85ut/2f7IVr1DztHPXnyZNrVgLDzrXbfh71nLbsHEq16h/W12bVaG2g1Pqzv/4d/+IfE3gMyOjpKuxoQ//zP/9xaA3nf+95nDj/8cLTqE671pzbd7B6x9evXt/aL2box9vlIje6/P7qND7uGeuqpp5qHHnqo43W06h+29snWiWg1Pp7ve6bXc53Qqn9s2LAhsc/fSY/RanzY+Wm7tmb7oN2Hnr6OVr3jS1/6UvL5z3++4zW0Gh+2BrRezeZDxna3sDWzfRZEeoxWneFaf2rTbenSpcY+g2fVqlXJ1VdfLf58Y0X33x/dxscll1xi1q5dO+51tBof9vlXtu659tprjX3GRfo6Wg2ObD9Eq95hn5ty2WWXmexeGbQaH3a8+q3f+i3zqU99Knnzm9+MVkPiiiuuaD3fMBtoNT5++qd/2nzmM59JPvvZz7aeLZu+jla9w3o1+8xMe99MGmjVGa71pzbdtmzZkpxyyinGPjN4z549sU9HXHTPu6btAN3Gh9XmhS98oTniiCMSSxpoNT7sniJ7f5i9T/jhhx8eex2tBkd2HEar8WH1mThxolmwYEHruTJpoNX4sJrYOUJbL9IHh4fdq9/9GlqND7v3yu7ns+trdn9RGmg1PuznX9n9VytWrOhoW2jVjrz1J7oRBEEQMSJ73xVBEARBEARBEARBEARBEARBEARBEARBEARBEARBEARBEARBEARBEARB/P/24JAAAAAAQND/174wAQAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA8AhnTPrQ=)
]]}}&]
[s0; &]
[s0; &]
[s0;i150;O0; [*2 Linked controls]&]
[s0;2%- &]
[ {{4548:5452f0;g0;^ [s0;# [2 It is possible to fit different plots with LinkedWith() so 
that any scroll or zoom in any graph will affect the rest of 
them.]&]
[s0;2 ]
::= [s0;= [*R2 
@@image:2118&1377
(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)
]]}}&]
[s0; ]]