topic "Streams";
[2 $$0,0#00000000000000000000000000000000:Default]
[i448;a25;kKO9;2 $$1,0#37138531426314131252341829483380:class]
[l288;2 $$2,0#27521748481378242620020725143825:desc]
[0 $$3,0#96390100711032703541132217272105:end]
[H6;0 $$4,0#05600065144404261032431302351956:begin]
[i448;a25;kKO9;2 $$5,0#37138531426314131252341829483370:item]
[l288;a4;*@5;1 $$6,6#70004532496200323422659154056402:requirement]
[l288;i1121;b17;O9;~~~.1408;2 $$7,0#10431211400427159095818037425705:param]
[i448;b42;O9;2 $$8,8#61672508125594000341940100500538:tparam]
[b42;2 $$9,9#13035079074754324216151401829390:normal]
[{_}%EN-US 
[ {{10000@(113.42.0) [s0; [*@7;4 Stream]]}}&]
[s3; &]
[s1;:Stream`:`:class:%- [@(0.0.255)3 class][3 _][*3 Stream]&]
[s9; Stream is the base class of all U`+`+ streams.&]
[s0; U`+`+ streams generally serve in two different roles:&]
[s0;i150;O0; As basic raw binary streams, which includes text input 
and output.&]
[s0;i150;O0; As binary serialization target/source. This mainly needs 
to store flag indicating serialization direction.&]
[s0; &]
[s0; While Stream offers a basic interface for stream based operations, 
more specific operations are handled by one of the following 
classes derived from Stream:&]
[s0; &]
[ {{993:993:993:993:995:996:987:1013:1016:1021f0;g33;GNl17/25r17/4t17/0b17/0@7-2 [s0; [^topic`:`/`/Core`/src`/Stream`$en`-us`#`:`:Stream`:`:class Stream^1 Stream]]
::l0/25r0/25t0/15b0/15@2-1 [s0;%- ]
:: [s0;%- ]
::r/4t/0b/0 [s0; ]
:: [s0; ]
:: [s0; ]
:: [s0; ]
:: [s0; ]
:: [s0; ]
:: [s0; ]
:: [s0; ]
::l17/25r17/4t17/0b17/0@7-2 [s0; [^topic`:`/`/Core`/src`/Stream`$en`-us`#`:`:StringStream`:`:class StringStream^1 S
tringStream]]
::l0/25r0/25t0/15b0/15@2-1 [s0;%- ]
:: [s0;%- ]
::r/4t/0b/0 [s0; ]
:: [s0; ]
:: [s0; ]
:: [s0; ]
:: [s0; ]
:: [s0; ]
:: [s0; ]
::l17/25r17/4t17/0b17/0@7-2 [s0; [^topic`:`/`/Core`/src`/Stream`$en`-us`#`:`:MemStream`:`:class MemStream^1 MemStre
am]]
::l0/25r0/25t0/15b0/15@2-1 [s0;%- ]
:: [s0;%- ]
::r/4t/0b/0 [s0; ]
:: [s0; ]
:: [s0; ]
:: [s0; ]
:: [s0; ]
:: [s0; ]
:: [s0; ]
:: [s0; ]
::l17/25r17/4t17/0b17/0@7-2 [s0; [^topic`:`/`/Core`/src`/Stream`$en`-us`#`:`:MemReadStream`:`:class MemReadStream^1 M
emReadStream]]
::l0/25r0/25t0/15b0/15@2-1 [s0;%- ]
:: [s0;%- ]
::r/4t/0b/0 [s0; ]
:: [s0; ]
:: [s0; ]
:: [s0; ]
:: [s0; ]
:: [s0; ]
::l17/25r17/4t17/0b17/0@7-2 [s0; [^topic`:`/`/Core`/src`/Stream`$en`-us`#`:`:BufferStream`:`:class BufferStream^1 B
ufferStream]]
::l0/25r0/25t0/15b0/15@2-1 [s0;%- ]
:: [s0;%- ]
::r/4t/0b/0 [s0; ]
:: [s0; ]
:: [s0; ]
:: [s0; ]
:: [s0; ]
:: [s0; ]
:: [s0; ]
:: [s0; ]
::l17/25r17/4t17/0b17/0@7-2 [s0; [^topic`:`/`/Core`/src`/Stream`$en`-us`#`:`:BlockStream`:`:class BlockStream^1 Blo
ckStream]]
::l0/25r0/25t0/15b0/15@2-1 [s0;%- ]
:: [s0;%- ]
::r/4t/0b/0 [s0; ]
:: [s0; ]
:: [s0; ]
:: [s0; ]
:: [s0; ]
:: [s0; ]
:: [s0; ]
:: [s0; ]
::l17/25r17/4t17/0b17/0@7-2 [s0; [^topic`:`/`/Core`/src`/Stream`$en`-us`#`:`:FileStream`:`:class FileStream^1 FileS
tream]]
::l0/25r0/25t0/15b0/15@2-1 [s0;%- ]
:: [s0;%- ]
::r/4t/0b/0 [s0; ]
:: [s0; ]
:: [s0; ]
:: [s0; ]
:: [s0; ]
:: [s0; ]
:: [s0; ]
:: [s0; ]
::l17/25r17/4t17/0b17/0@7-2 [s0; [^topic`:`/`/Core`/src`/Stream`$en`-us`#`:`:FileIn`:`:class FileIn^1 FileIn]]
::l0/25r0/25t0/15b0/15@2-1 [s0;%- ]
:: [s0;%- ]
::r/4t/0b/0 [s0; ]
:: [s0; ]
:: [s0; ]
:: [s0; ]
:: [s0; ]
:: [s0; ]
:: [s0; ]
::l17/25r17/4t17/0b17/0@7-2 [s0; [^topic`:`/`/Core`/src`/Stream`$en`-us`#`:`:FileOut`:`:class FileOut^1 FileOut]]
::l0/25r0/25t0/15b0/15@2-1 [s0;%- ]
:: [s0;%- ]
::r/4t/0b/0 [s0; ]
:: [s0; ]
:: [s0; ]
:: [s0; ]
:: [s0; ]
:: [s0; ]
:: [s0; ]
::l17/25r17/4t17/0b17/0@7-2 [s0; [^topic`:`/`/Core`/src`/Stream`$en`-us`#`:`:FileAppend`:`:class FileAppend^1 FileA
ppend]]
::l0/25r0/25t0/15b0/15@2-1 [s0;%- ]
:: [s0;%- ]
::r/4t/0b/0 [s0; ]
:: [s0; ]
:: [s0; ]
:: [s0; ]
:: [s0; ]
::l17/25r17/4t17/0b17/0@7-2 [s0; [^topic`:`/`/Core`/src`/Stream`$en`-us`#`:`:SizeStream`:`:class SizeStream^1 SizeS
tream]]
::l0/25r0/25t0/15b0/15@2-1 [s0;%- ]
:: [s0;%- ]
::r/4t/0b/0 [s0; ]
:: [s0; ]
:: [s0; ]
:: [s0; ]
:: [s0; ]
:: [s0; ]
:: [s0; ]
::l17/25r17/4t17/0b17/0@7-2 [s0; [^topic`:`/`/Core`/src`/Stream`$en`-us`#`:`:CompareStream`:`:class CompareStream^1 C
ompareStream]]
::l0/25r0/25t0/15b0/15@2-1 [s0;%- ]
:: [s0;%- ]
::r/4t/0b/0 [s0; ]
:: [s0; ]
:: [s0; ]
:: [s0; ]
:: [s0; ]}}&]
[s3; &]
[s0; &]
[s0; In order to achieve optimal performance of buffered stream operations, 
the most frequent operations have a little bit more complicated 
implementation that demands proper definition of virtual methods, 
as they must correctly adjust some protected data members of 
Stream. Therefore the implementation of some method can be considered 
a part of interface definition:&]
[s0; &]
[s0; [*C@5 void  Stream`::Put(int c)]&]
[s0; [*C@5 `{]&]
[s0; [*C@5 -|if(ptr < wrlim)]&]
[s0; [*C@5 -|-|`*ptr`+`+ `= c;]&]
[s0; [*C@5 -|else]&]
[s0; [*C@5 -|-|`_Put(c);]&]
[s0; [*C@5 `}]&]
[s0;*C@5 &]
[s0; [*C@5 int  Stream`::Term()]&]
[s0; [*C@5 `{]&]
[s0; [*C@5 -|return ptr < rdlim ? `*ptr : `_Term();]&]
[s0; [*C@5 `}]&]
[s0;*C@5 &]
[s0; [*C@5 int  Stream`::Get()]&]
[s0; [*C@5 `{]&]
[s0; [*C@5 -|return ptr < rdlim ? `*ptr`+`+ : `_Get();]&]
[s0; [*C@5 `}]&]
[s0;*C@5 &]
[s0; [*C@5 int64 Stream`::GetPos() const]&]
[s0; [*C@5 `{]&]
[s0; [*C@5 -|return dword(ptr `- buffer) `+ pos;]&]
[s0; [*C@5 `}]&]
[s0; &]
[s0; &]
[ {{10000F(128)G(128)@1 [s0; [* Protected members]]}}&]
[s3;%- &]
[s5;:Stream`:`:pos:%- [_^int64^ int64]_[* pos]&]
[s6;%- Protected.&]
[s2; Position of buffer in the stream.&]
[s3; &]
[s4;%- &]
[s5;:Stream`:`:buffer:%- [_^byte^ byte]_`*[* buffer]&]
[s6; Protected.&]
[s2; Pointer to beginning of buffer.&]
[s3; &]
[s4;%- &]
[s5;:Stream`:`:ptr:%- [_^byte^ byte]_`*[* ptr]&]
[s6; Protected.&]
[s2; Pointer to current input/output byte.&]
[s3; &]
[s4;%- &]
[s5;:Stream`:`:rdlim:%- [_^byte^ byte]_`*[* rdlim]&]
[s6; Protected.&]
[s2; Read limit. [* Get] method returns values from buffer as long 
as [* ptr < rdlim].&]
[s3; &]
[s4;%- &]
[s5;:Stream`:`:wrlim:%- [_^byte^ byte]_`*[* wrlim]&]
[s6; Protected.&]
[s2; Write limit. [* Put] method returns values from buffer as long 
as [* ptr < wrlim].&]
[s3; &]
[s4;%- &]
[s5;:Stream`:`:`_Put`(int`):%- [@(0.0.255) virtual] [@(0.0.255) void]_[* `_Put]([@(0.0.255) i
nt]_[*@3 w])&]
[s2; Called by [* Put] method in case that output byte cannot be stored 
into buffer ([* ptr >`= wrlim]). If Stream wants to use buffering, 
this method should adjust [* buffer], [* ptr] and [* wrlim].&]
[s7; [%-*C@3 w]-|Byte to store.&]
[s3; &]
[s4;%- &]
[s5;:Stream`:`:`_Term`(`):%- [@(0.0.255) virtual] [@(0.0.255) int]_[* `_Term]()&]
[s2; Called by [* Term] method in case that input byte is not in buffer 
([* ptr >`= rdlim]). If Stream wants to use buffering, this method 
should adjust [* buffer], [* ptr] and [* rdlim].&]
[s7; [*/ Return value]-|Value at current position in the stream. Current 
position is not advanced.&]
[s3; &]
[s4;%- &]
[s5;:Stream`:`:`_Get`(`):%- [@(0.0.255) virtual] [@(0.0.255) int]_[* `_Get]()&]
[s2; Called by [* Get] method in case that input byte is not in buffer 
([* ptr >`= rdlim]). If Stream wants to use buffering, this method 
should adjust [* buffer], [* ptr] and [* rdlim].&]
[s7; [*/ Return value]-|Value read from the stream.&]
[s3; &]
[s4;%- &]
[s5;:Stream`:`:`_Put`(const void`*`,dword`):%- [@(0.0.255) virtual] 
[@(0.0.255) void]_[* `_Put]([@(0.0.255) const]_[@(0.0.255) void]_`*[*@3 data], 
[_^dword^ dword]_[*@3 size])&]
[s2; Directly called by [* Put] method. Writes a block of binary data.&]
[s7; [%-*C@3 data]-|Pointer to data.&]
[s7; [%-*C@3 size]-|Size.&]
[s3; &]
[s4;%- &]
[s5;:Stream`:`:`_Get`(void`*`,dword`):%- [@(0.0.255) virtual] [_^dword^ dword]_[* `_Get]([@(0.0.255) v
oid]_`*[*@3 data], [_^dword^ dword]_[*@3 size])&]
[s2; Directly called by [* Get] method. &]
[s7; [%-*C@3 data]-|&]
[s7; [%-*C@3 size]-|&]
[s7; [*/ Return value]-|&]
[s3; &]
[s0; &]
[ {{10000F(128)G(128)@1 [s0; [* Constructor Detail]]}}&]
[s3; &]
[s5;:Stream`:`:Stream`(`):%- [* Stream]()&]
[s2; Default constructor. Sets stream into Loading serialization 
mode and zero level indentation. All protected variables are 
set to 0 / NULL.&]
[s3;%- &]
[s4;%- &]
[s5;:Stream`:`:Stream`(const Stream`&`):%- [* Stream]([@(0.0.255) const]_[* Stream][@(0.0.255) `&
]_[*@3 s])&]
[s2; Default copy constructor.&]
[s3; &]
[s4;%- &]
[s5;:Stream`:`:`~Stream`(`):%- [@(0.0.255) `~][* Stream]()&]
[s2; Default destructor.&]
[s3;%- &]
[s0; &]
[ {{10000F(128)G(128)@1 [s0; [* Public Member List: Raw Operations]]}}&]
[s3;%- &]
[s5;:Stream`:`:Seek`(int64`):%- [@(0.0.255) virtual] [@(0.0.255) void]_[* Seek]([_^int64^ int
64]_[*@3 pos])&]
[s2; Seeks to given position.&]
[s7; [%-*C@3 pos]-|Position.&]
[s3; &]
[s4;%- &]
[s5;:Stream`:`:GetSize`(`)const:%- [@(0.0.255) virtual] [_^int64^ int64]_[* GetSize]()_[@(0.0.255) c
onst]&]
[s7; [* Return value]-|Size of stream.&]
[s3; &]
[s4;%- &]
[s5;:Stream`:`:SetSize`(int64`):%- [@(0.0.255) virtual] [@(0.0.255) void]_[* SetSize]([_^int64^ i
nt64]_[*@3 size])&]
[s2; Alters the size of the stream.&]
[s7; [%-*C@3 size]-|New size.&]
[s3; &]
[s4;%- &]
[s5;:Stream`:`:Flush`(`):%- [@(0.0.255) virtual] [@(0.0.255) void]_[* Flush]()&]
[s2; If stream has any internal buffers (like [* FileStream]), writes 
these buffers to OS.&]
[s3; &]
[s4;%- &]
[s5;:Stream`:`:Close`(`):%- [@(0.0.255) virtual] [@(0.0.255) void]_[* Close]()&]
[s2; Closes stream.&]
[s3; &]
[s4;%- &]
[s5;:Stream`:`:IsOpen`(`)const:%- [@(0.0.255) virtual] [@(0.0.255) bool]_[* IsOpen]()_[@(0.0.255) c
onst]_`=_[@3 0]&]
[s7; [* Return value]-|true if stream is open.&]
[s3; &]
[s4;%- &]
[s5;:Stream`:`:IsError`(`)const:%- [@(0.0.255) bool]_[* IsError]()_[@(0.0.255) const]&]
[s7; [* Return value]-|true if error was encountered during stream operations 
since opening it or last [* ClearError] call `- error code is non`-zero.&]
[s3; &]
[s4;%- &]
[s5;:Stream`:`:IsOK`(`)const:%- [@(0.0.255) bool]_[* IsOK]()_[@(0.0.255) const]&]
[s7; [*/ Return value]-|!IsError().&]
[s3; &]
[s4;%- &]
[s5;:Stream`:`:SetError`(int`):%- [@(0.0.255) void]_[* SetError]([@(0.0.255) int]_[*@3 c]_`=_
[@3 0])&]
[s2; Sets stream error code.&]
[s7; [%-*C@3 c]-|Error code.&]
[s3; &]
[s4;%- &]
[s5;:Stream`:`:SetLastError`(`):%- [@(0.0.255) void]_[* SetLastError]()&]
[s2; Sets stream error to last OS`-specific error (obtained e.g. 
by GetLastError call in Win32 or in errno in Posix). This error 
can be interpreted by GetErrorMessage function.&]
[s3; &]
[s4;%- &]
[s5;:Stream`:`:GetError`(`)const:%- [@(0.0.255) int]_[* GetError]()_[@(0.0.255) const]&]
[s2; Returns current error`-code. Zero indicates no error.&]
[s3; &]
[s4;%- &]
[s5;:Stream`:`:ClearError`(`):%- [@(0.0.255) void]_[* ClearError]()&]
[s2; Clears error code.&]
[s3; &]
[s4;%- &]
[s5;:Stream`:`:GetPos`(`)const:%- [_^int64^ int64]_[* GetPos]()_[@(0.0.255) const]&]
[s7; [*/ Return value]-|Current position in the stream.&]
[s3; &]
[s4;%- &]
[s5;:Stream`:`:GetLeft`(`)const:%- [_^int64^ int64]_[* GetLeft]()_[@(0.0.255) const]&]
[s7; [*/ Return value]-|Bytes between current position and the end of 
stream `- equivalent to GetSize() `- GetPos().&]
[s3; &]
[s4;%- &]
[s5;:Stream`:`:SeekEnd`(int64`):%- [@(0.0.255) void]_[* SeekEnd]([_^int64^ int64]_[*@3 rel]_`=
_[@3 0])&]
[s2; Sets current position in the stream relative to the end of stream. 
Same as Seek(GetSize() `+ rel).&]
[s7; [%-*C@3 rel]-|Position `- should be less or equal to zero.&]
[s3; &]
[s4;%- &]
[s5;:Stream`:`:SeekCur`(int64`):%- [@(0.0.255) void]_[* SeekCur]([_^int64^ int64]_[*@3 rel])&]
[s2; Sets current position in the stream relative to the current 
position. Same as Seek(GetPos() `+ rel).&]
[s7; [%-*C@3 rel]-|Relative offset.&]
[s3; &]
[s4;%- &]
[s5;:Stream`:`:IsEof`(`):%- [@(0.0.255) bool]_[* IsEof]()&]
[s2; There are no more byte to be read from the stream. Is also true 
in case of error.&]
[s3;%- &]
[s4;%- &]
[s5;:Stream`:`:Put`(int`):%- [@(0.0.255) void]_[* Put]([@(0.0.255) int]_[*@3 c])&]
[s2; Puts single byte into the output stream.&]
[s7; [%-*C@3 c]-|Byte.&]
[s3; &]
[s4;%- &]
[s5;:Stream`:`:Term`(`):%- [@(0.0.255) int]_[* Term]()&]
[s5;:Stream`:`:Peek`(`):%- [@(0.0.255) int]_[* Peek]()&]
[s2; Peeks byte from input stream not advancing current position. 
If there are no more bytes in input stream or error occurred, 
negative value is returned.&]
[s3;%- &]
[s4;%- &]
[s5;:Stream`:`:Get`(`):%- [@(0.0.255) int]_[* Get]()&]
[s2; Reads single byte from input stream, advancing current position. 
If there are no more bytes in input stream or error occurred, 
negative value is returned.&]
[s7; [*/ Return value]-|Byte read from input stream.&]
[s3; &]
[s4;%- &]
[s5;:Stream`:`:PeekPtr`(int`):%- [@(0.0.255) const]_[_^byte^ byte]_`*[* PeekPtr]([@(0.0.255) i
nt]_[*@3 size]_`=_[@3 1])&]
[s2; This is a special optimization method; it might return a pointer 
to data of [%-*@3 size] bytes at current position in the stream, 
but it is allowed to return NULL `- in that case you need to 
use Get to load data. PeekPtr does not move the position forward, 
you need to use some of Seek methods to do that.&]
[s3; &]
[s4;%- &]
[s5;:Stream`:`:GetPtr`(int`):%- [@(0.0.255) const]_[_^byte^ byte]_`*[* GetPtr]([@(0.0.255) in
t]_[*@3 size]_`=_[@3 1])&]
[s2; This is a special optimization method; it might return a pointer 
to data of [%-*@3 size] bytes at current position in the stream, 
but it is allowed to return NULL `- in that case you need to 
use Get to load data. Unlike PeekPtr, it advances stream by [%-*@3 size].&]
[s3; &]
[s4;%- &]
[s5;:Stream`:`:PutPtr`(int`):%- [_^byte^ byte]_`*[* PutPtr]([@(0.0.255) int]_[*@3 size]_`=_[@3 1
])&]
[s2; This is a special optimization method; it might return a writable 
pointer where you can write output data of [%-*@3 size] bytes, 
but it is allowed to return NULL `- in that case you need to 
output data using Put. Advances stream by [%-*@3 size].&]
[s3; &]
[s4;%- &]
[s5;:Stream`:`:GetSzPtr`(int`&`):%- [@(0.0.255) const]_[_^byte^ byte]_`*[* GetSzPtr]([@(0.0.255) i
nt`&]_[*@3 size])&]
[s2; This is a special optimization method, it returns a pointer 
to data at current position of stream, sets [%-*@3 size] to the 
maximal possible amount of bytes that can be read from this pointer 
and advances stream by this size. [%-*@3 size] can be set to zero, 
in that case stream has to be read by another means (e.g. Get).&]
[s3; &]
[s4;%- &]
[s5;:Stream`:`:Put`(const void`*`,int`):%- [@(0.0.255) void]_[* Put]([@(0.0.255) const]_[@(0.0.255) v
oid]_`*[*@3 data], [@(0.0.255) int]_[*@3 size])&]
[s2; Writes a block of raw binary data to the output stream.&]
[s3; &]
[s4;%- &]
[s5;:Stream`:`:Get`(void`*`,int`):%- [@(0.0.255) int]_[* Get]([@(0.0.255) void]_`*[*@3 data],
 [@(0.0.255) int]_[*@3 size])&]
[s2; Reads at most [%-*@3 size] bytes from the stream to [%-*@3 data]. 
Returns the number of bytes actually read.&]
[s3; &]
[s4;%- &]
[s5;:Stream`:`:Get`(int`):%- [_^String^ String]_[* Get]([@(0.0.255) int]_[*@3 size])&]
[s2; Reads at most [%-*@3 size] bytes from the input stream and returns 
result as String.&]
[s3; &]
[s4;%- &]
[s5;:Stream`:`:GetAll`(int`):%- [_^String^ String]_[* GetAll]([@(0.0.255) int]_[*@3 size])&]
[s2; Reads exactly [%-*@3 size] bytes from the input stream and returns 
result as String. If there is not enough bytes left, returns 
String`::GetVoid(). Note that is [%-*@3 size] is large (currently 
> 4MB), function reads result in chunks in order to avoid problems 
with corrupted streams, e.g. situation where the [%-*@3 size] is 
obtained from the stream, is corrupted and too big and allocating 
that much memory would cause out`-of`-memory situation.&]
[s3; &]
[s4;%- &]
[s5;:Stream`:`:GetAll`(void`*`,int`):%- [@(0.0.255) bool]_[* GetAll]([@(0.0.255) void]_`*[*@3 d
ata], [@(0.0.255) int]_[*@3 size])&]
[s2; Reads [%-*@3 size] bytes from the stream to memory at [%-*@3 data]. 
If there is not enough data in the stream, LoadError is invoked 
(that in turn might throw an exception). Returns true if required 
number of bytes was read.&]
[s3;%- &]
[s4;%- &]
[s5;:Stream`:`:Put64`(const void`*`,int64`):%- [@(0.0.255) void]_[* Put64]([@(0.0.255) cons
t]_[@(0.0.255) void]_`*[*@3 data], [_^int64^ int64]_[*@3 size])&]
[s2; Writes a block of raw binary data to the output stream, unlike 
regular Put, block size can be greater than 2GB, if CPU is 64 
bit.&]
[s3; &]
[s4;%- &]
[s5;:Stream`:`:Get64`(void`*`,int64`):%- [_^int64^ int64]_[* Get64]([@(0.0.255) void]_`*[*@3 d
ata], [_^int64^ int64]_[*@3 size])&]
[s2; Reads at most [%-*@3 size] bytes from the stream to [%-*@3 data]. 
Returns the number of bytes actually read. Unlike regular Get, 
block size can be greater than 2GB, if CPU is 64 bit.&]
[s3; &]
[s4;%- &]
[s5;:Stream`:`:GetAll64`(void`*`,int64`):%- [@(0.0.255) bool]_[* GetAll64]([@(0.0.255) void
]_`*[*@3 data], [_^int64^ int64]_[*@3 size])&]
[s2; Reads [%-*@3 size] bytes from the stream to memory at [%-*@3 data]. 
If there is not enough data in the stream, LoadError is invoked 
(that in turn might throw an exception). Returns true if required 
number of bytes was read. Unlike regular Get, block size can 
be greater than 2GB, if CPU is 64 bit.&]
[s3; &]
[s4;%- &]
[s5;:Stream`:`:LoadThrowing`(`):%- [@(0.0.255) void]_[* LoadThrowing]()&]
[s2; Sets stream into the mode that throws LoadingError exception 
when LoadError is invoked. This mode is typical for serialization 
usage of stream.&]
[s3; &]
[s4;%- &]
[s5;:Stream`:`:LoadError`(`):%- [@(0.0.255) void]_[* LoadError]()&]
[s2; Performs SetError(ERROR`_LOADING`_FAILED). If Stream set to 
the LoadThrowing mode (by LoadThrowing() method), LoadingError 
exception is thrown.&]
[s3; &]
[s4;%- &]
[s5;:Stream`:`:Get8`(`):%- [@(0.0.255) int]_[* Get8]()&]
[s2; Reads a single byte from the stream. If there is not enough 
data in the stream, LoadError is invoked (that in turn might 
throw an exception) `- this is the difference from Get() method.&]
[s7; [*/ Return value]-|Byte from stream or `-1.&]
[s3; &]
[s4;%- &]
[s5;:Stream`:`:Get16`(`):%- [@(0.0.255) int]_[* Get16]()&]
[s2; Reads 16`-bit value from the stream in platform specific format 
(either little`-endian or big`-endian). If there is not enough 
data in the stream, LoadError is invoked (that in turn might 
throw an exception) and `-1 returned.&]
[s7; [*/ Return value]-|16`-bit value.&]
[s3; &]
[s4;%- &]
[s5;:Stream`:`:Get32`(`):%- [@(0.0.255) int]_[* Get32]()&]
[s2; Reads 32`-bit value from the stream in platform specific format 
(either little`-endian or big`-endian). If there is not enough 
data in the stream, LoadError is invoked (that in turn might 
throw an exception) and `-1 returned (but that is a valid return 
value as well).&]
[s7; [*/ Return value]-|32`-bit value.&]
[s3; &]
[s4;%- &]
[s5;:Stream`:`:Get64`(`):%- [_^int64^ int64]_[* Get64]()&]
[s2; Reads 64`-bit value from the stream in platform specific format 
(either little`-endian or big`-endian). If there is not enough 
data in the stream, LoadError is invoked (that in turn might 
throw an exception) and `-1 returned (but that is a valid return 
value as well).&]
[s7; [*/ Return value]-|64`-bit value.&]
[s3; &]
[s4;%- &]
[s5;:Stream`:`:Get16le`(`):%- [@(0.0.255) int]_[* Get16le]()&]
[s2; Reads 16`-bit value from the stream in the little`-endian mode. 
If there is not enough data in the stream, LoadError is invoked 
(that in turn might throw an exception) and `-1 returned.&]
[s7; [*/ Return value]-|16`-bit value.&]
[s3; &]
[s4;%- &]
[s5;:Stream`:`:Get32le`(`):%- [@(0.0.255) int]_[* Get32le]()&]
[s2; Reads 32`-bit value from the stream in the little`-endian mode. 
If there is not enough data in the stream, LoadError is invoked 
(that in turn might throw an exception) and `-1 returned (but 
that is a valid return value as well).&]
[s7; [*/ Return value]-|32`-bit value.&]
[s3; &]
[s4;%- &]
[s5;:Stream`:`:Get64le`(`):%- [_^int64^ int64]_[* Get64le]()&]
[s2; Reads 64`-bit value from the stream in the little`-endian mode. 
If there is not enough data in the stream, LoadError is invoked 
(that in turn might throw an exception) and `-1 returned (but 
that is a valid value return as well).&]
[s7; [*/ Return value]-|64`-bit value.&]
[s3; &]
[s4;%- &]
[s5;:Stream`:`:Get16be`(`):%- [@(0.0.255) int]_[* Get16be]()&]
[s2; Reads 16`-bit value from the stream in the big`-endian mode. 
If there is not enough data in the stream, LoadError is invoked 
(that in turn might throw an exception) and `-1 is returned.&]
[s7; [*/ Return value]-|16`-bit value.&]
[s3; &]
[s4;%- &]
[s5;:Stream`:`:Get32be`(`):%- [@(0.0.255) int]_[* Get32be]()&]
[s2; Reads 32`-bit value from the stream in the big`-endian mode. 
If there is not enough data in the stream, LoadError is invoked 
(that in turn might throw an exception) and `-1 returned (but 
that is a valid value return as well).&]
[s7; [*/ Return value]-|32`-bit value.&]
[s3; &]
[s4;%- &]
[s5;:Stream`:`:Get64be`(`):%- [_^int64^ int64]_[* Get64be]()&]
[s2; Reads 64`-bit value from the stream in the big`-endian mode. 
If there is not enough data in the stream, LoadError is invoked 
(that in turn might throw an exception) and `-1 returned (but 
that is a valid value return as well).&]
[s7; [*/ Return value]-|64`-bit value.&]
[s3; &]
[s4;%- &]
[s5;:Stream`:`:GetLine`(`):%- [_^String^ String]_[* GetLine]()&]
[s2; Reads single line from the stream. Line is delimited by `'`\n`' 
character or the end of file (or error). `'`\r`' characters are 
ignored.&]
[s7; [*/ Return value]-|Line from the stream.&]
[s3; &]
[s4;%- &]
[s5;:Stream`:`:GetUtf8`(`):%- [@(0.0.255) int]_[* GetUtf8]()&]
[s2; Reads single Utf8 encoded value from the stream.&]
[s7; [*/ Return value]-|Utf`-8 value.&]
[s3; &]
[s4;%- &]
[s5;:Stream`:`:Put16`(word`):%- [@(0.0.255) void]_[* Put16]([_^word^ word]_[*@3 q])&]
[s2; Writes 16`-bit value [%-*@3 q ]in platform specific format (either 
little`-endian or big`-endian).&]
[s3; &]
[s4;%- &]
[s5;:Stream`:`:Put32`(dword`):%- [@(0.0.255) void]_[* Put32]([_^dword^ dword]_[*@3 q])&]
[s2; Writes 32`-bit value [%-*@3 q ]in platform specific format (either 
little`-endian or big`-endian).&]
[s3; &]
[s4;%- &]
[s5;:Stream`:`:Put64`(int64`):%- [@(0.0.255) void]_[* Put64]([_^int64^ int64]_[*@3 q])&]
[s2; Writes 64`-bit value [%-*@3 q ]in platform specific format (either 
little`-endian or big`-endian).&]
[s3; &]
[s4;%- &]
[s5;:Stream`:`:Put16le`(word`):%- [@(0.0.255) void]_[* Put16le]([_^word^ word]_[*@3 q])&]
[s2; Writes 16`-bit value [%-*@3 q ]in little`-endian mode.&]
[s3; &]
[s4;%- &]
[s5;:Stream`:`:Put32le`(dword`):%- [@(0.0.255) void]_[* Put32le]([_^dword^ dword]_[*@3 q])&]
[s2; Writes 32`-bit value [%-*@3 q ]in little`-endian mode.&]
[s3; &]
[s4;%- &]
[s5;:Stream`:`:Put64le`(int64`):%- [@(0.0.255) void]_[* Put64le]([_^int64^ int64]_[*@3 q])&]
[s2; Writes 64`-bit value [%-*@3 q ]in little`-endian mode.&]
[s3; &]
[s4;%- &]
[s5;:Stream`:`:Put16be`(word`):%- [@(0.0.255) void]_[* Put16be]([_^word^ word]_[*@3 q])&]
[s2; Writes 16`-bit value [%-*@3 q ]in big`-endian mode.&]
[s3; &]
[s4;%- &]
[s5;:Stream`:`:Put32be`(dword`):%- [@(0.0.255) void]_[* Put32be]([_^dword^ dword]_[*@3 q])&]
[s2; Writes 32`-bit value [%-*@3 q ]in big`-endian mode.&]
[s3; &]
[s4;%- &]
[s5;:Stream`:`:Put64be`(int64`):%- [@(0.0.255) void]_[* Put64be]([_^int64^ int64]_[*@3 q])&]
[s2; Writes 64`-bit value [%-*@3 q ]in big`-endian mode.&]
[s3; &]
[s4;%- &]
[s5;:Stream`:`:PutUtf8`(int`):%- [@(0.0.255) void]_[* PutUtf8]([@(0.0.255) int]_[*@3 c])&]
[s2; Puts a single Utf8 value to the stream.&]
[s7; [%-*C@3 c]-|Value.&]
[s3; &]
[s4;%- &]
[s5;:Stream`:`:Put`(const char`*`):%- [@(0.0.255) void]_[* Put]([@(0.0.255) const]_[@(0.0.255) c
har]_`*[*@3 s])&]
[s2; Writes zero terminated string to the stream (zero is not written).&]
[s7; [%-*C@3 s]-|String to write.&]
[s3; &]
[s4;%- &]
[s5;:Stream`:`:Put`(const String`&`):%- [@(0.0.255) void]_[* Put]([@(0.0.255) const]_[_^String^ S
tring][@(0.0.255) `&]_[*@3 s])&]
[s2; Writes String to the the stream. String can contain zero characters.&]
[s7; [%-*C@3 s]-|String to write.&]
[s3; &]
[s4;%- &]
[s5;:Stream`:`:Put`(int`,int`):%- [@(0.0.255) void]_[* Put]([@(0.0.255) int]_[*@3 c], 
[@(0.0.255) int]_[*@3 count])&]
[s2; Writes single byte to the stream requested number of times.&]
[s7; [%-*C@3 c]-|Byte to write.&]
[s7; [%-*C@3 count]-|Repeat count.&]
[s3; &]
[s4;%- &]
[s5;:Stream`:`:Put0`(int`):%- [@(0.0.255) void]_[* Put0]([@(0.0.255) int]_[*@3 count])&]
[s2; Writes zero byte to the stream requested number of times. This 
variation is mainly provided because Put(0, count) causes ambiguity 
as 0 is considered as NULL pointer too...&]
[s7; [%-*C@3 count]-|Repeat count.&]
[s3; &]
[s4;%- &]
[s5;:Stream`:`:PutW`(const wchar`*`,int`):%- [@(0.0.255) void]_[* PutW]([@(0.0.255) const]_
[_^wchar^ wchar]_`*[*@3 s], [@(0.0.255) int]_[*@3 count])&]
[s2; Writes a specified number of wchars (16`-bit character values) 
to the stream in platform specific format (little`-endian or 
big`-endian).&]
[s7; [%-*C@3 s]-|String to write.&]
[s7; [%-*C@3 count]-|Length of string.&]
[s3; &]
[s4;%- &]
[s5;:Stream`:`:GetW`(wchar`*`,int`):%- [_^dword^ dword]_[* GetW]([_^wchar^ wchar]_`*[*@3 s], 
[@(0.0.255) int]_[*@3 count])&]
[s2; Reads a specified number of wchars (16`-bit character values) 
from the stream in platform specific format.&]
[s7; [%-*C@3 s]-|Pointer to buffer to receive wchars.&]
[s7; [%-*C@3 count]-|Number of wchars.&]
[s7; [*/ Return value]-|Number of wchars actually read.&]
[s3; &]
[s4;%- &]
[s5;:Stream`:`:GetAllW`(wchar`*`,int`):%- [@(0.0.255) bool]_[* GetAllW]([_^wchar^ wchar]_`*
[*@3 s], [@(0.0.255) int]_[*@3 count])&]
[s2; Reads a specified number of wchars (16`-bit character values) 
from the stream in platform specific format. If there is not 
enough data in the stream, LoadError is invoked (that in turn 
might throw an exception).&]
[s7; [%-*C@3 s]-|&]
[s7; [%-*C@3 count]-|&]
[s7; [*/ Return value]-|&]
[s3; &]
[s4;%- &]
[s5;:Stream`:`:PutCrLf`(`):%- [@(0.0.255) void]_[* PutCrLf]()&]
[s2; Writes CR`-LF pair to the stream. &]
[s3; &]
[s4;%- &]
[s5;:Stream`:`:PutEol`(`):%- [@(0.0.255) void]_[* PutEol]()&]
[s2; Writes platform specific `"end of line`" to the stream. It is 
CR`-LF pair on Win32 platform or single LF on Posix platform.&]
[s3; &]
[s4;%- &]
[s5;:Stream`:`:operator`<`<`(EOLenum`):%- [_^Stream^ Stream][@(0.0.255) `&]_[* operator<<](
EOLenum)&]
[s2; This is the same as PutEol. EOLenum contains single value, EOL. 
This is operator allows more convenient way to express PutEol 
in the chain of << operators.&]
[s3; &]
[s4;%- &]
[s5;:Stream`:`:PutLine`(const char`*`):%- [@(0.0.255) void]_[* PutLine]([@(0.0.255) const]_
[@(0.0.255) char]_`*[*@3 s])&]
[s2; Writes a line to stream `- equivalent of Put(s); PutEol();&]
[s7; [%-*C@3 s]-|Zero`-terminated string.&]
[s3; &]
[s4;%- &]
[s5;:Stream`:`:PutLine`(const String`&`):%- [@(0.0.255) void]_[* PutLine]([@(0.0.255) const
]_[_^String^ String][@(0.0.255) `&]_[*@3 s])&]
[s2; Writes a line to stream `- equivalent of Put(s); PutEol();&]
[s7; [%-*C@3 s]-|String.&]
[s3; &]
[s4;%- &]
[s5;:Stream`:`:Put`(Stream`&`,int64`,dword`):%- [@(0.0.255) void]_[* Put]([_^Stream^ Stream
][@(0.0.255) `&]_[*@3 s], [_^int64^ int64]_[*@3 size]_`=_INT64`_MAX, 
[_^dword^ dword]_[*@3 click]_`=_[@3 4096])&]
[s2; Writes a content of specified stream to the stream.&]
[s7; [%-*C@3 s]-|Input stream.&]
[s7; [%-*C@3 size]-|Maximum number of bytes to write. Default value 
INT64`_MAX means whole input stream from current position to 
the end is written.&]
[s7; [%-*C@3 click]-|Size of buffer used for copying.&]
[s3; &]
[s0; &]
[ {{10000F(128)G(128)@1 [s0; [* Public Member List: Serialization Support]]}}&]
[s3;%- &]
[s5;:Stream`:`:SetLoading`(`):%- [@(0.0.255) void]_[* SetLoading]()&]
[s2; Sets the stream into the loading mode.&]
[s3; &]
[s4;%- &]
[s5;:Stream`:`:SetStoring`(`):%- [@(0.0.255) void]_[* SetStoring]()&]
[s2; Sets the stream into the storing mode.&]
[s3; &]
[s4;%- &]
[s5;:Stream`:`:IsLoading`(`)const:%- [@(0.0.255) bool]_[* IsLoading]()_[@(0.0.255) const]&]
[s2; Returns true if stream is in loading mode.&]
[s3;%- &]
[s4;%- &]
[s5;:Stream`:`:IsStoring`(`)const:%- [@(0.0.255) bool]_[* IsStoring]()_[@(0.0.255) const]&]
[s2; Returns true if stream is in storing mode.&]
[s3; &]
[s4;%- &]
[s5;:Stream`:`:SerializeRaw`(byte`*`,int`):%- [@(0.0.255) void]_[* SerializeRaw]([_^byte^ b
yte]_`*[*@3 data], [@(0.0.255) int]_[*@3 count])&]
[s2; Serializes raw 8`-bit data. Might invoke LoadError if there 
is not enough data to load.&]
[s7; [%-*C@3 data]-|Pointer to data to store or buffer to receive loaded 
data.&]
[s7; [%-*C@3 count]-|Number of bytes to load/store.&]
[s3; &]
[s4;%- &]
[s5;:Stream`:`:SerializeRaw`(word`*`,int`):%- [@(0.0.255) void]_[* SerializeRaw]([_^word^ w
ord]_`*[*@3 data], [@(0.0.255) int]_[*@3 count])&]
[s2; Serializes raw 16`-bit data. Might invoke LoadError if there 
is not enough data to load.&]
[s7; [%-*C@3 data]-|Pointer to data to store or buffer to receive loaded 
data.&]
[s7; [%-*C@3 count]-|Number of values to load/store.&]
[s3; &]
[s4;%- &]
[s5;:Stream`:`:SerializeRaw`(dword`*`,int`):%- [@(0.0.255) void]_[* SerializeRaw]([_^dword^ d
word]_`*[*@3 data], [@(0.0.255) int]_[*@3 count])&]
[s2; Serializes raw 32`-bit data. Might invoke LoadError if there 
is not enough data to load.&]
[s7; [%-*C@3 data]-|Pointer to data to store or buffer to receive loaded 
data.&]
[s7; [%-*C@3 count]-|Number of values to load/store.&]
[s3; &]
[s4;%- &]
[s5;:Stream`:`:SerializeRaw`(uint64`*`,int`):%- [@(0.0.255) void]_[* SerializeRaw]([_^uint64^ u
int64]_`*[*@3 data], [@(0.0.255) int]_[*@3 count])&]
[s2; Serializes raw 64`-bit data. Might invoke LoadError if there 
is not enough data to load.&]
[s7; [%-*C@3 data]-|Pointer to data to store or buffer to receive loaded 
data.&]
[s7; [%-*C@3 count]-|Number of values to load/store.&]
[s3; &]
[s4;%- &]
[s5;:Stream`:`:SerializeRLE`(byte`*`,int`):%- [@(0.0.255) void]_[* SerializeRLE]([_^byte^ b
yte]_`*[*@3 data], [@(0.0.255) int]_[*@3 count])&]
[s2; Serializes raw data, using simple RLE compression.&]
[s3; &]
[s4;%- &]
[s5;:Stream`:`:operator`%`(bool`&`):%- [_^Stream^ Stream][@(0.0.255) `&]_[* operator%]([@(0.0.255) b
ool`&]_[*@3 d])&]
[s2; Serializes bool variable [%-*@3 d]. Might invoke LoadError if 
there is not enough data to load. Returns [* `*this] for chaining.&]
[s3; &]
[s4;%- &]
[s5;:Stream`:`:operator`%`(char`&`):%- [_^Stream^ Stream][@(0.0.255) `&]_[* operator%]([@(0.0.255) c
har`&]_[*@3 d])&]
[s2; Serializes char variable [%-*@3 d]. Might invoke LoadError if 
there is not enough data to load. Returns [* `*this] for chaining.&]
[s3; &]
[s4;%- &]
[s5;:Stream`:`:operator`%`(signed char`&`):%- [_^Stream^ Stream][@(0.0.255) `&]_[* operator
%]([@(0.0.255) signed]_[@(0.0.255) char`&]_[*@3 d])&]
[s2; Serializes signed char variable [%-*@3 d]. Might invoke LoadError 
if there is not enough data to load. Returns [* `*this] for chaining.&]
[s3; &]
[s4;%- &]
[s5;:Stream`:`:operator`%`(unsigned char`&`):%- [_^Stream^ Stream][@(0.0.255) `&]_[* operat
or%]([@(0.0.255) unsigned]_[@(0.0.255) char`&]_[*@3 d])&]
[s2; Serializes unsigned char variable [%-*@3 d]. Might invoke LoadError 
if there is not enough data to load. Returns [* `*this] for chaining.&]
[s3; &]
[s4;%- &]
[s5;:Stream`:`:operator`%`(short`&`):%- [_^Stream^ Stream][@(0.0.255) `&]_[* operator%]([@(0.0.255) s
hort`&]_[*@3 d])&]
[s2; Serializes short variable [%-*@3 d]. Might invoke LoadError if 
there is not enough data to load. Returns [* `*this] for chaining.&]
[s3; &]
[s4;%- &]
[s5;:Stream`:`:operator`%`(unsigned short`&`):%- [_^Stream^ Stream][@(0.0.255) `&]_[* opera
tor%]([@(0.0.255) unsigned]_[@(0.0.255) short`&]_[*@3 d])&]
[s2; Serializes unsigned short variable [%-*@3 d]. Might invoke LoadError 
if there is not enough data to load. Returns [* `*this] for chaining.&]
[s3; &]
[s4;%- &]
[s5;:Stream`:`:operator`%`(int`&`):%- [_^Stream^ Stream][@(0.0.255) `&]_[* operator%]([@(0.0.255) i
nt`&]_[*@3 d])&]
[s2; Serializes int variable [%-*@3 d]. Might invoke LoadError if there 
is not enough data to load. Returns [* `*this] for chaining.&]
[s3; &]
[s4;%- &]
[s5;:Stream`:`:operator`%`(unsigned int`&`):%- [_^Stream^ Stream][@(0.0.255) `&]_[* operato
r%]([@(0.0.255) unsigned]_[@(0.0.255) int`&]_[*@3 d])&]
[s2; Serializes unsigned int variable [%-*@3 d]. Might invoke LoadError 
if there is not enough data to load. Returns [* `*this] for chaining.&]
[s3; &]
[s4;%- &]
[s5;:Stream`:`:operator`%`(long`&`):%- [_^Stream^ Stream][@(0.0.255) `&]_[* operator%]([@(0.0.255) l
ong`&]_[*@3 d])&]
[s2; Serializes long variable [%-*@3 d]. Might invoke LoadError if 
there is not enough data to load. Returns [* `*this] for chaining.&]
[s3; &]
[s4;%- &]
[s5;:Stream`:`:operator`%`(unsigned long`&`):%- [_^Stream^ Stream][@(0.0.255) `&]_[* operat
or%]([@(0.0.255) unsigned]_[@(0.0.255) long`&]_[*@3 d])&]
[s2; Serializes unsigned long variable [%-*@3 d]. Might invoke LoadError 
if there is not enough data to load. Returns [* `*this] for chaining.&]
[s3; &]
[s4;%- &]
[s5;:Stream`:`:operator`%`(float`&`):%- [_^Stream^ Stream][@(0.0.255) `&]_[* operator%]([@(0.0.255) f
loat`&]_[*@3 d])&]
[s2; Serializes float variable [%-*@3 d]. Might invoke LoadError if 
there is not enough data to load. Returns [* `*this] for chaining.&]
[s3; &]
[s4;%- &]
[s5;:Stream`:`:operator`%`(double`&`):%- [_^Stream^ Stream][@(0.0.255) `&]_[* operator%]([@(0.0.255) d
ouble`&]_[*@3 d])&]
[s2; Serializes double variable [%-*@3 d]. Might invoke LoadError if 
there is not enough data to load. Returns [* `*this] for chaining.&]
[s3; &]
[s4;%- &]
[s5;:Stream`:`:operator`%`(int64`&`):%- [_^Stream^ Stream][@(0.0.255) `&]_[* operator%]([_^int64^ i
nt64][@(0.0.255) `&]_[*@3 d])&]
[s2; Serializes int64 variable [%-*@3 d]. Might invoke LoadError if 
there is not enough data to load. Returns [* `*this] for chaining.&]
[s3; &]
[s4;%- &]
[s5;:Stream`:`:operator`%`(uint64`&`):%- [_^Stream^ Stream][@(0.0.255) `&]_[* operator%]([_^uint64^ u
int64][@(0.0.255) `&]_[*@3 d])&]
[s2; Serializes uint64 variable [%-*@3 d]. Might invoke LoadError if 
there is not enough data to load. Returns [* `*this] for chaining.&]
[s3; &]
[s4;%- &]
[s5;:Stream`:`:operator`%`(String`&`):%- [_^Stream^ Stream][@(0.0.255) `&]_[* operator%]([_^String^ S
tring][@(0.0.255) `&]_[*@3 s])&]
[s2; Serializes String variable [%-*@3 s]. Might invoke LoadError if 
there is not enough data to load or input data are invalid. Returns 
[* `*this] for chaining.&]
[s3; &]
[s4;%- &]
[s5;:Stream`:`:operator`/`(String`&`):%- [_^Stream^ Stream][@(0.0.255) `&]_[* operator/]([_^String^ S
tring][@(0.0.255) `&]_[*@3 s])&]
[s2; Serializes String variable [%-*@3 s ]using RLE compression and 
packed format for length. Might invoke LoadError if there is 
not enough data to load or input data are invalid. Returns [* `*this] 
for chaining.&]
[s3; &]
[s4;%- &]
[s5;:Stream`:`:operator`%`(WString`&`):%- [_^Stream^ Stream][@(0.0.255) `&]_[* operator%]([_^WString^ W
String][@(0.0.255) `&]_[*@3 s])&]
[s2; Serializes WString variable. Might invoke LoadError if there 
is not enough data to load or input data are invalid. Returns 
[* `*this] for chaining.&]
[s3; &]
[s4;%- &]
[s5;:Stream`:`:operator`/`(WString`&`):%- [_^Stream^ Stream][@(0.0.255) `&]_[* operator/]([_^WString^ W
String][@(0.0.255) `&]_[*@3 s])&]
[s2; Serializes String variable using RLE compression and packed 
format for length. Might invoke LoadError if there is not enough 
data to load or input data are invalid. Returns [* `*this] for 
chaining.&]
[s3; &]
[s4;%- &]
[s5;:Stream`:`:Pack`(dword`&`):%- [@(0.0.255) void]_[* Pack]([_^dword^ dword][@(0.0.255) `&]_
[*@3 i])&]
[s2; Serializes dword value using format optimized for storing small 
values. Values 0..254 are stored as serializes as single byte, 
other values result in 5 bytes. Might invoke LoadError if there 
is not enough data to load or input data are invalid.&]
[s7; [%-*C@3 i]-|Variable to serialize.&]
[s3; &]
[s4;%- &]
[s5;:Stream`:`:operator`/`(int`&`):%- [_^Stream^ Stream][@(0.0.255) `&]_[* operator/]([@(0.0.255) i
nt`&]_[*@3 i])&]
[s2; Serializes int value using format optimized for storing small 
values. Might invoke LoadError if there is not enough data to 
load or input data are invalid.&]
[s7; [%-*C@3 i]-|Variable to serialize.&]
[s7; [*/ Return value]-|`*this for chaining.&]
[s3; &]
[s4;%- &]
[s5;:Stream`:`:operator`/`(unsigned int`&`):%- [_^Stream^ Stream][@(0.0.255) `&]_[* operato
r/]([@(0.0.255) unsigned]_[@(0.0.255) int`&]_[*@3 i])&]
[s2; Serializes unsigned int value using format optimized for storing 
small values. Might invoke LoadError if there is not enough data 
to load or input data are invalid.&]
[s7; [%-*C@3 i]-|Variable to serialize.&]
[s7; [*/ Return value]-|`*this for chaining.&]
[s3; &]
[s4;%- &]
[s5;:Stream`:`:Magic`(dword`):%- [@(0.0.255) void]_[* Magic]([_^dword^ dword]_[*@3 magic]_`=_
[@3 0]x7d674d7b)&]
[s2; Serializes `"magic value`" to ensure stream integrity. When 
loading, this value is loaded and checked `- mismatch results 
in invoking LoadError.&]
[s7; [%-*C@3 magic]-|Magic value.&]
[s3; &]
[s4;%- &]
[s5;:Stream`:`:Pack`(bool`&`,bool`&`,bool`&`,bool`&`,bool`&`,bool`&`,bool`&`,bool`&`):%- [@(0.0.255) v
oid]_[* Pack]([@(0.0.255) bool`&]_[*@3 a], [@(0.0.255) bool`&]_[*@3 b], 
[@(0.0.255) bool`&]_[*@3 c], [@(0.0.255) bool`&]_[*@3 d], [@(0.0.255) bool`&]_[*@3 e], 
[@(0.0.255) bool`&]_[*@3 f], [@(0.0.255) bool`&]_[*@3 g], [@(0.0.255) bool`&]_[*@3 h])&]
[s2; Serializes a set of boolean values compressed into single byte.&]
[s3; &]
[s4;%- &]
[s5;:Stream`:`:Pack`(bool`&`,bool`&`,bool`&`,bool`&`,bool`&`,bool`&`,bool`&`):%- [@(0.0.255) v
oid]_[* Pack]([@(0.0.255) bool`&]_[*@3 a], [@(0.0.255) bool`&]_[*@3 b], 
[@(0.0.255) bool`&]_[*@3 c], [@(0.0.255) bool`&]_[*@3 d], [@(0.0.255) bool`&]_[*@3 e], 
[@(0.0.255) bool`&]_[*@3 f], [@(0.0.255) bool`&]_[*@3 g])&]
[s2; Serializes a set of boolean values compressed into single byte.&]
[s3; &]
[s4;%- &]
[s5;:Stream`:`:Pack`(bool`&`,bool`&`,bool`&`,bool`&`,bool`&`,bool`&`):%- [@(0.0.255) vo
id]_[* Pack]([@(0.0.255) bool`&]_[*@3 a], [@(0.0.255) bool`&]_[*@3 b], 
[@(0.0.255) bool`&]_[*@3 c], [@(0.0.255) bool`&]_[*@3 d], [@(0.0.255) bool`&]_[*@3 e], 
[@(0.0.255) bool`&]_[*@3 f])&]
[s2; Serializes a set of boolean values compressed into single byte.&]
[s3; &]
[s4;%- &]
[s5;:Stream`:`:Pack`(bool`&`,bool`&`,bool`&`,bool`&`,bool`&`):%- [@(0.0.255) void]_[* Pac
k]([@(0.0.255) bool`&]_[*@3 a], [@(0.0.255) bool`&]_[*@3 b], [@(0.0.255) bool`&]_[*@3 c], 
[@(0.0.255) bool`&]_[*@3 d], [@(0.0.255) bool`&]_[*@3 e])&]
[s2; Serializes a set of boolean values compressed into single byte.&]
[s3; &]
[s4;%- &]
[s5;:Stream`:`:Pack`(bool`&`,bool`&`,bool`&`,bool`&`):%- [@(0.0.255) void]_[* Pack]([@(0.0.255) b
ool`&]_[*@3 a], [@(0.0.255) bool`&]_[*@3 b], [@(0.0.255) bool`&]_[*@3 c], 
[@(0.0.255) bool`&]_[*@3 d])&]
[s2; Serializes a set of boolean values compressed into single byte.&]
[s3; &]
[s4;%- &]
[s5;:Stream`:`:Pack`(bool`&`,bool`&`,bool`&`):%- [@(0.0.255) void]_[* Pack]([@(0.0.255) boo
l`&]_[*@3 a], [@(0.0.255) bool`&]_[*@3 b], [@(0.0.255) bool`&]_[*@3 c])&]
[s2; Serializes a set of boolean values compressed into single byte.&]
[s4;%- &]
[s5;:Stream`:`:Pack`(bool`&`,bool`&`):%- [@(0.0.255) void]_[* Pack]([@(0.0.255) bool`&]_[*@3 a
], [@(0.0.255) bool`&]_[*@3 b])&]
[s2; Serializes a set of boolean values compressed into single byte.&]
[s3; &]
[s0;3 &]
[s0;3 &]
[s0;%- &]
[ {{10000@(113.42.0) [s0; [*@7;4 StringStream]]}}&]
[s3; &]
[s1;:StringStream`:`:class:%- [@(0.0.255)3 class][3 _][*3 StringStream][3 _:_][@(0.0.255)3 publi
c][3 _][*@3;3 Stream]&]
[s9; StringStream is stream that uses String as storage medium.&]
[s2; &]
[s0;%- [%%/ Derived from][%%  ][^topic`:`/`/Core`/src`/Stream`$en`-us`#`:`:Stream`:`:class Stream^ S
tream]&]
[s3; &]
[s0;%- &]
[ {{10000F(128)G(128)@1 [s0; [* Constructor Detail]]}}&]
[s3;%- &]
[s5;:StringStream`:`:StringStream`(`):%- [* StringStream]()&]
[s2; Consructs empty stream and sets it into Storing serialization 
mode (like [* Create]).&]
[s3; &]
[s4;%- &]
[s5;:StringStream`:`:StringStream`(const String`&`):%- [* StringStream]([@(0.0.255) const
]_[_^String^ String][@(0.0.255) `&]_[*@3 data])&]
[s2; Constructs stream with specified content and sets it into Loading 
serialization mode (like [* Open]).&]
[s7; [%-*C@3 data]-|Content of stream.&]
[s3; &]
[s0;%- &]
[ {{10000F(128)G(128)@1 [s0; [* Public Member List: Serialization Support]]}}&]
[s3;%- &]
[s5;:StringStream`:`:Open`(const String`&`):%- [@(0.0.255) void]_[* Open]([@(0.0.255) const
]_[_^String^ String][@(0.0.255) `&]_[*@3 data])&]
[s2;%- Sets the content of stream to specified String and sets it 
into the Loading serialization mode.&]
[s7; [%-*C@3 data]-|Content of stream.&]
[s3; &]
[s4;%- &]
[s5;:StringStream`:`:Create`(`):%- [@(0.0.255) void]_[* Create]()&]
[s2; Creates empty StringStream and sets it into Storing serialization 
mode.&]
[s3; &]
[s4;%- &]
[s5;:StringStream`:`:Reserve`(int`):%- [@(0.0.255) void]_[* Reserve]([@(0.0.255) int]_[*@3 n])
&]
[s2; Reserves additional [%-*@3 n] bytes of internal storage as optimization 
hint. This might speedup the operation in certain cases if you 
know how much data approximately will be put into StringStream.&]
[s3; &]
[s4;%- &]
[s5;:StringStream`:`:GetResult`(`):%- [_^String^ String]_[* GetResult]()&]
[s2; Returns resulting String.&]
[s7; [*/ Return value]-|Result.&]
[s3; &]
[s4;%- &]
[s5;:StringStream`:`:operator String`(`):%- [* operator_String]()&]
[s7; [*/ Return value]-|[^topic`:`/`/Core`/src`/Stream`$en`-us`#StringStream`:`:GetResult`(`)^ G
etResult]().&]
[s0;3 &]
[s0;3 &]
[s0;3 &]
[s0;%- &]
[ {{10000@(113.42.0) [s0; [*@7;4 MemStream]]}}&]
[s3; &]
[s1;:MemStream`:`:class:%- [@(0.0.255)3 class][3 _][*3 MemStream][3 _:_][@(0.0.255)3 public][3 _][*@3;3 S
tream]&]
[s9; Stream that is using raw memory as its content.&]
[s2; &]
[s0;%- [%%/ Derived from][%%  ][^topic`:`/`/Core`/src`/Stream`$en`-us`#`:`:Stream`:`:class Stream^ S
tream]&]
[s3; &]
[s0; &]
[ {{10000F(128)G(128)@1 [s0; [* Constructor Detail]]}}&]
[s3;%- &]
[s5;:MemStream`:`:MemStream`(void`*`,int`):%- [* MemStream]([@(0.0.255) void]_`*[*@3 data],
 [@(0.0.255) int]_[*@3 size])&]
[s2; Constructs [* MemStream] at specified memory buffer.&]
[s7; [%-*C@3 data]-|Pointer to the stream content.&]
[s7; [%-*C@3 size]-|Size.&]
[s0;3 &]
[s0;3 &]
[s0;3 &]
[s0;%- &]
[ {{10000@(113.42.0) [s0; [*@7;4 MemReadStream]]}}&]
[s3;%- &]
[s1;:MemReadStream`:`:class:%- [@(0.0.255)3 class][3 _][*3 MemReadStream][3 _:_][@(0.0.255)3 pub
lic][3 _][*@3;3 MemStream]&]
[s9; Read`-only stream using raw memory as content.&]
[s2; &]
[s0;%- [%%/ Derived from][%%  ][^topic`:`/`/Core`/src`/Stream`$en`-us`#`:`:MemStream`:`:class MemStream^ M
emStream]&]
[s3; &]
[s0;%- &]
[ {{10000F(128)G(128)@1 [s0; [* Constructor Detail]]}}&]
[s3; &]
[s5;:MemReadStream`:`:MemReadStream`(const void`*`,int`):%- [* MemReadStream]([@(0.0.255) c
onst]_[@(0.0.255) void]_`*[*@3 data], [@(0.0.255) int]_[*@3 size])&]
[s2; Constructs [* MemStream] at specified memory buffer.&]
[s7; [%-*C@3 data]-|Pointer to the stream content.&]
[s7; [%-*C@3 size]-|Size.&]
[s3; &]
[s0;3 &]
[s0;3 &]
[s0;%- &]
[ {{10000@(113.42.0) [s0; [*@7;4 BlockStream]]}}&]
[s3; &]
[s1;:BlockStream`:`:class:%- [@(0.0.255)3 class][3 _][*3 BlockStream][3 _:_][@(0.0.255)3 public][3 _
][*@3;3 Stream]&]
[s9; BlockStream implements operations needed to manage streams that 
are able to read or write a block of data at random positon. 
BlockStream provides buffered implementation of such stream. 
It implements all virtual methods of Stream, with exception of 
[* IsOpen] and [* Close], using new virtual methods [* Read], [* Write] 
and [* SetStreamSize].&]
[s2; &]
[s0;%- [%%/ Derived from][%%  ][^topic`:`/`/Core`/src`/Stream`$en`-us`#`:`:BufferStream`:`:class BufferStream^ B
ufferStream]&]
[s3; &]
[s0;%- &]
[ {{10000F(128)G(128)@1 [s0; [* Public Member List]]}}&]
[s3;%- &]
[s0;%- [@(0.0.255) enum]_`{_[*@3 READ], [*@3 CREATE], [*@3 APPEND], [*@3 READWRITE], 
[*@3 NOWRITESHARE], [*@3 DELETESHARE], [*@3 NOREADSHARE], [*@3 SHAREMASK]_`}&]
[s2; This enum defines basic operation modes of BlockStream (used 
combined with binary or).&]
[s7;:`:`:BlockStream`:`:READ: [%-*C@3 READ]-|Read mode.&]
[s7;:`:`:BlockStream`:`:CREATE: [%-*C@3 CREATE]-|Write mode.&]
[s7;:`:`:BlockStream`:`:APPEND: [%-*C@3 APPEND]-|Append mode `- means 
that initial position in the stream is at the end of it.&]
[s7;:`:`:BlockStream`:`:READWRITE: [%-*C@3 READWRITE]-|Enables subsequent 
streams full access to stream.&]
[s7;:`:`:BlockStream`:`:NOWRITESHARE: [%-*C@3 NOWRITESHARE]-|Disables 
subsequent streams to write to the stream.&]
[s7;:`:`:BlockStream`:`:DELETESHARE: [%-*C@3 DELETESHARE]-|Enables subsequent 
streams to delete the stream.&]
[s7;:`:`:BlockStream`:`:NOREADSHARE: [%-*C@3 NOREADSHARE]-|Disables 
subsequent streams to read the stream.&]
[s3; &]
[s4;%- &]
[s5;:BlockStream`:`:SetBufferSize`(dword`):%- [@(0.0.255) void]_[* SetBufferSize]([_^dword^ d
word]_[*@3 newsize])&]
[s2; Sets a new size of internal buffer.&]
[s7; [%-*C@3 newsize]-|The new size of buffer.&]
[s3; &]
[s4;%- &]
[s5;:BlockStream`:`:GetBufferSize`(`)const:%- [_^dword^ dword]_[* GetBufferSize]()_[@(0.0.255) c
onst]&]
[s2; [*/ Return value]-|Size of buffer.&]
[s3;%- &]
[s0;%- &]
[ {{10000F(128)G(128)@1 [s0; [* Protected Member List]]}}&]
[s3; &]
[s5;:BlockStream`:`:Read`(int64`,void`*`,dword`):%- [@(0.0.255) virtual] 
[_^dword^ dword]_[* Read]([_^int64^ int64]_[*@3 at], [@(0.0.255) void]_`*[*@3 ptr], 
[_^dword^ dword]_[*@3 size])&]
[s2; Implementation of this virtual method in derived class should 
read a block of data at specified position in media.&]
[s7; [%-*C@3 at]-|Position in media.&]
[s7; [%-*C@3 ptr]-|Pointer to buffer to receive data.&]
[s7; [%-*C@3 size]-|Requested size of data.&]
[s7; [*/ Return value]-|Size of data read.&]
[s3; &]
[s4;%- &]
[s5;:BlockStream`:`:Write`(int64`,const void`*`,dword`):%- [@(0.0.255) virtual] 
[@(0.0.255) void]_[* Write]([_^int64^ int64]_[*@3 at], [@(0.0.255) const]_[@(0.0.255) void]_`*
[*@3 data], [_^dword^ dword]_[*@3 size])&]
[s2; Implementation of this virtual method in derived method should 
write a block of data at specified position in media.&]
[s7; [%-*C@3 at]-|Position in media.&]
[s7; [%-*C@3 data]-|Pointer to  data.&]
[s7; [%-*C@3 size]-|Size of data.&]
[s3; &]
[s4;%- &]
[s5;:BlockStream`:`:SetStreamSize`(int64`):%- [@(0.0.255) virtual] 
[@(0.0.255) void]_[* SetStreamSize]([_^int64^ int64]_[*@3 size])&]
[s2; Implementation of this virtual method in derived class should 
adjust the size of media.&]
[s7; [%-*C@3 size]-|Requested new size of media.&]
[s3; &]
[s4;%- &]
[s5;:BlockStream`:`:GetStreamSize`(`)const:%- [_^int64^ int64]_[* GetStreamSize]()_[@(0.0.255) c
onst]&]
[s2; Returns current media size. Note that this might be different 
from current GetSize() `- media size adjustment can be deffered 
to flushing the buffer.&]
[s7; [*/ Return value]-|Current media size.&]
[s3; &]
[s4;%- &]
[s5;:BlockStream`:`:OpenInit`(dword`,int64`):%- [@(0.0.255) void]_[* OpenInit]([_^dword^ dw
ord]_[*@3 mode], [_^int64^ int64]_[*@3 file`_size])&]
[s2; Initializes the BlockStream to specified mode and actual media 
size.&]
[s7; [%-*C@3 mode]-|Mode.&]
[s7; [%-*C@3 file`_size]-|Actual media size.&]
[s3; &]
[s0;3 &]
[s0;3 &]
[s0;%- &]
[ {{10000@(113.42.0) [s0; [*@7;4 FileStream]]}}&]
[s3; &]
[s1;:FileStream`:`:class:%- [@(0.0.255)3 class][3 _][*3 FileStream][3 _:_][@(0.0.255)3 public][3 _
][*@3;3 BlockStream]&]
[s9; Classical file stream.&]
[s9; &]
[s0;%- [%%/ Derived from][%%  ][^topic`:`/`/Core`/src`/Stream`$en`-us`#`:`:BlockStream`:`:class BlockStream^ B
lockStream]&]
[s3; &]
[s0; &]
[ {{10000F(128)G(128)@1 [s0; [* Constructor Detail]]}}&]
[s3;%- &]
[s5;:FileStream`:`:FileStream`(const char`*`,dword`):%- [* FileStream]([@(0.0.255) const]_
[@(0.0.255) char]_`*[*@3 filename], [_^dword^ dword]_[*@3 mode])&]
[s2; Opens file stream in specified mode (as defined in BlockStream).&]
[s7; [%-*C@3 filename]-|The name of the file.&]
[s7; [%-*C@3 mode]-|Open mode.&]
[s3; &]
[s4;%- &]
[s5;:FileStream`:`:FileStream`(const char`*`,dword`,mode`_t`):%- [* FileStream]([@(0.0.255) c
onst]_[@(0.0.255) char]_`*[*@3 filename], [_^dword^ dword]_[*@3 mode], 
mode`_t_[*@3 acm]_`=_[@3 0644])&]
[s6;%- Posix specific.&]
[s2; Opens file stream in specified mode (as defined in BlockStream) 
and specific POSIX access rights.&]
[s7; [%-*C@3 filename]-|The name of the file.&]
[s7; [%-*C@3 mode]-|Open mode.&]
[s7; [%-*C@3 acm]-|Access rights.&]
[s3; &]
[s4;%- &]
[s5;:FileStream`:`:FileStream`(int`):%- [* FileStream]([@(0.0.255) int]_[*@3 std`_handle])&]
[s6; Posix specific.&]
[s2; Assigns existing file handle to FileStream.&]
[s7; [%-*C@3 std`_handle]-|File handle of open file. FileStream takes 
ownership of this handle.&]
[s3; &]
[s4;%- &]
[s5;:FileStream`:`:FileStream`(`):%- [* FileStream]()&]
[s2; Creates empty unopened FileStream.&]
[s3; &]
[s0;%- &]
[ {{10000F(128)G(128)@1 [s0; [* Public Member List]]}}&]
[s3;%- &]
[s5;:FileStream`:`:operator bool`(`)const:%- [* operator_bool]()_[@(0.0.255) const]&]
[s2; [*/ Return value]-|True if stream is open.&]
[s3; &]
[s4;%- &]
[s5;:FileStream`:`:GetTime`(`)const:%- [_^FileTime^ FileTime]_[* GetTime]()_[@(0.0.255) con
st]&]
[s2; Returns last`-write time of stream.&]
[s7; [*/ Return value]-|Time.&]
[s3; &]
[s4;%- &]
[s5;:FileStream`:`:SetTime`(const FileTime`&`):%- [@(0.0.255) void]_[* SetTime]([@(0.0.255) c
onst]_[_^FileTime^ FileTime][@(0.0.255) `&]_[*@3 tm])&]
[s2; Opens file stream in specified mode (as defined in BlockStream).&]
[s7; [%-*C@3 filename]-|The name of the file.&]
[s2; [%-*C@3 mode]-|Open mode.&]
[s3; &]
[s4;%- &]
[s5;:FileStream`:`:Open`(const char`*`,dword`):%- [@(0.0.255) bool]_[* Open]([@(0.0.255) co
nst]_[@(0.0.255) char]_`*[*@3 filename], [_^dword^ dword]_[*@3 mode])&]
[s6;%- Posix specific.&]
[s2; Opens file stream in specified mode (as defined in BlockStream) 
and specific POSIX access rights. [%-*@3 mode] can be one of READ, 
CREATE, APPEND, READWRITE possibly combined (using `'`|`') with 
flag NOWRITESHARE. This enforces exclusive write access to the 
file.&]
[s7; [%-*C@3 filename]-|The name of the file.&]
[s7; [%-*C@3 mode]-|Open mode.&]
[s3; &]
[s4;%- &]
[s5;:FileStream`:`:Open`(const char`*`,dword`,mode`_t`):%- [@(0.0.255) bool]_[* Open]([@(0.0.255) c
onst]_[@(0.0.255) char]_`*[*@3 filename], [_^dword^ dword]_[*@3 mode], 
mode`_t_[*@3 acm]_`=_[@3 0644])&]
[s6;%- Posix specific.&]
[s2; Opens file stream in specified mode (as defined in BlockStream) 
and specific POSIX access rights. [%-*@3 mode] can be one of READ, 
CREATE, APPEND, READWRITE possibly combined (using `'`|`') with 
flag NOWRITESHARE. This flag uses flock system call to enforce 
exclusive write access to the file. In READ, if file does not 
exist, function fails. In CREATE mode, files is always created 
empty. In APPEND and READWRITE modes, file is created if it does 
not already exist.&]
[s7; [%-*C@3 filename]-|The name of the file.&]
[s7; [%-*C@3 mode]-|Open mode.&]
[s7; [%-*C@3 acm]-|Access rights.&]
[s3; &]
[s4;%- &]
[s5;:FileStream`:`:GetHandle`(`)const:%- HANDLE_[* GetHandle]()_[@(0.0.255) const]&]
[s2; [*/ Return value]-|File handle, either POSIX or WIN32.&]
[s3; &]
[s0;3 &]
[s0;3 &]
[s0;%- &]
[ {{10000@(113.42.0) [s0; [*@7;4 FileIn]]}}&]
[s3; &]
[s1;:FileIn`:`:class:%- [@(0.0.255)3 class][3 _][*3 FileIn][3 _:_][@(0.0.255)3 public][3 _][*@3;3 Fi
leStream]&]
[s9; Simple helper class that represents FileStream in read mode.&]
[s0; &]
[s9;%- [%%/ Derived from][%%  ][^topic`:`/`/Core`/src`/Stream`$en`-us`#`:`:FileStream`:`:class FileStream^ F
ileStream]&]
[s3; &]
[s0; &]
[ {{10000F(128)G(128)@1 [s0; [* Constructor Detail]]}}&]
[s3; &]
[s5;:FileIn`:`:FileIn`(const char`*`):%- [* FileIn]([@(0.0.255) const]_[@(0.0.255) char]_`*
[*@3 fn])&]
[s2; Opens file for reading.&]
[s7; [%-*C@3 fn]-|File name.&]
[s3; &]
[s4;%- &]
[s5;:FileIn`:`:FileIn`(`):%- [* FileIn]()&]
[s2; Constructs empty FileStream.&]
[s3; &]
[s0;%- &]
[ {{10000F(128)G(128)@1 [s0; [* Public Member List]]}}&]
[s3;%- &]
[s5;:FileIn`:`:Open`(const char`*`):%- [@(0.0.255) bool]_[* Open]([@(0.0.255) const]_[@(0.0.255) c
har]_`*[*@3 fn])&]
[s2; Opens file for reading.&]
[s7; [%-*C@3 fn]-|File name.&]
[s7; [*/ Return value]-|True if open was successful.&]
[s3; &]
[s0;3 &]
[s0;3 &]
[s0;%- &]
[ {{10000@(113.42.0) [s0; [*@7;4 FileOut]]}}&]
[s3; &]
[s1;:FileOut`:`:class:%- [@(0.0.255)3 class][3 _][*3 FileOut][3 _:_][@(0.0.255)3 public][3 _][*@3;3 F
ileStream]&]
[s9; Simple helper class that represents FileStream in write mode.&]
[s2; &]
[s0;%- [%%/ Derived from][%%  ][^topic`:`/`/Core`/src`/Stream`$en`-us`#`:`:FileStream`:`:class FileStream^ F
ileStream]&]
[s3; &]
[s0; &]
[ {{10000F(128)G(128)@1 [s0; [* Constructor Detail]]}}&]
[s3;%- &]
[s5;:FileOut`:`:FileOut`(const char`*`):%- [* FileOut]([@(0.0.255) const]_[@(0.0.255) char]_
`*[*@3 fn])&]
[s2; Opens file for writing.&]
[s7; [%-*C@3 fn]-|File name.&]
[s3; &]
[s4;%- &]
[s5;:FileOut`:`:FileOut`(`):%- [* FileOut]()&]
[s2;%- Constructs non`-opened FileStream.&]
[s3; &]
[s0;%- &]
[ {{10000F(128)G(128)@1 [s0; [* Public Member List]]}}&]
[s3; &]
[s5;:FileOut`:`:Open`(const char`*`):%- [@(0.0.255) bool]_[* Open]([@(0.0.255) const]_[@(0.0.255) c
har]_`*[*@3 fn])&]
[s2; Opens file for writing.&]
[s7; [%-*C@3 fn]-|File name.&]
[s7; [*/ Return value]-|True if open was successful.&]
[s3; &]
[s4;%- &]
[s5;:FileOut`:`:Open`(const char`*`,mode`_t`):%- [@(0.0.255) bool]_[* Open]([@(0.0.255) con
st]_[@(0.0.255) char]_`*[*@3 fn], mode`_t_[*@3 acm]_`=_[@3 0644])&]
[s2; Opens file for writing.&]
[s6; POSIX specific&]
[s7; [%-*C@3 fn]-|File name.&]
[s7;%- [*@3 acm][@3 -|]File mode&]
[s2; [*/ Return value]-|True if open was successful.&]
[s3; &]
[s0; &]
[s0;3 &]
[s0;3 &]
[ {{10000@(113.42.0) [s0; [*@7;4 FileAppend]]}}&]
[s3; &]
[s1;:FileAppend`:`:class:%- [@(0.0.255)3 class][3 _][*3 FileAppend][3 _:_][@(0.0.255)3 public][3 _
][*@3;3 FileStream]&]
[s9; Simple helper class that represents FileStream in append mode 
`- that in fact means in write mode with current position at 
the end of the file.&]
[s2; &]
[s0;%- [%%/ Derived from][%%  ]FileStream&]
[s3; &]
[s0;%- &]
[ {{10000F(128)G(128)@1 [s0; [* Constructor Detail]]}}&]
[s3; &]
[s5;:FileAppend`:`:FileAppend`(const char`*`):%- [* FileAppend]([@(0.0.255) const]_[@(0.0.255) c
har]_`*[*@3 fn])&]
[s2; Opens file in append mode.&]
[s7; [%-*C@3 fn]-|File name.&]
[s3; &]
[s4;%- &]
[s5;:FileAppend`:`:FileAppend`(`):%- [* FileAppend]()&]
[s2; Constructs empty FileStream.&]
[s3; &]
[s0;%- &]
[ {{10000F(128)G(128)@1 [s0; [* Public Member List]]}}&]
[s3; &]
[s5;:FileAppend`:`:Open`(const char`*`):%- [@(0.0.255) bool]_[* Open]([@(0.0.255) const]_[@(0.0.255) c
har]_`*[*@3 fn])&]
[s2; Opens file in append mode.&]
[s7; [%-*C@3 fn]-|File name.&]
[s7; [*/ Return value]-|true when Open was successful.&]
[s3; &]
[s0;3 &]
[s0;3 &]
[s0;%- &]
[ {{10000@(113.42.0) [s0; [*@7;4 SizeStream]]}}&]
[s3; &]
[s1;:SizeStream`:`:class:%- [@(0.0.255)3 class][3 _][*3 SizeStream][3 _:_][@(0.0.255)3 public][3 _
][*@3;3 Stream]&]
[s9; Special output stream that in fact does not store output data, 
only counts the total number of bytes written.&]
[s2; &]
[s0;%- [%%/ Derived from][%%  ][^topic`:`/`/Core`/src`/Stream`$en`-us`#`:`:BufferStream`:`:class BufferStream^ B
ufferStream]&]
[s3; &]
[s0;%- &]
[ {{10000F(128)G(128)@1 [s0; [* Constructor Detail]]}}&]
[s3; &]
[s0;:`:`:SizeStream`:`:SizeStream`(`):%- [* SizeStream]()&]
[s2; Default constructor.&]
[s3; &]
[s0;%- &]
[ {{10000F(128)G(128)@1 [s0; [* Public Member List]]}}&]
[s3; &]
[s5;:SizeStream`:`:`_Put`(int`):%- [@(0.0.255) virtual] [@(0.0.255) void]_[* `_Put]([@(0.0.255) i
nt]_[*@3 w])&]
[s7; Return value-|Current number of bytes written.&]
[s3; &]
[s4;%- &]
[s5;:SizeStream`:`:Open`(`):%- [@(0.0.255) void]_[* Open]()&]
[s2; Reopens data `- resets the counter of output bytes.&]
[s3; &]
[s4;%- &]
[s5;:SizeStream`:`:operator int64`(`)const:%- [* operator_int64]()_[@(0.0.255) const]&]
[s2; Returns current number of bytes written.&]
[s3;%- &]
[s0; &]
[s0;3 &]
[s0;%- &]
[ {{10000@(113.42.0) [s0; [*@7;4 CompareStream]]}}&]
[s3; &]
[s1;:CompareStream`:`:class:%- [@(0.0.255)3 class][3 _][*3 CompareStream][3 _:_][@(0.0.255)3 pub
lic][3 _][*@3;3 Stream]&]
[s9; Special output stream that instead of storing data performs 
their comparison to the data of another stream.&]
[s2; &]
[s0;%- [%%/ Derived from][%%  ][^topic`:`/`/Core`/src`/Stream`$en`-us`#`:`:BufferStream`:`:class BufferStream^ B
ufferStream]&]
[s3; &]
[s0;%- &]
[ {{10000F(128)G(128)@1 [s0; [* Constructor Detail]]}}&]
[s3; &]
[s0;:CompareStream`:`:CompareStream`(`):%- [* CompareStream]()&]
[s2; Constructs closed CompareStream.&]
[s3; &]
[s4;%- &]
[s5;:CompareStream`:`:CompareStream`(Stream`&`):%- [* CompareStream]([_^Stream^ Stream][@(0.0.255) `&
]_[*@3 aStream])&]
[s2; Constructors CompareStream opened for comparison with specified 
stream.&]
[s7; [%-*C@3 aStream]-|Stream to compare with.&]
[s3;%- &]
[s0;%- &]
[ {{10000F(128)G(128)@1 [s0; [* Public Member List]]}}&]
[s3; &]
[s5;:CompareStream`:`:Open`(Stream`&`):%- [@(0.0.255) void]_[* Open]([_^Stream^ Stream][@(0.0.255) `&
]_[*@3 aStream])&]
[s2; Opens CompareStream for comparison with the specified stream.&]
[s7; [%-*C@3 aStream]-|Stream to compare with.&]
[s3; &]
[s4;%- &]
[s5;:CompareStream`:`:IsEqual`(`):%- [@(0.0.255) bool]_[* IsEqual]()&]
[s7; Return value-|true if all bytes written so far match those in 
comparison stream.&]
[s3; &]
[s4;%- &]
[s5;:CompareStream`:`:operator bool`(`):%- [* operator_bool]()&]
[s7; Return value-|IsEqual().&]
[s3; &]
[s0; ]]