/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.runtime.regexp.joni;

import jdk.nashorn.internal.runtime.regexp.joni.ApplyCaseFoldArg;
import jdk.nashorn.internal.runtime.regexp.joni.BitSet;
import jdk.nashorn.internal.runtime.regexp.joni.ScanEnvironment;
import jdk.nashorn.internal.runtime.regexp.joni.ast.CClassNode;
import jdk.nashorn.internal.runtime.regexp.joni.ast.ConsAltNode;
import jdk.nashorn.internal.runtime.regexp.joni.ast.StringNode;

final class ApplyCaseFold {
    static final ApplyCaseFold INSTANCE = new ApplyCaseFold();

    ApplyCaseFold() {
    }

    public void apply(int from, int[] to, int length, Object o) {
        ApplyCaseFoldArg arg = (ApplyCaseFoldArg)o;
        ScanEnvironment env = arg.env;
        CClassNode cc = arg.cc;
        BitSet bs = cc.bs;
        if (length == 1) {
            boolean inCC = cc.isCodeInCC(from);
            if (inCC && !cc.isNot() || !inCC && cc.isNot()) {
                if (to[0] >= 256) {
                    cc.addCodeRange(env, to[0], to[0]);
                } else {
                    bs.set(to[0]);
                }
            }
        } else if (cc.isCodeInCC(from) && !cc.isNot()) {
            StringNode node = null;
            for (int i = 0; i < length; ++i) {
                if (i == 0) {
                    node = new StringNode();
                    node.setAmbig();
                }
                node.catCode(to[i]);
            }
            ConsAltNode alt = ConsAltNode.newAltNode(node, null);
            if (arg.tail == null) {
                arg.altRoot = alt;
            } else {
                arg.tail.setCdr(alt);
            }
            arg.tail = alt;
        }
    }
}

