/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.runtime.linker;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.TypeDescriptor;
import jdk.internal.dynalink.CallSiteDescriptor;
import jdk.internal.dynalink.beans.BeansLinker;
import jdk.internal.dynalink.linker.GuardedInvocation;
import jdk.internal.dynalink.linker.LinkRequest;
import jdk.internal.dynalink.linker.LinkerServices;
import jdk.internal.dynalink.linker.TypeBasedGuardingDynamicLinker;
import jdk.internal.dynalink.support.Guards;
import jdk.nashorn.internal.runtime.linker.BoundDynamicMethod;
import jdk.nashorn.internal.runtime.linker.NashornBeansLinker;

final class BoundDynamicMethodLinker
implements TypeBasedGuardingDynamicLinker {
    BoundDynamicMethodLinker() {
    }

    @Override
    public boolean canLinkType(Class<?> type) {
        return type == BoundDynamicMethod.class;
    }

    @Override
    public GuardedInvocation getGuardedInvocation(LinkRequest linkRequest, LinkerServices linkerServices) throws Exception {
        Object objBoundDynamicMethod = linkRequest.getReceiver();
        if (!(objBoundDynamicMethod instanceof BoundDynamicMethod)) {
            return null;
        }
        BoundDynamicMethod boundDynamicMethod = (BoundDynamicMethod)objBoundDynamicMethod;
        Object dynamicMethod = boundDynamicMethod.getDynamicMethod();
        Object boundThis = boundDynamicMethod.getBoundThis();
        Object[] args = linkRequest.getArguments();
        args[0] = dynamicMethod;
        args[1] = boundThis;
        CallSiteDescriptor descriptor = linkRequest.getCallSiteDescriptor();
        MethodType type = descriptor.getMethodType();
        Class<?> dynamicMethodClass = dynamicMethod.getClass();
        CallSiteDescriptor newDescriptor = descriptor.changeMethodType(type.changeParameterType(0, dynamicMethodClass).changeParameterType(1, boundThis.getClass()));
        GuardedInvocation inv = NashornBeansLinker.getGuardedInvocation(BeansLinker.getLinkerForClass(dynamicMethodClass), linkRequest.replaceArguments(newDescriptor, args), linkerServices);
        if (inv == null) {
            return null;
        }
        MethodHandle boundHandle = MethodHandles.insertArguments(inv.getInvocation(), 0, dynamicMethod, boundThis);
        TypeDescriptor.OfField p0Type = type.parameterType(0);
        MethodHandle droppingHandle = MethodHandles.dropArguments(boundHandle, 0, new Class[]{p0Type, type.parameterType(1)});
        MethodHandle newGuard = Guards.getIdentityGuard(boundDynamicMethod);
        return inv.replaceMethods(droppingHandle, newGuard.asType(newGuard.type().changeParameterType(0, (Class<?>)p0Type)));
    }
}

