/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.runtime;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.SwitchPoint;
import jdk.internal.dynalink.CallSiteDescriptor;
import jdk.internal.dynalink.linker.GuardedInvocation;
import jdk.internal.dynalink.linker.LinkRequest;
import jdk.internal.dynalink.support.CallSiteDescriptorFactory;
import jdk.nashorn.internal.lookup.Lookup;
import jdk.nashorn.internal.runtime.FindProperty;
import jdk.nashorn.internal.runtime.JSType;
import jdk.nashorn.internal.runtime.PropertyMap;
import jdk.nashorn.internal.runtime.Scope;
import jdk.nashorn.internal.runtime.ScriptFunction;
import jdk.nashorn.internal.runtime.ScriptObject;
import jdk.nashorn.internal.runtime.linker.NashornCallSiteDescriptor;

public final class WithObject
extends ScriptObject
implements Scope {
    private static final MethodHandle WITHEXPRESSIONGUARD = WithObject.findOwnMH("withExpressionGuard", Boolean.TYPE, Object.class, PropertyMap.class, SwitchPoint.class);
    private static final MethodHandle WITHEXPRESSIONFILTER = WithObject.findOwnMH("withFilterExpression", Object.class, Object.class);
    private static final MethodHandle WITHSCOPEFILTER = WithObject.findOwnMH("withFilterScope", Object.class, Object.class);
    private static final MethodHandle BIND_TO_EXPRESSION_OBJ = WithObject.findOwnMH("bindToExpression", Object.class, Object.class, Object.class);
    private static final MethodHandle BIND_TO_EXPRESSION_FN = WithObject.findOwnMH("bindToExpression", Object.class, ScriptFunction.class, Object.class);
    private final ScriptObject expression;

    WithObject(ScriptObject scope, ScriptObject expression) {
        super(scope, null);
        this.setIsScope();
        this.expression = expression;
    }

    @Override
    public boolean delete(Object key, boolean strict) {
        ScriptObject self = this.expression;
        String propName = JSType.toString(key);
        FindProperty find = self.findProperty(propName, true);
        if (find != null) {
            return self.delete(propName, strict);
        }
        return false;
    }

    @Override
    public GuardedInvocation lookup(CallSiteDescriptor desc, LinkRequest request) {
        String name;
        boolean isNamedOperation;
        NashornCallSiteDescriptor ndesc = (NashornCallSiteDescriptor)desc;
        FindProperty find = null;
        GuardedInvocation link = null;
        ScriptObject self = null;
        if (desc.getNameTokenCount() > 2) {
            isNamedOperation = true;
            name = desc.getNameToken(2);
        } else {
            isNamedOperation = false;
            name = null;
        }
        self = this.expression;
        if (isNamedOperation) {
            find = self.findProperty(name, true);
        }
        if (find != null && (link = self.lookup(desc, request)) != null) {
            return WithObject.fixExpressionCallSite(ndesc, link);
        }
        ScriptObject scope = this.getProto();
        if (isNamedOperation) {
            find = scope.findProperty(name, true);
        }
        if (find != null) {
            return this.fixScopeCallSite(scope.lookup(desc, request), name);
        }
        if (self != null) {
            String fallBack;
            String operator;
            switch (operator = CallSiteDescriptorFactory.tokenizeOperators(desc).get(0)) {
                case "callMethod": {
                    throw new AssertionError();
                }
                case "getMethod": {
                    fallBack = "__noSuchMethod__";
                    break;
                }
                case "getProp": 
                case "getElem": {
                    fallBack = "__noSuchProperty__";
                    break;
                }
                default: {
                    fallBack = null;
                }
            }
            if (fallBack != null && (find = self.findProperty(fallBack, true)) != null) {
                switch (operator) {
                    case "getMethod": {
                        link = self.noSuchMethod(desc, request);
                        break;
                    }
                    case "getProp": 
                    case "getElem": {
                        link = self.noSuchProperty(desc, request);
                        break;
                    }
                }
            }
            if (link != null) {
                return WithObject.fixExpressionCallSite(ndesc, link);
            }
        }
        if ((link = scope.lookup(desc, request)) != null) {
            return this.fixScopeCallSite(link, name);
        }
        return null;
    }

    @Override
    FindProperty findProperty(String key, boolean deep, boolean stopOnNonScope, ScriptObject start) {
        FindProperty exprProperty = this.expression.findProperty(key, deep, stopOnNonScope, start);
        if (exprProperty != null) {
            return exprProperty;
        }
        return super.findProperty(key, deep, stopOnNonScope, start);
    }

    @Override
    public void setSplitState(int state) {
        this.getNonWithParent().setSplitState(state);
    }

    @Override
    public int getSplitState() {
        return this.getNonWithParent().getSplitState();
    }

    private Scope getNonWithParent() {
        ScriptObject proto = this.getParentScope();
        while (proto != null && proto instanceof WithObject) {
            proto = ((WithObject)proto).getParentScope();
        }
        assert (proto instanceof Scope) : "with scope without parent scope";
        return (Scope)((Object)proto);
    }

    private static GuardedInvocation fixReceiverType(GuardedInvocation link, MethodHandle filter) {
        MethodType invType = link.getInvocation().type();
        MethodType newInvType = invType.changeParameterType(0, (Class<?>)filter.type().returnType());
        return link.asType(newInvType);
    }

    private static GuardedInvocation fixExpressionCallSite(NashornCallSiteDescriptor desc, GuardedInvocation link) {
        if (!"getMethod".equals(desc.getFirstOperator())) {
            return WithObject.fixReceiverType(link, WITHEXPRESSIONFILTER).filterArguments(0, WITHEXPRESSIONFILTER);
        }
        MethodHandle linkInvocation = link.getInvocation();
        MethodType linkType = linkInvocation.type();
        boolean linkReturnsFunction = ScriptFunction.class.isAssignableFrom((Class<?>)linkType.returnType());
        return link.replaceMethods(Lookup.MH.foldArguments(linkReturnsFunction ? BIND_TO_EXPRESSION_FN : BIND_TO_EXPRESSION_OBJ, WithObject.filter(linkInvocation.asType(linkType.changeReturnType(linkReturnsFunction ? ScriptFunction.class : Object.class)), WITHEXPRESSIONFILTER)), WithObject.filterGuard(link, WITHEXPRESSIONFILTER));
    }

    private GuardedInvocation fixScopeCallSite(GuardedInvocation link, String name) {
        GuardedInvocation newLink = WithObject.fixReceiverType(link, WITHSCOPEFILTER);
        return link.replaceMethods(WithObject.filter(newLink.getInvocation(), WITHSCOPEFILTER), Lookup.MH.guardWithTest(this.expressionGuard(name), WithObject.filterGuard(newLink, WITHSCOPEFILTER), Lookup.MH.dropArguments(Lookup.MH.constant(Boolean.TYPE, false), 0, Object.class)));
    }

    private static MethodHandle filterGuard(GuardedInvocation link, MethodHandle filter) {
        MethodHandle test = link.getGuard();
        return test == null ? null : WithObject.filter(test, filter);
    }

    private static MethodHandle filter(MethodHandle mh, MethodHandle filter) {
        return Lookup.MH.filterArguments(mh, 0, filter);
    }

    public static Object withFilterExpression(Object receiver) {
        return ((WithObject)receiver).expression;
    }

    private static Object bindToExpression(Object fn, Object receiver) {
        return fn instanceof ScriptFunction ? WithObject.bindToExpression((ScriptFunction)fn, receiver) : fn;
    }

    private static Object bindToExpression(ScriptFunction fn, Object receiver) {
        return fn.makeBoundFunction(WithObject.withFilterExpression(receiver), new Object[0]);
    }

    private MethodHandle expressionGuard(String name) {
        PropertyMap map = this.expression.getMap();
        SwitchPoint sp = map.getProtoGetSwitchPoint(this.expression.getProto(), name);
        return Lookup.MH.insertArguments(WITHEXPRESSIONGUARD, 1, map, sp);
    }

    private static boolean withExpressionGuard(Object receiver, PropertyMap map, SwitchPoint sp) {
        return ((WithObject)receiver).expression.getMap() == map && (sp == null || !sp.hasBeenInvalidated());
    }

    public static Object withFilterScope(Object receiver) {
        return ((WithObject)receiver).getProto();
    }

    public ScriptObject getExpression() {
        return this.expression;
    }

    public ScriptObject getParentScope() {
        return this.getProto();
    }

    private static MethodHandle findOwnMH(String name, Class<?> rtype, Class<?> ... types) {
        return Lookup.MH.findStatic(MethodHandles.lookup(), WithObject.class, name, Lookup.MH.type(rtype, types));
    }
}

