/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.codegen;

import java.util.ArrayList;
import java.util.List;
import jdk.internal.org.objectweb.asm.MethodVisitor;
import jdk.nashorn.internal.codegen.ClassEmitter;
import jdk.nashorn.internal.codegen.CompilerConstants;
import jdk.nashorn.internal.codegen.Label;
import jdk.nashorn.internal.codegen.MethodEmitter;
import jdk.nashorn.internal.codegen.types.Type;
import jdk.nashorn.internal.ir.LexicalContext;
import jdk.nashorn.internal.ir.SplitNode;
import jdk.nashorn.internal.runtime.Scope;

public class SplitMethodEmitter
extends MethodEmitter {
    private final SplitNode splitNode;
    private final List<Label> externalTargets = new ArrayList<Label>();

    SplitMethodEmitter(ClassEmitter classEmitter, MethodVisitor mv, SplitNode splitNode) {
        super(classEmitter, mv);
        this.splitNode = splitNode;
    }

    @Override
    void splitAwareGoto(LexicalContext lc, Label label) {
        assert (this.splitNode != null);
        int index = this.findExternalTarget(lc, label);
        if (index >= 0) {
            this.loadCompilerConstant(CompilerConstants.SCOPE);
            this.checkcast(Scope.class);
            this.load(index + 1);
            this.invoke(Scope.SET_SPLIT_STATE);
            this.loadUndefined(Type.OBJECT);
            this._return(this.functionNode.getReturnType());
            return;
        }
        super.splitAwareGoto(lc, label);
    }

    private int findExternalTarget(LexicalContext lc, Label label) {
        int index = this.externalTargets.indexOf(label);
        if (index >= 0) {
            return index;
        }
        if (lc.isExternalTarget(this.splitNode, label)) {
            this.externalTargets.add(label);
            return this.externalTargets.size() - 1;
        }
        return -1;
    }

    @Override
    MethodEmitter registerReturn() {
        this.setHasReturn();
        this.loadCompilerConstant(CompilerConstants.SCOPE);
        this.checkcast(Scope.class);
        this.load(0);
        this.invoke(Scope.SET_SPLIT_STATE);
        return this;
    }

    @Override
    final List<Label> getExternalTargets() {
        return this.externalTargets;
    }
}

