/*
 * Decompiled with CFR 0.152.
 */
package jdk.internal.dynalink;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.concurrent.atomic.AtomicReference;
import jdk.internal.dynalink.CallSiteDescriptor;
import jdk.internal.dynalink.linker.GuardedInvocation;
import jdk.internal.dynalink.support.AbstractRelinkableCallSite;
import jdk.internal.dynalink.support.Lookup;

public class ChainedCallSite
extends AbstractRelinkableCallSite {
    private static final MethodHandle PRUNE = Lookup.findOwnSpecial(MethodHandles.lookup(), "prune", MethodHandle.class, MethodHandle.class);
    private final AtomicReference<LinkedList<GuardedInvocation>> invocations = new AtomicReference();

    public ChainedCallSite(CallSiteDescriptor descriptor) {
        super(descriptor);
    }

    protected int getMaxChainLength() {
        return 8;
    }

    @Override
    public void relink(GuardedInvocation guardedInvocation, MethodHandle fallback) {
        this.relinkInternal(guardedInvocation, fallback, false);
    }

    @Override
    public void resetAndRelink(GuardedInvocation guardedInvocation, MethodHandle fallback) {
        this.relinkInternal(guardedInvocation, fallback, true);
    }

    private MethodHandle relinkInternal(GuardedInvocation invocation, MethodHandle relink, boolean reset) {
        LinkedList<GuardedInvocation> currentInvocations = this.invocations.get();
        LinkedList newInvocations = currentInvocations == null || reset ? new LinkedList() : (LinkedList)currentInvocations.clone();
        Iterator it = newInvocations.iterator();
        while (it.hasNext()) {
            if (!((GuardedInvocation)it.next()).hasBeenInvalidated()) continue;
            it.remove();
        }
        if (invocation != null) {
            if (newInvocations.size() == this.getMaxChainLength()) {
                newInvocations.removeFirst();
            }
            newInvocations.addLast(invocation);
        }
        MethodHandle pruneAndInvoke = this.makePruneAndInvokeMethod(relink);
        MethodHandle target = relink;
        for (GuardedInvocation inv : newInvocations) {
            target = inv.compose(pruneAndInvoke, target);
        }
        if (this.invocations.compareAndSet(currentInvocations, newInvocations)) {
            this.setTarget(target);
        }
        return target;
    }

    private MethodHandle makePruneAndInvokeMethod(MethodHandle relink) {
        MethodHandle boundPrune = MethodHandles.insertArguments(PRUNE, 0, this, relink);
        MethodHandle ignoreArgsPrune = MethodHandles.dropArguments(boundPrune, 0, this.type().parameterList());
        return MethodHandles.foldArguments(MethodHandles.exactInvoker(this.type()), ignoreArgsPrune);
    }

    private MethodHandle prune(MethodHandle relink) {
        return this.relinkInternal(null, relink, false);
    }
}

