/*
 * Decompiled with CFR 0.152.
 */
package sun.net;

import java.security.AccessController;
import java.security.PrivilegedAction;

public final class PortConfig {
    private static int defaultUpper;
    private static int defaultLower;
    private static final int upper;
    private static final int lower;

    private PortConfig() {
    }

    static native int getLower0();

    static native int getUpper0();

    public static int getLower() {
        return lower;
    }

    public static int getUpper() {
        return upper;
    }

    static {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                System.loadLibrary("net");
                String string = System.getProperty("os.name");
                if (string.startsWith("Linux")) {
                    defaultLower = 32768;
                    defaultUpper = 61000;
                } else if (string.startsWith("SunOS")) {
                    defaultLower = 32768;
                    defaultUpper = 65535;
                } else if (string.contains("OS X")) {
                    defaultLower = 49152;
                    defaultUpper = 65535;
                } else {
                    throw new InternalError("sun.net.PortConfig: unknown OS");
                }
                return null;
            }
        });
        int n = PortConfig.getLower0();
        if (n == -1) {
            n = defaultLower;
        }
        lower = n;
        n = PortConfig.getUpper0();
        if (n == -1) {
            n = defaultUpper;
        }
        upper = n;
    }
}

