/*
 * Decompiled with CFR 0.152.
 */
package java.util.zip;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.AccessController;
import java.util.HashSet;
import java.util.Vector;
import java.util.zip.CRC32;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.ZipCoder;
import java.util.zip.ZipConstants;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipUtils;
import sun.security.action.GetPropertyAction;

public class ZipOutputStream
extends DeflaterOutputStream
implements ZipConstants {
    private static final boolean inhibitZip64 = Boolean.parseBoolean(AccessController.doPrivileged(new GetPropertyAction("jdk.util.zip.inhibitZip64", "false")));
    private XEntry current;
    private Vector<XEntry> xentries = new Vector();
    private HashSet<String> names = new HashSet();
    private CRC32 crc = new CRC32();
    private long written = 0L;
    private long locoff = 0L;
    private byte[] comment;
    private int method = 8;
    private boolean finished;
    private boolean closed = false;
    private final ZipCoder zc;
    public static final int STORED = 0;
    public static final int DEFLATED = 8;

    private static int version(ZipEntry zipEntry) throws ZipException {
        switch (zipEntry.method) {
            case 8: {
                return 20;
            }
            case 0: {
                return 10;
            }
        }
        throw new ZipException("unsupported compression method");
    }

    private void ensureOpen() throws IOException {
        if (this.closed) {
            throw new IOException("Stream closed");
        }
    }

    public ZipOutputStream(OutputStream outputStream) {
        this(outputStream, StandardCharsets.UTF_8);
    }

    public ZipOutputStream(OutputStream outputStream, Charset charset) {
        super(outputStream, new Deflater(-1, true));
        if (charset == null) {
            throw new NullPointerException("charset is null");
        }
        this.zc = ZipCoder.get(charset);
        this.usesDefaultDeflater = true;
    }

    public void setComment(String string) {
        if (string != null) {
            this.comment = this.zc.getBytes(string);
            if (this.comment.length > 65535) {
                throw new IllegalArgumentException("ZIP file comment too long.");
            }
        }
    }

    public void setMethod(int n) {
        if (n != 8 && n != 0) {
            throw new IllegalArgumentException("invalid compression method");
        }
        this.method = n;
    }

    public void setLevel(int n) {
        this.def.setLevel(n);
    }

    public void putNextEntry(ZipEntry zipEntry) throws IOException {
        this.ensureOpen();
        if (this.current != null) {
            this.closeEntry();
        }
        if (zipEntry.time == -1L) {
            zipEntry.setTime(System.currentTimeMillis());
        }
        if (zipEntry.method == -1) {
            zipEntry.method = this.method;
        }
        zipEntry.flag = 0;
        switch (zipEntry.method) {
            case 8: {
                if (zipEntry.size != -1L && zipEntry.csize != -1L && zipEntry.crc != -1L) break;
                zipEntry.flag = 8;
                break;
            }
            case 0: {
                if (zipEntry.size == -1L) {
                    zipEntry.size = zipEntry.csize;
                } else if (zipEntry.csize == -1L) {
                    zipEntry.csize = zipEntry.size;
                } else if (zipEntry.size != zipEntry.csize) {
                    throw new ZipException("STORED entry where compressed != uncompressed size");
                }
                if (zipEntry.size != -1L && zipEntry.crc != -1L) break;
                throw new ZipException("STORED entry missing size, compressed size, or crc-32");
            }
            default: {
                throw new ZipException("unsupported compression method");
            }
        }
        if (!this.names.add(zipEntry.name)) {
            throw new ZipException("duplicate entry: " + zipEntry.name);
        }
        if (this.zc.isUTF8()) {
            zipEntry.flag |= 0x800;
        }
        this.current = new XEntry(zipEntry, this.written);
        this.xentries.add(this.current);
        this.writeLOC(this.current);
    }

    public void closeEntry() throws IOException {
        this.ensureOpen();
        if (this.current != null) {
            ZipEntry zipEntry = this.current.entry;
            switch (zipEntry.method) {
                case 8: {
                    this.def.finish();
                    while (!this.def.finished()) {
                        this.deflate();
                    }
                    if ((zipEntry.flag & 8) == 0) {
                        if (zipEntry.size != this.def.getBytesRead()) {
                            throw new ZipException("invalid entry size (expected " + zipEntry.size + " but got " + this.def.getBytesRead() + " bytes)");
                        }
                        if (zipEntry.csize != this.def.getBytesWritten()) {
                            throw new ZipException("invalid entry compressed size (expected " + zipEntry.csize + " but got " + this.def.getBytesWritten() + " bytes)");
                        }
                        if (zipEntry.crc != this.crc.getValue()) {
                            throw new ZipException("invalid entry CRC-32 (expected 0x" + Long.toHexString(zipEntry.crc) + " but got 0x" + Long.toHexString(this.crc.getValue()) + ")");
                        }
                    } else {
                        zipEntry.size = this.def.getBytesRead();
                        zipEntry.csize = this.def.getBytesWritten();
                        zipEntry.crc = this.crc.getValue();
                        this.writeEXT(zipEntry);
                    }
                    this.def.reset();
                    this.written += zipEntry.csize;
                    break;
                }
                case 0: {
                    if (zipEntry.size != this.written - this.locoff) {
                        throw new ZipException("invalid entry size (expected " + zipEntry.size + " but got " + (this.written - this.locoff) + " bytes)");
                    }
                    if (zipEntry.crc == this.crc.getValue()) break;
                    throw new ZipException("invalid entry crc-32 (expected 0x" + Long.toHexString(zipEntry.crc) + " but got 0x" + Long.toHexString(this.crc.getValue()) + ")");
                }
                default: {
                    throw new ZipException("invalid compression method");
                }
            }
            this.crc.reset();
            this.current = null;
        }
    }

    @Override
    public synchronized void write(byte[] byArray, int n, int n2) throws IOException {
        this.ensureOpen();
        if (n < 0 || n2 < 0 || n > byArray.length - n2) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 == 0) {
            return;
        }
        if (this.current == null) {
            throw new ZipException("no current ZIP entry");
        }
        ZipEntry zipEntry = this.current.entry;
        switch (zipEntry.method) {
            case 8: {
                super.write(byArray, n, n2);
                break;
            }
            case 0: {
                this.written += (long)n2;
                if (this.written - this.locoff > zipEntry.size) {
                    throw new ZipException("attempt to write past end of STORED entry");
                }
                this.out.write(byArray, n, n2);
                break;
            }
            default: {
                throw new ZipException("invalid compression method");
            }
        }
        this.crc.update(byArray, n, n2);
    }

    @Override
    public void finish() throws IOException {
        this.ensureOpen();
        if (this.finished) {
            return;
        }
        if (this.current != null) {
            this.closeEntry();
        }
        long l = this.written;
        for (XEntry xEntry : this.xentries) {
            this.writeCEN(xEntry);
        }
        this.writeEND(l, this.written - l);
        this.finished = true;
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            super.close();
            this.closed = true;
        }
    }

    private void writeLOC(XEntry xEntry) throws IOException {
        ZipEntry zipEntry = xEntry.entry;
        int n = zipEntry.flag;
        boolean bl = false;
        int n2 = this.getExtraLen(zipEntry.extra);
        xEntry.dostime = ZipUtils.javaToDosTime(zipEntry.time);
        this.writeInt(67324752L);
        if ((n & 8) == 8) {
            this.writeShort(ZipOutputStream.version(zipEntry));
            this.writeShort(n);
            this.writeShort(zipEntry.method);
            this.writeInt(xEntry.dostime);
            this.writeInt(0L);
            this.writeInt(0L);
            this.writeInt(0L);
        } else {
            if (zipEntry.csize >= 0xFFFFFFFFL || zipEntry.size >= 0xFFFFFFFFL) {
                bl = true;
                this.writeShort(45);
            } else {
                this.writeShort(ZipOutputStream.version(zipEntry));
            }
            this.writeShort(n);
            this.writeShort(zipEntry.method);
            this.writeInt(xEntry.dostime);
            this.writeInt(zipEntry.crc);
            if (bl) {
                this.writeInt(0xFFFFFFFFL);
                this.writeInt(0xFFFFFFFFL);
                n2 += 20;
            } else {
                this.writeInt(zipEntry.csize);
                this.writeInt(zipEntry.size);
            }
        }
        byte[] byArray = this.zc.getBytes(zipEntry.name);
        this.writeShort(byArray.length);
        int n3 = 0;
        int n4 = 0;
        if (zipEntry.mtime != null) {
            n3 += 4;
            n4 |= 1;
        }
        if (zipEntry.atime != null) {
            n3 += 4;
            n4 |= 2;
        }
        if (zipEntry.ctime != null) {
            n3 += 4;
            n4 |= 4;
        }
        if (n4 != 0) {
            n2 += n3 + 5;
        }
        this.writeShort(n2);
        this.writeBytes(byArray, 0, byArray.length);
        if (bl) {
            this.writeShort(1);
            this.writeShort(16);
            this.writeLong(zipEntry.size);
            this.writeLong(zipEntry.csize);
        }
        if (n4 != 0) {
            this.writeShort(21589);
            this.writeShort(n3 + 1);
            this.writeByte(n4);
            if (zipEntry.mtime != null) {
                this.writeInt(ZipUtils.fileTimeToUnixTime(zipEntry.mtime));
            }
            if (zipEntry.atime != null) {
                this.writeInt(ZipUtils.fileTimeToUnixTime(zipEntry.atime));
            }
            if (zipEntry.ctime != null) {
                this.writeInt(ZipUtils.fileTimeToUnixTime(zipEntry.ctime));
            }
        }
        this.writeExtra(zipEntry.extra);
        this.locoff = this.written;
    }

    private void writeEXT(ZipEntry zipEntry) throws IOException {
        this.writeInt(134695760L);
        this.writeInt(zipEntry.crc);
        if (zipEntry.csize >= 0xFFFFFFFFL || zipEntry.size >= 0xFFFFFFFFL) {
            this.writeLong(zipEntry.csize);
            this.writeLong(zipEntry.size);
        } else {
            this.writeInt(zipEntry.csize);
            this.writeInt(zipEntry.size);
        }
    }

    private void writeCEN(XEntry xEntry) throws IOException {
        byte[] byArray;
        ZipEntry zipEntry = xEntry.entry;
        int n = zipEntry.flag;
        int n2 = ZipOutputStream.version(zipEntry);
        long l = zipEntry.csize;
        long l2 = zipEntry.size;
        long l3 = xEntry.offset;
        int n3 = 0;
        boolean bl = false;
        if (zipEntry.csize >= 0xFFFFFFFFL) {
            l = 0xFFFFFFFFL;
            n3 += 8;
            bl = true;
        }
        if (zipEntry.size >= 0xFFFFFFFFL) {
            l2 = 0xFFFFFFFFL;
            n3 += 8;
            bl = true;
        }
        if (xEntry.offset >= 0xFFFFFFFFL) {
            l3 = 0xFFFFFFFFL;
            n3 += 8;
            bl = true;
        }
        this.writeInt(33639248L);
        if (bl) {
            this.writeShort(45);
            this.writeShort(45);
        } else {
            this.writeShort(n2);
            this.writeShort(n2);
        }
        this.writeShort(n);
        this.writeShort(zipEntry.method);
        this.writeInt(xEntry.dostime);
        this.writeInt(zipEntry.crc);
        this.writeInt(l);
        this.writeInt(l2);
        byte[] byArray2 = this.zc.getBytes(zipEntry.name);
        this.writeShort(byArray2.length);
        int n4 = this.getExtraLen(zipEntry.extra);
        if (bl) {
            n4 += n3 + 4;
        }
        int n5 = 0;
        if (zipEntry.mtime != null) {
            n4 += 4;
            n5 |= 1;
        }
        if (zipEntry.atime != null) {
            n5 |= 2;
        }
        if (zipEntry.ctime != null) {
            n5 |= 4;
        }
        if (n5 != 0) {
            n4 += 5;
        }
        this.writeShort(n4);
        if (zipEntry.comment != null) {
            byArray = this.zc.getBytes(zipEntry.comment);
            this.writeShort(Math.min(byArray.length, 65535));
        } else {
            byArray = null;
            this.writeShort(0);
        }
        this.writeShort(0);
        this.writeShort(0);
        this.writeInt(0L);
        this.writeInt(l3);
        this.writeBytes(byArray2, 0, byArray2.length);
        if (bl) {
            this.writeShort(1);
            this.writeShort(n3);
            if (l2 == 0xFFFFFFFFL) {
                this.writeLong(zipEntry.size);
            }
            if (l == 0xFFFFFFFFL) {
                this.writeLong(zipEntry.csize);
            }
            if (l3 == 0xFFFFFFFFL) {
                this.writeLong(xEntry.offset);
            }
        }
        if (n5 != 0) {
            this.writeShort(21589);
            if (zipEntry.mtime != null) {
                this.writeShort(5);
                this.writeByte(n5);
                this.writeInt(ZipUtils.fileTimeToUnixTime(zipEntry.mtime));
            } else {
                this.writeShort(1);
                this.writeByte(n5);
            }
        }
        this.writeExtra(zipEntry.extra);
        if (byArray != null) {
            this.writeBytes(byArray, 0, Math.min(byArray.length, 65535));
        }
    }

    private void writeEND(long l, long l2) throws IOException {
        int n;
        boolean bl = false;
        long l3 = l2;
        long l4 = l;
        if (l3 >= 0xFFFFFFFFL) {
            l3 = 0xFFFFFFFFL;
            bl = true;
        }
        if (l4 >= 0xFFFFFFFFL) {
            l4 = 0xFFFFFFFFL;
            bl = true;
        }
        if ((n = this.xentries.size()) >= 65535 && (bl |= !inhibitZip64)) {
            n = 65535;
        }
        if (bl) {
            long l5 = this.written;
            this.writeInt(101075792L);
            this.writeLong(44L);
            this.writeShort(45);
            this.writeShort(45);
            this.writeInt(0L);
            this.writeInt(0L);
            this.writeLong(this.xentries.size());
            this.writeLong(this.xentries.size());
            this.writeLong(l2);
            this.writeLong(l);
            this.writeInt(117853008L);
            this.writeInt(0L);
            this.writeLong(l5);
            this.writeInt(1L);
        }
        this.writeInt(101010256L);
        this.writeShort(0);
        this.writeShort(0);
        this.writeShort(n);
        this.writeShort(n);
        this.writeInt(l3);
        this.writeInt(l4);
        if (this.comment != null) {
            this.writeShort(this.comment.length);
            this.writeBytes(this.comment, 0, this.comment.length);
        } else {
            this.writeShort(0);
        }
    }

    private int getExtraLen(byte[] byArray) {
        if (byArray == null) {
            return 0;
        }
        int n = 0;
        int n2 = byArray.length;
        int n3 = 0;
        while (n3 + 4 <= n2) {
            int n4 = ZipUtils.get16(byArray, n3);
            int n5 = ZipUtils.get16(byArray, n3 + 2);
            if (n5 < 0 || n3 + 4 + n5 > n2) break;
            if (n4 == 21589 || n4 == 1) {
                n += n5 + 4;
            }
            n3 += n5 + 4;
        }
        return n2 - n;
    }

    private void writeExtra(byte[] byArray) throws IOException {
        if (byArray != null) {
            int n = byArray.length;
            int n2 = 0;
            while (n2 + 4 <= n) {
                int n3 = ZipUtils.get16(byArray, n2);
                int n4 = ZipUtils.get16(byArray, n2 + 2);
                if (n4 < 0 || n2 + 4 + n4 > n) {
                    this.writeBytes(byArray, n2, n - n2);
                    return;
                }
                if (n3 != 21589 && n3 != 1) {
                    this.writeBytes(byArray, n2, n4 + 4);
                }
                n2 += n4 + 4;
            }
            if (n2 < n) {
                this.writeBytes(byArray, n2, n - n2);
            }
        }
    }

    private void writeByte(int n) throws IOException {
        OutputStream outputStream = this.out;
        outputStream.write(n & 0xFF);
        ++this.written;
    }

    private void writeShort(int n) throws IOException {
        OutputStream outputStream = this.out;
        outputStream.write(n >>> 0 & 0xFF);
        outputStream.write(n >>> 8 & 0xFF);
        this.written += 2L;
    }

    private void writeInt(long l) throws IOException {
        OutputStream outputStream = this.out;
        outputStream.write((int)(l >>> 0 & 0xFFL));
        outputStream.write((int)(l >>> 8 & 0xFFL));
        outputStream.write((int)(l >>> 16 & 0xFFL));
        outputStream.write((int)(l >>> 24 & 0xFFL));
        this.written += 4L;
    }

    private void writeLong(long l) throws IOException {
        OutputStream outputStream = this.out;
        outputStream.write((int)(l >>> 0 & 0xFFL));
        outputStream.write((int)(l >>> 8 & 0xFFL));
        outputStream.write((int)(l >>> 16 & 0xFFL));
        outputStream.write((int)(l >>> 24 & 0xFFL));
        outputStream.write((int)(l >>> 32 & 0xFFL));
        outputStream.write((int)(l >>> 40 & 0xFFL));
        outputStream.write((int)(l >>> 48 & 0xFFL));
        outputStream.write((int)(l >>> 56 & 0xFFL));
        this.written += 8L;
    }

    private void writeBytes(byte[] byArray, int n, int n2) throws IOException {
        this.out.write(byArray, n, n2);
        this.written += (long)n2;
    }

    private static class XEntry {
        final ZipEntry entry;
        final long offset;
        long dostime;

        public XEntry(ZipEntry zipEntry, long l) {
            this.entry = zipEntry;
            this.offset = l;
        }
    }
}

