/*
 * Decompiled with CFR 0.152.
 */
package java.util.stream;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Objects;
import java.util.Spliterator;
import java.util.function.IntFunction;
import java.util.stream.AbstractPipeline;
import java.util.stream.DoublePipeline;
import java.util.stream.DoubleStream;
import java.util.stream.IntPipeline;
import java.util.stream.IntStream;
import java.util.stream.LongPipeline;
import java.util.stream.LongStream;
import java.util.stream.Node;
import java.util.stream.Nodes;
import java.util.stream.PipelineHelper;
import java.util.stream.ReferencePipeline;
import java.util.stream.Sink;
import java.util.stream.SpinedBuffer;
import java.util.stream.Stream;
import java.util.stream.StreamOpFlag;
import java.util.stream.StreamShape;

final class SortedOps {
    private SortedOps() {
    }

    static <T> Stream<T> makeRef(AbstractPipeline<?, T, ?> abstractPipeline) {
        return new OfRef<T>(abstractPipeline);
    }

    static <T> Stream<T> makeRef(AbstractPipeline<?, T, ?> abstractPipeline, Comparator<? super T> comparator) {
        return new OfRef<T>(abstractPipeline, comparator);
    }

    static <T> IntStream makeInt(AbstractPipeline<?, Integer, ?> abstractPipeline) {
        return new OfInt(abstractPipeline);
    }

    static <T> LongStream makeLong(AbstractPipeline<?, Long, ?> abstractPipeline) {
        return new OfLong(abstractPipeline);
    }

    static <T> DoubleStream makeDouble(AbstractPipeline<?, Double, ?> abstractPipeline) {
        return new OfDouble(abstractPipeline);
    }

    private static final class DoubleSortingSink
    extends Sink.ChainedDouble<Double> {
        private SpinedBuffer.OfDouble b;

        DoubleSortingSink(Sink<? super Double> sink) {
            super(sink);
        }

        @Override
        public void begin(long l) {
            if (l >= 0x7FFFFFF7L) {
                throw new IllegalArgumentException("Stream size exceeds max array size");
            }
            this.b = l > 0L ? new SpinedBuffer.OfDouble((int)l) : new SpinedBuffer.OfDouble();
        }

        @Override
        public void end() {
            double[] dArray = (double[])this.b.asPrimitiveArray();
            Arrays.sort(dArray);
            this.downstream.begin(dArray.length);
            for (double d : dArray) {
                this.downstream.accept(d);
            }
            this.downstream.end();
        }

        @Override
        public void accept(double d) {
            this.b.accept(d);
        }
    }

    private static final class SizedDoubleSortingSink
    extends Sink.ChainedDouble<Double> {
        private double[] array;
        private int offset;

        SizedDoubleSortingSink(Sink<? super Double> sink) {
            super(sink);
        }

        @Override
        public void begin(long l) {
            if (l >= 0x7FFFFFF7L) {
                throw new IllegalArgumentException("Stream size exceeds max array size");
            }
            this.array = new double[(int)l];
        }

        @Override
        public void end() {
            Arrays.sort(this.array, 0, this.offset);
            this.downstream.begin(this.offset);
            for (int i = 0; i < this.offset; ++i) {
                this.downstream.accept(this.array[i]);
            }
            this.downstream.end();
            this.array = null;
        }

        @Override
        public void accept(double d) {
            this.array[this.offset++] = d;
        }
    }

    private static final class LongSortingSink
    extends Sink.ChainedLong<Long> {
        private SpinedBuffer.OfLong b;

        LongSortingSink(Sink<? super Long> sink) {
            super(sink);
        }

        @Override
        public void begin(long l) {
            if (l >= 0x7FFFFFF7L) {
                throw new IllegalArgumentException("Stream size exceeds max array size");
            }
            this.b = l > 0L ? new SpinedBuffer.OfLong((int)l) : new SpinedBuffer.OfLong();
        }

        @Override
        public void end() {
            long[] lArray = (long[])this.b.asPrimitiveArray();
            Arrays.sort(lArray);
            this.downstream.begin(lArray.length);
            for (long l : lArray) {
                this.downstream.accept(l);
            }
            this.downstream.end();
        }

        @Override
        public void accept(long l) {
            this.b.accept(l);
        }
    }

    private static final class SizedLongSortingSink
    extends Sink.ChainedLong<Long> {
        private long[] array;
        private int offset;

        SizedLongSortingSink(Sink<? super Long> sink) {
            super(sink);
        }

        @Override
        public void begin(long l) {
            if (l >= 0x7FFFFFF7L) {
                throw new IllegalArgumentException("Stream size exceeds max array size");
            }
            this.array = new long[(int)l];
        }

        @Override
        public void end() {
            Arrays.sort(this.array, 0, this.offset);
            this.downstream.begin(this.offset);
            for (int i = 0; i < this.offset; ++i) {
                this.downstream.accept(this.array[i]);
            }
            this.downstream.end();
            this.array = null;
        }

        @Override
        public void accept(long l) {
            this.array[this.offset++] = l;
        }
    }

    private static final class IntSortingSink
    extends Sink.ChainedInt<Integer> {
        private SpinedBuffer.OfInt b;

        IntSortingSink(Sink<? super Integer> sink) {
            super(sink);
        }

        @Override
        public void begin(long l) {
            if (l >= 0x7FFFFFF7L) {
                throw new IllegalArgumentException("Stream size exceeds max array size");
            }
            this.b = l > 0L ? new SpinedBuffer.OfInt((int)l) : new SpinedBuffer.OfInt();
        }

        @Override
        public void end() {
            int[] nArray = (int[])this.b.asPrimitiveArray();
            Arrays.sort(nArray);
            this.downstream.begin(nArray.length);
            for (int n : nArray) {
                this.downstream.accept(n);
            }
            this.downstream.end();
        }

        @Override
        public void accept(int n) {
            this.b.accept(n);
        }
    }

    private static final class SizedIntSortingSink
    extends Sink.ChainedInt<Integer> {
        private int[] array;
        private int offset;

        SizedIntSortingSink(Sink<? super Integer> sink) {
            super(sink);
        }

        @Override
        public void begin(long l) {
            if (l >= 0x7FFFFFF7L) {
                throw new IllegalArgumentException("Stream size exceeds max array size");
            }
            this.array = new int[(int)l];
        }

        @Override
        public void end() {
            Arrays.sort(this.array, 0, this.offset);
            this.downstream.begin(this.offset);
            for (int i = 0; i < this.offset; ++i) {
                this.downstream.accept(this.array[i]);
            }
            this.downstream.end();
            this.array = null;
        }

        @Override
        public void accept(int n) {
            this.array[this.offset++] = n;
        }
    }

    private static final class RefSortingSink<T>
    extends Sink.ChainedReference<T, T> {
        private final Comparator<? super T> comparator;
        private ArrayList<T> list;

        RefSortingSink(Sink<? super T> sink, Comparator<? super T> comparator) {
            super(sink);
            this.comparator = comparator;
        }

        @Override
        public void begin(long l) {
            if (l >= 0x7FFFFFF7L) {
                throw new IllegalArgumentException("Stream size exceeds max array size");
            }
            this.list = l >= 0L ? new ArrayList((int)l) : new ArrayList();
        }

        @Override
        public void end() {
            this.list.sort(this.comparator);
            this.downstream.begin(this.list.size());
            this.list.forEach(this.downstream::accept);
            this.downstream.end();
            this.list = null;
        }

        @Override
        public void accept(T t) {
            this.list.add(t);
        }
    }

    private static final class SizedRefSortingSink<T>
    extends Sink.ChainedReference<T, T> {
        private final Comparator<? super T> comparator;
        private T[] array;
        private int offset;

        SizedRefSortingSink(Sink<? super T> sink, Comparator<? super T> comparator) {
            super(sink);
            this.comparator = comparator;
        }

        @Override
        public void begin(long l) {
            if (l >= 0x7FFFFFF7L) {
                throw new IllegalArgumentException("Stream size exceeds max array size");
            }
            this.array = new Object[(int)l];
        }

        @Override
        public void end() {
            Arrays.sort(this.array, 0, this.offset, this.comparator);
            this.downstream.begin(this.offset);
            for (int i = 0; i < this.offset; ++i) {
                this.downstream.accept(this.array[i]);
            }
            this.downstream.end();
            this.array = null;
        }

        @Override
        public void accept(T t) {
            this.array[this.offset++] = t;
        }
    }

    private static final class OfDouble
    extends DoublePipeline.StatefulOp<Double> {
        OfDouble(AbstractPipeline<?, Double, ?> abstractPipeline) {
            super(abstractPipeline, StreamShape.DOUBLE_VALUE, StreamOpFlag.IS_ORDERED | StreamOpFlag.IS_SORTED);
        }

        @Override
        public Sink<Double> opWrapSink(int n, Sink<Double> sink) {
            Objects.requireNonNull(sink);
            if (StreamOpFlag.SORTED.isKnown(n)) {
                return sink;
            }
            if (StreamOpFlag.SIZED.isKnown(n)) {
                return new SizedDoubleSortingSink((Sink<? super Double>)sink);
            }
            return new DoubleSortingSink((Sink<? super Double>)sink);
        }

        @Override
        public <P_IN> Node<Double> opEvaluateParallel(PipelineHelper<Double> pipelineHelper, Spliterator<P_IN> spliterator, IntFunction<Double[]> intFunction) {
            if (StreamOpFlag.SORTED.isKnown(pipelineHelper.getStreamAndOpFlags())) {
                return pipelineHelper.evaluate(spliterator, false, intFunction);
            }
            Node.OfDouble ofDouble = (Node.OfDouble)pipelineHelper.evaluate(spliterator, true, intFunction);
            double[] dArray = (double[])ofDouble.asPrimitiveArray();
            Arrays.parallelSort(dArray);
            return Nodes.node(dArray);
        }
    }

    private static final class OfLong
    extends LongPipeline.StatefulOp<Long> {
        OfLong(AbstractPipeline<?, Long, ?> abstractPipeline) {
            super(abstractPipeline, StreamShape.LONG_VALUE, StreamOpFlag.IS_ORDERED | StreamOpFlag.IS_SORTED);
        }

        @Override
        public Sink<Long> opWrapSink(int n, Sink<Long> sink) {
            Objects.requireNonNull(sink);
            if (StreamOpFlag.SORTED.isKnown(n)) {
                return sink;
            }
            if (StreamOpFlag.SIZED.isKnown(n)) {
                return new SizedLongSortingSink((Sink<? super Long>)sink);
            }
            return new LongSortingSink((Sink<? super Long>)sink);
        }

        @Override
        public <P_IN> Node<Long> opEvaluateParallel(PipelineHelper<Long> pipelineHelper, Spliterator<P_IN> spliterator, IntFunction<Long[]> intFunction) {
            if (StreamOpFlag.SORTED.isKnown(pipelineHelper.getStreamAndOpFlags())) {
                return pipelineHelper.evaluate(spliterator, false, intFunction);
            }
            Node.OfLong ofLong = (Node.OfLong)pipelineHelper.evaluate(spliterator, true, intFunction);
            long[] lArray = (long[])ofLong.asPrimitiveArray();
            Arrays.parallelSort(lArray);
            return Nodes.node(lArray);
        }
    }

    private static final class OfInt
    extends IntPipeline.StatefulOp<Integer> {
        OfInt(AbstractPipeline<?, Integer, ?> abstractPipeline) {
            super(abstractPipeline, StreamShape.INT_VALUE, StreamOpFlag.IS_ORDERED | StreamOpFlag.IS_SORTED);
        }

        @Override
        public Sink<Integer> opWrapSink(int n, Sink sink) {
            Objects.requireNonNull(sink);
            if (StreamOpFlag.SORTED.isKnown(n)) {
                return sink;
            }
            if (StreamOpFlag.SIZED.isKnown(n)) {
                return new SizedIntSortingSink(sink);
            }
            return new IntSortingSink(sink);
        }

        @Override
        public <P_IN> Node<Integer> opEvaluateParallel(PipelineHelper<Integer> pipelineHelper, Spliterator<P_IN> spliterator, IntFunction<Integer[]> intFunction) {
            if (StreamOpFlag.SORTED.isKnown(pipelineHelper.getStreamAndOpFlags())) {
                return pipelineHelper.evaluate(spliterator, false, intFunction);
            }
            Node.OfInt ofInt = (Node.OfInt)pipelineHelper.evaluate(spliterator, true, intFunction);
            int[] nArray = (int[])ofInt.asPrimitiveArray();
            Arrays.parallelSort(nArray);
            return Nodes.node(nArray);
        }
    }

    private static final class OfRef<T>
    extends ReferencePipeline.StatefulOp<T, T> {
        private final boolean isNaturalSort;
        private final Comparator<? super T> comparator;

        OfRef(AbstractPipeline<?, T, ?> abstractPipeline) {
            super(abstractPipeline, StreamShape.REFERENCE, StreamOpFlag.IS_ORDERED | StreamOpFlag.IS_SORTED);
            this.isNaturalSort = true;
            this.comparator = Comparator.naturalOrder();
        }

        OfRef(AbstractPipeline<?, T, ?> abstractPipeline, Comparator<? super T> comparator) {
            super(abstractPipeline, StreamShape.REFERENCE, StreamOpFlag.IS_ORDERED | StreamOpFlag.NOT_SORTED);
            this.isNaturalSort = false;
            this.comparator = Objects.requireNonNull(comparator);
        }

        @Override
        public Sink<T> opWrapSink(int n, Sink<T> sink) {
            Objects.requireNonNull(sink);
            if (StreamOpFlag.SORTED.isKnown(n) && this.isNaturalSort) {
                return sink;
            }
            if (StreamOpFlag.SIZED.isKnown(n)) {
                return new SizedRefSortingSink<T>(sink, this.comparator);
            }
            return new RefSortingSink<T>(sink, this.comparator);
        }

        @Override
        public <P_IN> Node<T> opEvaluateParallel(PipelineHelper<T> pipelineHelper, Spliterator<P_IN> spliterator, IntFunction<T[]> intFunction) {
            if (StreamOpFlag.SORTED.isKnown(pipelineHelper.getStreamAndOpFlags()) && this.isNaturalSort) {
                return pipelineHelper.evaluate(spliterator, false, intFunction);
            }
            T[] TArray = pipelineHelper.evaluate(spliterator, true, intFunction).asArray(intFunction);
            Arrays.parallelSort(TArray, this.comparator);
            return Nodes.node(TArray);
        }
    }
}

