/*
 * Decompiled with CFR 0.152.
 */
package java.time.format;

import java.time.ZoneId;
import java.time.chrono.Chronology;
import java.time.chrono.IsoChronology;
import java.time.format.DateTimeFormatter;
import java.time.format.DecimalStyle;
import java.time.format.Parsed;
import java.time.temporal.TemporalField;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Objects;
import java.util.function.Consumer;

final class DateTimeParseContext {
    private DateTimeFormatter formatter;
    private boolean caseSensitive = true;
    private boolean strict = true;
    private final ArrayList<Parsed> parsed = new ArrayList();
    private ArrayList<Consumer<Chronology>> chronoListeners = null;

    DateTimeParseContext(DateTimeFormatter dateTimeFormatter) {
        this.formatter = dateTimeFormatter;
        this.parsed.add(new Parsed());
    }

    DateTimeParseContext copy() {
        DateTimeParseContext dateTimeParseContext = new DateTimeParseContext(this.formatter);
        dateTimeParseContext.caseSensitive = this.caseSensitive;
        dateTimeParseContext.strict = this.strict;
        return dateTimeParseContext;
    }

    Locale getLocale() {
        return this.formatter.getLocale();
    }

    DecimalStyle getDecimalStyle() {
        return this.formatter.getDecimalStyle();
    }

    Chronology getEffectiveChronology() {
        Chronology chronology = this.currentParsed().chrono;
        if (chronology == null && (chronology = this.formatter.getChronology()) == null) {
            chronology = IsoChronology.INSTANCE;
        }
        return chronology;
    }

    boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    void setCaseSensitive(boolean bl) {
        this.caseSensitive = bl;
    }

    boolean subSequenceEquals(CharSequence charSequence, int n, CharSequence charSequence2, int n2, int n3) {
        if (n + n3 > charSequence.length() || n2 + n3 > charSequence2.length()) {
            return false;
        }
        if (this.isCaseSensitive()) {
            for (int i = 0; i < n3; ++i) {
                char c;
                char c2 = charSequence.charAt(n + i);
                if (c2 == (c = charSequence2.charAt(n2 + i))) continue;
                return false;
            }
        } else {
            for (int i = 0; i < n3; ++i) {
                char c;
                char c3 = charSequence.charAt(n + i);
                if (c3 == (c = charSequence2.charAt(n2 + i)) || Character.toUpperCase(c3) == Character.toUpperCase(c) || Character.toLowerCase(c3) == Character.toLowerCase(c)) continue;
                return false;
            }
        }
        return true;
    }

    boolean charEquals(char c, char c2) {
        if (this.isCaseSensitive()) {
            return c == c2;
        }
        return DateTimeParseContext.charEqualsIgnoreCase(c, c2);
    }

    static boolean charEqualsIgnoreCase(char c, char c2) {
        return c == c2 || Character.toUpperCase(c) == Character.toUpperCase(c2) || Character.toLowerCase(c) == Character.toLowerCase(c2);
    }

    boolean isStrict() {
        return this.strict;
    }

    void setStrict(boolean bl) {
        this.strict = bl;
    }

    void startOptional() {
        this.parsed.add(this.currentParsed().copy());
    }

    void endOptional(boolean bl) {
        if (bl) {
            this.parsed.remove(this.parsed.size() - 2);
        } else {
            this.parsed.remove(this.parsed.size() - 1);
        }
    }

    private Parsed currentParsed() {
        return this.parsed.get(this.parsed.size() - 1);
    }

    Parsed toParsed() {
        Parsed parsed = this.currentParsed();
        parsed.effectiveChrono = this.getEffectiveChronology();
        return parsed;
    }

    Long getParsed(TemporalField temporalField) {
        return this.currentParsed().fieldValues.get(temporalField);
    }

    int setParsedField(TemporalField temporalField, long l, int n, int n2) {
        Objects.requireNonNull(temporalField, "field");
        Long l2 = this.currentParsed().fieldValues.put(temporalField, l);
        return l2 != null && l2 != l ? ~n : n2;
    }

    void setParsed(Chronology chronology) {
        Objects.requireNonNull(chronology, "chrono");
        this.currentParsed().chrono = chronology;
        if (this.chronoListeners != null && !this.chronoListeners.isEmpty()) {
            Consumer[] consumerArray = new Consumer[1];
            Consumer[] consumerArray2 = this.chronoListeners.toArray(consumerArray);
            this.chronoListeners.clear();
            for (Consumer consumer : consumerArray2) {
                consumer.accept(chronology);
            }
        }
    }

    void addChronoChangedListener(Consumer<Chronology> consumer) {
        if (this.chronoListeners == null) {
            this.chronoListeners = new ArrayList();
        }
        this.chronoListeners.add(consumer);
    }

    void setParsed(ZoneId zoneId) {
        Objects.requireNonNull(zoneId, "zone");
        this.currentParsed().zone = zoneId;
    }

    void setParsedLeapSecond() {
        this.currentParsed().leapSecond = true;
    }

    public String toString() {
        return this.currentParsed().toString();
    }
}

