/*
 * Decompiled with CFR 0.152.
 */
package java.time;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.time.Clock;
import java.time.DateTimeException;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.OffsetTime;
import java.time.Ser;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalAdjuster;
import java.time.temporal.TemporalAmount;
import java.time.temporal.TemporalField;
import java.time.temporal.TemporalQueries;
import java.time.temporal.TemporalQuery;
import java.time.temporal.TemporalUnit;
import java.time.temporal.UnsupportedTemporalTypeException;
import java.time.temporal.ValueRange;
import java.util.Objects;

public final class LocalTime
implements Temporal,
TemporalAdjuster,
Comparable<LocalTime>,
Serializable {
    public static final LocalTime MIN;
    public static final LocalTime MAX;
    public static final LocalTime MIDNIGHT;
    public static final LocalTime NOON;
    private static final LocalTime[] HOURS;
    static final int HOURS_PER_DAY = 24;
    static final int MINUTES_PER_HOUR = 60;
    static final int MINUTES_PER_DAY = 1440;
    static final int SECONDS_PER_MINUTE = 60;
    static final int SECONDS_PER_HOUR = 3600;
    static final int SECONDS_PER_DAY = 86400;
    static final long MILLIS_PER_DAY = 86400000L;
    static final long MICROS_PER_DAY = 86400000000L;
    static final long NANOS_PER_SECOND = 1000000000L;
    static final long NANOS_PER_MINUTE = 60000000000L;
    static final long NANOS_PER_HOUR = 3600000000000L;
    static final long NANOS_PER_DAY = 86400000000000L;
    private static final long serialVersionUID = 6414437269572265201L;
    private final byte hour;
    private final byte minute;
    private final byte second;
    private final int nano;

    public static LocalTime now() {
        return LocalTime.now(Clock.systemDefaultZone());
    }

    public static LocalTime now(ZoneId zoneId) {
        return LocalTime.now(Clock.system(zoneId));
    }

    public static LocalTime now(Clock clock) {
        Objects.requireNonNull(clock, "clock");
        Instant instant = clock.instant();
        ZoneOffset zoneOffset = clock.getZone().getRules().getOffset(instant);
        long l = instant.getEpochSecond() + (long)zoneOffset.getTotalSeconds();
        int n = (int)Math.floorMod(l, 86400L);
        return LocalTime.ofNanoOfDay((long)n * 1000000000L + (long)instant.getNano());
    }

    public static LocalTime of(int n, int n2) {
        ChronoField.HOUR_OF_DAY.checkValidValue(n);
        if (n2 == 0) {
            return HOURS[n];
        }
        ChronoField.MINUTE_OF_HOUR.checkValidValue(n2);
        return new LocalTime(n, n2, 0, 0);
    }

    public static LocalTime of(int n, int n2, int n3) {
        ChronoField.HOUR_OF_DAY.checkValidValue(n);
        if ((n2 | n3) == 0) {
            return HOURS[n];
        }
        ChronoField.MINUTE_OF_HOUR.checkValidValue(n2);
        ChronoField.SECOND_OF_MINUTE.checkValidValue(n3);
        return new LocalTime(n, n2, n3, 0);
    }

    public static LocalTime of(int n, int n2, int n3, int n4) {
        ChronoField.HOUR_OF_DAY.checkValidValue(n);
        ChronoField.MINUTE_OF_HOUR.checkValidValue(n2);
        ChronoField.SECOND_OF_MINUTE.checkValidValue(n3);
        ChronoField.NANO_OF_SECOND.checkValidValue(n4);
        return LocalTime.create(n, n2, n3, n4);
    }

    public static LocalTime ofSecondOfDay(long l) {
        ChronoField.SECOND_OF_DAY.checkValidValue(l);
        int n = (int)(l / 3600L);
        int n2 = (int)((l -= (long)(n * 3600)) / 60L);
        return LocalTime.create(n, n2, (int)(l -= (long)(n2 * 60)), 0);
    }

    public static LocalTime ofNanoOfDay(long l) {
        ChronoField.NANO_OF_DAY.checkValidValue(l);
        int n = (int)(l / 3600000000000L);
        int n2 = (int)((l -= (long)n * 3600000000000L) / 60000000000L);
        int n3 = (int)((l -= (long)n2 * 60000000000L) / 1000000000L);
        return LocalTime.create(n, n2, n3, (int)(l -= (long)n3 * 1000000000L));
    }

    public static LocalTime from(TemporalAccessor temporalAccessor) {
        Objects.requireNonNull(temporalAccessor, "temporal");
        LocalTime localTime = temporalAccessor.query(TemporalQueries.localTime());
        if (localTime == null) {
            throw new DateTimeException("Unable to obtain LocalTime from TemporalAccessor: " + temporalAccessor + " of type " + temporalAccessor.getClass().getName());
        }
        return localTime;
    }

    public static LocalTime parse(CharSequence charSequence) {
        return LocalTime.parse(charSequence, DateTimeFormatter.ISO_LOCAL_TIME);
    }

    public static LocalTime parse(CharSequence charSequence, DateTimeFormatter dateTimeFormatter) {
        Objects.requireNonNull(dateTimeFormatter, "formatter");
        return dateTimeFormatter.parse(charSequence, LocalTime::from);
    }

    private static LocalTime create(int n, int n2, int n3, int n4) {
        if ((n2 | n3 | n4) == 0) {
            return HOURS[n];
        }
        return new LocalTime(n, n2, n3, n4);
    }

    private LocalTime(int n, int n2, int n3, int n4) {
        this.hour = (byte)n;
        this.minute = (byte)n2;
        this.second = (byte)n3;
        this.nano = n4;
    }

    @Override
    public boolean isSupported(TemporalField temporalField) {
        if (temporalField instanceof ChronoField) {
            return temporalField.isTimeBased();
        }
        return temporalField != null && temporalField.isSupportedBy(this);
    }

    @Override
    public boolean isSupported(TemporalUnit temporalUnit) {
        if (temporalUnit instanceof ChronoUnit) {
            return temporalUnit.isTimeBased();
        }
        return temporalUnit != null && temporalUnit.isSupportedBy(this);
    }

    @Override
    public ValueRange range(TemporalField temporalField) {
        return Temporal.super.range(temporalField);
    }

    @Override
    public int get(TemporalField temporalField) {
        if (temporalField instanceof ChronoField) {
            return this.get0(temporalField);
        }
        return Temporal.super.get(temporalField);
    }

    @Override
    public long getLong(TemporalField temporalField) {
        if (temporalField instanceof ChronoField) {
            if (temporalField == ChronoField.NANO_OF_DAY) {
                return this.toNanoOfDay();
            }
            if (temporalField == ChronoField.MICRO_OF_DAY) {
                return this.toNanoOfDay() / 1000L;
            }
            return this.get0(temporalField);
        }
        return temporalField.getFrom(this);
    }

    private int get0(TemporalField temporalField) {
        switch ((ChronoField)temporalField) {
            case NANO_OF_SECOND: {
                return this.nano;
            }
            case NANO_OF_DAY: {
                throw new UnsupportedTemporalTypeException("Invalid field 'NanoOfDay' for get() method, use getLong() instead");
            }
            case MICRO_OF_SECOND: {
                return this.nano / 1000;
            }
            case MICRO_OF_DAY: {
                throw new UnsupportedTemporalTypeException("Invalid field 'MicroOfDay' for get() method, use getLong() instead");
            }
            case MILLI_OF_SECOND: {
                return this.nano / 1000000;
            }
            case MILLI_OF_DAY: {
                return (int)(this.toNanoOfDay() / 1000000L);
            }
            case SECOND_OF_MINUTE: {
                return this.second;
            }
            case SECOND_OF_DAY: {
                return this.toSecondOfDay();
            }
            case MINUTE_OF_HOUR: {
                return this.minute;
            }
            case MINUTE_OF_DAY: {
                return this.hour * 60 + this.minute;
            }
            case HOUR_OF_AMPM: {
                return this.hour % 12;
            }
            case CLOCK_HOUR_OF_AMPM: {
                int n = this.hour % 12;
                return n % 12 == 0 ? 12 : n;
            }
            case HOUR_OF_DAY: {
                return this.hour;
            }
            case CLOCK_HOUR_OF_DAY: {
                return this.hour == 0 ? 24 : (int)this.hour;
            }
            case AMPM_OF_DAY: {
                return this.hour / 12;
            }
        }
        throw new UnsupportedTemporalTypeException("Unsupported field: " + temporalField);
    }

    public int getHour() {
        return this.hour;
    }

    public int getMinute() {
        return this.minute;
    }

    public int getSecond() {
        return this.second;
    }

    public int getNano() {
        return this.nano;
    }

    @Override
    public LocalTime with(TemporalAdjuster temporalAdjuster) {
        if (temporalAdjuster instanceof LocalTime) {
            return (LocalTime)temporalAdjuster;
        }
        return (LocalTime)temporalAdjuster.adjustInto(this);
    }

    @Override
    public LocalTime with(TemporalField temporalField, long l) {
        if (temporalField instanceof ChronoField) {
            ChronoField chronoField = (ChronoField)temporalField;
            chronoField.checkValidValue(l);
            switch (chronoField) {
                case NANO_OF_SECOND: {
                    return this.withNano((int)l);
                }
                case NANO_OF_DAY: {
                    return LocalTime.ofNanoOfDay(l);
                }
                case MICRO_OF_SECOND: {
                    return this.withNano((int)l * 1000);
                }
                case MICRO_OF_DAY: {
                    return this.plusNanos((l - this.toNanoOfDay() / 1000L) * 1000L);
                }
                case MILLI_OF_SECOND: {
                    return this.withNano((int)l * 1000000);
                }
                case MILLI_OF_DAY: {
                    return this.plusNanos((l - this.toNanoOfDay() / 1000000L) * 1000000L);
                }
                case SECOND_OF_MINUTE: {
                    return this.withSecond((int)l);
                }
                case SECOND_OF_DAY: {
                    return this.plusSeconds(l - (long)this.toSecondOfDay());
                }
                case MINUTE_OF_HOUR: {
                    return this.withMinute((int)l);
                }
                case MINUTE_OF_DAY: {
                    return this.plusMinutes(l - (long)(this.hour * 60 + this.minute));
                }
                case HOUR_OF_AMPM: {
                    return this.plusHours(l - (long)(this.hour % 12));
                }
                case CLOCK_HOUR_OF_AMPM: {
                    return this.plusHours((l == 12L ? 0L : l) - (long)(this.hour % 12));
                }
                case HOUR_OF_DAY: {
                    return this.withHour((int)l);
                }
                case CLOCK_HOUR_OF_DAY: {
                    return this.withHour((int)(l == 24L ? 0L : l));
                }
                case AMPM_OF_DAY: {
                    return this.plusHours((l - (long)(this.hour / 12)) * 12L);
                }
            }
            throw new UnsupportedTemporalTypeException("Unsupported field: " + temporalField);
        }
        return temporalField.adjustInto(this, l);
    }

    public LocalTime withHour(int n) {
        if (this.hour == n) {
            return this;
        }
        ChronoField.HOUR_OF_DAY.checkValidValue(n);
        return LocalTime.create(n, this.minute, this.second, this.nano);
    }

    public LocalTime withMinute(int n) {
        if (this.minute == n) {
            return this;
        }
        ChronoField.MINUTE_OF_HOUR.checkValidValue(n);
        return LocalTime.create(this.hour, n, this.second, this.nano);
    }

    public LocalTime withSecond(int n) {
        if (this.second == n) {
            return this;
        }
        ChronoField.SECOND_OF_MINUTE.checkValidValue(n);
        return LocalTime.create(this.hour, this.minute, n, this.nano);
    }

    public LocalTime withNano(int n) {
        if (this.nano == n) {
            return this;
        }
        ChronoField.NANO_OF_SECOND.checkValidValue(n);
        return LocalTime.create(this.hour, this.minute, this.second, n);
    }

    public LocalTime truncatedTo(TemporalUnit temporalUnit) {
        if (temporalUnit == ChronoUnit.NANOS) {
            return this;
        }
        Duration duration = temporalUnit.getDuration();
        if (duration.getSeconds() > 86400L) {
            throw new UnsupportedTemporalTypeException("Unit is too large to be used for truncation");
        }
        long l = duration.toNanos();
        if (86400000000000L % l != 0L) {
            throw new UnsupportedTemporalTypeException("Unit must divide into a standard day without remainder");
        }
        long l2 = this.toNanoOfDay();
        return LocalTime.ofNanoOfDay(l2 / l * l);
    }

    @Override
    public LocalTime plus(TemporalAmount temporalAmount) {
        return (LocalTime)temporalAmount.addTo(this);
    }

    @Override
    public LocalTime plus(long l, TemporalUnit temporalUnit) {
        if (temporalUnit instanceof ChronoUnit) {
            switch ((ChronoUnit)temporalUnit) {
                case NANOS: {
                    return this.plusNanos(l);
                }
                case MICROS: {
                    return this.plusNanos(l % 86400000000L * 1000L);
                }
                case MILLIS: {
                    return this.plusNanos(l % 86400000L * 1000000L);
                }
                case SECONDS: {
                    return this.plusSeconds(l);
                }
                case MINUTES: {
                    return this.plusMinutes(l);
                }
                case HOURS: {
                    return this.plusHours(l);
                }
                case HALF_DAYS: {
                    return this.plusHours(l % 2L * 12L);
                }
            }
            throw new UnsupportedTemporalTypeException("Unsupported unit: " + temporalUnit);
        }
        return temporalUnit.addTo(this, l);
    }

    public LocalTime plusHours(long l) {
        if (l == 0L) {
            return this;
        }
        int n = ((int)(l % 24L) + this.hour + 24) % 24;
        return LocalTime.create(n, this.minute, this.second, this.nano);
    }

    public LocalTime plusMinutes(long l) {
        if (l == 0L) {
            return this;
        }
        int n = this.hour * 60 + this.minute;
        int n2 = ((int)(l % 1440L) + n + 1440) % 1440;
        if (n == n2) {
            return this;
        }
        int n3 = n2 / 60;
        int n4 = n2 % 60;
        return LocalTime.create(n3, n4, this.second, this.nano);
    }

    public LocalTime plusSeconds(long l) {
        if (l == 0L) {
            return this;
        }
        int n = this.hour * 3600 + this.minute * 60 + this.second;
        int n2 = ((int)(l % 86400L) + n + 86400) % 86400;
        if (n == n2) {
            return this;
        }
        int n3 = n2 / 3600;
        int n4 = n2 / 60 % 60;
        int n5 = n2 % 60;
        return LocalTime.create(n3, n4, n5, this.nano);
    }

    public LocalTime plusNanos(long l) {
        long l2;
        if (l == 0L) {
            return this;
        }
        long l3 = this.toNanoOfDay();
        if (l3 == (l2 = (l % 86400000000000L + l3 + 86400000000000L) % 86400000000000L)) {
            return this;
        }
        int n = (int)(l2 / 3600000000000L);
        int n2 = (int)(l2 / 60000000000L % 60L);
        int n3 = (int)(l2 / 1000000000L % 60L);
        int n4 = (int)(l2 % 1000000000L);
        return LocalTime.create(n, n2, n3, n4);
    }

    @Override
    public LocalTime minus(TemporalAmount temporalAmount) {
        return (LocalTime)temporalAmount.subtractFrom(this);
    }

    @Override
    public LocalTime minus(long l, TemporalUnit temporalUnit) {
        return l == Long.MIN_VALUE ? this.plus(Long.MAX_VALUE, temporalUnit).plus(1L, temporalUnit) : this.plus(-l, temporalUnit);
    }

    public LocalTime minusHours(long l) {
        return this.plusHours(-(l % 24L));
    }

    public LocalTime minusMinutes(long l) {
        return this.plusMinutes(-(l % 1440L));
    }

    public LocalTime minusSeconds(long l) {
        return this.plusSeconds(-(l % 86400L));
    }

    public LocalTime minusNanos(long l) {
        return this.plusNanos(-(l % 86400000000000L));
    }

    @Override
    public <R> R query(TemporalQuery<R> temporalQuery) {
        if (temporalQuery == TemporalQueries.chronology() || temporalQuery == TemporalQueries.zoneId() || temporalQuery == TemporalQueries.zone() || temporalQuery == TemporalQueries.offset()) {
            return null;
        }
        if (temporalQuery == TemporalQueries.localTime()) {
            return (R)this;
        }
        if (temporalQuery == TemporalQueries.localDate()) {
            return null;
        }
        if (temporalQuery == TemporalQueries.precision()) {
            return (R)ChronoUnit.NANOS;
        }
        return temporalQuery.queryFrom(this);
    }

    @Override
    public Temporal adjustInto(Temporal temporal) {
        return temporal.with(ChronoField.NANO_OF_DAY, this.toNanoOfDay());
    }

    @Override
    public long until(Temporal temporal, TemporalUnit temporalUnit) {
        LocalTime localTime = LocalTime.from(temporal);
        if (temporalUnit instanceof ChronoUnit) {
            long l = localTime.toNanoOfDay() - this.toNanoOfDay();
            switch ((ChronoUnit)temporalUnit) {
                case NANOS: {
                    return l;
                }
                case MICROS: {
                    return l / 1000L;
                }
                case MILLIS: {
                    return l / 1000000L;
                }
                case SECONDS: {
                    return l / 1000000000L;
                }
                case MINUTES: {
                    return l / 60000000000L;
                }
                case HOURS: {
                    return l / 3600000000000L;
                }
                case HALF_DAYS: {
                    return l / 43200000000000L;
                }
            }
            throw new UnsupportedTemporalTypeException("Unsupported unit: " + temporalUnit);
        }
        return temporalUnit.between(this, localTime);
    }

    public String format(DateTimeFormatter dateTimeFormatter) {
        Objects.requireNonNull(dateTimeFormatter, "formatter");
        return dateTimeFormatter.format(this);
    }

    public LocalDateTime atDate(LocalDate localDate) {
        return LocalDateTime.of(localDate, this);
    }

    public OffsetTime atOffset(ZoneOffset zoneOffset) {
        return OffsetTime.of(this, zoneOffset);
    }

    public int toSecondOfDay() {
        int n = this.hour * 3600;
        n += this.minute * 60;
        return n += this.second;
    }

    public long toNanoOfDay() {
        long l = (long)this.hour * 3600000000000L;
        l += (long)this.minute * 60000000000L;
        l += (long)this.second * 1000000000L;
        return l += (long)this.nano;
    }

    @Override
    public int compareTo(LocalTime localTime) {
        int n = Integer.compare(this.hour, localTime.hour);
        if (n == 0 && (n = Integer.compare(this.minute, localTime.minute)) == 0 && (n = Integer.compare(this.second, localTime.second)) == 0) {
            n = Integer.compare(this.nano, localTime.nano);
        }
        return n;
    }

    public boolean isAfter(LocalTime localTime) {
        return this.compareTo(localTime) > 0;
    }

    public boolean isBefore(LocalTime localTime) {
        return this.compareTo(localTime) < 0;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof LocalTime) {
            LocalTime localTime = (LocalTime)object;
            return this.hour == localTime.hour && this.minute == localTime.minute && this.second == localTime.second && this.nano == localTime.nano;
        }
        return false;
    }

    public int hashCode() {
        long l = this.toNanoOfDay();
        return (int)(l ^ l >>> 32);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(18);
        byte by = this.hour;
        byte by2 = this.minute;
        byte by3 = this.second;
        int n = this.nano;
        stringBuilder.append(by < 10 ? "0" : "").append(by).append(by2 < 10 ? ":0" : ":").append(by2);
        if (by3 > 0 || n > 0) {
            stringBuilder.append(by3 < 10 ? ":0" : ":").append(by3);
            if (n > 0) {
                stringBuilder.append('.');
                if (n % 1000000 == 0) {
                    stringBuilder.append(Integer.toString(n / 1000000 + 1000).substring(1));
                } else if (n % 1000 == 0) {
                    stringBuilder.append(Integer.toString(n / 1000 + 1000000).substring(1));
                } else {
                    stringBuilder.append(Integer.toString(n + 1000000000).substring(1));
                }
            }
        }
        return stringBuilder.toString();
    }

    private Object writeReplace() {
        return new Ser(4, this);
    }

    private void readObject(ObjectInputStream objectInputStream) throws InvalidObjectException {
        throw new InvalidObjectException("Deserialization via serialization delegate");
    }

    void writeExternal(DataOutput dataOutput) throws IOException {
        if (this.nano == 0) {
            if (this.second == 0) {
                if (this.minute == 0) {
                    dataOutput.writeByte(~this.hour);
                } else {
                    dataOutput.writeByte(this.hour);
                    dataOutput.writeByte(~this.minute);
                }
            } else {
                dataOutput.writeByte(this.hour);
                dataOutput.writeByte(this.minute);
                dataOutput.writeByte(~this.second);
            }
        } else {
            dataOutput.writeByte(this.hour);
            dataOutput.writeByte(this.minute);
            dataOutput.writeByte(this.second);
            dataOutput.writeInt(this.nano);
        }
    }

    static LocalTime readExternal(DataInput dataInput) throws IOException {
        int n = dataInput.readByte();
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        if (n < 0) {
            n ^= 0xFFFFFFFF;
        } else {
            n2 = dataInput.readByte();
            if (n2 < 0) {
                n2 ^= 0xFFFFFFFF;
            } else {
                n3 = dataInput.readByte();
                if (n3 < 0) {
                    n3 ^= 0xFFFFFFFF;
                } else {
                    n4 = dataInput.readInt();
                }
            }
        }
        return LocalTime.of(n, n2, n3, n4);
    }

    static {
        HOURS = new LocalTime[24];
        for (int i = 0; i < HOURS.length; ++i) {
            LocalTime.HOURS[i] = new LocalTime(i, 0, 0, 0);
        }
        MIDNIGHT = HOURS[0];
        NOON = HOURS[12];
        MIN = HOURS[0];
        MAX = new LocalTime(23, 59, 59, 999999999);
    }
}

