/*
 * Decompiled with CFR 0.152.
 */
package com.sun.crypto.provider;

import com.sun.crypto.provider.AESCrypt;
import com.sun.crypto.provider.CipherCore;
import java.nio.ByteBuffer;
import java.security.AlgorithmParameters;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.ProviderException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.BadPaddingException;
import javax.crypto.CipherSpi;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;

abstract class AESCipher
extends CipherSpi {
    private CipherCore core = new CipherCore(new AESCrypt(), 16);
    private final int fixedKeySize;

    static final void checkKeySize(Key key, int n) throws InvalidKeyException {
        if (n != -1) {
            if (key == null) {
                throw new InvalidKeyException("The key must not be null");
            }
            byte[] byArray = key.getEncoded();
            if (byArray == null) {
                throw new InvalidKeyException("Key encoding must not be null");
            }
            if (byArray.length != n) {
                throw new InvalidKeyException("The key must be " + n * 8 + " bits");
            }
        }
    }

    protected AESCipher(int n) {
        this.fixedKeySize = n;
    }

    @Override
    protected void engineSetMode(String string) throws NoSuchAlgorithmException {
        this.core.setMode(string);
    }

    @Override
    protected void engineSetPadding(String string) throws NoSuchPaddingException {
        this.core.setPadding(string);
    }

    @Override
    protected int engineGetBlockSize() {
        return 16;
    }

    @Override
    protected int engineGetOutputSize(int n) {
        return this.core.getOutputSize(n);
    }

    @Override
    protected byte[] engineGetIV() {
        return this.core.getIV();
    }

    @Override
    protected AlgorithmParameters engineGetParameters() {
        return this.core.getParameters("AES");
    }

    @Override
    protected void engineInit(int n, Key key, SecureRandom secureRandom) throws InvalidKeyException {
        AESCipher.checkKeySize(key, this.fixedKeySize);
        this.core.init(n, key, secureRandom);
    }

    @Override
    protected void engineInit(int n, Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        AESCipher.checkKeySize(key, this.fixedKeySize);
        this.core.init(n, key, algorithmParameterSpec, secureRandom);
    }

    @Override
    protected void engineInit(int n, Key key, AlgorithmParameters algorithmParameters, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        AESCipher.checkKeySize(key, this.fixedKeySize);
        this.core.init(n, key, algorithmParameters, secureRandom);
    }

    @Override
    protected byte[] engineUpdate(byte[] byArray, int n, int n2) {
        return this.core.update(byArray, n, n2);
    }

    @Override
    protected int engineUpdate(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws ShortBufferException {
        return this.core.update(byArray, n, n2, byArray2, n3);
    }

    @Override
    protected byte[] engineDoFinal(byte[] byArray, int n, int n2) throws IllegalBlockSizeException, BadPaddingException {
        return this.core.doFinal(byArray, n, n2);
    }

    @Override
    protected int engineDoFinal(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws IllegalBlockSizeException, ShortBufferException, BadPaddingException {
        return this.core.doFinal(byArray, n, n2, byArray2, n3);
    }

    @Override
    protected int engineGetKeySize(Key key) throws InvalidKeyException {
        byte[] byArray = key.getEncoded();
        if (!AESCrypt.isKeySizeValid(byArray.length)) {
            throw new InvalidKeyException("Invalid AES key length: " + byArray.length + " bytes");
        }
        return byArray.length * 8;
    }

    @Override
    protected byte[] engineWrap(Key key) throws IllegalBlockSizeException, InvalidKeyException {
        return this.core.wrap(key);
    }

    @Override
    protected Key engineUnwrap(byte[] byArray, String string, int n) throws InvalidKeyException, NoSuchAlgorithmException {
        return this.core.unwrap(byArray, string, n);
    }

    @Override
    protected void engineUpdateAAD(byte[] byArray, int n, int n2) {
        this.core.updateAAD(byArray, n, n2);
    }

    @Override
    protected void engineUpdateAAD(ByteBuffer byteBuffer) {
        int n;
        if (byteBuffer != null && (n = byteBuffer.limit() - byteBuffer.position()) != 0) {
            if (byteBuffer.hasArray()) {
                int n2 = byteBuffer.arrayOffset() + byteBuffer.position();
                this.core.updateAAD(byteBuffer.array(), n2, n);
                byteBuffer.position(byteBuffer.limit());
            } else {
                byte[] byArray = new byte[n];
                byteBuffer.get(byArray);
                this.core.updateAAD(byArray, 0, n);
            }
        }
    }

    public static final class AES256_GCM_NoPadding
    extends OidImpl {
        public AES256_GCM_NoPadding() {
            super(32, "GCM", "NOPADDING");
        }
    }

    public static final class AES192_GCM_NoPadding
    extends OidImpl {
        public AES192_GCM_NoPadding() {
            super(24, "GCM", "NOPADDING");
        }
    }

    public static final class AES128_GCM_NoPadding
    extends OidImpl {
        public AES128_GCM_NoPadding() {
            super(16, "GCM", "NOPADDING");
        }
    }

    public static final class AES256_CFB_NoPadding
    extends OidImpl {
        public AES256_CFB_NoPadding() {
            super(32, "CFB", "NOPADDING");
        }
    }

    public static final class AES192_CFB_NoPadding
    extends OidImpl {
        public AES192_CFB_NoPadding() {
            super(24, "CFB", "NOPADDING");
        }
    }

    public static final class AES128_CFB_NoPadding
    extends OidImpl {
        public AES128_CFB_NoPadding() {
            super(16, "CFB", "NOPADDING");
        }
    }

    public static final class AES256_OFB_NoPadding
    extends OidImpl {
        public AES256_OFB_NoPadding() {
            super(32, "OFB", "NOPADDING");
        }
    }

    public static final class AES192_OFB_NoPadding
    extends OidImpl {
        public AES192_OFB_NoPadding() {
            super(24, "OFB", "NOPADDING");
        }
    }

    public static final class AES128_OFB_NoPadding
    extends OidImpl {
        public AES128_OFB_NoPadding() {
            super(16, "OFB", "NOPADDING");
        }
    }

    public static final class AES256_CBC_NoPadding
    extends OidImpl {
        public AES256_CBC_NoPadding() {
            super(32, "CBC", "NOPADDING");
        }
    }

    public static final class AES192_CBC_NoPadding
    extends OidImpl {
        public AES192_CBC_NoPadding() {
            super(24, "CBC", "NOPADDING");
        }
    }

    public static final class AES128_CBC_NoPadding
    extends OidImpl {
        public AES128_CBC_NoPadding() {
            super(16, "CBC", "NOPADDING");
        }
    }

    public static final class AES256_ECB_NoPadding
    extends OidImpl {
        public AES256_ECB_NoPadding() {
            super(32, "ECB", "NOPADDING");
        }
    }

    public static final class AES192_ECB_NoPadding
    extends OidImpl {
        public AES192_ECB_NoPadding() {
            super(24, "ECB", "NOPADDING");
        }
    }

    public static final class AES128_ECB_NoPadding
    extends OidImpl {
        public AES128_ECB_NoPadding() {
            super(16, "ECB", "NOPADDING");
        }
    }

    static abstract class OidImpl
    extends AESCipher {
        protected OidImpl(int n, String string, String string2) {
            super(n);
            try {
                this.engineSetMode(string);
                this.engineSetPadding(string2);
            }
            catch (GeneralSecurityException generalSecurityException) {
                ProviderException providerException = new ProviderException("Internal Error");
                providerException.initCause(generalSecurityException);
                throw providerException;
            }
        }
    }

    public static final class General
    extends AESCipher {
        public General() {
            super(-1);
        }
    }
}

