/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.runtime;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.TypeDescriptor;
import jdk.internal.dynalink.CallSiteDescriptor;
import jdk.internal.dynalink.linker.GuardedInvocation;
import jdk.nashorn.internal.codegen.ObjectClassGenerator;
import jdk.nashorn.internal.lookup.Lookup;
import jdk.nashorn.internal.runtime.AccessorProperty;
import jdk.nashorn.internal.runtime.Context;
import jdk.nashorn.internal.runtime.ECMAErrors;
import jdk.nashorn.internal.runtime.FindProperty;
import jdk.nashorn.internal.runtime.Property;
import jdk.nashorn.internal.runtime.PropertyMap;
import jdk.nashorn.internal.runtime.ScriptObject;
import jdk.nashorn.internal.runtime.linker.NashornCallSiteDescriptor;
import jdk.nashorn.internal.runtime.linker.NashornGuards;

final class SetMethodCreator {
    private final ScriptObject sobj;
    private final PropertyMap map;
    private final FindProperty find;
    private final CallSiteDescriptor desc;

    SetMethodCreator(ScriptObject sobj, FindProperty find, CallSiteDescriptor desc) {
        this.sobj = sobj;
        this.map = sobj.getMap();
        this.find = find;
        this.desc = desc;
    }

    private String getName() {
        return this.desc.getNameToken(2);
    }

    private PropertyMap getMap() {
        return this.map;
    }

    GuardedInvocation createGuardedInvocation() {
        return this.createSetMethod().createGuardedInvocation();
    }

    private SetMethod createSetMethod() {
        if (this.find != null) {
            return this.createExistingPropertySetter();
        }
        this.checkStrictCreateNewVariable();
        if (this.sobj.isScope()) {
            return this.createGlobalPropertySetter();
        }
        return this.createNewPropertySetter();
    }

    private void checkStrictCreateNewVariable() {
        if (NashornCallSiteDescriptor.isScope(this.desc) && NashornCallSiteDescriptor.isStrict(this.desc)) {
            throw ECMAErrors.referenceError("not.defined", this.getName());
        }
    }

    private SetMethod createExistingPropertySetter() {
        Property property = this.find.getProperty();
        TypeDescriptor.OfField type = this.desc.getMethodType().parameterType(1);
        MethodHandle methodHandle = this.find.getSetter((Class<?>)type, NashornCallSiteDescriptor.isStrict(this.desc));
        assert (methodHandle != null);
        assert (property != null);
        ScriptObject prototype = this.find.getOwner();
        MethodHandle boundHandle = !property.hasSetterFunction(prototype) && this.find.isInherited() ? ScriptObject.bindTo(methodHandle, prototype) : methodHandle;
        return new SetMethod(boundHandle, property);
    }

    private SetMethod createGlobalPropertySetter() {
        ScriptObject global = Context.getGlobalTrusted();
        return new SetMethod(ScriptObject.bindTo(global.addSpill(this.getName()), global), null);
    }

    private SetMethod createNewPropertySetter() {
        SetMethod sm = this.map.getFieldCount() < this.map.getFieldMaximum() ? this.createNewFieldSetter() : this.createNewSpillPropertySetter();
        this.sobj.notifyPropertyAdded(this.sobj, sm.property);
        return sm;
    }

    private SetMethod createNewFieldSetter() {
        PropertyMap oldMap = this.getMap();
        AccessorProperty property = new AccessorProperty(this.getName(), 0, this.sobj.getClass(), oldMap.getFieldCount());
        PropertyMap newMap = oldMap.addProperty(property);
        MethodHandle setter = Lookup.MH.insertArguments(ScriptObject.SETFIELD, 0, this.desc, oldMap, newMap, ((Property)property).getSetter(Object.class, newMap));
        return new SetMethod(Lookup.MH.asType(setter, Lookup.SET_OBJECT_TYPE), property);
    }

    private SetMethod createNewSpillPropertySetter() {
        int nextSpill = this.getMap().getSpillLength();
        AccessorProperty property = new AccessorProperty(this.getName(), 8, nextSpill);
        return new SetMethod(this.createSpillMethodHandle(nextSpill, property), property);
    }

    private MethodHandle createSpillMethodHandle(int nextSpill, Property property) {
        PropertyMap oldMap = this.getMap();
        PropertyMap newMap = this.getNewMap(property);
        Object[] spill = this.sobj.spill;
        if (spill == null) {
            return Lookup.MH.insertArguments(ScriptObject.SETSPILLWITHNEW, 0, this.desc, oldMap, newMap, nextSpill);
        }
        if (nextSpill < spill.length) {
            return Lookup.MH.insertArguments(ScriptObject.SETSPILL, 0, this.desc, oldMap, newMap, nextSpill);
        }
        int newLength = (nextSpill + 8) / 8 * 8;
        return Lookup.MH.insertArguments(ScriptObject.SETSPILLWITHGROW, 0, this.desc, oldMap, newMap, nextSpill, newLength);
    }

    private PropertyMap getNewMap(Property property) {
        return this.getMap().addProperty(property);
    }

    private class SetMethod {
        private final MethodHandle methodHandle;
        private final Property property;

        SetMethod(MethodHandle methodHandle, Property property) {
            assert (methodHandle != null);
            this.methodHandle = methodHandle;
            this.property = property;
        }

        GuardedInvocation createGuardedInvocation() {
            return new GuardedInvocation(this.methodHandle, this.getGuard());
        }

        private MethodHandle getGuard() {
            return this.needsNoGuard() ? null : NashornGuards.getMapGuard(SetMethodCreator.this.getMap());
        }

        private boolean needsNoGuard() {
            return NashornCallSiteDescriptor.isFastScope(SetMethodCreator.this.desc) && (ObjectClassGenerator.OBJECT_FIELDS_ONLY || this.isPropertyTypeStable());
        }

        private boolean isPropertyTypeStable() {
            return this.property == null || !this.property.canChangeType();
        }
    }
}

