/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.objects;

import java.io.PrintWriter;
import java.util.Collections;
import java.util.Objects;
import jdk.nashorn.internal.objects.Global;
import jdk.nashorn.internal.runtime.Context;
import jdk.nashorn.internal.runtime.PropertyListenerManager;
import jdk.nashorn.internal.runtime.PropertyMap;
import jdk.nashorn.internal.runtime.ScriptFunction;
import jdk.nashorn.internal.runtime.ScriptObject;
import jdk.nashorn.internal.runtime.ScriptRuntime;
import jdk.nashorn.internal.runtime.linker.LinkerCallSite;

public final class NativeDebug
extends ScriptObject {
    private static PropertyMap $nasgenmap$;

    private NativeDebug() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getClassName() {
        return "Debug";
    }

    public static Object getContext(Object self) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new RuntimePermission("nashorn.getContext"));
        }
        return Global.getThisContext();
    }

    public static Object map(Object self, Object obj) {
        if (obj instanceof ScriptObject) {
            return ((ScriptObject)obj).getMap();
        }
        return ScriptRuntime.UNDEFINED;
    }

    public static Object spill(Object self, Object obj) {
        if (obj instanceof ScriptObject) {
            return ((ScriptObject)obj).spill;
        }
        return ScriptRuntime.UNDEFINED;
    }

    public static Object identical(Object self, Object obj1, Object obj2) {
        return obj1 == obj2;
    }

    public static Object getClass(Object self, Object obj) {
        if (obj != null) {
            return obj.getClass();
        }
        return ScriptRuntime.UNDEFINED;
    }

    public static Object equals(Object self, Object obj1, Object obj2) {
        return Objects.equals(obj1, obj2);
    }

    public static Object toJavaString(Object self, Object obj) {
        return Objects.toString(obj);
    }

    public static Object toIdentString(Object self, Object obj) {
        if (obj == null) {
            return "null";
        }
        int hash = System.identityHashCode(obj);
        return obj.getClass() + "@" + Integer.toHexString(hash);
    }

    public static Object getListenerCount(Object self, Object obj) {
        return obj instanceof ScriptObject ? ((ScriptObject)obj).getListenerCount() : 0;
    }

    public static Object dumpCounters(Object self) {
        PrintWriter out = Context.getCurrentErr();
        out.println("ScriptObject count " + ScriptObject.getCount());
        out.println("Scope count " + ScriptObject.getScopeCount());
        out.println("ScriptObject listeners added " + PropertyListenerManager.getListenersAdded());
        out.println("ScriptObject listeners removed " + PropertyListenerManager.getListenersRemoved());
        out.println("ScriptFunction constructor calls " + ScriptFunction.getConstructorCount());
        out.println("ScriptFunction invokes " + ScriptFunction.getInvokes());
        out.println("ScriptFunction allocations " + ScriptFunction.getAllocations());
        out.println("PropertyMap count " + PropertyMap.getCount());
        out.println("PropertyMap cloned " + PropertyMap.getClonedCount());
        out.println("PropertyMap shared " + PropertyMap.getSharedCount());
        out.println("PropertyMap duplicated " + PropertyMap.getDuplicatedCount());
        out.println("PropertyMap history hit " + PropertyMap.getHistoryHit());
        out.println("PropertyMap proto invalidations " + PropertyMap.getProtoInvalidations());
        out.println("PropertyMap proto history hit " + PropertyMap.getProtoHistoryHit());
        out.println("PropertyMap setProtoNewMapCount " + PropertyMap.getSetProtoNewMapCount());
        out.println("Callsite count " + LinkerCallSite.getCount());
        out.println("Callsite misses " + LinkerCallSite.getMissCount());
        out.println("Callsite misses by site at " + LinkerCallSite.getMissSamplingPercentage() + "%");
        LinkerCallSite.getMissCounts(out);
        return ScriptRuntime.UNDEFINED;
    }

    static {
        NativeDebug.$clinit$();
    }

    public static void $clinit$() {
        $nasgenmap$ = PropertyMap.newMap(Collections.EMPTY_LIST).setIsShared();
    }
}

