/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.ir;

import jdk.nashorn.internal.codegen.Label;
import jdk.nashorn.internal.ir.Block;
import jdk.nashorn.internal.ir.Expression;
import jdk.nashorn.internal.ir.LexicalContext;
import jdk.nashorn.internal.ir.Node;
import jdk.nashorn.internal.ir.annotations.Immutable;
import jdk.nashorn.internal.ir.visitor.NodeVisitor;

@Immutable
public final class CaseNode
extends Node {
    private final Expression test;
    private final Block body;
    private final Label entry;

    public CaseNode(long token, int finish, Expression test, Block body) {
        super(token, finish);
        this.test = test;
        this.body = body;
        this.entry = new Label("entry");
    }

    CaseNode(CaseNode caseNode, Expression test, Block body) {
        super(caseNode);
        this.test = test;
        this.body = body;
        this.entry = new Label(caseNode.entry);
    }

    @Override
    public boolean isTerminal() {
        return this.body.isTerminal();
    }

    @Override
    public Node accept(NodeVisitor<? extends LexicalContext> visitor) {
        if (visitor.enterCaseNode(this)) {
            Expression newTest = this.test == null ? null : (Expression)this.test.accept(visitor);
            Block newBody = this.body == null ? null : (Block)this.body.accept(visitor);
            return visitor.leaveCaseNode(this.setTest(newTest).setBody(newBody));
        }
        return this;
    }

    @Override
    public void toString(StringBuilder sb) {
        if (this.test != null) {
            sb.append("case ");
            this.test.toString(sb);
            sb.append(':');
        } else {
            sb.append("default:");
        }
    }

    public Block getBody() {
        return this.body;
    }

    public Label getEntry() {
        return this.entry;
    }

    public Expression getTest() {
        return this.test;
    }

    public CaseNode setTest(Expression test) {
        if (this.test == test) {
            return this;
        }
        return new CaseNode(this, test, this.body);
    }

    private CaseNode setBody(Block body) {
        if (this.body == body) {
            return this;
        }
        return new CaseNode(this, this.test, body);
    }
}

