/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import javax.crypto.BadPaddingException;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLProtocolException;
import sun.misc.HexDumpEncoder;
import sun.security.ssl.Authenticator;
import sun.security.ssl.CipherBox;
import sun.security.ssl.Debug;
import sun.security.ssl.HandshakeHash;
import sun.security.ssl.MAC;
import sun.security.ssl.ProtocolVersion;
import sun.security.ssl.Record;

class InputRecord
extends ByteArrayInputStream
implements Record {
    private HandshakeHash handshakeHash;
    private int lastHashed;
    boolean formatVerified = true;
    private boolean isClosed;
    private boolean appDataValid;
    private ProtocolVersion helloVersion;
    static final Debug debug = Debug.getInstance("ssl");
    private int exlen;
    private byte[] v2Buf;
    private static final byte[] v2NoCipher = new byte[]{-128, 3, 0, 0, 1};

    InputRecord() {
        super(new byte[16921]);
        this.setHelloVersion(ProtocolVersion.DEFAULT_HELLO);
        this.pos = 5;
        this.lastHashed = this.count = 5;
        this.exlen = 0;
        this.v2Buf = null;
    }

    void setHelloVersion(ProtocolVersion protocolVersion) {
        this.helloVersion = protocolVersion;
    }

    ProtocolVersion getHelloVersion() {
        return this.helloVersion;
    }

    void enableFormatChecks() {
        this.formatVerified = false;
    }

    boolean isAppDataValid() {
        return this.appDataValid;
    }

    void setAppDataValid(boolean bl) {
        this.appDataValid = bl;
    }

    byte contentType() {
        return this.buf[0];
    }

    void setHandshakeHash(HandshakeHash handshakeHash) {
        this.handshakeHash = handshakeHash;
    }

    HandshakeHash getHandshakeHash() {
        return this.handshakeHash;
    }

    void decrypt(Authenticator authenticator, CipherBox cipherBox) throws BadPaddingException {
        int n;
        BadPaddingException badPaddingException = null;
        int n2 = authenticator instanceof MAC ? ((MAC)authenticator).MAClen() : 0;
        int n3 = this.count - 5;
        if (!cipherBox.isNullCipher()) {
            try {
                int n4 = cipherBox.applyExplicitNonce(authenticator, this.contentType(), this.buf, 5, n3);
                this.lastHashed = this.pos = 5 + n4;
                n = 5;
                if (cipherBox.isAEADMode()) {
                    n += n4;
                }
                this.count = n + cipherBox.decrypt(this.buf, n, this.count - n, n2);
            }
            catch (BadPaddingException badPaddingException2) {
                badPaddingException = badPaddingException2;
            }
        }
        if (authenticator instanceof MAC && n2 != 0) {
            MAC mAC = (MAC)authenticator;
            n = this.count - n2;
            int n5 = n - this.pos;
            if (n5 < 0) {
                if (badPaddingException == null) {
                    badPaddingException = new BadPaddingException("bad record");
                }
                n = 5 + n3 - n2;
                n5 = n - 5;
            }
            this.count -= n2;
            if (InputRecord.checkMacTags(this.contentType(), this.buf, this.pos, n5, mAC, false) && badPaddingException == null) {
                badPaddingException = new BadPaddingException("bad record MAC");
            }
            if (cipherBox.isCBCMode()) {
                int n6 = InputRecord.calculateRemainingLen(mAC, n3, n5);
                if (n6 > this.buf.length) {
                    throw new RuntimeException("Internal buffer capacity error");
                }
                InputRecord.checkMacTags(this.contentType(), this.buf, 0, n6, mAC, true);
            }
        }
        if (badPaddingException != null) {
            throw badPaddingException;
        }
    }

    static boolean checkMacTags(byte by, byte[] byArray, int n, int n2, MAC mAC, boolean bl) {
        int n3 = mAC.MAClen();
        byte[] byArray2 = mAC.compute(by, byArray, n, n2, bl);
        if (byArray2 == null || n3 != byArray2.length) {
            throw new RuntimeException("Internal MAC error");
        }
        int[] nArray = InputRecord.compareMacTags(byArray, n + n2, byArray2);
        return nArray[0] != 0;
    }

    private static int[] compareMacTags(byte[] byArray, int n, byte[] byArray2) {
        int[] nArray = new int[]{0, 0};
        for (int i = 0; i < byArray2.length; ++i) {
            if (byArray[n + i] != byArray2[i]) {
                nArray[0] = nArray[0] + 1;
                continue;
            }
            nArray[1] = nArray[1] + 1;
        }
        return nArray;
    }

    static int calculateRemainingLen(MAC mAC, int n, int n2) {
        int n3 = mAC.hashBlockLen();
        int n4 = mAC.minimalPaddingLen();
        return 1 + (int)(Math.ceil((double)(n += 13 - (n3 - n4)) / (1.0 * (double)n3)) - Math.ceil((double)(n2 += 13 - (n3 - n4)) / (1.0 * (double)n3))) * mAC.hashBlockLen();
    }

    void ignore(int n) {
        if (n > 0) {
            this.pos += n;
            this.lastHashed = this.pos;
        }
    }

    void doHashes() {
        int n = this.pos - this.lastHashed;
        if (n > 0) {
            this.hashInternal(this.buf, this.lastHashed, n);
            this.lastHashed = this.pos;
        }
    }

    private void hashInternal(byte[] byArray, int n, int n2) {
        if (debug != null && Debug.isOn("data")) {
            try {
                HexDumpEncoder hexDumpEncoder = new HexDumpEncoder();
                System.out.println("[read] MD5 and SHA1 hashes:  len = " + n2);
                hexDumpEncoder.encodeBuffer((InputStream)new ByteArrayInputStream(byArray, n, n2), (OutputStream)System.out);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.handshakeHash.update(byArray, n, n2);
    }

    void queueHandshake(InputRecord inputRecord) throws IOException {
        int n;
        this.doHashes();
        if (this.pos > 5) {
            n = this.count - this.pos;
            if (n != 0) {
                System.arraycopy(this.buf, this.pos, this.buf, 5, n);
            }
            this.lastHashed = this.pos = 5;
            this.count = 5 + n;
        }
        if (this.buf.length < (n = inputRecord.available() + this.count)) {
            byte[] byArray = new byte[n];
            System.arraycopy(this.buf, 0, byArray, 0, this.count);
            this.buf = byArray;
        }
        System.arraycopy(inputRecord.buf, inputRecord.pos, this.buf, this.count, n - this.count);
        this.count = n;
        n = inputRecord.lastHashed - inputRecord.pos;
        if (this.pos == 5) {
            this.lastHashed += n;
        } else {
            throw new SSLProtocolException("?? confused buffer hashing ??");
        }
        inputRecord.pos = inputRecord.count;
    }

    @Override
    public void close() {
        this.appDataValid = false;
        this.isClosed = true;
        this.mark = 0;
        this.pos = 0;
        this.count = 0;
    }

    private int readFully(InputStream inputStream, byte[] byArray, int n, int n2) throws IOException {
        int n3 = 0;
        while (n3 < n2) {
            int n4 = inputStream.read(byArray, n + n3, n2 - n3);
            if (n4 < 0) {
                return n4;
            }
            if (debug != null && Debug.isOn("packet")) {
                try {
                    HexDumpEncoder hexDumpEncoder = new HexDumpEncoder();
                    ByteBuffer byteBuffer = ByteBuffer.wrap(byArray, n + n3, n4);
                    System.out.println("[Raw read]: length = " + byteBuffer.remaining());
                    hexDumpEncoder.encodeBuffer(byteBuffer, (OutputStream)System.out);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            n3 += n4;
            this.exlen += n4;
        }
        return n3;
    }

    void read(InputStream inputStream, OutputStream outputStream) throws IOException {
        if (this.isClosed) {
            return;
        }
        if (this.exlen < 5) {
            int n = this.readFully(inputStream, this.buf, this.exlen, 5 - this.exlen);
            if (n < 0) {
                throw new EOFException("SSL peer shut down incorrectly");
            }
            this.pos = 5;
            this.count = 5;
            this.lastHashed = this.pos;
        }
        if (!this.formatVerified) {
            this.formatVerified = true;
            if (this.buf[0] != 22 && this.buf[0] != 21) {
                this.handleUnknownRecord(inputStream, outputStream);
            } else {
                this.readV3Record(inputStream, outputStream);
            }
        } else {
            this.readV3Record(inputStream, outputStream);
        }
    }

    private void readV3Record(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n;
        ProtocolVersion protocolVersion = ProtocolVersion.valueOf(this.buf[1], this.buf[2]);
        if (protocolVersion.v < ProtocolVersion.MIN.v || protocolVersion.major > ProtocolVersion.MAX.major) {
            throw new SSLException("Unsupported record version " + protocolVersion);
        }
        int n2 = ((this.buf[3] & 0xFF) << 8) + (this.buf[4] & 0xFF);
        if (n2 < 0 || n2 > 33300) {
            throw new SSLProtocolException("Bad InputRecord size, count = " + n2 + ", buf.length = " + this.buf.length);
        }
        if (n2 > this.buf.length - 5) {
            byte[] byArray = new byte[n2 + 5];
            System.arraycopy(this.buf, 0, byArray, 0, 5);
            this.buf = byArray;
        }
        if (this.exlen < n2 + 5 && (n = this.readFully(inputStream, this.buf, this.exlen, n2 + 5 - this.exlen)) < 0) {
            throw new SSLException("SSL peer shut down incorrectly");
        }
        this.count = n2 + 5;
        this.exlen = 0;
        if (debug != null && Debug.isOn("record")) {
            if (this.count < 0 || this.count > 16916) {
                System.out.println(Thread.currentThread().getName() + ", Bad InputRecord size" + ", count = " + this.count);
            }
            System.out.println(Thread.currentThread().getName() + ", READ: " + protocolVersion + " " + InputRecord.contentName(this.contentType()) + ", length = " + this.available());
        }
    }

    private void handleUnknownRecord(InputStream inputStream, OutputStream outputStream) throws IOException {
        if ((this.buf[0] & 0x80) != 0 && this.buf[2] == 1) {
            int n;
            if (this.helloVersion != ProtocolVersion.SSL20Hello) {
                throw new SSLHandshakeException("SSLv2Hello is disabled");
            }
            ProtocolVersion protocolVersion = ProtocolVersion.valueOf(this.buf[3], this.buf[4]);
            if (protocolVersion == ProtocolVersion.SSL20Hello) {
                try {
                    this.writeBuffer(outputStream, v2NoCipher, 0, v2NoCipher.length);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw new SSLException("Unsupported SSL v2.0 ClientHello");
            }
            int n2 = ((this.buf[0] & 0x7F) << 8) + (this.buf[1] & 0xFF) - 3;
            if (this.v2Buf == null) {
                this.v2Buf = new byte[n2];
            }
            if (this.exlen < n2 + 5 && (n = this.readFully(inputStream, this.v2Buf, this.exlen - 5, n2 + 5 - this.exlen)) < 0) {
                throw new EOFException("SSL peer shut down incorrectly");
            }
            this.exlen = 0;
            this.hashInternal(this.buf, 2, 3);
            this.hashInternal(this.v2Buf, 0, n2);
            this.V2toV3ClientHello(this.v2Buf);
            this.v2Buf = null;
            this.lastHashed = this.count;
            if (debug != null && Debug.isOn("record")) {
                System.out.println(Thread.currentThread().getName() + ", READ:  SSL v2, contentType = " + InputRecord.contentName(this.contentType()) + ", translated length = " + this.available());
            }
            return;
        }
        if ((this.buf[0] & 0x80) != 0 && this.buf[2] == 4) {
            throw new SSLException("SSL V2.0 servers are not supported.");
        }
        for (int i = 0; i < v2NoCipher.length; ++i) {
            if (this.buf[i] == v2NoCipher[i]) continue;
            throw new SSLException("Unrecognized SSL message, plaintext connection?");
        }
        throw new SSLException("SSL V2.0 servers are not supported.");
    }

    void writeBuffer(OutputStream outputStream, byte[] byArray, int n, int n2) throws IOException {
        outputStream.write(byArray, 0, n2);
        outputStream.flush();
    }

    private void V2toV3ClientHello(byte[] byArray) throws SSLException {
        int n;
        this.buf[0] = 22;
        this.buf[1] = this.buf[3];
        this.buf[2] = this.buf[4];
        this.buf[5] = 1;
        this.buf[9] = this.buf[1];
        this.buf[10] = this.buf[2];
        this.count = 11;
        int n2 = ((byArray[0] & 0xFF) << 8) + (byArray[1] & 0xFF);
        int n3 = ((byArray[2] & 0xFF) << 8) + (byArray[3] & 0xFF);
        int n4 = ((byArray[4] & 0xFF) << 8) + (byArray[5] & 0xFF);
        int n5 = 6 + n2 + n3;
        if (n4 < 32) {
            for (n = 0; n < 32 - n4; ++n) {
                this.buf[this.count++] = 0;
            }
            System.arraycopy(byArray, n5, this.buf, this.count, n4);
            this.count += n4;
        } else {
            System.arraycopy(byArray, n5 + (n4 - 32), this.buf, this.count, 32);
            this.count += 32;
        }
        this.buf[this.count++] = (byte)n3;
        System.arraycopy(byArray, n5 -= n3, this.buf, this.count, n3);
        this.count += n3;
        n5 -= n2;
        int n6 = this.count + 2;
        for (n = 0; n < n2; n += 3) {
            if (byArray[n5 + n] != 0) continue;
            this.buf[n6++] = byArray[n5 + n + 1];
            this.buf[n6++] = byArray[n5 + n + 2];
        }
        this.buf[this.count++] = (byte)((n6 -= this.count + 2) >>> 8);
        this.buf[this.count++] = (byte)n6;
        this.count += n6;
        this.buf[this.count++] = 1;
        this.buf[this.count++] = 0;
        this.buf[3] = (byte)(this.count - 5);
        this.buf[4] = (byte)(this.count - 5 >>> 8);
        this.buf[6] = 0;
        this.buf[7] = (byte)(this.count - 5 - 4 >>> 8);
        this.buf[8] = (byte)(this.count - 5 - 4);
        this.pos = 5;
    }

    static String contentName(int n) {
        switch (n) {
            case 20: {
                return "Change Cipher Spec";
            }
            case 21: {
                return "Alert";
            }
            case 22: {
                return "Handshake";
            }
            case 23: {
                return "Application Data";
            }
        }
        return "contentType = " + n;
    }
}

