/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.ci;

import java.io.PrintStream;
import java.util.Observable;
import java.util.Observer;
import sun.jvm.hotspot.ci.ciMetadata;
import sun.jvm.hotspot.ci.ciObjectFactory;
import sun.jvm.hotspot.compiler.CompileTask;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.oops.CIntField;
import sun.jvm.hotspot.oops.InstanceKlass;
import sun.jvm.hotspot.oops.Method;
import sun.jvm.hotspot.oops.OopUtilities;
import sun.jvm.hotspot.opto.Compile;
import sun.jvm.hotspot.prims.JvmtiExport;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.runtime.VMObject;
import sun.jvm.hotspot.types.AddressField;
import sun.jvm.hotspot.types.Type;
import sun.jvm.hotspot.types.TypeDataBase;
import sun.jvm.hotspot.types.WrongTypeException;
import sun.jvm.hotspot.utilities.GrowableArray;

public class ciEnv
extends VMObject {
    private static AddressField dependenciesField;
    private static AddressField factoryField;
    private static AddressField compilerDataField;
    private static AddressField taskField;
    private static CIntField systemDictionaryModificationCounterField;

    private static synchronized void initialize(TypeDataBase db) throws WrongTypeException {
        Type type = db.lookupType("ciEnv");
        dependenciesField = type.getAddressField("_dependencies");
        factoryField = type.getAddressField("_factory");
        compilerDataField = type.getAddressField("_compiler_data");
        taskField = type.getAddressField("_task");
        systemDictionaryModificationCounterField = new CIntField(type.getCIntegerField("_system_dictionary_modification_counter"), 0L);
    }

    public ciEnv(Address addr) {
        super(addr);
    }

    public Compile compilerData() {
        return new Compile(compilerDataField.getValue(this.getAddress()));
    }

    public ciObjectFactory factory() {
        return new ciObjectFactory(factoryField.getValue(this.getAddress()));
    }

    public CompileTask task() {
        return new CompileTask(taskField.getValue(this.getAddress()));
    }

    public void dumpReplayData(PrintStream out) {
        out.println("JvmtiExport can_access_local_variables " + (JvmtiExport.canAccessLocalVariables() ? (char)'1' : '0'));
        out.println("JvmtiExport can_hotswap_or_post_breakpoint " + (JvmtiExport.canHotswapOrPostBreakpoint() ? (char)'1' : '0'));
        out.println("JvmtiExport can_post_on_exceptions " + (JvmtiExport.canPostOnExceptions() ? (char)'1' : '0'));
        GrowableArray<ciMetadata> objects = this.factory().objects();
        out.println("# " + objects.length() + " ciObject found");
        for (int i = 0; i < objects.length(); ++i) {
            ciMetadata o = objects.at(i);
            out.println("# ciMetadata" + i + " @ " + o);
            o.dumpReplayData(out);
        }
        CompileTask task = this.task();
        Method method = task.method();
        int entryBci = task.osrBci();
        int compLevel = task.compLevel();
        InstanceKlass holder = method.getMethodHolder();
        out.println("compile " + holder.getName().asString() + " " + OopUtilities.escapeString(method.getName().asString()) + " " + method.getSignature().asString() + " " + entryBci + " " + compLevel);
    }

    static {
        VM.registerVMInitializedObserver(new Observer(){

            @Override
            public void update(Observable o, Object data) {
                ciEnv.initialize(VM.getVM().getTypeDataBase());
            }
        });
    }
}

