/**
* @file   NeighborhoodTables.h
* @author Pablo Hernandez-Cerdan. Institute of Fundamental Sciences.
* Massey University. Palmerston North, New Zealand
* @date 2016/03/25
*
* Configuration header for DGtal look up tables.

* You can use loadTable(table)
* @see NeighborhoodConfigurations.h
*
**/
#include <string>

namespace DGtal {
  namespace simplicity  {
  ///Path to the DGtal look up tables. Compressed with zlib.
  const std::string tableDir = "/usr/src/packages/BUILD/libDGtal/src/DGtal-0.9.3/src/DGtal/topology/tables";
  const std::string tableSimple26_6 =
    "/usr/src/packages/BUILD/libDGtal/src/DGtal-0.9.3/src/DGtal/topology/tables/simplicity_table26_6.zlib";
  const std::string tableSimple18_6 =
    "/usr/src/packages/BUILD/libDGtal/src/DGtal-0.9.3/src/DGtal/topology/tables/simplicity_table18_6.zlib";
  const std::string tableSimple6_26 =
    "/usr/src/packages/BUILD/libDGtal/src/DGtal-0.9.3/src/DGtal/topology/tables/simplicity_table6_26.zlib";
  const std::string tableSimple6_18 =
    "/usr/src/packages/BUILD/libDGtal/src/DGtal-0.9.3/src/DGtal/topology/tables/simplicity_table6_18.zlib";
  const std::string tableSimple8_4 =
    "/usr/src/packages/BUILD/libDGtal/src/DGtal-0.9.3/src/DGtal/topology/tables/simplicity_table8_4.zlib";
  const std::string tableSimple4_8 =
    "/usr/src/packages/BUILD/libDGtal/src/DGtal-0.9.3/src/DGtal/topology/tables/simplicity_table4_8.zlib";

  } // simplicity namespace
} // DGtal namespace


