/**
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as
 *  published by the Free Software Foundation, either version 3 of the
 *  License, or  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 **/

/**
 * @file NeighborhoodConfigurationsHelper.h
 *
 * @author Pablo Hernandez-Cerdan. Institute of Fundamental Sciences.
 * Massey University. Palmerston North, New Zealand
 *
 * @date 2016/03/25
 *
 * Help definitions for NeigborhoodConfigurations
 *
 * This file is part of the DGtal library.
 */

#if defined(NeighborhoodConfigurationsHelper_RECURSES)
#error Recursive header files inclusion detected in NeighborhoodConfigurationsHelper.h
#else // defined(NeighborhoodConfigurationsHelper_RECURSES)
/** Prevents recursive inclusion of headers. */
#define NeighborhoodConfigurationsHelper_RECURSES

#if !defined NeighborhoodConfigurationsHelper_h
/** Prevents repeated inclusion of headers. */
#define NeighborhoodConfigurationsHelper_h
//////////////////////////////////////////////////////////////////////////////
// Inclusions

namespace DGtal {
  using NeighborhoodConfiguration = uint32_t;
}

#endif // !defined NeighborhoodConfigurationsHelper_h

#undef NeighborhoodConfigurationsHelper_RECURSES
#endif // else defined(NeighborhoodConfigurationsHelper_RECURSES)
