/*
 * Freescale i.MX28 PINCTRL Register Definitions
 *
 * Copyright (C) 2011 Marek Vasut <marek.vasut@gmail.com>
 * on behalf of DENX Software Engineering GmbH
 *
 * Based on code from LTIB:
 * Copyright 2008-2010 Freescale Semiconductor, Inc. All Rights Reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 */

#ifndef __MX28_REGS_PINCTRL_H__
#define __MX28_REGS_PINCTRL_H__

#include <asm/arch/regs-common.h>

#ifndef	__ASSEMBLY__
struct mxs_pinctrl_regs {
	mxs_reg_32(hw_pinctrl_ctrl)		/* 0x0 */

	uint32_t	reserved1[60];

	mxs_reg_32(hw_pinctrl_muxsel0)		/* 0x100 */
	mxs_reg_32(hw_pinctrl_muxsel1)		/* 0x110 */
	mxs_reg_32(hw_pinctrl_muxsel2)		/* 0x120 */
	mxs_reg_32(hw_pinctrl_muxsel3)		/* 0x130 */
	mxs_reg_32(hw_pinctrl_muxsel4)		/* 0x140 */
	mxs_reg_32(hw_pinctrl_muxsel5)		/* 0x150 */
	mxs_reg_32(hw_pinctrl_muxsel6)		/* 0x160 */
	mxs_reg_32(hw_pinctrl_muxsel7)		/* 0x170 */
	mxs_reg_32(hw_pinctrl_muxsel8)		/* 0x180 */
	mxs_reg_32(hw_pinctrl_muxsel9)		/* 0x190 */
	mxs_reg_32(hw_pinctrl_muxsel10)	/* 0x1a0 */
	mxs_reg_32(hw_pinctrl_muxsel11)	/* 0x1b0 */
	mxs_reg_32(hw_pinctrl_muxsel12)	/* 0x1c0 */
	mxs_reg_32(hw_pinctrl_muxsel13)	/* 0x1d0 */

	uint32_t	reserved2[72];

	mxs_reg_32(hw_pinctrl_drive0)		/* 0x300 */
	mxs_reg_32(hw_pinctrl_drive1)		/* 0x310 */
	mxs_reg_32(hw_pinctrl_drive2)		/* 0x320 */
	mxs_reg_32(hw_pinctrl_drive3)		/* 0x330 */
	mxs_reg_32(hw_pinctrl_drive4)		/* 0x340 */
	mxs_reg_32(hw_pinctrl_drive5)		/* 0x350 */
	mxs_reg_32(hw_pinctrl_drive6)		/* 0x360 */
	mxs_reg_32(hw_pinctrl_drive7)		/* 0x370 */
	mxs_reg_32(hw_pinctrl_drive8)		/* 0x380 */
	mxs_reg_32(hw_pinctrl_drive9)		/* 0x390 */
	mxs_reg_32(hw_pinctrl_drive10)		/* 0x3a0 */
	mxs_reg_32(hw_pinctrl_drive11)		/* 0x3b0 */
	mxs_reg_32(hw_pinctrl_drive12)		/* 0x3c0 */
	mxs_reg_32(hw_pinctrl_drive13)		/* 0x3d0 */
	mxs_reg_32(hw_pinctrl_drive14)		/* 0x3e0 */
	mxs_reg_32(hw_pinctrl_drive15)		/* 0x3f0 */
	mxs_reg_32(hw_pinctrl_drive16)		/* 0x400 */
	mxs_reg_32(hw_pinctrl_drive17)		/* 0x410 */
	mxs_reg_32(hw_pinctrl_drive18)		/* 0x420 */
	mxs_reg_32(hw_pinctrl_drive19)		/* 0x430 */

	uint32_t	reserved3[112];

	mxs_reg_32(hw_pinctrl_pull0)		/* 0x600 */
	mxs_reg_32(hw_pinctrl_pull1)		/* 0x610 */
	mxs_reg_32(hw_pinctrl_pull2)		/* 0x620 */
	mxs_reg_32(hw_pinctrl_pull3)		/* 0x630 */
	mxs_reg_32(hw_pinctrl_pull4)		/* 0x640 */
	mxs_reg_32(hw_pinctrl_pull5)		/* 0x650 */
	mxs_reg_32(hw_pinctrl_pull6)		/* 0x660 */

	uint32_t	reserved4[36];

	mxs_reg_32(hw_pinctrl_dout0)		/* 0x700 */
	mxs_reg_32(hw_pinctrl_dout1)		/* 0x710 */
	mxs_reg_32(hw_pinctrl_dout2)		/* 0x720 */
	mxs_reg_32(hw_pinctrl_dout3)		/* 0x730 */
	mxs_reg_32(hw_pinctrl_dout4)		/* 0x740 */

	uint32_t	reserved5[108];

	mxs_reg_32(hw_pinctrl_din0)		/* 0x900 */
	mxs_reg_32(hw_pinctrl_din1)		/* 0x910 */
	mxs_reg_32(hw_pinctrl_din2)		/* 0x920 */
	mxs_reg_32(hw_pinctrl_din3)		/* 0x930 */
	mxs_reg_32(hw_pinctrl_din4)		/* 0x940 */

	uint32_t	reserved6[108];

	mxs_reg_32(hw_pinctrl_doe0)		/* 0xb00 */
	mxs_reg_32(hw_pinctrl_doe1)		/* 0xb10 */
	mxs_reg_32(hw_pinctrl_doe2)		/* 0xb20 */
	mxs_reg_32(hw_pinctrl_doe3)		/* 0xb30 */
	mxs_reg_32(hw_pinctrl_doe4)		/* 0xb40 */

	uint32_t	reserved7[300];

	mxs_reg_32(hw_pinctrl_pin2irq0)	/* 0x1000 */
	mxs_reg_32(hw_pinctrl_pin2irq1)	/* 0x1010 */
	mxs_reg_32(hw_pinctrl_pin2irq2)	/* 0x1020 */
	mxs_reg_32(hw_pinctrl_pin2irq3)	/* 0x1030 */
	mxs_reg_32(hw_pinctrl_pin2irq4)	/* 0x1040 */

	uint32_t	reserved8[44];

	mxs_reg_32(hw_pinctrl_irqen0)		/* 0x1100 */
	mxs_reg_32(hw_pinctrl_irqen1)		/* 0x1110 */
	mxs_reg_32(hw_pinctrl_irqen2)		/* 0x1120 */
	mxs_reg_32(hw_pinctrl_irqen3)		/* 0x1130 */
	mxs_reg_32(hw_pinctrl_irqen4)		/* 0x1140 */

	uint32_t	reserved9[44];

	mxs_reg_32(hw_pinctrl_irqlevel0)	/* 0x1200 */
	mxs_reg_32(hw_pinctrl_irqlevel1)	/* 0x1210 */
	mxs_reg_32(hw_pinctrl_irqlevel2)	/* 0x1220 */
	mxs_reg_32(hw_pinctrl_irqlevel3)	/* 0x1230 */
	mxs_reg_32(hw_pinctrl_irqlevel4)	/* 0x1240 */

	uint32_t	reserved10[44];

	mxs_reg_32(hw_pinctrl_irqpol0)		/* 0x1300 */
	mxs_reg_32(hw_pinctrl_irqpol1)		/* 0x1310 */
	mxs_reg_32(hw_pinctrl_irqpol2)		/* 0x1320 */
	mxs_reg_32(hw_pinctrl_irqpol3)		/* 0x1330 */
	mxs_reg_32(hw_pinctrl_irqpol4)		/* 0x1340 */

	uint32_t	reserved11[44];

	mxs_reg_32(hw_pinctrl_irqstat0)	/* 0x1400 */
	mxs_reg_32(hw_pinctrl_irqstat1)	/* 0x1410 */
	mxs_reg_32(hw_pinctrl_irqstat2)	/* 0x1420 */
	mxs_reg_32(hw_pinctrl_irqstat3)	/* 0x1430 */
	mxs_reg_32(hw_pinctrl_irqstat4)	/* 0x1440 */

	uint32_t	reserved12[380];

	mxs_reg_32(hw_pinctrl_emi_odt_ctrl)	/* 0x1a40 */

	uint32_t	reserved13[76];

	mxs_reg_32(hw_pinctrl_emi_ds_ctrl)	/* 0x1b80 */
};
#endif

#define	PINCTRL_CTRL_SFTRST				(1 << 31)
#define	PINCTRL_CTRL_CLKGATE				(1 << 30)
#define	PINCTRL_CTRL_PRESENT4				(1 << 24)
#define	PINCTRL_CTRL_PRESENT3				(1 << 23)
#define	PINCTRL_CTRL_PRESENT2				(1 << 22)
#define	PINCTRL_CTRL_PRESENT1				(1 << 21)
#define	PINCTRL_CTRL_PRESENT0				(1 << 20)
#define	PINCTRL_CTRL_IRQOUT4				(1 << 4)
#define	PINCTRL_CTRL_IRQOUT3				(1 << 3)
#define	PINCTRL_CTRL_IRQOUT2				(1 << 2)
#define	PINCTRL_CTRL_IRQOUT1				(1 << 1)
#define	PINCTRL_CTRL_IRQOUT0				(1 << 0)

#define	PINCTRL_MUXSEL0_BANK0_PIN07_MASK		(0x3 << 14)
#define	PINCTRL_MUXSEL0_BANK0_PIN07_OFFSET		14
#define	PINCTRL_MUXSEL0_BANK0_PIN06_MASK		(0x3 << 12)
#define	PINCTRL_MUXSEL0_BANK0_PIN06_OFFSET		12
#define	PINCTRL_MUXSEL0_BANK0_PIN05_MASK		(0x3 << 10)
#define	PINCTRL_MUXSEL0_BANK0_PIN05_OFFSET		10
#define	PINCTRL_MUXSEL0_BANK0_PIN04_MASK		(0x3 << 8)
#define	PINCTRL_MUXSEL0_BANK0_PIN04_OFFSET		8
#define	PINCTRL_MUXSEL0_BANK0_PIN03_MASK		(0x3 << 6)
#define	PINCTRL_MUXSEL0_BANK0_PIN03_OFFSET		6
#define	PINCTRL_MUXSEL0_BANK0_PIN02_MASK		(0x3 << 4)
#define	PINCTRL_MUXSEL0_BANK0_PIN02_OFFSET		4
#define	PINCTRL_MUXSEL0_BANK0_PIN01_MASK		(0x3 << 2)
#define	PINCTRL_MUXSEL0_BANK0_PIN01_OFFSET		2
#define	PINCTRL_MUXSEL0_BANK0_PIN00_MASK		(0x3 << 0)
#define	PINCTRL_MUXSEL0_BANK0_PIN00_OFFSET		0

#define	PINCTRL_MUXSEL1_BANK0_PIN28_MASK		(0x3 << 24)
#define	PINCTRL_MUXSEL1_BANK0_PIN28_OFFSET		24
#define	PINCTRL_MUXSEL1_BANK0_PIN27_MASK		(0x3 << 22)
#define	PINCTRL_MUXSEL1_BANK0_PIN27_OFFSET		22
#define	PINCTRL_MUXSEL1_BANK0_PIN26_MASK		(0x3 << 20)
#define	PINCTRL_MUXSEL1_BANK0_PIN26_OFFSET		20
#define	PINCTRL_MUXSEL1_BANK0_PIN25_MASK		(0x3 << 18)
#define	PINCTRL_MUXSEL1_BANK0_PIN25_OFFSET		18
#define	PINCTRL_MUXSEL1_BANK0_PIN24_MASK		(0x3 << 16)
#define	PINCTRL_MUXSEL1_BANK0_PIN24_OFFSET		16
#define	PINCTRL_MUXSEL1_BANK0_PIN23_MASK		(0x3 << 14)
#define	PINCTRL_MUXSEL1_BANK0_PIN23_OFFSET		14
#define	PINCTRL_MUXSEL1_BANK0_PIN22_MASK		(0x3 << 12)
#define	PINCTRL_MUXSEL1_BANK0_PIN22_OFFSET		12
#define	PINCTRL_MUXSEL1_BANK0_PIN21_MASK		(0x3 << 10)
#define	PINCTRL_MUXSEL1_BANK0_PIN21_OFFSET		10
#define	PINCTRL_MUXSEL1_BANK0_PIN20_MASK		(0x3 << 8)
#define	PINCTRL_MUXSEL1_BANK0_PIN20_OFFSET		8
#define	PINCTRL_MUXSEL1_BANK0_PIN19_MASK		(0x3 << 6)
#define	PINCTRL_MUXSEL1_BANK0_PIN19_OFFSET		6
#define	PINCTRL_MUXSEL1_BANK0_PIN18_MASK		(0x3 << 4)
#define	PINCTRL_MUXSEL1_BANK0_PIN18_OFFSET		4
#define	PINCTRL_MUXSEL1_BANK0_PIN17_MASK		(0x3 << 2)
#define	PINCTRL_MUXSEL1_BANK0_PIN17_OFFSET		2
#define	PINCTRL_MUXSEL1_BANK0_PIN16_MASK		(0x3 << 0)
#define	PINCTRL_MUXSEL1_BANK0_PIN16_OFFSET		0

#define	PINCTRL_MUXSEL2_BANK1_PIN15_MASK		(0x3 << 30)
#define	PINCTRL_MUXSEL2_BANK1_PIN15_OFFSET		30
#define	PINCTRL_MUXSEL2_BANK1_PIN14_MASK		(0x3 << 28)
#define	PINCTRL_MUXSEL2_BANK1_PIN14_OFFSET		28
#define	PINCTRL_MUXSEL2_BANK1_PIN13_MASK		(0x3 << 26)
#define	PINCTRL_MUXSEL2_BANK1_PIN13_OFFSET		26
#define	PINCTRL_MUXSEL2_BANK1_PIN12_MASK		(0x3 << 24)
#define	PINCTRL_MUXSEL2_BANK1_PIN12_OFFSET		24
#define	PINCTRL_MUXSEL2_BANK1_PIN11_MASK		(0x3 << 22)
#define	PINCTRL_MUXSEL2_BANK1_PIN11_OFFSET		22
#define	PINCTRL_MUXSEL2_BANK1_PIN10_MASK		(0x3 << 20)
#define	PINCTRL_MUXSEL2_BANK1_PIN10_OFFSET		20
#define	PINCTRL_MUXSEL2_BANK1_PIN09_MASK		(0x3 << 18)
#define	PINCTRL_MUXSEL2_BANK1_PIN09_OFFSET		18
#define	PINCTRL_MUXSEL2_BANK1_PIN08_MASK		(0x3 << 16)
#define	PINCTRL_MUXSEL2_BANK1_PIN08_OFFSET		16
#define	PINCTRL_MUXSEL2_BANK1_PIN07_MASK		(0x3 << 14)
#define	PINCTRL_MUXSEL2_BANK1_PIN07_OFFSET		14
#define	PINCTRL_MUXSEL2_BANK1_PIN06_MASK		(0x3 << 12)
#define	PINCTRL_MUXSEL2_BANK1_PIN06_OFFSET		12
#define	PINCTRL_MUXSEL2_BANK1_PIN05_MASK		(0x3 << 10)
#define	PINCTRL_MUXSEL2_BANK1_PIN05_OFFSET		10
#define	PINCTRL_MUXSEL2_BANK1_PIN04_MASK		(0x3 << 8)
#define	PINCTRL_MUXSEL2_BANK1_PIN04_OFFSET		8
#define	PINCTRL_MUXSEL2_BANK1_PIN03_MASK		(0x3 << 6)
#define	PINCTRL_MUXSEL2_BANK1_PIN03_OFFSET		6
#define	PINCTRL_MUXSEL2_BANK1_PIN02_MASK		(0x3 << 4)
#define	PINCTRL_MUXSEL2_BANK1_PIN02_OFFSET		4
#define	PINCTRL_MUXSEL2_BANK1_PIN01_MASK		(0x3 << 2)
#define	PINCTRL_MUXSEL2_BANK1_PIN01_OFFSET		2
#define	PINCTRL_MUXSEL2_BANK1_PIN00_MASK		(0x3 << 0)
#define	PINCTRL_MUXSEL2_BANK1_PIN00_OFFSET		0

#define	PINCTRL_MUXSEL3_BANK1_PIN31_MASK		(0x3 << 30)
#define	PINCTRL_MUXSEL3_BANK1_PIN31_OFFSET		30
#define	PINCTRL_MUXSEL3_BANK1_PIN30_MASK		(0x3 << 28)
#define	PINCTRL_MUXSEL3_BANK1_PIN30_OFFSET		28
#define	PINCTRL_MUXSEL3_BANK1_PIN29_MASK		(0x3 << 26)
#define	PINCTRL_MUXSEL3_BANK1_PIN29_OFFSET		26
#define	PINCTRL_MUXSEL3_BANK1_PIN28_MASK		(0x3 << 24)
#define	PINCTRL_MUXSEL3_BANK1_PIN28_OFFSET		24
#define	PINCTRL_MUXSEL3_BANK1_PIN27_MASK		(0x3 << 22)
#define	PINCTRL_MUXSEL3_BANK1_PIN27_OFFSET		22
#define	PINCTRL_MUXSEL3_BANK1_PIN26_MASK		(0x3 << 20)
#define	PINCTRL_MUXSEL3_BANK1_PIN26_OFFSET		20
#define	PINCTRL_MUXSEL3_BANK1_PIN25_MASK		(0x3 << 18)
#define	PINCTRL_MUXSEL3_BANK1_PIN25_OFFSET		18
#define	PINCTRL_MUXSEL3_BANK1_PIN24_MASK		(0x3 << 16)
#define	PINCTRL_MUXSEL3_BANK1_PIN24_OFFSET		16
#define	PINCTRL_MUXSEL3_BANK1_PIN23_MASK		(0x3 << 14)
#define	PINCTRL_MUXSEL3_BANK1_PIN23_OFFSET		14
#define	PINCTRL_MUXSEL3_BANK1_PIN22_MASK		(0x3 << 12)
#define	PINCTRL_MUXSEL3_BANK1_PIN22_OFFSET		12
#define	PINCTRL_MUXSEL3_BANK1_PIN21_MASK		(0x3 << 10)
#define	PINCTRL_MUXSEL3_BANK1_PIN21_OFFSET		10
#define	PINCTRL_MUXSEL3_BANK1_PIN20_MASK		(0x3 << 8)
#define	PINCTRL_MUXSEL3_BANK1_PIN20_OFFSET		8
#define	PINCTRL_MUXSEL3_BANK1_PIN19_MASK		(0x3 << 6)
#define	PINCTRL_MUXSEL3_BANK1_PIN19_OFFSET		6
#define	PINCTRL_MUXSEL3_BANK1_PIN18_MASK		(0x3 << 4)
#define	PINCTRL_MUXSEL3_BANK1_PIN18_OFFSET		4
#define	PINCTRL_MUXSEL3_BANK1_PIN17_MASK		(0x3 << 2)
#define	PINCTRL_MUXSEL3_BANK1_PIN17_OFFSET		2
#define	PINCTRL_MUXSEL3_BANK1_PIN16_MASK		(0x3 << 0)
#define	PINCTRL_MUXSEL3_BANK1_PIN16_OFFSET		0

#define	PINCTRL_MUXSEL4_BANK2_PIN15_MASK		(0x3 << 30)
#define	PINCTRL_MUXSEL4_BANK2_PIN15_OFFSET		30
#define	PINCTRL_MUXSEL4_BANK2_PIN14_MASK		(0x3 << 28)
#define	PINCTRL_MUXSEL4_BANK2_PIN14_OFFSET		28
#define	PINCTRL_MUXSEL4_BANK2_PIN13_MASK		(0x3 << 26)
#define	PINCTRL_MUXSEL4_BANK2_PIN13_OFFSET		26
#define	PINCTRL_MUXSEL4_BANK2_PIN12_MASK		(0x3 << 24)
#define	PINCTRL_MUXSEL4_BANK2_PIN12_OFFSET		24
#define	PINCTRL_MUXSEL4_BANK2_PIN10_MASK		(0x3 << 20)
#define	PINCTRL_MUXSEL4_BANK2_PIN10_OFFSET		20
#define	PINCTRL_MUXSEL4_BANK2_PIN09_MASK		(0x3 << 18)
#define	PINCTRL_MUXSEL4_BANK2_PIN09_OFFSET		18
#define	PINCTRL_MUXSEL4_BANK2_PIN08_MASK		(0x3 << 16)
#define	PINCTRL_MUXSEL4_BANK2_PIN08_OFFSET		16
#define	PINCTRL_MUXSEL4_BANK2_PIN07_MASK		(0x3 << 14)
#define	PINCTRL_MUXSEL4_BANK2_PIN07_OFFSET		14
#define	PINCTRL_MUXSEL4_BANK2_PIN06_MASK		(0x3 << 12)
#define	PINCTRL_MUXSEL4_BANK2_PIN06_OFFSET		12
#define	PINCTRL_MUXSEL4_BANK2_PIN05_MASK		(0x3 << 10)
#define	PINCTRL_MUXSEL4_BANK2_PIN05_OFFSET		10
#define	PINCTRL_MUXSEL4_BANK2_PIN04_MASK		(0x3 << 8)
#define	PINCTRL_MUXSEL4_BANK2_PIN04_OFFSET		8
#define	PINCTRL_MUXSEL4_BANK2_PIN03_MASK		(0x3 << 6)
#define	PINCTRL_MUXSEL4_BANK2_PIN03_OFFSET		6
#define	PINCTRL_MUXSEL4_BANK2_PIN02_MASK		(0x3 << 4)
#define	PINCTRL_MUXSEL4_BANK2_PIN02_OFFSET		4
#define	PINCTRL_MUXSEL4_BANK2_PIN01_MASK		(0x3 << 2)
#define	PINCTRL_MUXSEL4_BANK2_PIN01_OFFSET		2
#define	PINCTRL_MUXSEL4_BANK2_PIN00_MASK		(0x3 << 0)
#define	PINCTRL_MUXSEL4_BANK2_PIN00_OFFSET		0

#define	PINCTRL_MUXSEL5_BANK2_PIN27_MASK		(0x3 << 22)
#define	PINCTRL_MUXSEL5_BANK2_PIN27_OFFSET		22
#define	PINCTRL_MUXSEL5_BANK2_PIN26_MASK		(0x3 << 20)
#define	PINCTRL_MUXSEL5_BANK2_PIN26_OFFSET		20
#define	PINCTRL_MUXSEL5_BANK2_PIN25_MASK		(0x3 << 18)
#define	PINCTRL_MUXSEL5_BANK2_PIN25_OFFSET		18
#define	PINCTRL_MUXSEL5_BANK2_PIN24_MASK		(0x3 << 16)
#define	PINCTRL_MUXSEL5_BANK2_PIN24_OFFSET		16
#define	PINCTRL_MUXSEL5_BANK2_PIN21_MASK		(0x3 << 10)
#define	PINCTRL_MUXSEL5_BANK2_PIN21_OFFSET		10
#define	PINCTRL_MUXSEL5_BANK2_PIN20_MASK		(0x3 << 8)
#define	PINCTRL_MUXSEL5_BANK2_PIN20_OFFSET		8
#define	PINCTRL_MUXSEL5_BANK2_PIN19_MASK		(0x3 << 6)
#define	PINCTRL_MUXSEL5_BANK2_PIN19_OFFSET		6
#define	PINCTRL_MUXSEL5_BANK2_PIN18_MASK		(0x3 << 4)
#define	PINCTRL_MUXSEL5_BANK2_PIN18_OFFSET		4
#define	PINCTRL_MUXSEL5_BANK2_PIN17_MASK		(0x3 << 2)
#define	PINCTRL_MUXSEL5_BANK2_PIN17_OFFSET		2
#define	PINCTRL_MUXSEL5_BANK2_PIN16_MASK		(0x3 << 0)
#define	PINCTRL_MUXSEL5_BANK2_PIN16_OFFSET		0

#define	PINCTRL_MUXSEL6_BANK3_PIN15_MASK		(0x3 << 30)
#define	PINCTRL_MUXSEL6_BANK3_PIN15_OFFSET		30
#define	PINCTRL_MUXSEL6_BANK3_PIN14_MASK		(0x3 << 28)
#define	PINCTRL_MUXSEL6_BANK3_PIN14_OFFSET		28
#define	PINCTRL_MUXSEL6_BANK3_PIN13_MASK		(0x3 << 26)
#define	PINCTRL_MUXSEL6_BANK3_PIN13_OFFSET		26
#define	PINCTRL_MUXSEL6_BANK3_PIN12_MASK		(0x3 << 24)
#define	PINCTRL_MUXSEL6_BANK3_PIN12_OFFSET		24
#define	PINCTRL_MUXSEL6_BANK3_PIN11_MASK		(0x3 << 22)
#define	PINCTRL_MUXSEL6_BANK3_PIN11_OFFSET		22
#define	PINCTRL_MUXSEL6_BANK3_PIN10_MASK		(0x3 << 20)
#define	PINCTRL_MUXSEL6_BANK3_PIN10_OFFSET		20
#define	PINCTRL_MUXSEL6_BANK3_PIN09_MASK		(0x3 << 18)
#define	PINCTRL_MUXSEL6_BANK3_PIN09_OFFSET		18
#define	PINCTRL_MUXSEL6_BANK3_PIN08_MASK		(0x3 << 16)
#define	PINCTRL_MUXSEL6_BANK3_PIN08_OFFSET		16
#define	PINCTRL_MUXSEL6_BANK3_PIN07_MASK		(0x3 << 14)
#define	PINCTRL_MUXSEL6_BANK3_PIN07_OFFSET		14
#define	PINCTRL_MUXSEL6_BANK3_PIN06_MASK		(0x3 << 12)
#define	PINCTRL_MUXSEL6_BANK3_PIN06_OFFSET		12
#define	PINCTRL_MUXSEL6_BANK3_PIN05_MASK		(0x3 << 10)
#define	PINCTRL_MUXSEL6_BANK3_PIN05_OFFSET		10
#define	PINCTRL_MUXSEL6_BANK3_PIN04_MASK		(0x3 << 8)
#define	PINCTRL_MUXSEL6_BANK3_PIN04_OFFSET		8
#define	PINCTRL_MUXSEL6_BANK3_PIN03_MASK		(0x3 << 6)
#define	PINCTRL_MUXSEL6_BANK3_PIN03_OFFSET		6
#define	PINCTRL_MUXSEL6_BANK3_PIN02_MASK		(0x3 << 4)
#define	PINCTRL_MUXSEL6_BANK3_PIN02_OFFSET		4
#define	PINCTRL_MUXSEL6_BANK3_PIN01_MASK		(0x3 << 2)
#define	PINCTRL_MUXSEL6_BANK3_PIN01_OFFSET		2
#define	PINCTRL_MUXSEL6_BANK3_PIN00_MASK		(0x3 << 0)
#define	PINCTRL_MUXSEL6_BANK3_PIN00_OFFSET		0

#define	PINCTRL_MUXSEL7_BANK3_PIN30_MASK		(0x3 << 28)
#define	PINCTRL_MUXSEL7_BANK3_PIN30_OFFSET		28
#define	PINCTRL_MUXSEL7_BANK3_PIN29_MASK		(0x3 << 26)
#define	PINCTRL_MUXSEL7_BANK3_PIN29_OFFSET		26
#define	PINCTRL_MUXSEL7_BANK3_PIN28_MASK		(0x3 << 24)
#define	PINCTRL_MUXSEL7_BANK3_PIN28_OFFSET		24
#define	PINCTRL_MUXSEL7_BANK3_PIN27_MASK		(0x3 << 22)
#define	PINCTRL_MUXSEL7_BANK3_PIN27_OFFSET		22
#define	PINCTRL_MUXSEL7_BANK3_PIN26_MASK		(0x3 << 20)
#define	PINCTRL_MUXSEL7_BANK3_PIN26_OFFSET		20
#define	PINCTRL_MUXSEL7_BANK3_PIN25_MASK		(0x3 << 18)
#define	PINCTRL_MUXSEL7_BANK3_PIN25_OFFSET		18
#define	PINCTRL_MUXSEL7_BANK3_PIN24_MASK		(0x3 << 16)
#define	PINCTRL_MUXSEL7_BANK3_PIN24_OFFSET		16
#define	PINCTRL_MUXSEL7_BANK3_PIN23_MASK		(0x3 << 14)
#define	PINCTRL_MUXSEL7_BANK3_PIN23_OFFSET		14
#define	PINCTRL_MUXSEL7_BANK3_PIN22_MASK		(0x3 << 12)
#define	PINCTRL_MUXSEL7_BANK3_PIN22_OFFSET		12
#define	PINCTRL_MUXSEL7_BANK3_PIN21_MASK		(0x3 << 10)
#define	PINCTRL_MUXSEL7_BANK3_PIN21_OFFSET		10
#define	PINCTRL_MUXSEL7_BANK3_PIN20_MASK		(0x3 << 8)
#define	PINCTRL_MUXSEL7_BANK3_PIN20_OFFSET		8
#define	PINCTRL_MUXSEL7_BANK3_PIN18_MASK		(0x3 << 4)
#define	PINCTRL_MUXSEL7_BANK3_PIN18_OFFSET		4
#define	PINCTRL_MUXSEL7_BANK3_PIN17_MASK		(0x3 << 2)
#define	PINCTRL_MUXSEL7_BANK3_PIN17_OFFSET		2
#define	PINCTRL_MUXSEL7_BANK3_PIN16_MASK		(0x3 << 0)
#define	PINCTRL_MUXSEL7_BANK3_PIN16_OFFSET		0

#define	PINCTRL_MUXSEL8_BANK4_PIN15_MASK		(0x3 << 30)
#define	PINCTRL_MUXSEL8_BANK4_PIN15_OFFSET		30
#define	PINCTRL_MUXSEL8_BANK4_PIN14_MASK		(0x3 << 28)
#define	PINCTRL_MUXSEL8_BANK4_PIN14_OFFSET		28
#define	PINCTRL_MUXSEL8_BANK4_PIN13_MASK		(0x3 << 26)
#define	PINCTRL_MUXSEL8_BANK4_PIN13_OFFSET		26
#define	PINCTRL_MUXSEL8_BANK4_PIN12_MASK		(0x3 << 24)
#define	PINCTRL_MUXSEL8_BANK4_PIN12_OFFSET		24
#define	PINCTRL_MUXSEL8_BANK4_PIN11_MASK		(0x3 << 22)
#define	PINCTRL_MUXSEL8_BANK4_PIN11_OFFSET		22
#define	PINCTRL_MUXSEL8_BANK4_PIN10_MASK		(0x3 << 20)
#define	PINCTRL_MUXSEL8_BANK4_PIN10_OFFSET		20
#define	PINCTRL_MUXSEL8_BANK4_PIN09_MASK		(0x3 << 18)
#define	PINCTRL_MUXSEL8_BANK4_PIN09_OFFSET		18
#define	PINCTRL_MUXSEL8_BANK4_PIN08_MASK		(0x3 << 16)
#define	PINCTRL_MUXSEL8_BANK4_PIN08_OFFSET		16
#define	PINCTRL_MUXSEL8_BANK4_PIN07_MASK		(0x3 << 14)
#define	PINCTRL_MUXSEL8_BANK4_PIN07_OFFSET		14
#define	PINCTRL_MUXSEL8_BANK4_PIN06_MASK		(0x3 << 12)
#define	PINCTRL_MUXSEL8_BANK4_PIN06_OFFSET		12
#define	PINCTRL_MUXSEL8_BANK4_PIN05_MASK		(0x3 << 10)
#define	PINCTRL_MUXSEL8_BANK4_PIN05_OFFSET		10
#define	PINCTRL_MUXSEL8_BANK4_PIN04_MASK		(0x3 << 8)
#define	PINCTRL_MUXSEL8_BANK4_PIN04_OFFSET		8
#define	PINCTRL_MUXSEL8_BANK4_PIN03_MASK		(0x3 << 6)
#define	PINCTRL_MUXSEL8_BANK4_PIN03_OFFSET		6
#define	PINCTRL_MUXSEL8_BANK4_PIN02_MASK		(0x3 << 4)
#define	PINCTRL_MUXSEL8_BANK4_PIN02_OFFSET		4
#define	PINCTRL_MUXSEL8_BANK4_PIN01_MASK		(0x3 << 2)
#define	PINCTRL_MUXSEL8_BANK4_PIN01_OFFSET		2
#define	PINCTRL_MUXSEL8_BANK4_PIN00_MASK		(0x3 << 0)
#define	PINCTRL_MUXSEL8_BANK4_PIN00_OFFSET		0

#define	PINCTRL_MUXSEL9_BANK4_PIN20_MASK		(0x3 << 8)
#define	PINCTRL_MUXSEL9_BANK4_PIN20_OFFSET		8
#define	PINCTRL_MUXSEL9_BANK4_PIN16_MASK		(0x3 << 0)
#define	PINCTRL_MUXSEL9_BANK4_PIN16_OFFSET		0

#define	PINCTRL_MUXSEL10_BANK5_PIN15_MASK		(0x3 << 30)
#define	PINCTRL_MUXSEL10_BANK5_PIN15_OFFSET		30
#define	PINCTRL_MUXSEL10_BANK5_PIN14_MASK		(0x3 << 28)
#define	PINCTRL_MUXSEL10_BANK5_PIN14_OFFSET		28
#define	PINCTRL_MUXSEL10_BANK5_PIN13_MASK		(0x3 << 26)
#define	PINCTRL_MUXSEL10_BANK5_PIN13_OFFSET		26
#define	PINCTRL_MUXSEL10_BANK5_PIN12_MASK		(0x3 << 24)
#define	PINCTRL_MUXSEL10_BANK5_PIN12_OFFSET		24
#define	PINCTRL_MUXSEL10_BANK5_PIN11_MASK		(0x3 << 22)
#define	PINCTRL_MUXSEL10_BANK5_PIN11_OFFSET		22
#define	PINCTRL_MUXSEL10_BANK5_PIN10_MASK		(0x3 << 20)
#define	PINCTRL_MUXSEL10_BANK5_PIN10_OFFSET		20
#define	PINCTRL_MUXSEL10_BANK5_PIN09_MASK		(0x3 << 18)
#define	PINCTRL_MUXSEL10_BANK5_PIN09_OFFSET		18
#define	PINCTRL_MUXSEL10_BANK5_PIN08_MASK		(0x3 << 16)
#define	PINCTRL_MUXSEL10_BANK5_PIN08_OFFSET		16
#define	PINCTRL_MUXSEL10_BANK5_PIN07_MASK		(0x3 << 14)
#define	PINCTRL_MUXSEL10_BANK5_PIN07_OFFSET		14
#define	PINCTRL_MUXSEL10_BANK5_PIN06_MASK		(0x3 << 12)
#define	PINCTRL_MUXSEL10_BANK5_PIN06_OFFSET		12
#define	PINCTRL_MUXSEL10_BANK5_PIN05_MASK		(0x3 << 10)
#define	PINCTRL_MUXSEL10_BANK5_PIN05_OFFSET		10
#define	PINCTRL_MUXSEL10_BANK5_PIN04_MASK		(0x3 << 8)
#define	PINCTRL_MUXSEL10_BANK5_PIN04_OFFSET		8
#define	PINCTRL_MUXSEL10_BANK5_PIN03_MASK		(0x3 << 6)
#define	PINCTRL_MUXSEL10_BANK5_PIN03_OFFSET		6
#define	PINCTRL_MUXSEL10_BANK5_PIN02_MASK		(0x3 << 4)
#define	PINCTRL_MUXSEL10_BANK5_PIN02_OFFSET		4
#define	PINCTRL_MUXSEL10_BANK5_PIN01_MASK		(0x3 << 2)
#define	PINCTRL_MUXSEL10_BANK5_PIN01_OFFSET		2
#define	PINCTRL_MUXSEL10_BANK5_PIN00_MASK		(0x3 << 0)
#define	PINCTRL_MUXSEL10_BANK5_PIN00_OFFSET		0

#define	PINCTRL_MUXSEL11_BANK5_PIN26_MASK		(0x3 << 20)
#define	PINCTRL_MUXSEL11_BANK5_PIN26_OFFSET		20
#define	PINCTRL_MUXSEL11_BANK5_PIN23_MASK		(0x3 << 14)
#define	PINCTRL_MUXSEL11_BANK5_PIN23_OFFSET		14
#define	PINCTRL_MUXSEL11_BANK5_PIN22_MASK		(0x3 << 12)
#define	PINCTRL_MUXSEL11_BANK5_PIN22_OFFSET		12
#define	PINCTRL_MUXSEL11_BANK5_PIN21_MASK		(0x3 << 10)
#define	PINCTRL_MUXSEL11_BANK5_PIN21_OFFSET		10
#define	PINCTRL_MUXSEL11_BANK5_PIN20_MASK		(0x3 << 8)
#define	PINCTRL_MUXSEL11_BANK5_PIN20_OFFSET		8
#define	PINCTRL_MUXSEL11_BANK5_PIN19_MASK		(0x3 << 6)
#define	PINCTRL_MUXSEL11_BANK5_PIN19_OFFSET		6
#define	PINCTRL_MUXSEL11_BANK5_PIN18_MASK		(0x3 << 4)
#define	PINCTRL_MUXSEL11_BANK5_PIN18_OFFSET		4
#define	PINCTRL_MUXSEL11_BANK5_PIN17_MASK		(0x3 << 2)
#define	PINCTRL_MUXSEL11_BANK5_PIN17_OFFSET		2
#define	PINCTRL_MUXSEL11_BANK5_PIN16_MASK		(0x3 << 0)
#define	PINCTRL_MUXSEL11_BANK5_PIN16_OFFSET		0

#define	PINCTRL_MUXSEL12_BANK6_PIN14_MASK		(0x3 << 28)
#define	PINCTRL_MUXSEL12_BANK6_PIN14_OFFSET		28
#define	PINCTRL_MUXSEL12_BANK6_PIN13_MASK		(0x3 << 26)
#define	PINCTRL_MUXSEL12_BANK6_PIN13_OFFSET		26
#define	PINCTRL_MUXSEL12_BANK6_PIN12_MASK		(0x3 << 24)
#define	PINCTRL_MUXSEL12_BANK6_PIN12_OFFSET		24
#define	PINCTRL_MUXSEL12_BANK6_PIN11_MASK		(0x3 << 22)
#define	PINCTRL_MUXSEL12_BANK6_PIN11_OFFSET		22
#define	PINCTRL_MUXSEL12_BANK6_PIN10_MASK		(0x3 << 20)
#define	PINCTRL_MUXSEL12_BANK6_PIN10_OFFSET		20
#define	PINCTRL_MUXSEL12_BANK6_PIN09_MASK		(0x3 << 18)
#define	PINCTRL_MUXSEL12_BANK6_PIN09_OFFSET		18
#define	PINCTRL_MUXSEL12_BANK6_PIN08_MASK		(0x3 << 16)
#define	PINCTRL_MUXSEL12_BANK6_PIN08_OFFSET		16
#define	PINCTRL_MUXSEL12_BANK6_PIN07_MASK		(0x3 << 14)
#define	PINCTRL_MUXSEL12_BANK6_PIN07_OFFSET		14
#define	PINCTRL_MUXSEL12_BANK6_PIN06_MASK		(0x3 << 12)
#define	PINCTRL_MUXSEL12_BANK6_PIN06_OFFSET		12
#define	PINCTRL_MUXSEL12_BANK6_PIN05_MASK		(0x3 << 10)
#define	PINCTRL_MUXSEL12_BANK6_PIN05_OFFSET		10
#define	PINCTRL_MUXSEL12_BANK6_PIN04_MASK		(0x3 << 8)
#define	PINCTRL_MUXSEL12_BANK6_PIN04_OFFSET		8
#define	PINCTRL_MUXSEL12_BANK6_PIN03_MASK		(0x3 << 6)
#define	PINCTRL_MUXSEL12_BANK6_PIN03_OFFSET		6
#define	PINCTRL_MUXSEL12_BANK6_PIN02_MASK		(0x3 << 4)
#define	PINCTRL_MUXSEL12_BANK6_PIN02_OFFSET		4
#define	PINCTRL_MUXSEL12_BANK6_PIN01_MASK		(0x3 << 2)
#define	PINCTRL_MUXSEL12_BANK6_PIN01_OFFSET		2
#define	PINCTRL_MUXSEL12_BANK6_PIN00_MASK		(0x3 << 0)
#define	PINCTRL_MUXSEL12_BANK6_PIN00_OFFSET		0

#define	PINCTRL_MUXSEL13_BANK6_PIN24_MASK		(0x3 << 16)
#define	PINCTRL_MUXSEL13_BANK6_PIN24_OFFSET		16
#define	PINCTRL_MUXSEL13_BANK6_PIN23_MASK		(0x3 << 14)
#define	PINCTRL_MUXSEL13_BANK6_PIN23_OFFSET		14
#define	PINCTRL_MUXSEL13_BANK6_PIN22_MASK		(0x3 << 12)
#define	PINCTRL_MUXSEL13_BANK6_PIN22_OFFSET		12
#define	PINCTRL_MUXSEL13_BANK6_PIN21_MASK		(0x3 << 10)
#define	PINCTRL_MUXSEL13_BANK6_PIN21_OFFSET		10
#define	PINCTRL_MUXSEL13_BANK6_PIN20_MASK		(0x3 << 8)
#define	PINCTRL_MUXSEL13_BANK6_PIN20_OFFSET		8
#define	PINCTRL_MUXSEL13_BANK6_PIN19_MASK		(0x3 << 6)
#define	PINCTRL_MUXSEL13_BANK6_PIN19_OFFSET		6
#define	PINCTRL_MUXSEL13_BANK6_PIN18_MASK		(0x3 << 4)
#define	PINCTRL_MUXSEL13_BANK6_PIN18_OFFSET		4
#define	PINCTRL_MUXSEL13_BANK6_PIN17_MASK		(0x3 << 2)
#define	PINCTRL_MUXSEL13_BANK6_PIN17_OFFSET		2
#define	PINCTRL_MUXSEL13_BANK6_PIN16_MASK		(0x3 << 0)
#define	PINCTRL_MUXSEL13_BANK6_PIN16_OFFSET		0

#define	PINCTRL_DRIVE0_BANK0_PIN07_V			(1 << 30)
#define	PINCTRL_DRIVE0_BANK0_PIN07_MA_MASK		(0x3 << 28)
#define	PINCTRL_DRIVE0_BANK0_PIN07_MA_OFFSET		28
#define	PINCTRL_DRIVE0_BANK0_PIN06_V			(1 << 26)
#define	PINCTRL_DRIVE0_BANK0_PIN06_MA_MASK		(0x3 << 24)
#define	PINCTRL_DRIVE0_BANK0_PIN06_MA_OFFSET		24
#define	PINCTRL_DRIVE0_BANK0_PIN05_V			(1 << 22)
#define	PINCTRL_DRIVE0_BANK0_PIN05_MA_MASK		(0x3 << 20)
#define	PINCTRL_DRIVE0_BANK0_PIN05_MA_OFFSET		20
#define	PINCTRL_DRIVE0_BANK0_PIN04_V			(1 << 18)
#define	PINCTRL_DRIVE0_BANK0_PIN04_MA_MASK		(0x3 << 16)
#define	PINCTRL_DRIVE0_BANK0_PIN04_MA_OFFSET		16
#define	PINCTRL_DRIVE0_BANK0_PIN03_V			(1 << 14)
#define	PINCTRL_DRIVE0_BANK0_PIN03_MA_MASK		(0x3 << 12)
#define	PINCTRL_DRIVE0_BANK0_PIN03_MA_OFFSET		12
#define	PINCTRL_DRIVE0_BANK0_PIN02_V			(1 << 10)
#define	PINCTRL_DRIVE0_BANK0_PIN02_MA_MASK		(0x3 << 8)
#define	PINCTRL_DRIVE0_BANK0_PIN02_MA_OFFSET		8
#define	PINCTRL_DRIVE0_BANK0_PIN01_V			(1 << 6)
#define	PINCTRL_DRIVE0_BANK0_PIN01_MA_MASK		(0x3 << 4)
#define	PINCTRL_DRIVE0_BANK0_PIN01_MA_OFFSET		4
#define	PINCTRL_DRIVE0_BANK0_PIN00_V			(1 << 2)
#define	PINCTRL_DRIVE0_BANK0_PIN00_MA_MASK		(0x3 << 0)
#define	PINCTRL_DRIVE0_BANK0_PIN00_MA_OFFSET		0

#define	PINCTRL_DRIVE2_BANK0_PIN23_V			(1 << 30)
#define	PINCTRL_DRIVE2_BANK0_PIN23_MA_MASK		(0x3 << 28)
#define	PINCTRL_DRIVE2_BANK0_PIN23_MA_OFFSET		28
#define	PINCTRL_DRIVE2_BANK0_PIN22_V			(1 << 26)
#define	PINCTRL_DRIVE2_BANK0_PIN22_MA_MASK		(0x3 << 24)
#define	PINCTRL_DRIVE2_BANK0_PIN22_MA_OFFSET		24
#define	PINCTRL_DRIVE2_BANK0_PIN21_V			(1 << 22)
#define	PINCTRL_DRIVE2_BANK0_PIN21_MA_MASK		(0x3 << 20)
#define	PINCTRL_DRIVE2_BANK0_PIN21_MA_OFFSET		20
#define	PINCTRL_DRIVE2_BANK0_PIN20_V			(1 << 18)
#define	PINCTRL_DRIVE2_BANK0_PIN20_MA_MASK		(0x3 << 16)
#define	PINCTRL_DRIVE2_BANK0_PIN20_MA_OFFSET		16
#define	PINCTRL_DRIVE2_BANK0_PIN19_V			(1 << 14)
#define	PINCTRL_DRIVE2_BANK0_PIN19_MA_MASK		(0x3 << 12)
#define	PINCTRL_DRIVE2_BANK0_PIN19_MA_OFFSET		12
#define	PINCTRL_DRIVE2_BANK0_PIN18_V			(1 << 10)
#define	PINCTRL_DRIVE2_BANK0_PIN18_MA_MASK		(0x3 << 8)
#define	PINCTRL_DRIVE2_BANK0_PIN18_MA_OFFSET		8
#define	PINCTRL_DRIVE2_BANK0_PIN17_V			(1 << 6)
#define	PINCTRL_DRIVE2_BANK0_PIN17_MA_MASK		(0x3 << 4)
#define	PINCTRL_DRIVE2_BANK0_PIN17_MA_OFFSET		4
#define	PINCTRL_DRIVE2_BANK0_PIN16_V			(1 << 2)
#define	PINCTRL_DRIVE2_BANK0_PIN16_MA_MASK		(0x3 << 0)
#define	PINCTRL_DRIVE2_BANK0_PIN16_MA_OFFSET		0

#define	PINCTRL_DRIVE3_BANK0_PIN28_V			(1 << 18)
#define	PINCTRL_DRIVE3_BANK0_PIN28_MA_MASK		(0x3 << 16)
#define	PINCTRL_DRIVE3_BANK0_PIN28_MA_OFFSET		16
#define	PINCTRL_DRIVE3_BANK0_PIN27_V			(1 << 14)
#define	PINCTRL_DRIVE3_BANK0_PIN27_MA_MASK		(0x3 << 12)
#define	PINCTRL_DRIVE3_BANK0_PIN27_MA_OFFSET		12
#define	PINCTRL_DRIVE3_BANK0_PIN26_V			(1 << 10)
#define	PINCTRL_DRIVE3_BANK0_PIN26_MA_MASK		(0x3 << 8)
#define	PINCTRL_DRIVE3_BANK0_PIN26_MA_OFFSET		8
#define	PINCTRL_DRIVE3_BANK0_PIN25_V			(1 << 6)
#define	PINCTRL_DRIVE3_BANK0_PIN25_MA_MASK		(0x3 << 4)
#define	PINCTRL_DRIVE3_BANK0_PIN25_MA_OFFSET		4
#define	PINCTRL_DRIVE3_BANK0_PIN24_V			(1 << 2)
#define	PINCTRL_DRIVE3_BANK0_PIN24_MA_MASK		(0x3 << 0)
#define	PINCTRL_DRIVE3_BANK0_PIN24_MA_OFFSET		0

#define	PINCTRL_DRIVE4_BANK1_PIN07_V			(1 << 30)
#define	PINCTRL_DRIVE4_BANK1_PIN07_MA_MASK		(0x3 << 28)
#define	PINCTRL_DRIVE4_BANK1_PIN07_MA_OFFSET		28
#define	PINCTRL_DRIVE4_BANK1_PIN06_V			(1 << 26)
#define	PINCTRL_DRIVE4_BANK1_PIN06_MA_MASK		(0x3 << 24)
#define	PINCTRL_DRIVE4_BANK1_PIN06_MA_OFFSET		24
#define	PINCTRL_DRIVE4_BANK1_PIN05_V			(1 << 22)
#define	PINCTRL_DRIVE4_BANK1_PIN05_MA_MASK		(0x3 << 20)
#define	PINCTRL_DRIVE4_BANK1_PIN05_MA_OFFSET		20
#define	PINCTRL_DRIVE4_BANK1_PIN04_V			(1 << 18)
#define	PINCTRL_DRIVE4_BANK1_PIN04_MA_MASK		(0x3 << 16)
#define	PINCTRL_DRIVE4_BANK1_PIN04_MA_OFFSET		16
#define	PINCTRL_DRIVE4_BANK1_PIN03_V			(1 << 14)
#define	PINCTRL_DRIVE4_BANK1_PIN03_MA_MASK		(0x3 << 12)
#define	PINCTRL_DRIVE4_BANK1_PIN03_MA_OFFSET		12
#define	PINCTRL_DRIVE4_BANK1_PIN02_V			(1 << 10)
#define	PINCTRL_DRIVE4_BANK1_PIN02_MA_MASK		(0x3 << 8)
#define	PINCTRL_DRIVE4_BANK1_PIN02_MA_OFFSET		8
#define	PINCTRL_DRIVE4_BANK1_PIN01_V			(1 << 6)
#define	PINCTRL_DRIVE4_BANK1_PIN01_MA_MASK		(0x3 << 4)
#define	PINCTRL_DRIVE4_BANK1_PIN01_MA_OFFSET		4
#define	PINCTRL_DRIVE4_BANK1_PIN00_V			(1 << 2)
#define	PINCTRL_DRIVE4_BANK1_PIN00_MA_MASK		(0x3 << 0)
#define	PINCTRL_DRIVE4_BANK1_PIN00_MA_OFFSET		0

#define	PINCTRL_DRIVE5_BANK1_PIN15_V			(1 << 30)
#define	PINCTRL_DRIVE5_BANK1_PIN15_MA_MASK		(0x3 << 28)
#define	PINCTRL_DRIVE5_BANK1_PIN15_MA_OFFSET		28
#define	PINCTRL_DRIVE5_BANK1_PIN14_V			(1 << 26)
#define	PINCTRL_DRIVE5_BANK1_PIN14_MA_MASK		(0x3 << 24)
#define	PINCTRL_DRIVE5_BANK1_PIN14_MA_OFFSET		24
#define	PINCTRL_DRIVE5_BANK1_PIN13_V			(1 << 22)
#define	PINCTRL_DRIVE5_BANK1_PIN13_MA_MASK		(0x3 << 20)
#define	PINCTRL_DRIVE5_BANK1_PIN13_MA_OFFSET		20
#define	PINCTRL_DRIVE5_BANK1_PIN12_V			(1 << 18)
#define	PINCTRL_DRIVE5_BANK1_PIN12_MA_MASK		(0x3 << 16)
#define	PINCTRL_DRIVE5_BANK1_PIN12_MA_OFFSET		16
#define	PINCTRL_DRIVE5_BANK1_PIN11_V			(1 << 14)
#define	PINCTRL_DRIVE5_BANK1_PIN11_MA_MASK		(0x3 << 12)
#define	PINCTRL_DRIVE5_BANK1_PIN11_MA_OFFSET		12
#define	PINCTRL_DRIVE5_BANK1_PIN10_V			(1 << 10)
#define	PINCTRL_DRIVE5_BANK1_PIN10_MA_MASK		(0x3 << 8)
#define	PINCTRL_DRIVE5_BANK1_PIN10_MA_OFFSET		8
#define	PINCTRL_DRIVE5_BANK1_PIN09_V			(1 << 6)
#define	PINCTRL_DRIVE5_BANK1_PIN09_MA_MASK		(0x3 << 4)
#define	PINCTRL_DRIVE5_BANK1_PIN09_MA_OFFSET		4
#define	PINCTRL_DRIVE5_BANK1_PIN08_V			(1 << 2)
#define	PINCTRL_DRIVE5_BANK1_PIN08_MA_MASK		(0x3 << 0)
#define	PINCTRL_DRIVE5_BANK1_PIN08_MA_OFFSET		0

#define	PINCTRL_DRIVE6_BANK1_PIN23_V			(1 << 30)
#define	PINCTRL_DRIVE6_BANK1_PIN23_MA_MASK		(0x3 << 28)
#define	PINCTRL_DRIVE6_BANK1_PIN23_MA_OFFSET		28
#define	PINCTRL_DRIVE6_BANK1_PIN22_V			(1 << 26)
#define	PINCTRL_DRIVE6_BANK1_PIN22_MA_MASK		(0x3 << 24)
#define	PINCTRL_DRIVE6_BANK1_PIN22_MA_OFFSET		24
#define	PINCTRL_DRIVE6_BANK1_PIN21_V			(1 << 22)
#define	PINCTRL_DRIVE6_BANK1_PIN21_MA_MASK		(0x3 << 20)
#define	PINCTRL_DRIVE6_BANK1_PIN21_MA_OFFSET		20
#define	PINCTRL_DRIVE6_BANK1_PIN20_V			(1 << 18)
#define	PINCTRL_DRIVE6_BANK1_PIN20_MA_MASK		(0x3 << 16)
#define	PINCTRL_DRIVE6_BANK1_PIN20_MA_OFFSET		16
#define	PINCTRL_DRIVE6_BANK1_PIN19_V			(1 << 14)
#define	PINCTRL_DRIVE6_BANK1_PIN19_MA_MASK		(0x3 << 12)
#define	PINCTRL_DRIVE6_BANK1_PIN19_MA_OFFSET		12
#define	PINCTRL_DRIVE6_BANK1_PIN18_V			(1 << 10)
#define	PINCTRL_DRIVE6_BANK1_PIN18_MA_MASK		(0x3 << 8)
#define	PINCTRL_DRIVE6_BANK1_PIN18_MA_OFFSET		8
#define	PINCTRL_DRIVE6_BANK1_PIN17_V			(1 << 6)
#define	PINCTRL_DRIVE6_BANK1_PIN17_MA_MASK		(0x3 << 4)
#define	PINCTRL_DRIVE6_BANK1_PIN17_MA_OFFSET		4
#define	PINCTRL_DRIVE6_BANK1_PIN16_V			(1 << 2)
#define	PINCTRL_DRIVE6_BANK1_PIN16_MA_MASK		(0x3 << 0)
#define	PINCTRL_DRIVE6_BANK1_PIN16_MA_OFFSET		0

#define	PINCTRL_DRIVE7_BANK1_PIN31_V			(1 << 30)
#define	PINCTRL_DRIVE7_BANK1_PIN31_MA_MASK		(0x3 << 28)
#define	PINCTRL_DRIVE7_BANK1_PIN31_MA_OFFSET		28
#define	PINCTRL_DRIVE7_BANK1_PIN30_V			(1 << 26)
#define	PINCTRL_DRIVE7_BANK1_PIN30_MA_MASK		(0x3 << 24)
#define	PINCTRL_DRIVE7_BANK1_PIN30_MA_OFFSET		24
#define	PINCTRL_DRIVE7_BANK1_PIN29_V			(1 << 22)
#define	PINCTRL_DRIVE7_BANK1_PIN29_MA_MASK		(0x3 << 20)
#define	PINCTRL_DRIVE7_BANK1_PIN29_MA_OFFSET		20
#define	PINCTRL_DRIVE7_BANK1_PIN28_V			(1 << 18)
#define	PINCTRL_DRIVE7_BANK1_PIN28_MA_MASK		(0x3 << 16)
#define	PINCTRL_DRIVE7_BANK1_PIN28_MA_OFFSET		16
#define	PINCTRL_DRIVE7_BANK1_PIN27_V			(1 << 14)
#define	PINCTRL_DRIVE7_BANK1_PIN27_MA_MASK		(0x3 << 12)
#define	PINCTRL_DRIVE7_BANK1_PIN27_MA_OFFSET		12
#define	PINCTRL_DRIVE7_BANK1_PIN26_V			(1 << 10)
#define	PINCTRL_DRIVE7_BANK1_PIN26_MA_MASK		(0x3 << 8)
#define	PINCTRL_DRIVE7_BANK1_PIN26_MA_OFFSET		8
#define	PINCTRL_DRIVE7_BANK1_PIN25_V			(1 << 6)
#define	PINCTRL_DRIVE7_BANK1_PIN25_MA_MASK		(0x3 << 4)
#define	PINCTRL_DRIVE7_BANK1_PIN25_MA_OFFSET		4
#define	PINCTRL_DRIVE7_BANK1_PIN24_V			(1 << 2)
#define	PINCTRL_DRIVE7_BANK1_PIN24_MA_MASK		(0x3 << 0)
#define	PINCTRL_DRIVE7_BANK1_PIN24_MA_OFFSET		0

#define	PINCTRL_DRIVE8_BANK2_PIN07_V			(1 << 30)
#define	PINCTRL_DRIVE8_BANK2_PIN07_MA_MASK		(0x3 << 28)
#define	PINCTRL_DRIVE8_BANK2_PIN07_MA_OFFSET		28
#define	PINCTRL_DRIVE8_BANK2_PIN06_V			(1 << 26)
#define	PINCTRL_DRIVE8_BANK2_PIN06_MA_MASK		(0x3 << 24)
#define	PINCTRL_DRIVE8_BANK2_PIN06_MA_OFFSET		24
#define	PINCTRL_DRIVE8_BANK2_PIN05_V			(1 << 22)
#define	PINCTRL_DRIVE8_BANK2_PIN05_MA_MASK		(0x3 << 20)
#define	PINCTRL_DRIVE8_BANK2_PIN05_MA_OFFSET		20
#define	PINCTRL_DRIVE8_BANK2_PIN04_V			(1 << 18)
#define	PINCTRL_DRIVE8_BANK2_PIN04_MA_MASK		(0x3 << 16)
#define	PINCTRL_DRIVE8_BANK2_PIN04_MA_OFFSET		16
#define	PINCTRL_DRIVE8_BANK2_PIN03_V			(1 << 14)
#define	PINCTRL_DRIVE8_BANK2_PIN03_MA_MASK		(0x3 << 12)
#define	PINCTRL_DRIVE8_BANK2_PIN03_MA_OFFSET		12
#define	PINCTRL_DRIVE8_BANK2_PIN02_V			(1 << 10)
#define	PINCTRL_DRIVE8_BANK2_PIN02_MA_MASK		(0x3 << 8)
#define	PINCTRL_DRIVE8_BANK2_PIN02_MA_OFFSET		8
#define	PINCTRL_DRIVE8_BANK2_PIN01_V			(1 << 6)
#define	PINCTRL_DRIVE8_BANK2_PIN01_MA_MASK		(0x3 << 4)
#define	PINCTRL_DRIVE8_BANK2_PIN01_MA_OFFSET		4
#define	PINCTRL_DRIVE8_BANK2_PIN00_V			(1 << 2)
#define	PINCTRL_DRIVE8_BANK2_PIN00_MA_MASK		(0x3 << 0)
#define	PINCTRL_DRIVE8_BANK2_PIN00_MA_OFFSET		0

#define	PINCTRL_DRIVE9_BANK2_PIN15_V			(1 << 30)
#define	PINCTRL_DRIVE9_BANK2_PIN15_MA_MASK		(0x3 << 28)
#define	PINCTRL_DRIVE9_BANK2_PIN15_MA_OFFSET		28
#define	PINCTRL_DRIVE9_BANK2_PIN14_V			(1 << 26)
#define	PINCTRL_DRIVE9_BANK2_PIN14_MA_MASK		(0x3 << 24)
#define	PINCTRL_DRIVE9_BANK2_PIN14_MA_OFFSET		24
#define	PINCTRL_DRIVE9_BANK2_PIN13_V			(1 << 22)
#define	PINCTRL_DRIVE9_BANK2_PIN13_MA_MASK		(0x3 << 20)
#define	PINCTRL_DRIVE9_BANK2_PIN13_MA_OFFSET		20
#define	PINCTRL_DRIVE9_BANK2_PIN12_V			(1 << 18)
#define	PINCTRL_DRIVE9_BANK2_PIN12_MA_MASK		(0x3 << 16)
#define	PINCTRL_DRIVE9_BANK2_PIN12_MA_OFFSET		16
#define	PINCTRL_DRIVE9_BANK2_PIN10_V			(1 << 10)
#define	PINCTRL_DRIVE9_BANK2_PIN10_MA_MASK		(0x3 << 8)
#define	PINCTRL_DRIVE9_BANK2_PIN10_MA_OFFSET		8
#define	PINCTRL_DRIVE9_BANK2_PIN09_V			(1 << 6)
#define	PINCTRL_DRIVE9_BANK2_PIN09_MA_MASK		(0x3 << 4)
#define	PINCTRL_DRIVE9_BANK2_PIN09_MA_OFFSET		4
#define	PINCTRL_DRIVE9_BANK2_PIN08_V			(1 << 2)
#define	PINCTRL_DRIVE9_BANK2_PIN08_MA_MASK		(0x3 << 0)
#define	PINCTRL_DRIVE9_BANK2_PIN08_MA_OFFSET		0

#define	PINCTRL_DRIVE10_BANK2_PIN21_V			(1 << 22)
#define	PINCTRL_DRIVE10_BANK2_PIN21_MA_MASK		(0x3 << 20)
#define	PINCTRL_DRIVE10_BANK2_PIN21_MA_OFFSET		20
#define	PINCTRL_DRIVE10_BANK2_PIN20_V			(1 << 18)
#define	PINCTRL_DRIVE10_BANK2_PIN20_MA_MASK		(0x3 << 16)
#define	PINCTRL_DRIVE10_BANK2_PIN20_MA_OFFSET		16
#define	PINCTRL_DRIVE10_BANK2_PIN19_V			(1 << 14)
#define	PINCTRL_DRIVE10_BANK2_PIN19_MA_MASK		(0x3 << 12)
#define	PINCTRL_DRIVE10_BANK2_PIN19_MA_OFFSET		12
#define	PINCTRL_DRIVE10_BANK2_PIN18_V			(1 << 10)
#define	PINCTRL_DRIVE10_BANK2_PIN18_MA_MASK		(0x3 << 8)
#define	PINCTRL_DRIVE10_BANK2_PIN18_MA_OFFSET		8
#define	PINCTRL_DRIVE10_BANK2_PIN17_V			(1 << 6)
#define	PINCTRL_DRIVE10_BANK2_PIN17_MA_MASK		(0x3 << 4)
#define	PINCTRL_DRIVE10_BANK2_PIN17_MA_OFFSET		4
#define	PINCTRL_DRIVE10_BANK2_PIN16_V			(1 << 2)
#define	PINCTRL_DRIVE10_BANK2_PIN16_MA_MASK		(0x3 << 0)
#define	PINCTRL_DRIVE10_BANK2_PIN16_MA_OFFSET		0

#define	PINCTRL_DRIVE11_BANK2_PIN27_V			(1 << 14)
#define	PINCTRL_DRIVE11_BANK2_PIN27_MA_MASK		(0x3 << 12)
#define	PINCTRL_DRIVE11_BANK2_PIN27_MA_OFFSET		12
#define	PINCTRL_DRIVE11_BANK2_PIN26_V			(1 << 10)
#define	PINCTRL_DRIVE11_BANK2_PIN26_MA_MASK		(0x3 << 8)
#define	PINCTRL_DRIVE11_BANK2_PIN26_MA_OFFSET		8
#define	PINCTRL_DRIVE11_BANK2_PIN25_V			(1 << 6)
#define	PINCTRL_DRIVE11_BANK2_PIN25_MA_MASK		(0x3 << 4)
#define	PINCTRL_DRIVE11_BANK2_PIN25_MA_OFFSET		4
#define	PINCTRL_DRIVE11_BANK2_PIN24_V			(1 << 2)
#define	PINCTRL_DRIVE11_BANK2_PIN24_MA_MASK		(0x3 << 0)
#define	PINCTRL_DRIVE11_BANK2_PIN24_MA_OFFSET		0

#define	PINCTRL_DRIVE12_BANK3_PIN07_V			(1 << 30)
#define	PINCTRL_DRIVE12_BANK3_PIN07_MA_MASK		(0x3 << 28)
#define	PINCTRL_DRIVE12_BANK3_PIN07_MA_OFFSET		28
#define	PINCTRL_DRIVE12_BANK3_PIN06_V			(1 << 26)
#define	PINCTRL_DRIVE12_BANK3_PIN06_MA_MASK		(0x3 << 24)
#define	PINCTRL_DRIVE12_BANK3_PIN06_MA_OFFSET		24
#define	PINCTRL_DRIVE12_BANK3_PIN05_V			(1 << 22)
#define	PINCTRL_DRIVE12_BANK3_PIN05_MA_MASK		(0x3 << 20)
#define	PINCTRL_DRIVE12_BANK3_PIN05_MA_OFFSET		20
#define	PINCTRL_DRIVE12_BANK3_PIN04_V			(1 << 18)
#define	PINCTRL_DRIVE12_BANK3_PIN04_MA_MASK		(0x3 << 16)
#define	PINCTRL_DRIVE12_BANK3_PIN04_MA_OFFSET		16
#define	PINCTRL_DRIVE12_BANK3_PIN03_V			(1 << 14)
#define	PINCTRL_DRIVE12_BANK3_PIN03_MA_MASK		(0x3 << 12)
#define	PINCTRL_DRIVE12_BANK3_PIN03_MA_OFFSET		12
#define	PINCTRL_DRIVE12_BANK3_PIN02_V			(1 << 10)
#define	PINCTRL_DRIVE12_BANK3_PIN02_MA_MASK		(0x3 << 8)
#define	PINCTRL_DRIVE12_BANK3_PIN02_MA_OFFSET		8
#define	PINCTRL_DRIVE12_BANK3_PIN01_V			(1 << 6)
#define	PINCTRL_DRIVE12_BANK3_PIN01_MA_MASK		(0x3 << 4)
#define	PINCTRL_DRIVE12_BANK3_PIN01_MA_OFFSET		4
#define	PINCTRL_DRIVE12_BANK3_PIN00_V			(1 << 2)
#define	PINCTRL_DRIVE12_BANK3_PIN00_MA_MASK		(0x3 << 0)
#define	PINCTRL_DRIVE12_BANK3_PIN00_MA_OFFSET		0

#define	PINCTRL_DRIVE13_BANK3_PIN15_V			(1 << 30)
#define	PINCTRL_DRIVE13_BANK3_PIN15_MA_MASK		(0x3 << 28)
#define	PINCTRL_DRIVE13_BANK3_PIN15_MA_OFFSET		28
#define	PINCTRL_DRIVE13_BANK3_PIN14_V			(1 << 26)
#define	PINCTRL_DRIVE13_BANK3_PIN14_MA_MASK		(0x3 << 24)
#define	PINCTRL_DRIVE13_BANK3_PIN14_MA_OFFSET		24
#define	PINCTRL_DRIVE13_BANK3_PIN13_V			(1 << 22)
#define	PINCTRL_DRIVE13_BANK3_PIN13_MA_MASK		(0x3 << 20)
#define	PINCTRL_DRIVE13_BANK3_PIN13_MA_OFFSET		20
#define	PINCTRL_DRIVE13_BANK3_PIN12_V			(1 << 18)
#define	PINCTRL_DRIVE13_BANK3_PIN12_MA_MASK		(0x3 << 16)
#define	PINCTRL_DRIVE13_BANK3_PIN12_MA_OFFSET		16
#define	PINCTRL_DRIVE13_BANK3_PIN11_V			(1 << 14)
#define	PINCTRL_DRIVE13_BANK3_PIN11_MA_MASK		(0x3 << 12)
#define	PINCTRL_DRIVE13_BANK3_PIN11_MA_OFFSET		12
#define	PINCTRL_DRIVE13_BANK3_PIN10_V			(1 << 10)
#define	PINCTRL_DRIVE13_BANK3_PIN10_MA_MASK		(0x3 << 8)
#define	PINCTRL_DRIVE13_BANK3_PIN10_MA_OFFSET		8
#define	PINCTRL_DRIVE13_BANK3_PIN09_V			(1 << 6)
#define	PINCTRL_DRIVE13_BANK3_PIN09_MA_MASK		(0x3 << 4)
#define	PINCTRL_DRIVE13_BANK3_PIN09_MA_OFFSET		4
#define	PINCTRL_DRIVE13_BANK3_PIN08_V			(1 << 2)
#define	PINCTRL_DRIVE13_BANK3_PIN08_MA_MASK		(0x3 << 0)
#define	PINCTRL_DRIVE13_BANK3_PIN08_MA_OFFSET		0

#define	PINCTRL_DRIVE14_BANK3_PIN23_V			(1 << 30)
#define	PINCTRL_DRIVE14_BANK3_PIN23_MA_MASK		(0x3 << 28)
#define	PINCTRL_DRIVE14_BANK3_PIN23_MA_OFFSET		28
#define	PINCTRL_DRIVE14_BANK3_PIN22_V			(1 << 26)
#define	PINCTRL_DRIVE14_BANK3_PIN22_MA_MASK		(0x3 << 24)
#define	PINCTRL_DRIVE14_BANK3_PIN22_MA_OFFSET		24
#define	PINCTRL_DRIVE14_BANK3_PIN21_V			(1 << 22)
#define	PINCTRL_DRIVE14_BANK3_PIN21_MA_MASK		(0x3 << 20)
#define	PINCTRL_DRIVE14_BANK3_PIN21_MA_OFFSET		20
#define	PINCTRL_DRIVE14_BANK3_PIN20_V			(1 << 18)
#define	PINCTRL_DRIVE14_BANK3_PIN20_MA_MASK		(0x3 << 16)
#define	PINCTRL_DRIVE14_BANK3_PIN20_MA_OFFSET		16
#define	PINCTRL_DRIVE14_BANK3_PIN18_V			(1 << 10)
#define	PINCTRL_DRIVE14_BANK3_PIN18_MA_MASK		(0x3 << 8)
#define	PINCTRL_DRIVE14_BANK3_PIN18_MA_OFFSET		8
#define	PINCTRL_DRIVE14_BANK3_PIN17_V			(1 << 6)
#define	PINCTRL_DRIVE14_BANK3_PIN17_MA_MASK		(0x3 << 4)
#define	PINCTRL_DRIVE14_BANK3_PIN17_MA_OFFSET		4
#define	PINCTRL_DRIVE14_BANK3_PIN16_V			(1 << 2)
#define	PINCTRL_DRIVE14_BANK3_PIN16_MA_MASK		(0x3 << 0)
#define	PINCTRL_DRIVE14_BANK3_PIN16_MA_OFFSET		0

#define	PINCTRL_DRIVE15_BANK3_PIN30_V			(1 << 26)
#define	PINCTRL_DRIVE15_BANK3_PIN30_MA_MASK		(0x3 << 24)
#define	PINCTRL_DRIVE15_BANK3_PIN30_MA_OFFSET		24
#define	PINCTRL_DRIVE15_BANK3_PIN29_V			(1 << 22)
#define	PINCTRL_DRIVE15_BANK3_PIN29_MA_MASK		(0x3 << 20)
#define	PINCTRL_DRIVE15_BANK3_PIN29_MA_OFFSET		20
#define	PINCTRL_DRIVE15_BANK3_PIN28_V			(1 << 18)
#define	PINCTRL_DRIVE15_BANK3_PIN28_MA_MASK		(0x3 << 16)
#define	PINCTRL_DRIVE15_BANK3_PIN28_MA_OFFSET		16
#define	PINCTRL_DRIVE15_BANK3_PIN27_V			(1 << 14)
#define	PINCTRL_DRIVE15_BANK3_PIN27_MA_MASK		(0x3 << 12)
#define	PINCTRL_DRIVE15_BANK3_PIN27_MA_OFFSET		12
#define	PINCTRL_DRIVE15_BANK3_PIN26_V			(1 << 10)
#define	PINCTRL_DRIVE15_BANK3_PIN26_MA_MASK		(0x3 << 8)
#define	PINCTRL_DRIVE15_BANK3_PIN26_MA_OFFSET		8
#define	PINCTRL_DRIVE15_BANK3_PIN25_V			(1 << 6)
#define	PINCTRL_DRIVE15_BANK3_PIN25_MA_MASK		(0x3 << 4)
#define	PINCTRL_DRIVE15_BANK3_PIN25_MA_OFFSET		4
#define	PINCTRL_DRIVE15_BANK3_PIN24_V			(1 << 2)
#define	PINCTRL_DRIVE15_BANK3_PIN24_MA_MASK		(0x3 << 0)
#define	PINCTRL_DRIVE15_BANK3_PIN24_MA_OFFSET		0

#define	PINCTRL_DRIVE16_BANK4_PIN07_V			(1 << 30)
#define	PINCTRL_DRIVE16_BANK4_PIN07_MA_MASK		(0x3 << 28)
#define	PINCTRL_DRIVE16_BANK4_PIN07_MA_OFFSET		28
#define	PINCTRL_DRIVE16_BANK4_PIN06_V			(1 << 26)
#define	PINCTRL_DRIVE16_BANK4_PIN06_MA_MASK		(0x3 << 24)
#define	PINCTRL_DRIVE16_BANK4_PIN06_MA_OFFSET		24
#define	PINCTRL_DRIVE16_BANK4_PIN05_V			(1 << 22)
#define	PINCTRL_DRIVE16_BANK4_PIN05_MA_MASK		(0x3 << 20)
#define	PINCTRL_DRIVE16_BANK4_PIN05_MA_OFFSET		20
#define	PINCTRL_DRIVE16_BANK4_PIN04_V			(1 << 18)
#define	PINCTRL_DRIVE16_BANK4_PIN04_MA_MASK		(0x3 << 16)
#define	PINCTRL_DRIVE16_BANK4_PIN04_MA_OFFSET		16
#define	PINCTRL_DRIVE16_BANK4_PIN03_V			(1 << 14)
#define	PINCTRL_DRIVE16_BANK4_PIN03_MA_MASK		(0x3 << 12)
#define	PINCTRL_DRIVE16_BANK4_PIN03_MA_OFFSET		12
#define	PINCTRL_DRIVE16_BANK4_PIN02_V			(1 << 10)
#define	PINCTRL_DRIVE16_BANK4_PIN02_MA_MASK		(0x3 << 8)
#define	PINCTRL_DRIVE16_BANK4_PIN02_MA_OFFSET		8
#define	PINCTRL_DRIVE16_BANK4_PIN01_V			(1 << 6)
#define	PINCTRL_DRIVE16_BANK4_PIN01_MA_MASK		(0x3 << 4)
#define	PINCTRL_DRIVE16_BANK4_PIN01_MA_OFFSET		4
#define	PINCTRL_DRIVE16_BANK4_PIN00_V			(1 << 2)
#define	PINCTRL_DRIVE16_BANK4_PIN00_MA_MASK		(0x3 << 0)
#define	PINCTRL_DRIVE16_BANK4_PIN00_MA_OFFSET		0

#define	PINCTRL_DRIVE17_BANK4_PIN15_V			(1 << 30)
#define	PINCTRL_DRIVE17_BANK4_PIN15_MA_MASK		(0x3 << 28)
#define	PINCTRL_DRIVE17_BANK4_PIN15_MA_OFFSET		28
#define	PINCTRL_DRIVE17_BANK4_PIN14_V			(1 << 26)
#define	PINCTRL_DRIVE17_BANK4_PIN14_MA_MASK		(0x3 << 24)
#define	PINCTRL_DRIVE17_BANK4_PIN14_MA_OFFSET		24
#define	PINCTRL_DRIVE17_BANK4_PIN13_V			(1 << 22)
#define	PINCTRL_DRIVE17_BANK4_PIN13_MA_MASK		(0x3 << 20)
#define	PINCTRL_DRIVE17_BANK4_PIN13_MA_OFFSET		20
#define	PINCTRL_DRIVE17_BANK4_PIN12_V			(1 << 18)
#define	PINCTRL_DRIVE17_BANK4_PIN12_MA_MASK		(0x3 << 16)
#define	PINCTRL_DRIVE17_BANK4_PIN12_MA_OFFSET		16
#define	PINCTRL_DRIVE17_BANK4_PIN11_V			(1 << 14)
#define	PINCTRL_DRIVE17_BANK4_PIN11_MA_MASK		(0x3 << 12)
#define	PINCTRL_DRIVE17_BANK4_PIN11_MA_OFFSET		12
#define	PINCTRL_DRIVE17_BANK4_PIN10_V			(1 << 10)
#define	PINCTRL_DRIVE17_BANK4_PIN10_MA_MASK		(0x3 << 8)
#define	PINCTRL_DRIVE17_BANK4_PIN10_MA_OFFSET		8
#define	PINCTRL_DRIVE17_BANK4_PIN09_V			(1 << 6)
#define	PINCTRL_DRIVE17_BANK4_PIN09_MA_MASK		(0x3 << 4)
#define	PINCTRL_DRIVE17_BANK4_PIN09_MA_OFFSET		4
#define	PINCTRL_DRIVE17_BANK4_PIN08_V			(1 << 2)
#define	PINCTRL_DRIVE17_BANK4_PIN08_MA_MASK		(0x3 << 0)
#define	PINCTRL_DRIVE17_BANK4_PIN08_MA_OFFSET		0

#define	PINCTRL_DRIVE18_BANK4_PIN20_V			(1 << 18)
#define	PINCTRL_DRIVE18_BANK4_PIN20_MA_MASK		(0x3 << 16)
#define	PINCTRL_DRIVE18_BANK4_PIN20_MA_OFFSET		16
#define	PINCTRL_DRIVE18_BANK4_PIN16_V			(1 << 2)
#define	PINCTRL_DRIVE18_BANK4_PIN16_MA_MASK		(0x3 << 0)
#define	PINCTRL_DRIVE18_BANK4_PIN16_MA_OFFSET		0

#define	PINCTRL_PULL0_BANK0_PIN28			(1 << 28)
#define	PINCTRL_PULL0_BANK0_PIN27			(1 << 27)
#define	PINCTRL_PULL0_BANK0_PIN26			(1 << 26)
#define	PINCTRL_PULL0_BANK0_PIN25			(1 << 25)
#define	PINCTRL_PULL0_BANK0_PIN24			(1 << 24)
#define	PINCTRL_PULL0_BANK0_PIN23			(1 << 23)
#define	PINCTRL_PULL0_BANK0_PIN22			(1 << 22)
#define	PINCTRL_PULL0_BANK0_PIN21			(1 << 21)
#define	PINCTRL_PULL0_BANK0_PIN20			(1 << 20)
#define	PINCTRL_PULL0_BANK0_PIN19			(1 << 19)
#define	PINCTRL_PULL0_BANK0_PIN18			(1 << 18)
#define	PINCTRL_PULL0_BANK0_PIN17			(1 << 17)
#define	PINCTRL_PULL0_BANK0_PIN16			(1 << 16)
#define	PINCTRL_PULL0_BANK0_PIN07			(1 << 7)
#define	PINCTRL_PULL0_BANK0_PIN06			(1 << 6)
#define	PINCTRL_PULL0_BANK0_PIN05			(1 << 5)
#define	PINCTRL_PULL0_BANK0_PIN04			(1 << 4)
#define	PINCTRL_PULL0_BANK0_PIN03			(1 << 3)
#define	PINCTRL_PULL0_BANK0_PIN02			(1 << 2)
#define	PINCTRL_PULL0_BANK0_PIN01			(1 << 1)
#define	PINCTRL_PULL0_BANK0_PIN00			(1 << 0)

#define	PINCTRL_PULL1_BANK1_PIN31			(1 << 31)
#define	PINCTRL_PULL1_BANK1_PIN30			(1 << 30)
#define	PINCTRL_PULL1_BANK1_PIN29			(1 << 29)
#define	PINCTRL_PULL1_BANK1_PIN28			(1 << 28)
#define	PINCTRL_PULL1_BANK1_PIN27			(1 << 27)
#define	PINCTRL_PULL1_BANK1_PIN26			(1 << 26)
#define	PINCTRL_PULL1_BANK1_PIN25			(1 << 25)
#define	PINCTRL_PULL1_BANK1_PIN24			(1 << 24)
#define	PINCTRL_PULL1_BANK1_PIN23			(1 << 23)
#define	PINCTRL_PULL1_BANK1_PIN22			(1 << 22)
#define	PINCTRL_PULL1_BANK1_PIN21			(1 << 21)
#define	PINCTRL_PULL1_BANK1_PIN20			(1 << 20)
#define	PINCTRL_PULL1_BANK1_PIN19			(1 << 19)
#define	PINCTRL_PULL1_BANK1_PIN18			(1 << 18)
#define	PINCTRL_PULL1_BANK1_PIN17			(1 << 17)
#define	PINCTRL_PULL1_BANK1_PIN16			(1 << 16)
#define	PINCTRL_PULL1_BANK1_PIN15			(1 << 15)
#define	PINCTRL_PULL1_BANK1_PIN14			(1 << 14)
#define	PINCTRL_PULL1_BANK1_PIN13			(1 << 13)
#define	PINCTRL_PULL1_BANK1_PIN12			(1 << 12)
#define	PINCTRL_PULL1_BANK1_PIN11			(1 << 11)
#define	PINCTRL_PULL1_BANK1_PIN10			(1 << 10)
#define	PINCTRL_PULL1_BANK1_PIN09			(1 << 9)
#define	PINCTRL_PULL1_BANK1_PIN08			(1 << 8)
#define	PINCTRL_PULL1_BANK1_PIN07			(1 << 7)
#define	PINCTRL_PULL1_BANK1_PIN06			(1 << 6)
#define	PINCTRL_PULL1_BANK1_PIN05			(1 << 5)
#define	PINCTRL_PULL1_BANK1_PIN04			(1 << 4)
#define	PINCTRL_PULL1_BANK1_PIN03			(1 << 3)
#define	PINCTRL_PULL1_BANK1_PIN02			(1 << 2)
#define	PINCTRL_PULL1_BANK1_PIN01			(1 << 1)
#define	PINCTRL_PULL1_BANK1_PIN00			(1 << 0)

#define	PINCTRL_PULL2_BANK2_PIN27			(1 << 27)
#define	PINCTRL_PULL2_BANK2_PIN26			(1 << 26)
#define	PINCTRL_PULL2_BANK2_PIN25			(1 << 25)
#define	PINCTRL_PULL2_BANK2_PIN24			(1 << 24)
#define	PINCTRL_PULL2_BANK2_PIN21			(1 << 21)
#define	PINCTRL_PULL2_BANK2_PIN20			(1 << 20)
#define	PINCTRL_PULL2_BANK2_PIN19			(1 << 19)
#define	PINCTRL_PULL2_BANK2_PIN18			(1 << 18)
#define	PINCTRL_PULL2_BANK2_PIN17			(1 << 17)
#define	PINCTRL_PULL2_BANK2_PIN16			(1 << 16)
#define	PINCTRL_PULL2_BANK2_PIN15			(1 << 15)
#define	PINCTRL_PULL2_BANK2_PIN14			(1 << 14)
#define	PINCTRL_PULL2_BANK2_PIN13			(1 << 13)
#define	PINCTRL_PULL2_BANK2_PIN12			(1 << 12)
#define	PINCTRL_PULL2_BANK2_PIN10			(1 << 10)
#define	PINCTRL_PULL2_BANK2_PIN09			(1 << 9)
#define	PINCTRL_PULL2_BANK2_PIN08			(1 << 8)
#define	PINCTRL_PULL2_BANK2_PIN07			(1 << 7)
#define	PINCTRL_PULL2_BANK2_PIN06			(1 << 6)
#define	PINCTRL_PULL2_BANK2_PIN05			(1 << 5)
#define	PINCTRL_PULL2_BANK2_PIN04			(1 << 4)
#define	PINCTRL_PULL2_BANK2_PIN03			(1 << 3)
#define	PINCTRL_PULL2_BANK2_PIN02			(1 << 2)
#define	PINCTRL_PULL2_BANK2_PIN01			(1 << 1)
#define	PINCTRL_PULL2_BANK2_PIN00			(1 << 0)

#define	PINCTRL_PULL3_BANK3_PIN30			(1 << 30)
#define	PINCTRL_PULL3_BANK3_PIN29			(1 << 29)
#define	PINCTRL_PULL3_BANK3_PIN28			(1 << 28)
#define	PINCTRL_PULL3_BANK3_PIN27			(1 << 27)
#define	PINCTRL_PULL3_BANK3_PIN26			(1 << 26)
#define	PINCTRL_PULL3_BANK3_PIN25			(1 << 25)
#define	PINCTRL_PULL3_BANK3_PIN24			(1 << 24)
#define	PINCTRL_PULL3_BANK3_PIN23			(1 << 23)
#define	PINCTRL_PULL3_BANK3_PIN22			(1 << 22)
#define	PINCTRL_PULL3_BANK3_PIN21			(1 << 21)
#define	PINCTRL_PULL3_BANK3_PIN20			(1 << 20)
#define	PINCTRL_PULL3_BANK3_PIN18			(1 << 18)
#define	PINCTRL_PULL3_BANK3_PIN17			(1 << 17)
#define	PINCTRL_PULL3_BANK3_PIN16			(1 << 16)
#define	PINCTRL_PULL3_BANK3_PIN15			(1 << 15)
#define	PINCTRL_PULL3_BANK3_PIN14			(1 << 14)
#define	PINCTRL_PULL3_BANK3_PIN13			(1 << 13)
#define	PINCTRL_PULL3_BANK3_PIN12			(1 << 12)
#define	PINCTRL_PULL3_BANK3_PIN11			(1 << 11)
#define	PINCTRL_PULL3_BANK3_PIN10			(1 << 10)
#define	PINCTRL_PULL3_BANK3_PIN09			(1 << 9)
#define	PINCTRL_PULL3_BANK3_PIN08			(1 << 8)
#define	PINCTRL_PULL3_BANK3_PIN07			(1 << 7)
#define	PINCTRL_PULL3_BANK3_PIN06			(1 << 6)
#define	PINCTRL_PULL3_BANK3_PIN05			(1 << 5)
#define	PINCTRL_PULL3_BANK3_PIN04			(1 << 4)
#define	PINCTRL_PULL3_BANK3_PIN03			(1 << 3)
#define	PINCTRL_PULL3_BANK3_PIN02			(1 << 2)
#define	PINCTRL_PULL3_BANK3_PIN01			(1 << 1)
#define	PINCTRL_PULL3_BANK3_PIN00			(1 << 0)

#define	PINCTRL_PULL4_BANK4_PIN20			(1 << 20)
#define	PINCTRL_PULL4_BANK4_PIN16			(1 << 16)
#define	PINCTRL_PULL4_BANK4_PIN15			(1 << 15)
#define	PINCTRL_PULL4_BANK4_PIN14			(1 << 14)
#define	PINCTRL_PULL4_BANK4_PIN13			(1 << 13)
#define	PINCTRL_PULL4_BANK4_PIN12			(1 << 12)
#define	PINCTRL_PULL4_BANK4_PIN11			(1 << 11)
#define	PINCTRL_PULL4_BANK4_PIN10			(1 << 10)
#define	PINCTRL_PULL4_BANK4_PIN09			(1 << 9)
#define	PINCTRL_PULL4_BANK4_PIN08			(1 << 8)
#define	PINCTRL_PULL4_BANK4_PIN07			(1 << 7)
#define	PINCTRL_PULL4_BANK4_PIN06			(1 << 6)
#define	PINCTRL_PULL4_BANK4_PIN05			(1 << 5)
#define	PINCTRL_PULL4_BANK4_PIN04			(1 << 4)
#define	PINCTRL_PULL4_BANK4_PIN03			(1 << 3)
#define	PINCTRL_PULL4_BANK4_PIN02			(1 << 2)
#define	PINCTRL_PULL4_BANK4_PIN01			(1 << 1)
#define	PINCTRL_PULL4_BANK4_PIN00			(1 << 0)

#define	PINCTRL_PULL5_BANK5_PIN26			(1 << 26)
#define	PINCTRL_PULL5_BANK5_PIN23			(1 << 23)
#define	PINCTRL_PULL5_BANK5_PIN22			(1 << 22)
#define	PINCTRL_PULL5_BANK5_PIN21			(1 << 21)
#define	PINCTRL_PULL5_BANK5_PIN20			(1 << 20)
#define	PINCTRL_PULL5_BANK5_PIN19			(1 << 19)
#define	PINCTRL_PULL5_BANK5_PIN18			(1 << 18)
#define	PINCTRL_PULL5_BANK5_PIN17			(1 << 17)
#define	PINCTRL_PULL5_BANK5_PIN16			(1 << 16)
#define	PINCTRL_PULL5_BANK5_PIN15			(1 << 15)
#define	PINCTRL_PULL5_BANK5_PIN14			(1 << 14)
#define	PINCTRL_PULL5_BANK5_PIN13			(1 << 13)
#define	PINCTRL_PULL5_BANK5_PIN12			(1 << 12)
#define	PINCTRL_PULL5_BANK5_PIN11			(1 << 11)
#define	PINCTRL_PULL5_BANK5_PIN10			(1 << 10)
#define	PINCTRL_PULL5_BANK5_PIN09			(1 << 9)
#define	PINCTRL_PULL5_BANK5_PIN08			(1 << 8)
#define	PINCTRL_PULL5_BANK5_PIN07			(1 << 7)
#define	PINCTRL_PULL5_BANK5_PIN06			(1 << 6)
#define	PINCTRL_PULL5_BANK5_PIN05			(1 << 5)
#define	PINCTRL_PULL5_BANK5_PIN04			(1 << 4)
#define	PINCTRL_PULL5_BANK5_PIN03			(1 << 3)
#define	PINCTRL_PULL5_BANK5_PIN02			(1 << 2)
#define	PINCTRL_PULL5_BANK5_PIN01			(1 << 1)
#define	PINCTRL_PULL5_BANK5_PIN00			(1 << 0)

#define	PINCTRL_PULL6_BANK6_PIN24			(1 << 24)
#define	PINCTRL_PULL6_BANK6_PIN23			(1 << 23)
#define	PINCTRL_PULL6_BANK6_PIN22			(1 << 22)
#define	PINCTRL_PULL6_BANK6_PIN21			(1 << 21)
#define	PINCTRL_PULL6_BANK6_PIN20			(1 << 20)
#define	PINCTRL_PULL6_BANK6_PIN19			(1 << 19)
#define	PINCTRL_PULL6_BANK6_PIN18			(1 << 18)
#define	PINCTRL_PULL6_BANK6_PIN17			(1 << 17)
#define	PINCTRL_PULL6_BANK6_PIN16			(1 << 16)
#define	PINCTRL_PULL6_BANK6_PIN14			(1 << 14)
#define	PINCTRL_PULL6_BANK6_PIN13			(1 << 13)
#define	PINCTRL_PULL6_BANK6_PIN12			(1 << 12)
#define	PINCTRL_PULL6_BANK6_PIN11			(1 << 11)
#define	PINCTRL_PULL6_BANK6_PIN10			(1 << 10)
#define	PINCTRL_PULL6_BANK6_PIN09			(1 << 9)
#define	PINCTRL_PULL6_BANK6_PIN08			(1 << 8)
#define	PINCTRL_PULL6_BANK6_PIN07			(1 << 7)
#define	PINCTRL_PULL6_BANK6_PIN06			(1 << 6)
#define	PINCTRL_PULL6_BANK6_PIN05			(1 << 5)
#define	PINCTRL_PULL6_BANK6_PIN04			(1 << 4)
#define	PINCTRL_PULL6_BANK6_PIN03			(1 << 3)
#define	PINCTRL_PULL6_BANK6_PIN02			(1 << 2)
#define	PINCTRL_PULL6_BANK6_PIN01			(1 << 1)
#define	PINCTRL_PULL6_BANK6_PIN00			(1 << 0)

#define	PINCTRL_DOUT0_DOUT_MASK				0x1fffffff
#define	PINCTRL_DOUT0_DOUT_OFFSET			0

#define	PINCTRL_DOUT1_DOUT_MASK				0xffffffff
#define	PINCTRL_DOUT1_DOUT_OFFSET			0

#define	PINCTRL_DOUT2_DOUT_MASK				0xfffffff
#define	PINCTRL_DOUT2_DOUT_OFFSET			0

#define	PINCTRL_DOUT3_DOUT_MASK				0x7fffffff
#define	PINCTRL_DOUT3_DOUT_OFFSET			0

#define	PINCTRL_DOUT4_DOUT_MASK				0x1fffff
#define	PINCTRL_DOUT4_DOUT_OFFSET			0

#define	PINCTRL_DIN0_DIN_MASK				0x1fffffff
#define	PINCTRL_DIN0_DIN_OFFSET				0

#define	PINCTRL_DIN1_DIN_MASK				0xffffffff
#define	PINCTRL_DIN1_DIN_OFFSET				0

#define	PINCTRL_DIN2_DIN_MASK				0xfffffff
#define	PINCTRL_DIN2_DIN_OFFSET				0

#define	PINCTRL_DIN3_DIN_MASK				0x7fffffff
#define	PINCTRL_DIN3_DIN_OFFSET				0

#define	PINCTRL_DIN4_DIN_MASK				0x1fffff
#define	PINCTRL_DIN4_DIN_OFFSET				0

#define	PINCTRL_DOE0_DOE_MASK				0x1fffffff
#define	PINCTRL_DOE0_DOE_OFFSET				0

#define	PINCTRL_DOE1_DOE_MASK				0xffffffff
#define	PINCTRL_DOE1_DOE_OFFSET				0

#define	PINCTRL_DOE2_DOE_MASK				0xfffffff
#define	PINCTRL_DOE2_DOE_OFFSET				0

#define	PINCTRL_DOE3_DOE_MASK				0x7fffffff
#define	PINCTRL_DOE3_DOE_OFFSET				0

#define	PINCTRL_DOE4_DOE_MASK				0x1fffff
#define	PINCTRL_DOE4_DOE_OFFSET				0

#define	PINCTRL_PIN2IRQ0_PIN2IRQ_MASK			0x1fffffff
#define	PINCTRL_PIN2IRQ0_PIN2IRQ_OFFSET			0

#define	PINCTRL_PIN2IRQ1_PIN2IRQ_MASK			0xffffffff
#define	PINCTRL_PIN2IRQ1_PIN2IRQ_OFFSET			0

#define	PINCTRL_PIN2IRQ2_PIN2IRQ_MASK			0xfffffff
#define	PINCTRL_PIN2IRQ2_PIN2IRQ_OFFSET			0

#define	PINCTRL_PIN2IRQ3_PIN2IRQ_MASK			0x7fffffff
#define	PINCTRL_PIN2IRQ3_PIN2IRQ_OFFSET			0

#define	PINCTRL_PIN2IRQ4_PIN2IRQ_MASK			0x1fffff
#define	PINCTRL_PIN2IRQ4_PIN2IRQ_OFFSET			0

#define	PINCTRL_IRQEN0_IRQEN_MASK			0x1fffffff
#define	PINCTRL_IRQEN0_IRQEN_OFFSET			0

#define	PINCTRL_IRQEN1_IRQEN_MASK			0xffffffff
#define	PINCTRL_IRQEN1_IRQEN_OFFSET			0

#define	PINCTRL_IRQEN2_IRQEN_MASK			0xfffffff
#define	PINCTRL_IRQEN2_IRQEN_OFFSET			0

#define	PINCTRL_IRQEN3_IRQEN_MASK			0x7fffffff
#define	PINCTRL_IRQEN3_IRQEN_OFFSET			0

#define	PINCTRL_IRQEN4_IRQEN_MASK			0x1fffff
#define	PINCTRL_IRQEN4_IRQEN_OFFSET			0

#define	PINCTRL_IRQLEVEL0_IRQLEVEL_MASK			0x1fffffff
#define	PINCTRL_IRQLEVEL0_IRQLEVEL_OFFSET		0

#define	PINCTRL_IRQLEVEL1_IRQLEVEL_MASK			0xffffffff
#define	PINCTRL_IRQLEVEL1_IRQLEVEL_OFFSET		0

#define	PINCTRL_IRQLEVEL2_IRQLEVEL_MASK			0xfffffff
#define	PINCTRL_IRQLEVEL2_IRQLEVEL_OFFSET		0

#define	PINCTRL_IRQLEVEL3_IRQLEVEL_MASK			0x7fffffff
#define	PINCTRL_IRQLEVEL3_IRQLEVEL_OFFSET		0

#define	PINCTRL_IRQLEVEL4_IRQLEVEL_MASK			0x1fffff
#define	PINCTRL_IRQLEVEL4_IRQLEVEL_OFFSET		0

#define	PINCTRL_IRQPOL0_IRQPOL_MASK			0x1fffffff
#define	PINCTRL_IRQPOL0_IRQPOL_OFFSET			0

#define	PINCTRL_IRQPOL1_IRQPOL_MASK			0xffffffff
#define	PINCTRL_IRQPOL1_IRQPOL_OFFSET			0

#define	PINCTRL_IRQPOL2_IRQPOL_MASK			0xfffffff
#define	PINCTRL_IRQPOL2_IRQPOL_OFFSET			0

#define	PINCTRL_IRQPOL3_IRQPOL_MASK			0x7fffffff
#define	PINCTRL_IRQPOL3_IRQPOL_OFFSET			0

#define	PINCTRL_IRQPOL4_IRQPOL_MASK			0x1fffff
#define	PINCTRL_IRQPOL4_IRQPOL_OFFSET			0

#define	PINCTRL_IRQSTAT0_IRQSTAT_MASK			0x1fffffff
#define	PINCTRL_IRQSTAT0_IRQSTAT_OFFSET			0

#define	PINCTRL_IRQSTAT1_IRQSTAT_MASK			0xffffffff
#define	PINCTRL_IRQSTAT1_IRQSTAT_OFFSET			0

#define	PINCTRL_IRQSTAT2_IRQSTAT_MASK			0xfffffff
#define	PINCTRL_IRQSTAT2_IRQSTAT_OFFSET			0

#define	PINCTRL_IRQSTAT3_IRQSTAT_MASK			0x7fffffff
#define	PINCTRL_IRQSTAT3_IRQSTAT_OFFSET			0

#define	PINCTRL_IRQSTAT4_IRQSTAT_MASK			0x1fffff
#define	PINCTRL_IRQSTAT4_IRQSTAT_OFFSET			0

#define	PINCTRL_EMI_ODT_CTRL_ADDRESS_CALIB_MASK		(0x3 << 26)
#define	PINCTRL_EMI_ODT_CTRL_ADDRESS_CALIB_OFFSET	26
#define	PINCTRL_EMI_ODT_CTRL_ADDRESS_TLOAD_MASK		(0x3 << 24)
#define	PINCTRL_EMI_ODT_CTRL_ADDRESS_TLOAD_OFFSET	24
#define	PINCTRL_EMI_ODT_CTRL_CONTROL_CALIB_MASK		(0x3 << 22)
#define	PINCTRL_EMI_ODT_CTRL_CONTROL_CALIB_OFFSET	22
#define	PINCTRL_EMI_ODT_CTRL_CONTROL_TLOAD_MASK		(0x3 << 20)
#define	PINCTRL_EMI_ODT_CTRL_CONTROL_TLOAD_OFFSET	20
#define	PINCTRL_EMI_ODT_CTRL_DUALPAD_CALIB_MASK		(0x3 << 18)
#define	PINCTRL_EMI_ODT_CTRL_DUALPAD_CALIB_OFFSET	18
#define	PINCTRL_EMI_ODT_CTRL_DUALPAD_TLOAD_MASK		(0x3 << 16)
#define	PINCTRL_EMI_ODT_CTRL_DUALPAD_TLOAD_OFFSET	16
#define	PINCTRL_EMI_ODT_CTRL_SLICE3_CALIB_MASK		(0x3 << 14)
#define	PINCTRL_EMI_ODT_CTRL_SLICE3_CALIB_OFFSET	14
#define	PINCTRL_EMI_ODT_CTRL_SLICE3_TLOAD_MASK		(0x3 << 12)
#define	PINCTRL_EMI_ODT_CTRL_SLICE3_TLOAD_OFFSET	12
#define	PINCTRL_EMI_ODT_CTRL_SLICE2_CALIB_MASK		(0x3 << 10)
#define	PINCTRL_EMI_ODT_CTRL_SLICE2_CALIB_OFFSET	10
#define	PINCTRL_EMI_ODT_CTRL_SLICE2_TLOAD_MASK		(0x3 << 8)
#define	PINCTRL_EMI_ODT_CTRL_SLICE2_TLOAD_OFFSET	8
#define	PINCTRL_EMI_ODT_CTRL_SLICE1_CALIB_MASK		(0x3 << 6)
#define	PINCTRL_EMI_ODT_CTRL_SLICE1_CALIB_OFFSET	6
#define	PINCTRL_EMI_ODT_CTRL_SLICE1_TLOAD_MASK		(0x3 << 4)
#define	PINCTRL_EMI_ODT_CTRL_SLICE1_TLOAD_OFFSET	4
#define	PINCTRL_EMI_ODT_CTRL_SLICE0_CALIB_MASK		(0x3 << 2)
#define	PINCTRL_EMI_ODT_CTRL_SLICE0_CALIB_OFFSET	2
#define	PINCTRL_EMI_ODT_CTRL_SLICE0_TLOAD_MASK		(0x3 << 0)
#define	PINCTRL_EMI_ODT_CTRL_SLICE0_TLOAD_OFFSET	0

#define	PINCTRL_EMI_DS_CTRL_DDR_MODE_MASK		(0x3 << 16)
#define	PINCTRL_EMI_DS_CTRL_DDR_MODE_OFFSET		16
#define	PINCTRL_EMI_DS_CTRL_DDR_MODE_mDDR		(0x0 << 16)
#define	PINCTRL_EMI_DS_CTRL_DDR_MODE_GPIO		(0x1 << 16)
#define	PINCTRL_EMI_DS_CTRL_DDR_MODE_LVDDR2		(0x2 << 16)
#define	PINCTRL_EMI_DS_CTRL_DDR_MODE_DDR2		(0x3 << 16)
#define	PINCTRL_EMI_DS_CTRL_ADDRESS_MA_MASK		(0x3 << 12)
#define	PINCTRL_EMI_DS_CTRL_ADDRESS_MA_OFFSET		12
#define	PINCTRL_EMI_DS_CTRL_CONTROL_MA_MASK		(0x3 << 10)
#define	PINCTRL_EMI_DS_CTRL_CONTROL_MA_OFFSET		10
#define	PINCTRL_EMI_DS_CTRL_DUALPAD_MA_MASK		(0x3 << 8)
#define	PINCTRL_EMI_DS_CTRL_DUALPAD_MA_OFFSET		8
#define	PINCTRL_EMI_DS_CTRL_SLICE3_MA_MASK		(0x3 << 6)
#define	PINCTRL_EMI_DS_CTRL_SLICE3_MA_OFFSET		6
#define	PINCTRL_EMI_DS_CTRL_SLICE2_MA_MASK		(0x3 << 4)
#define	PINCTRL_EMI_DS_CTRL_SLICE2_MA_OFFSET		4
#define	PINCTRL_EMI_DS_CTRL_SLICE1_MA_MASK		(0x3 << 2)
#define	PINCTRL_EMI_DS_CTRL_SLICE1_MA_OFFSET		2
#define	PINCTRL_EMI_DS_CTRL_SLICE0_MA_MASK		(0x3 << 0)
#define	PINCTRL_EMI_DS_CTRL_SLICE0_MA_OFFSET		0

#endif /* __MX28_REGS_PINCTRL_H__ */
