#include <assert.h>
#include <math.h>

#include "tdist.h"

static void df_to_index(float df, int *index1_p, float *weight1_p);
static float get_t(int p_index, int df_index1, float df_weight1);
static float index_to_p(int index);
static float linear(float x, float x1, float y1, float x2, float y2);

/*
 * apologies to those hoping to find an implementation of the student's t
 * cumulative probability distribution here, as this is only a look-up table
 * with linear interpolation.
 */
float student_t_p_2tail(float t, float df) {
	int df_index1, p_index_min, p_index_mid, p_index_max;
	float df_weight1, t_max, t_mid, t_min;

	/* first test for extreme cases */
	p_index_min = 0;
	p_index_max = 189;
	df_to_index(df, &df_index1, &df_weight1);
	if (t < 0) t = -t;
	if (t > get_t(p_index_min, df_index1, df_weight1)) return 0.000;
	if (t < get_t(p_index_max, df_index1, df_weight1)) return 1.000;

	/* binary search in inverse table */
	while (p_index_max - p_index_min > 1) {
		p_index_mid = (p_index_min + p_index_max) / 2;
		t_mid = get_t(p_index_mid, df_index1, df_weight1);
		if (t_mid >= t) p_index_min = p_index_mid;
		if (t_mid <= t) p_index_max = p_index_mid;
	}

	/* linear interpolation to get p */
	t_max = get_t(p_index_min, df_index1, df_weight1);
	t_min = get_t(p_index_max, df_index1, df_weight1);
	assert(t >= t_min);
	assert(t <= t_max);
	return linear(t, t_max, index_to_p(p_index_min),
		t_min, index_to_p(p_index_max));
}

static float t_value_by_p_and_df[190][46] = {
/*      p \ df        1       2       3       4      5      6      7      8      9     10     11     12     13     14     15     16     17     18     19     20     21     22     23     24     25     26     27     28     29     30     40     50     60     70     80     90    100    200    300    400    500    600    700    800    900   1000 */
/* 0.0005 */ { 1273.239, 44.705, 16.326, 10.306, 7.976, 6.788, 6.082, 5.617, 5.291, 5.049, 4.863, 4.716, 4.597, 4.499, 4.417, 4.346, 4.286, 4.233, 4.187, 4.146, 4.110, 4.077, 4.047, 4.021, 3.996, 3.974, 3.954, 3.935, 3.918, 3.902, 3.788, 3.723, 3.681, 3.651, 3.629, 3.612, 3.598, 3.539, 3.519, 3.510, 3.504, 3.500, 3.497, 3.495, 3.493, 3.492 },
/* 0.0015 */ {  424.412, 25.791, 11.265,  7.741, 6.284, 5.511, 5.038, 4.721, 4.495, 4.326, 4.194, 4.090, 4.004, 3.933, 3.874, 3.822, 3.778, 3.740, 3.706, 3.676, 3.649, 3.625, 3.603, 3.583, 3.565, 3.548, 3.533, 3.519, 3.506, 3.494, 3.409, 3.360, 3.328, 3.305, 3.288, 3.275, 3.265, 3.219, 3.204, 3.197, 3.192, 3.189, 3.187, 3.186, 3.184, 3.183 },
/* 0.0025 */ {  254.647, 19.962,  9.465,  6.758, 5.604, 4.981, 4.595, 4.334, 4.146, 4.005, 3.895, 3.807, 3.735, 3.675, 3.624, 3.581, 3.543, 3.510, 3.481, 3.455, 3.432, 3.412, 3.393, 3.376, 3.361, 3.346, 3.333, 3.321, 3.310, 3.300, 3.227, 3.184, 3.156, 3.137, 3.122, 3.111, 3.102, 3.062, 3.049, 3.043, 3.039, 3.036, 3.034, 3.033, 3.032, 3.031 },
/* 0.0035 */ {  181.890, 16.859,  8.432,  6.172, 5.189, 4.651, 4.315, 4.087, 3.922, 3.798, 3.700, 3.622, 3.558, 3.505, 3.460, 3.421, 3.388, 3.358, 3.332, 3.309, 3.289, 3.270, 3.254, 3.238, 3.224, 3.212, 3.200, 3.189, 3.179, 3.170, 3.104, 3.065, 3.040, 3.023, 3.009, 2.999, 2.991, 2.955, 2.943, 2.938, 2.934, 2.932, 2.930, 2.929, 2.928, 2.927 },
/* 0.0045 */ {  141.469, 14.857,  7.731,  5.762, 4.893, 4.414, 4.113, 3.907, 3.758, 3.645, 3.557, 3.486, 3.427, 3.379, 3.337, 3.302, 3.271, 3.244, 3.221, 3.200, 3.181, 3.164, 3.148, 3.134, 3.122, 3.110, 3.099, 3.089, 3.080, 3.071, 3.011, 2.975, 2.952, 2.936, 2.923, 2.914, 2.907, 2.873, 2.862, 2.857, 2.854, 2.852, 2.850, 2.849, 2.848, 2.847 },
/* 0.0055 */ {  115.746, 13.428,  7.210,  5.452, 4.666, 4.230, 3.955, 3.766, 3.628, 3.524, 3.443, 3.377, 3.323, 3.278, 3.240, 3.207, 3.178, 3.153, 3.131, 3.111, 3.094, 3.078, 3.064, 3.051, 3.039, 3.028, 3.018, 3.009, 3.000, 2.992, 2.935, 2.902, 2.880, 2.865, 2.854, 2.845, 2.838, 2.807, 2.796, 2.791, 2.788, 2.786, 2.785, 2.784, 2.783, 2.782 },
/* 0.0065 */ {   97.938, 12.343,  6.801,  5.204, 4.483, 4.080, 3.825, 3.649, 3.522, 3.424, 3.348, 3.287, 3.236, 3.194, 3.158, 3.127, 3.100, 3.077, 3.056, 3.038, 3.021, 3.006, 2.993, 2.980, 2.969, 2.959, 2.950, 2.941, 2.933, 2.925, 2.872, 2.840, 2.820, 2.805, 2.795, 2.786, 2.780, 2.750, 2.741, 2.736, 2.733, 2.731, 2.730, 2.729, 2.728, 2.727 },
/* 0.0075 */ {   84.879, 11.482,  6.468,  4.998, 4.330, 3.954, 3.716, 3.551, 3.431, 3.339, 3.267, 3.209, 3.162, 3.122, 3.088, 3.059, 3.033, 3.011, 2.992, 2.974, 2.958, 2.944, 2.932, 2.920, 2.909, 2.900, 2.891, 2.882, 2.875, 2.867, 2.817, 2.787, 2.768, 2.754, 2.744, 2.736, 2.729, 2.701, 2.692, 2.687, 2.685, 2.683, 2.682, 2.681, 2.680, 2.679 },
/* 0.0085 */ {   74.892, 10.777,  6.188,  4.824, 4.199, 3.846, 3.621, 3.465, 3.352, 3.265, 3.197, 3.142, 3.097, 3.059, 3.027, 2.999, 2.975, 2.954, 2.935, 2.918, 2.903, 2.890, 2.878, 2.867, 2.857, 2.847, 2.839, 2.831, 2.823, 2.817, 2.768, 2.740, 2.721, 2.708, 2.698, 2.691, 2.685, 2.658, 2.649, 2.645, 2.642, 2.640, 2.639, 2.638, 2.637, 2.637 },
/* 0.0095 */ {   67.008, 10.187,  5.949,  4.673, 4.084, 3.751, 3.538, 3.390, 3.282, 3.199, 3.135, 3.082, 3.039, 3.003, 2.972, 2.945, 2.922, 2.902, 2.884, 2.868, 2.854, 2.841, 2.830, 2.819, 2.809, 2.800, 2.792, 2.785, 2.778, 2.771, 2.725, 2.697, 2.680, 2.667, 2.658, 2.650, 2.645, 2.619, 2.610, 2.606, 2.604, 2.602, 2.601, 2.600, 2.599, 2.599 },
/* 0.0105 */ {   60.625,  9.682,  5.740,  4.540, 3.983, 3.666, 3.463, 3.323, 3.219, 3.141, 3.078, 3.028, 2.987, 2.952, 2.923, 2.897, 2.875, 2.856, 2.839, 2.823, 2.810, 2.797, 2.786, 2.776, 2.767, 2.758, 2.750, 2.743, 2.736, 2.730, 2.685, 2.659, 2.642, 2.630, 2.621, 2.614, 2.608, 2.583, 2.575, 2.571, 2.569, 2.567, 2.566, 2.565, 2.564, 2.564 },
/* 0.0115 */ {   55.352,  9.244,  5.556,  4.421, 3.892, 3.590, 3.396, 3.262, 3.163, 3.087, 3.028, 2.979, 2.940, 2.906, 2.878, 2.853, 2.832, 2.813, 2.797, 2.782, 2.769, 2.757, 2.746, 2.737, 2.728, 2.719, 2.712, 2.705, 2.698, 2.692, 2.649, 2.624, 2.607, 2.595, 2.587, 2.580, 2.575, 2.551, 2.543, 2.539, 2.536, 2.535, 2.534, 2.533, 2.532, 2.532 },
/* 0.0125 */ {   50.923,  8.860,  5.392,  4.315, 3.810, 3.521, 3.335, 3.206, 3.111, 3.038, 2.981, 2.934, 2.896, 2.864, 2.837, 2.813, 2.793, 2.775, 2.759, 2.744, 2.732, 2.720, 2.710, 2.700, 2.692, 2.684, 2.676, 2.669, 2.663, 2.657, 2.616, 2.591, 2.575, 2.564, 2.555, 2.549, 2.544, 2.520, 2.513, 2.509, 2.507, 2.505, 2.504, 2.503, 2.503, 2.502 },
/* 0.0135 */ {   47.150,  8.519,  5.244,  4.218, 3.735, 3.458, 3.279, 3.155, 3.063, 2.993, 2.938, 2.893, 2.856, 2.825, 2.799, 2.776, 2.756, 2.738, 2.723, 2.709, 2.697, 2.686, 2.676, 2.667, 2.658, 2.650, 2.643, 2.637, 2.631, 2.625, 2.585, 2.561, 2.545, 2.534, 2.526, 2.520, 2.515, 2.492, 2.485, 2.481, 2.479, 2.478, 2.477, 2.476, 2.475, 2.475 },
/* 0.0145 */ {   43.897,  8.214,  5.110,  4.129, 3.666, 3.400, 3.228, 3.108, 3.019, 2.951, 2.898, 2.855, 2.819, 2.789, 2.763, 2.741, 2.722, 2.705, 2.690, 2.677, 2.665, 2.654, 2.644, 2.635, 2.627, 2.620, 2.613, 2.606, 2.600, 2.595, 2.556, 2.533, 2.518, 2.507, 2.499, 2.493, 2.488, 2.466, 2.459, 2.455, 2.453, 2.452, 2.451, 2.450, 2.449, 2.449 },
/* 0.0155 */ {   41.064,  7.939,  4.987,  4.048, 3.603, 3.346, 3.180, 3.064, 2.978, 2.912, 2.861, 2.819, 2.784, 2.755, 2.730, 2.708, 2.690, 2.673, 2.659, 2.646, 2.634, 2.624, 2.614, 2.606, 2.598, 2.591, 2.584, 2.578, 2.572, 2.567, 2.529, 2.506, 2.492, 2.481, 2.473, 2.467, 2.463, 2.441, 2.434, 2.431, 2.429, 2.427, 2.426, 2.426, 2.425, 2.425 },
/* 0.0165 */ {   38.574,  7.688,  4.875,  3.973, 3.544, 3.296, 3.135, 3.022, 2.940, 2.876, 2.826, 2.785, 2.751, 2.723, 2.699, 2.678, 2.660, 2.644, 2.630, 2.617, 2.606, 2.596, 2.587, 2.578, 2.570, 2.563, 2.557, 2.551, 2.545, 2.540, 2.503, 2.481, 2.467, 2.457, 2.449, 2.443, 2.439, 2.418, 2.411, 2.408, 2.406, 2.404, 2.403, 2.403, 2.402, 2.402 },
/* 0.0175 */ {   36.369,  7.460,  4.770,  3.903, 3.488, 3.248, 3.093, 2.984, 2.903, 2.842, 2.793, 2.753, 2.720, 2.693, 2.669, 2.649, 2.632, 2.616, 2.602, 2.590, 2.579, 2.569, 2.560, 2.552, 2.544, 2.538, 2.531, 2.525, 2.520, 2.515, 2.479, 2.458, 2.444, 2.434, 2.426, 2.421, 2.416, 2.396, 2.389, 2.386, 2.384, 2.383, 2.382, 2.381, 2.380, 2.380 },
/* 0.0185 */ {   34.402,  7.250,  4.674,  3.837, 3.437, 3.204, 3.053, 2.947, 2.869, 2.809, 2.762, 2.723, 2.691, 2.664, 2.642, 2.622, 2.605, 2.590, 2.576, 2.564, 2.554, 2.544, 2.535, 2.527, 2.520, 2.513, 2.507, 2.501, 2.496, 2.491, 2.456, 2.435, 2.421, 2.412, 2.405, 2.399, 2.395, 2.375, 2.368, 2.365, 2.363, 2.362, 2.361, 2.360, 2.360, 2.359 },
/* 0.0195 */ {   32.637,  7.056,  4.584,  3.776, 3.388, 3.163, 3.016, 2.913, 2.837, 2.779, 2.732, 2.695, 2.664, 2.637, 2.615, 2.596, 2.579, 2.564, 2.551, 2.540, 2.529, 2.520, 2.511, 2.504, 2.496, 2.490, 2.484, 2.478, 2.473, 2.468, 2.434, 2.414, 2.400, 2.391, 2.384, 2.378, 2.374, 2.355, 2.348, 2.345, 2.343, 2.342, 2.341, 2.341, 2.340, 2.340 },
/* 0.0205 */ {   31.044,  6.876,  4.499,  3.719, 3.342, 3.123, 2.981, 2.880, 2.806, 2.749, 2.704, 2.668, 2.637, 2.612, 2.590, 2.571, 2.555, 2.541, 2.528, 2.516, 2.506, 2.497, 2.489, 2.481, 2.474, 2.468, 2.462, 2.456, 2.451, 2.447, 2.413, 2.393, 2.380, 2.371, 2.364, 2.359, 2.355, 2.336, 2.329, 2.326, 2.324, 2.323, 2.322, 2.322, 2.321, 2.321 },
/* 0.0215 */ {   29.599,  6.709,  4.420,  3.664, 3.299, 3.086, 2.947, 2.849, 2.777, 2.722, 2.678, 2.642, 2.612, 2.587, 2.566, 2.548, 2.532, 2.518, 2.505, 2.494, 2.484, 2.475, 2.467, 2.460, 2.453, 2.446, 2.441, 2.435, 2.430, 2.426, 2.393, 2.374, 2.361, 2.352, 2.345, 2.340, 2.336, 2.317, 2.311, 2.308, 2.306, 2.305, 2.304, 2.304, 2.303, 2.303 },
/* 0.0225 */ {   28.282,  6.554,  4.346,  3.613, 3.258, 3.050, 2.915, 2.820, 2.749, 2.695, 2.652, 2.617, 2.588, 2.564, 2.543, 2.525, 2.510, 2.496, 2.484, 2.473, 2.463, 2.454, 2.446, 2.439, 2.432, 2.426, 2.421, 2.415, 2.410, 2.406, 2.374, 2.355, 2.342, 2.333, 2.327, 2.322, 2.318, 2.300, 2.294, 2.291, 2.289, 2.288, 2.287, 2.286, 2.286, 2.285 },
/* 0.0235 */ {   27.078,  6.408,  4.275,  3.564, 3.219, 3.017, 2.885, 2.792, 2.723, 2.670, 2.628, 2.594, 2.565, 2.542, 2.521, 2.504, 2.488, 2.475, 2.463, 2.452, 2.443, 2.434, 2.426, 2.419, 2.413, 2.407, 2.401, 2.396, 2.391, 2.387, 2.355, 2.337, 2.325, 2.316, 2.309, 2.304, 2.300, 2.283, 2.277, 2.274, 2.272, 2.271, 2.270, 2.270, 2.269, 2.269 },
/* 0.0245 */ {   25.972,  6.271,  4.209,  3.518, 3.181, 2.984, 2.855, 2.765, 2.697, 2.646, 2.604, 2.571, 2.543, 2.520, 2.500, 2.483, 2.468, 2.455, 2.443, 2.433, 2.423, 2.415, 2.407, 2.400, 2.394, 2.388, 2.382, 2.377, 2.373, 2.368, 2.338, 2.319, 2.307, 2.299, 2.293, 2.288, 2.284, 2.266, 2.261, 2.258, 2.256, 2.255, 2.254, 2.253, 2.253, 2.253 },
/* 0.0255 */ {   24.952,  6.142,  4.145,  3.474, 3.146, 2.953, 2.827, 2.739, 2.673, 2.622, 2.582, 2.549, 2.522, 2.499, 2.480, 2.463, 2.448, 2.435, 2.424, 2.414, 2.405, 2.396, 2.389, 2.382, 2.376, 2.370, 2.365, 2.360, 2.355, 2.351, 2.320, 2.303, 2.291, 2.283, 2.276, 2.272, 2.268, 2.251, 2.245, 2.242, 2.240, 2.239, 2.239, 2.238, 2.237, 2.237 },
/* 0.0265 */ {   24.010,  6.020,  4.085,  3.431, 3.112, 2.924, 2.801, 2.714, 2.649, 2.600, 2.560, 2.528, 2.502, 2.479, 2.460, 2.444, 2.429, 2.417, 2.406, 2.395, 2.386, 2.378, 2.371, 2.364, 2.358, 2.352, 2.347, 2.342, 2.338, 2.334, 2.304, 2.286, 2.275, 2.267, 2.261, 2.256, 2.252, 2.235, 2.230, 2.227, 2.225, 2.224, 2.224, 2.223, 2.222, 2.222 },
/* 0.0275 */ {   23.135,  5.905,  4.028,  3.391, 3.079, 2.895, 2.775, 2.690, 2.627, 2.578, 2.540, 2.508, 2.482, 2.460, 2.441, 2.425, 2.411, 2.399, 2.388, 2.378, 2.369, 2.361, 2.354, 2.347, 2.341, 2.336, 2.330, 2.326, 2.321, 2.317, 2.288, 2.271, 2.259, 2.251, 2.245, 2.241, 2.237, 2.221, 2.215, 2.212, 2.211, 2.210, 2.209, 2.208, 2.208, 2.208 },
/* 0.0285 */ {   22.323,  5.796,  3.973,  3.353, 3.048, 2.868, 2.750, 2.667, 2.605, 2.557, 2.520, 2.489, 2.463, 2.442, 2.423, 2.407, 2.393, 2.381, 2.370, 2.361, 2.352, 2.344, 2.337, 2.331, 2.325, 2.319, 2.314, 2.310, 2.305, 2.301, 2.273, 2.256, 2.245, 2.237, 2.231, 2.226, 2.223, 2.206, 2.201, 2.198, 2.197, 2.196, 2.195, 2.194, 2.194, 2.194 },
/* 0.0295 */ {   21.565,  5.693,  3.921,  3.316, 3.018, 2.842, 2.726, 2.645, 2.584, 2.537, 2.500, 2.470, 2.445, 2.424, 2.406, 2.390, 2.376, 2.364, 2.354, 2.344, 2.336, 2.328, 2.321, 2.315, 2.309, 2.304, 2.299, 2.294, 2.290, 2.286, 2.258, 2.241, 2.230, 2.222, 2.216, 2.212, 2.208, 2.192, 2.187, 2.185, 2.183, 2.182, 2.181, 2.181, 2.180, 2.180 },
/* 0.0305 */ {   20.857,  5.594,  3.871,  3.280, 2.988, 2.816, 2.703, 2.623, 2.564, 2.518, 2.481, 2.452, 2.427, 2.406, 2.389, 2.373, 2.360, 2.348, 2.338, 2.328, 2.320, 2.312, 2.305, 2.299, 2.293, 2.288, 2.283, 2.279, 2.275, 2.271, 2.243, 2.227, 2.216, 2.208, 2.203, 2.198, 2.195, 2.179, 2.174, 2.171, 2.170, 2.169, 2.168, 2.167, 2.167, 2.167 },
/* 0.0315 */ {   20.194,  5.500,  3.823,  3.246, 2.961, 2.792, 2.681, 2.602, 2.544, 2.499, 2.463, 2.434, 2.410, 2.389, 2.372, 2.357, 2.344, 2.332, 2.322, 2.313, 2.305, 2.297, 2.290, 2.284, 2.279, 2.273, 2.269, 2.264, 2.260, 2.256, 2.229, 2.213, 2.202, 2.195, 2.189, 2.185, 2.181, 2.166, 2.161, 2.158, 2.157, 2.156, 2.155, 2.154, 2.154, 2.154 },
/* 0.0325 */ {   19.571,  5.411,  3.777,  3.213, 2.934, 2.768, 2.659, 2.582, 2.525, 2.481, 2.446, 2.417, 2.393, 2.373, 2.356, 2.341, 2.328, 2.317, 2.307, 2.298, 2.290, 2.282, 2.276, 2.270, 2.264, 2.259, 2.254, 2.250, 2.246, 2.242, 2.215, 2.199, 2.189, 2.182, 2.176, 2.172, 2.168, 2.153, 2.148, 2.146, 2.144, 2.143, 2.142, 2.142, 2.142, 2.141 },
/* 0.0335 */ {   18.986,  5.325,  3.733,  3.181, 2.907, 2.745, 2.638, 2.563, 2.507, 2.463, 2.428, 2.400, 2.377, 2.357, 2.340, 2.326, 2.313, 2.302, 2.292, 2.283, 2.275, 2.268, 2.261, 2.255, 2.250, 2.245, 2.240, 2.236, 2.232, 2.228, 2.202, 2.186, 2.176, 2.169, 2.163, 2.159, 2.156, 2.141, 2.136, 2.133, 2.132, 2.131, 2.130, 2.130, 2.129, 2.129 },
/* 0.0345 */ {   18.435,  5.243,  3.691,  3.150, 2.882, 2.723, 2.618, 2.544, 2.489, 2.446, 2.412, 2.384, 2.361, 2.342, 2.325, 2.311, 2.298, 2.287, 2.278, 2.269, 2.261, 2.254, 2.247, 2.242, 2.236, 2.231, 2.227, 2.223, 2.219, 2.215, 2.189, 2.174, 2.163, 2.156, 2.151, 2.147, 2.143, 2.129, 2.124, 2.121, 2.120, 2.119, 2.118, 2.118, 2.117, 2.117 },
/* 0.0355 */ {   17.914,  5.165,  3.650,  3.121, 2.858, 2.702, 2.599, 2.526, 2.471, 2.429, 2.396, 2.368, 2.346, 2.327, 2.310, 2.296, 2.284, 2.273, 2.264, 2.255, 2.247, 2.240, 2.234, 2.228, 2.223, 2.218, 2.213, 2.209, 2.205, 2.202, 2.176, 2.161, 2.151, 2.144, 2.139, 2.135, 2.131, 2.117, 2.112, 2.110, 2.108, 2.107, 2.107, 2.106, 2.106, 2.105 },
/* 0.0365 */ {   17.423,  5.090,  3.610,  3.092, 2.834, 2.681, 2.579, 2.508, 2.454, 2.413, 2.380, 2.353, 2.331, 2.312, 2.296, 2.282, 2.270, 2.259, 2.250, 2.241, 2.234, 2.227, 2.221, 2.215, 2.210, 2.205, 2.201, 2.197, 2.193, 2.189, 2.164, 2.149, 2.139, 2.132, 2.127, 2.123, 2.120, 2.105, 2.101, 2.098, 2.097, 2.096, 2.095, 2.095, 2.094, 2.094 },
/* 0.0375 */ {   16.957,  5.018,  3.572,  3.064, 2.811, 2.660, 2.561, 2.490, 2.438, 2.397, 2.365, 2.338, 2.316, 2.298, 2.282, 2.268, 2.256, 2.246, 2.237, 2.228, 2.221, 2.214, 2.208, 2.202, 2.197, 2.192, 2.188, 2.184, 2.180, 2.177, 2.152, 2.137, 2.127, 2.121, 2.115, 2.112, 2.108, 2.094, 2.090, 2.087, 2.086, 2.085, 2.084, 2.084, 2.083, 2.083 },
/* 0.0385 */ {   16.515,  4.948,  3.535,  3.037, 2.789, 2.641, 2.543, 2.473, 2.422, 2.382, 2.350, 2.324, 2.302, 2.284, 2.268, 2.255, 2.243, 2.233, 2.224, 2.215, 2.208, 2.201, 2.195, 2.190, 2.185, 2.180, 2.176, 2.172, 2.168, 2.165, 2.140, 2.126, 2.116, 2.109, 2.104, 2.100, 2.097, 2.083, 2.079, 2.076, 2.075, 2.074, 2.073, 2.073, 2.073, 2.072 },
/* 0.0395 */ {   16.096,  4.881,  3.499,  3.011, 2.767, 2.622, 2.525, 2.457, 2.406, 2.367, 2.335, 2.310, 2.288, 2.270, 2.255, 2.242, 2.230, 2.220, 2.211, 2.203, 2.196, 2.189, 2.183, 2.178, 2.173, 2.168, 2.164, 2.160, 2.156, 2.153, 2.129, 2.114, 2.105, 2.098, 2.093, 2.089, 2.086, 2.073, 2.068, 2.066, 2.064, 2.063, 2.063, 2.062, 2.062, 2.062 },
/* 0.0405 */ {   15.698,  4.817,  3.465,  2.986, 2.746, 2.603, 2.508, 2.441, 2.391, 2.352, 2.321, 2.296, 2.275, 2.257, 2.242, 2.229, 2.218, 2.207, 2.199, 2.191, 2.183, 2.177, 2.171, 2.166, 2.161, 2.156, 2.152, 2.148, 2.145, 2.141, 2.117, 2.103, 2.094, 2.087, 2.082, 2.079, 2.076, 2.062, 2.058, 2.055, 2.054, 2.053, 2.052, 2.052, 2.052, 2.051 },
/* 0.0415 */ {   15.318,  4.755,  3.431,  2.961, 2.726, 2.585, 2.492, 2.425, 2.376, 2.338, 2.307, 2.282, 2.262, 2.244, 2.229, 2.216, 2.205, 2.195, 2.186, 2.179, 2.171, 2.165, 2.159, 2.154, 2.149, 2.145, 2.141, 2.137, 2.133, 2.130, 2.106, 2.092, 2.083, 2.077, 2.072, 2.068, 2.065, 2.052, 2.047, 2.045, 2.044, 2.043, 2.042, 2.042, 2.041, 2.041 },
/* 0.0425 */ {   14.957,  4.695,  3.399,  2.937, 2.706, 2.567, 2.475, 2.410, 2.361, 2.324, 2.294, 2.269, 2.249, 2.232, 2.217, 2.204, 2.193, 2.183, 2.175, 2.167, 2.160, 2.154, 2.148, 2.143, 2.138, 2.133, 2.129, 2.126, 2.122, 2.119, 2.096, 2.082, 2.073, 2.066, 2.062, 2.058, 2.055, 2.042, 2.037, 2.035, 2.034, 2.033, 2.032, 2.032, 2.031, 2.031 },
/* 0.0435 */ {   14.612,  4.637,  3.367,  2.914, 2.686, 2.550, 2.459, 2.395, 2.347, 2.310, 2.280, 2.256, 2.236, 2.219, 2.205, 2.192, 2.181, 2.172, 2.163, 2.155, 2.148, 2.142, 2.137, 2.131, 2.127, 2.122, 2.118, 2.115, 2.111, 2.108, 2.085, 2.071, 2.062, 2.056, 2.051, 2.048, 2.045, 2.032, 2.027, 2.025, 2.024, 2.023, 2.023, 2.022, 2.022, 2.021 },
/* 0.0445 */ {   14.283,  4.581,  3.337,  2.891, 2.667, 2.533, 2.444, 2.381, 2.333, 2.297, 2.268, 2.244, 2.224, 2.207, 2.193, 2.180, 2.170, 2.160, 2.152, 2.144, 2.137, 2.131, 2.126, 2.120, 2.116, 2.111, 2.108, 2.104, 2.100, 2.097, 2.075, 2.061, 2.052, 2.046, 2.041, 2.038, 2.035, 2.022, 2.018, 2.016, 2.014, 2.014, 2.013, 2.013, 2.012, 2.012 },
/* 0.0455 */ {   13.968,  4.527,  3.307,  2.869, 2.649, 2.517, 2.429, 2.366, 2.320, 2.284, 2.255, 2.231, 2.212, 2.195, 2.181, 2.169, 2.158, 2.149, 2.140, 2.133, 2.126, 2.120, 2.115, 2.110, 2.105, 2.101, 2.097, 2.093, 2.090, 2.087, 2.064, 2.051, 2.043, 2.036, 2.032, 2.028, 2.025, 2.013, 2.008, 2.006, 2.005, 2.004, 2.004, 2.003, 2.003, 2.003 },
/* 0.0465 */ {   13.666,  4.474,  3.278,  2.848, 2.631, 2.500, 2.414, 2.352, 2.307, 2.271, 2.242, 2.219, 2.200, 2.184, 2.170, 2.158, 2.147, 2.138, 2.130, 2.122, 2.116, 2.110, 2.104, 2.099, 2.095, 2.090, 2.087, 2.083, 2.080, 2.077, 2.055, 2.041, 2.033, 2.027, 2.022, 2.019, 2.016, 2.003, 1.999, 1.997, 1.996, 1.995, 1.994, 1.994, 1.994, 1.993 },
/* 0.0475 */ {   13.378,  4.423,  3.250,  2.827, 2.613, 2.485, 2.400, 2.339, 2.294, 2.258, 2.230, 2.207, 2.188, 2.172, 2.159, 2.147, 2.136, 2.127, 2.119, 2.112, 2.105, 2.099, 2.094, 2.089, 2.084, 2.080, 2.076, 2.073, 2.070, 2.067, 2.045, 2.032, 2.023, 2.017, 2.013, 2.009, 2.007, 1.994, 1.990, 1.988, 1.987, 1.986, 1.985, 1.985, 1.985, 1.984 },
/* 0.0485 */ {   13.101,  4.374,  3.222,  2.806, 2.596, 2.469, 2.385, 2.326, 2.281, 2.246, 2.218, 2.196, 2.177, 2.161, 2.148, 2.136, 2.126, 2.116, 2.108, 2.101, 2.095, 2.089, 2.084, 2.079, 2.074, 2.070, 2.066, 2.063, 2.060, 2.057, 2.035, 2.022, 2.014, 2.008, 2.004, 2.000, 1.997, 1.985, 1.981, 1.979, 1.978, 1.977, 1.976, 1.976, 1.976, 1.975 },
/* 0.0495 */ {   12.835,  4.326,  3.196,  2.786, 2.579, 2.454, 2.371, 2.312, 2.268, 2.234, 2.207, 2.184, 2.166, 2.150, 2.137, 2.125, 2.115, 2.106, 2.098, 2.091, 2.085, 2.079, 2.074, 2.069, 2.064, 2.060, 2.057, 2.053, 2.050, 2.047, 2.026, 2.013, 2.005, 1.999, 1.995, 1.991, 1.988, 1.976, 1.972, 1.970, 1.969, 1.968, 1.968, 1.967, 1.967, 1.967 },
/* 0.0505 */ {   12.580,  4.280,  3.170,  2.767, 2.562, 2.440, 2.358, 2.300, 2.256, 2.222, 2.195, 2.173, 2.155, 2.139, 2.126, 2.115, 2.105, 2.096, 2.088, 2.081, 2.075, 2.069, 2.064, 2.059, 2.055, 2.051, 2.047, 2.044, 2.040, 2.038, 2.016, 2.004, 1.996, 1.990, 1.986, 1.982, 1.980, 1.968, 1.964, 1.962, 1.960, 1.960, 1.959, 1.959, 1.958, 1.958 },
/* 0.0515 */ {   12.335,  4.234,  3.144,  2.748, 2.546, 2.425, 2.345, 2.287, 2.244, 2.211, 2.184, 2.162, 2.144, 2.129, 2.116, 2.104, 2.095, 2.086, 2.078, 2.071, 2.065, 2.059, 2.054, 2.049, 2.045, 2.041, 2.038, 2.034, 2.031, 2.028, 2.007, 1.995, 1.987, 1.981, 1.977, 1.974, 1.971, 1.959, 1.955, 1.953, 1.952, 1.951, 1.951, 1.950, 1.950, 1.950 },
/* 0.0525 */ {   12.099,  4.191,  3.119,  2.729, 2.530, 2.411, 2.331, 2.275, 2.232, 2.199, 2.173, 2.152, 2.134, 2.119, 2.106, 2.094, 2.085, 2.076, 2.068, 2.061, 2.055, 2.050, 2.045, 2.040, 2.036, 2.032, 2.028, 2.025, 2.022, 2.019, 1.998, 1.986, 1.978, 1.973, 1.968, 1.965, 1.962, 1.951, 1.947, 1.945, 1.944, 1.943, 1.942, 1.942, 1.942, 1.941 },
/* 0.0535 */ {   11.871,  4.148,  3.095,  2.711, 2.515, 2.397, 2.319, 2.263, 2.221, 2.188, 2.162, 2.141, 2.123, 2.108, 2.096, 2.084, 2.075, 2.066, 2.059, 2.052, 2.046, 2.040, 2.035, 2.031, 2.027, 2.023, 2.019, 2.016, 2.013, 2.010, 1.990, 1.978, 1.970, 1.964, 1.960, 1.957, 1.954, 1.942, 1.939, 1.937, 1.935, 1.935, 1.934, 1.934, 1.933, 1.933 },
/* 0.0545 */ {   11.653,  4.106,  3.071,  2.693, 2.500, 2.384, 2.306, 2.251, 2.209, 2.177, 2.152, 2.131, 2.113, 2.098, 2.086, 2.075, 2.065, 2.057, 2.049, 2.043, 2.037, 2.031, 2.026, 2.022, 2.017, 2.014, 2.010, 2.007, 2.004, 2.001, 1.981, 1.969, 1.961, 1.956, 1.951, 1.948, 1.946, 1.934, 1.930, 1.929, 1.927, 1.927, 1.926, 1.926, 1.925, 1.925 },
/* 0.0555 */ {   11.442,  4.066,  3.048,  2.675, 2.485, 2.370, 2.294, 2.239, 2.198, 2.166, 2.141, 2.120, 2.103, 2.089, 2.076, 2.065, 2.056, 2.047, 2.040, 2.033, 2.027, 2.022, 2.017, 2.013, 2.009, 2.005, 2.001, 1.998, 1.995, 1.992, 1.972, 1.961, 1.953, 1.947, 1.943, 1.940, 1.938, 1.926, 1.922, 1.921, 1.919, 1.919, 1.918, 1.918, 1.917, 1.917 },
/* 0.0565 */ {   11.238,  4.027,  3.026,  2.658, 2.470, 2.357, 2.282, 2.228, 2.187, 2.156, 2.131, 2.110, 2.093, 2.079, 2.066, 2.056, 2.046, 2.038, 2.031, 2.024, 2.018, 2.013, 2.008, 2.004, 2.000, 1.996, 1.993, 1.989, 1.987, 1.984, 1.964, 1.952, 1.945, 1.939, 1.935, 1.932, 1.930, 1.918, 1.915, 1.913, 1.912, 1.911, 1.910, 1.910, 1.910, 1.909 },
/* 0.0575 */ {   11.042,  3.988,  3.004,  2.641, 2.456, 2.344, 2.270, 2.216, 2.177, 2.145, 2.121, 2.100, 2.084, 2.069, 2.057, 2.047, 2.037, 2.029, 2.022, 2.015, 2.010, 2.004, 2.000, 1.995, 1.991, 1.987, 1.984, 1.981, 1.978, 1.975, 1.956, 1.944, 1.937, 1.931, 1.927, 1.924, 1.922, 1.910, 1.907, 1.905, 1.904, 1.903, 1.903, 1.902, 1.902, 1.902 },
/* 0.0585 */ {   10.852,  3.951,  2.982,  2.625, 2.442, 2.332, 2.258, 2.205, 2.166, 2.135, 2.111, 2.091, 2.074, 2.060, 2.048, 2.037, 2.028, 2.020, 2.013, 2.007, 2.001, 1.996, 1.991, 1.987, 1.983, 1.979, 1.976, 1.973, 1.970, 1.967, 1.948, 1.936, 1.929, 1.923, 1.919, 1.916, 1.914, 1.903, 1.899, 1.897, 1.896, 1.896, 1.895, 1.895, 1.894, 1.894 },
/* 0.0595 */ {   10.668,  3.914,  2.961,  2.609, 2.428, 2.319, 2.247, 2.195, 2.156, 2.125, 2.101, 2.081, 2.065, 2.051, 2.039, 2.028, 2.019, 2.011, 2.004, 1.998, 1.992, 1.987, 1.982, 1.978, 1.974, 1.971, 1.967, 1.964, 1.961, 1.959, 1.940, 1.928, 1.921, 1.916, 1.912, 1.909, 1.906, 1.895, 1.892, 1.890, 1.889, 1.888, 1.888, 1.887, 1.887, 1.887 },
/* 0.0605 */ {   10.491,  3.879,  2.940,  2.593, 2.415, 2.307, 2.235, 2.184, 2.145, 2.115, 2.091, 2.072, 2.055, 2.042, 2.030, 2.020, 2.011, 2.003, 1.996, 1.989, 1.984, 1.979, 1.974, 1.970, 1.966, 1.962, 1.959, 1.956, 1.953, 1.951, 1.932, 1.921, 1.913, 1.908, 1.904, 1.901, 1.899, 1.888, 1.884, 1.882, 1.881, 1.881, 1.880, 1.880, 1.879, 1.879 },
/* 0.0615 */ {   10.319,  3.844,  2.920,  2.577, 2.402, 2.295, 2.224, 2.173, 2.135, 2.106, 2.082, 2.062, 2.046, 2.033, 2.021, 2.011, 2.002, 1.994, 1.987, 1.981, 1.975, 1.970, 1.966, 1.962, 1.958, 1.954, 1.951, 1.948, 1.945, 1.943, 1.924, 1.913, 1.906, 1.900, 1.897, 1.894, 1.891, 1.880, 1.877, 1.875, 1.874, 1.873, 1.873, 1.873, 1.872, 1.872 },
/* 0.0625 */ {   10.153,  3.810,  2.900,  2.562, 2.389, 2.283, 2.213, 2.163, 2.125, 2.096, 2.073, 2.053, 2.037, 2.024, 2.012, 2.002, 1.994, 1.986, 1.979, 1.973, 1.967, 1.962, 1.958, 1.954, 1.950, 1.946, 1.943, 1.940, 1.937, 1.935, 1.916, 1.905, 1.898, 1.893, 1.889, 1.886, 1.884, 1.873, 1.870, 1.868, 1.867, 1.866, 1.866, 1.865, 1.865, 1.865 },
/* 0.0635 */ {    9.992,  3.777,  2.881,  2.547, 2.376, 2.272, 2.202, 2.153, 2.116, 2.087, 2.063, 2.044, 2.029, 2.015, 2.004, 1.994, 1.985, 1.978, 1.971, 1.965, 1.959, 1.954, 1.950, 1.946, 1.942, 1.938, 1.935, 1.932, 1.930, 1.927, 1.909, 1.898, 1.891, 1.886, 1.882, 1.879, 1.877, 1.866, 1.863, 1.861, 1.860, 1.859, 1.859, 1.858, 1.858, 1.858 },
/* 0.0645 */ {    9.836,  3.744,  2.861,  2.532, 2.363, 2.261, 2.192, 2.143, 2.106, 2.077, 2.054, 2.036, 2.020, 2.007, 1.995, 1.986, 1.977, 1.969, 1.963, 1.957, 1.951, 1.946, 1.942, 1.938, 1.934, 1.931, 1.927, 1.925, 1.922, 1.919, 1.901, 1.890, 1.883, 1.878, 1.875, 1.872, 1.869, 1.859, 1.856, 1.854, 1.853, 1.852, 1.852, 1.851, 1.851, 1.851 },
/* 0.0655 */ {    9.685,  3.713,  2.843,  2.518, 2.351, 2.249, 2.181, 2.133, 2.096, 2.068, 2.045, 2.027, 2.011, 1.998, 1.987, 1.977, 1.969, 1.961, 1.955, 1.949, 1.943, 1.938, 1.934, 1.930, 1.926, 1.923, 1.920, 1.917, 1.914, 1.912, 1.894, 1.883, 1.876, 1.871, 1.867, 1.865, 1.862, 1.852, 1.849, 1.847, 1.846, 1.845, 1.845, 1.844, 1.844, 1.844 },
/* 0.0665 */ {    9.538,  3.682,  2.824,  2.504, 2.339, 2.238, 2.171, 2.123, 2.087, 2.059, 2.037, 2.018, 2.003, 1.990, 1.979, 1.969, 1.961, 1.953, 1.947, 1.941, 1.936, 1.931, 1.926, 1.922, 1.919, 1.915, 1.912, 1.909, 1.907, 1.904, 1.887, 1.876, 1.869, 1.864, 1.860, 1.858, 1.855, 1.845, 1.842, 1.840, 1.839, 1.838, 1.838, 1.838, 1.837, 1.837 },
/* 0.0675 */ {    9.396,  3.651,  2.806,  2.490, 2.327, 2.227, 2.161, 2.114, 2.078, 2.050, 2.028, 2.010, 1.995, 1.982, 1.971, 1.961, 1.953, 1.946, 1.939, 1.933, 1.928, 1.923, 1.919, 1.915, 1.911, 1.908, 1.905, 1.902, 1.899, 1.897, 1.879, 1.869, 1.862, 1.857, 1.853, 1.851, 1.848, 1.838, 1.835, 1.833, 1.832, 1.832, 1.831, 1.831, 1.831, 1.830 },
/* 0.0685 */ {    9.258,  3.622,  2.789,  2.476, 2.315, 2.217, 2.151, 2.104, 2.069, 2.041, 2.019, 2.001, 1.986, 1.974, 1.963, 1.953, 1.945, 1.938, 1.931, 1.926, 1.920, 1.916, 1.911, 1.907, 1.904, 1.901, 1.898, 1.895, 1.892, 1.890, 1.872, 1.862, 1.855, 1.850, 1.847, 1.844, 1.842, 1.832, 1.828, 1.827, 1.826, 1.825, 1.825, 1.824, 1.824, 1.824 },
/* 0.0695 */ {    9.124,  3.593,  2.771,  2.463, 2.303, 2.206, 2.141, 2.095, 2.060, 2.033, 2.011, 1.993, 1.978, 1.966, 1.955, 1.946, 1.937, 1.930, 1.924, 1.918, 1.913, 1.908, 1.904, 1.900, 1.897, 1.893, 1.890, 1.887, 1.885, 1.882, 1.865, 1.855, 1.848, 1.843, 1.840, 1.837, 1.835, 1.825, 1.822, 1.820, 1.819, 1.818, 1.818, 1.818, 1.817, 1.817 },
/* 0.0705 */ {    8.993,  3.564,  2.754,  2.449, 2.292, 2.196, 2.132, 2.086, 2.051, 2.024, 2.003, 1.985, 1.970, 1.958, 1.947, 1.938, 1.930, 1.923, 1.916, 1.911, 1.905, 1.901, 1.897, 1.893, 1.889, 1.886, 1.883, 1.880, 1.878, 1.875, 1.858, 1.848, 1.841, 1.837, 1.833, 1.830, 1.828, 1.818, 1.815, 1.814, 1.813, 1.812, 1.811, 1.811, 1.811, 1.811 },
/* 0.0715 */ {    8.866,  3.536,  2.737,  2.436, 2.280, 2.186, 2.122, 2.077, 2.042, 2.016, 1.994, 1.977, 1.962, 1.950, 1.939, 1.930, 1.922, 1.915, 1.909, 1.903, 1.898, 1.894, 1.889, 1.886, 1.882, 1.879, 1.876, 1.873, 1.871, 1.868, 1.851, 1.841, 1.835, 1.830, 1.827, 1.824, 1.822, 1.812, 1.809, 1.807, 1.806, 1.805, 1.805, 1.805, 1.804, 1.804 },
/* 0.0725 */ {    8.743,  3.509,  2.721,  2.423, 2.269, 2.176, 2.113, 2.068, 2.034, 2.007, 1.986, 1.969, 1.954, 1.942, 1.932, 1.923, 1.915, 1.908, 1.902, 1.896, 1.891, 1.886, 1.882, 1.879, 1.875, 1.872, 1.869, 1.866, 1.864, 1.861, 1.845, 1.835, 1.828, 1.823, 1.820, 1.817, 1.815, 1.806, 1.802, 1.801, 1.800, 1.799, 1.799, 1.798, 1.798, 1.798 },
/* 0.0735 */ {    8.623,  3.482,  2.705,  2.411, 2.258, 2.166, 2.103, 2.059, 2.025, 1.999, 1.978, 1.961, 1.947, 1.935, 1.924, 1.915, 1.907, 1.901, 1.894, 1.889, 1.884, 1.879, 1.875, 1.872, 1.868, 1.865, 1.862, 1.859, 1.857, 1.855, 1.838, 1.828, 1.822, 1.817, 1.814, 1.811, 1.809, 1.799, 1.796, 1.794, 1.793, 1.793, 1.792, 1.792, 1.792, 1.792 },
/* 0.0745 */ {    8.506,  3.456,  2.689,  2.398, 2.248, 2.156, 2.094, 2.050, 2.017, 1.991, 1.970, 1.953, 1.939, 1.927, 1.917, 1.908, 1.900, 1.893, 1.887, 1.882, 1.877, 1.872, 1.868, 1.865, 1.861, 1.858, 1.855, 1.853, 1.850, 1.848, 1.831, 1.822, 1.815, 1.811, 1.807, 1.804, 1.802, 1.793, 1.790, 1.788, 1.787, 1.787, 1.786, 1.786, 1.786, 1.785 },
/* 0.0755 */ {    8.392,  3.430,  2.673,  2.386, 2.237, 2.146, 2.085, 2.041, 2.009, 1.983, 1.962, 1.946, 1.932, 1.920, 1.910, 1.901, 1.893, 1.886, 1.880, 1.875, 1.870, 1.866, 1.862, 1.858, 1.855, 1.851, 1.849, 1.846, 1.843, 1.841, 1.825, 1.815, 1.809, 1.804, 1.801, 1.798, 1.796, 1.787, 1.784, 1.782, 1.781, 1.781, 1.780, 1.780, 1.779, 1.779 },
/* 0.0765 */ {    8.282,  3.405,  2.658,  2.374, 2.227, 2.137, 2.076, 2.033, 2.000, 1.975, 1.955, 1.938, 1.924, 1.912, 1.902, 1.894, 1.886, 1.879, 1.873, 1.868, 1.863, 1.859, 1.855, 1.851, 1.848, 1.845, 1.842, 1.839, 1.837, 1.835, 1.818, 1.809, 1.802, 1.798, 1.795, 1.792, 1.790, 1.781, 1.777, 1.776, 1.775, 1.774, 1.774, 1.774, 1.773, 1.773 },
/* 0.0775 */ {    8.174,  3.380,  2.642,  2.362, 2.216, 2.127, 2.068, 2.025, 1.992, 1.967, 1.947, 1.931, 1.917, 1.905, 1.895, 1.887, 1.879, 1.872, 1.866, 1.861, 1.856, 1.852, 1.848, 1.844, 1.841, 1.838, 1.835, 1.833, 1.830, 1.828, 1.812, 1.802, 1.796, 1.792, 1.788, 1.786, 1.784, 1.775, 1.771, 1.770, 1.769, 1.768, 1.768, 1.768, 1.767, 1.767 },
/* 0.0785 */ {    8.069,  3.355,  2.627,  2.350, 2.206, 2.118, 2.059, 2.016, 1.984, 1.960, 1.940, 1.923, 1.910, 1.898, 1.888, 1.880, 1.872, 1.865, 1.860, 1.854, 1.850, 1.845, 1.841, 1.838, 1.835, 1.832, 1.829, 1.826, 1.824, 1.822, 1.806, 1.796, 1.790, 1.786, 1.782, 1.780, 1.778, 1.769, 1.765, 1.764, 1.763, 1.762, 1.762, 1.762, 1.761, 1.761 },
/* 0.0795 */ {    7.966,  3.332,  2.613,  2.339, 2.196, 2.109, 2.050, 2.008, 1.977, 1.952, 1.932, 1.916, 1.902, 1.891, 1.881, 1.873, 1.865, 1.859, 1.853, 1.848, 1.843, 1.839, 1.835, 1.831, 1.828, 1.825, 1.822, 1.820, 1.817, 1.815, 1.799, 1.790, 1.784, 1.779, 1.776, 1.774, 1.772, 1.763, 1.760, 1.758, 1.757, 1.757, 1.756, 1.756, 1.756, 1.755 },
/* 0.0805 */ {    7.866,  3.308,  2.598,  2.327, 2.186, 2.100, 2.042, 2.000, 1.969, 1.944, 1.925, 1.909, 1.895, 1.884, 1.874, 1.866, 1.859, 1.852, 1.846, 1.841, 1.836, 1.832, 1.828, 1.825, 1.822, 1.819, 1.816, 1.813, 1.811, 1.809, 1.793, 1.784, 1.778, 1.773, 1.770, 1.768, 1.766, 1.757, 1.754, 1.752, 1.751, 1.751, 1.750, 1.750, 1.750, 1.750 },
/* 0.0815 */ {    7.769,  3.285,  2.584,  2.316, 2.176, 2.091, 2.033, 1.992, 1.961, 1.937, 1.917, 1.902, 1.888, 1.877, 1.867, 1.859, 1.852, 1.845, 1.840, 1.835, 1.830, 1.826, 1.822, 1.818, 1.815, 1.812, 1.810, 1.807, 1.805, 1.803, 1.787, 1.778, 1.772, 1.768, 1.764, 1.762, 1.760, 1.751, 1.748, 1.746, 1.746, 1.745, 1.745, 1.744, 1.744, 1.744 },
/* 0.0825 */ {    7.673,  3.262,  2.570,  2.305, 2.167, 2.082, 2.025, 1.984, 1.954, 1.930, 1.910, 1.895, 1.881, 1.870, 1.861, 1.852, 1.845, 1.839, 1.833, 1.828, 1.823, 1.819, 1.816, 1.812, 1.809, 1.806, 1.803, 1.801, 1.799, 1.796, 1.781, 1.772, 1.766, 1.762, 1.758, 1.756, 1.754, 1.745, 1.742, 1.741, 1.740, 1.739, 1.739, 1.739, 1.738, 1.738 },
/* 0.0835 */ {    7.580,  3.240,  2.556,  2.294, 2.157, 2.073, 2.017, 1.976, 1.946, 1.922, 1.903, 1.888, 1.875, 1.864, 1.854, 1.846, 1.839, 1.832, 1.827, 1.822, 1.817, 1.813, 1.809, 1.806, 1.803, 1.800, 1.797, 1.795, 1.792, 1.790, 1.775, 1.766, 1.760, 1.756, 1.753, 1.750, 1.748, 1.739, 1.737, 1.735, 1.734, 1.734, 1.733, 1.733, 1.733, 1.732 },
/* 0.0845 */ {    7.490,  3.218,  2.542,  2.283, 2.148, 2.065, 2.009, 1.969, 1.939, 1.915, 1.896, 1.881, 1.868, 1.857, 1.847, 1.839, 1.832, 1.826, 1.820, 1.815, 1.811, 1.807, 1.803, 1.800, 1.797, 1.794, 1.791, 1.789, 1.786, 1.784, 1.769, 1.760, 1.754, 1.750, 1.747, 1.744, 1.742, 1.734, 1.731, 1.729, 1.729, 1.728, 1.728, 1.727, 1.727, 1.727 },
/* 0.0855 */ {    7.401,  3.197,  2.529,  2.272, 2.138, 2.056, 2.001, 1.961, 1.931, 1.908, 1.889, 1.874, 1.861, 1.850, 1.841, 1.833, 1.826, 1.820, 1.814, 1.809, 1.805, 1.801, 1.797, 1.794, 1.790, 1.788, 1.785, 1.783, 1.780, 1.778, 1.763, 1.754, 1.748, 1.744, 1.741, 1.739, 1.737, 1.728, 1.725, 1.724, 1.723, 1.722, 1.722, 1.722, 1.722, 1.721 },
/* 0.0865 */ {    7.314,  3.175,  2.516,  2.262, 2.129, 2.048, 1.993, 1.954, 1.924, 1.901, 1.882, 1.867, 1.854, 1.844, 1.834, 1.826, 1.819, 1.813, 1.808, 1.803, 1.798, 1.794, 1.791, 1.787, 1.784, 1.782, 1.779, 1.777, 1.774, 1.772, 1.757, 1.749, 1.743, 1.739, 1.736, 1.733, 1.731, 1.723, 1.720, 1.718, 1.718, 1.717, 1.717, 1.716, 1.716, 1.716 },
/* 0.0875 */ {    7.230,  3.155,  2.503,  2.251, 2.120, 2.040, 1.985, 1.946, 1.917, 1.894, 1.875, 1.860, 1.848, 1.837, 1.828, 1.820, 1.813, 1.807, 1.802, 1.797, 1.792, 1.788, 1.785, 1.781, 1.778, 1.776, 1.773, 1.771, 1.768, 1.766, 1.752, 1.743, 1.737, 1.733, 1.730, 1.728, 1.726, 1.717, 1.714, 1.713, 1.712, 1.712, 1.711, 1.711, 1.711, 1.710 },
/* 0.0885 */ {    7.147,  3.134,  2.490,  2.241, 2.111, 2.031, 1.978, 1.939, 1.910, 1.887, 1.869, 1.854, 1.841, 1.831, 1.822, 1.814, 1.807, 1.801, 1.795, 1.791, 1.786, 1.782, 1.779, 1.775, 1.772, 1.770, 1.767, 1.765, 1.763, 1.761, 1.746, 1.737, 1.732, 1.727, 1.724, 1.722, 1.720, 1.712, 1.709, 1.708, 1.707, 1.706, 1.706, 1.705, 1.705, 1.705 },
/* 0.0895 */ {    7.066,  3.114,  2.477,  2.231, 2.102, 2.023, 1.970, 1.932, 1.903, 1.880, 1.862, 1.847, 1.835, 1.824, 1.815, 1.808, 1.801, 1.795, 1.789, 1.785, 1.780, 1.776, 1.773, 1.770, 1.767, 1.764, 1.761, 1.759, 1.757, 1.755, 1.740, 1.732, 1.726, 1.722, 1.719, 1.717, 1.715, 1.706, 1.704, 1.702, 1.701, 1.701, 1.700, 1.700, 1.700, 1.700 },
/* 0.0905 */ {    6.987,  3.094,  2.465,  2.221, 2.093, 2.015, 1.962, 1.924, 1.896, 1.873, 1.855, 1.841, 1.829, 1.818, 1.809, 1.801, 1.795, 1.789, 1.783, 1.779, 1.774, 1.771, 1.767, 1.764, 1.761, 1.758, 1.756, 1.753, 1.751, 1.749, 1.735, 1.726, 1.720, 1.716, 1.713, 1.711, 1.709, 1.701, 1.698, 1.697, 1.696, 1.695, 1.695, 1.695, 1.695, 1.694 },
/* 0.0915 */ {    6.910,  3.075,  2.452,  2.211, 2.085, 2.007, 1.955, 1.917, 1.889, 1.867, 1.849, 1.834, 1.822, 1.812, 1.803, 1.795, 1.789, 1.783, 1.777, 1.773, 1.769, 1.765, 1.761, 1.758, 1.755, 1.752, 1.750, 1.748, 1.745, 1.743, 1.729, 1.721, 1.715, 1.711, 1.708, 1.706, 1.704, 1.696, 1.693, 1.692, 1.691, 1.690, 1.690, 1.690, 1.689, 1.689 },
/* 0.0925 */ {    6.834,  3.055,  2.440,  2.201, 2.076, 1.999, 1.948, 1.910, 1.882, 1.860, 1.842, 1.828, 1.816, 1.806, 1.797, 1.789, 1.783, 1.777, 1.772, 1.767, 1.763, 1.759, 1.755, 1.752, 1.749, 1.747, 1.744, 1.742, 1.740, 1.738, 1.724, 1.715, 1.710, 1.706, 1.703, 1.700, 1.699, 1.690, 1.688, 1.686, 1.686, 1.685, 1.685, 1.684, 1.684, 1.684 },
/* 0.0935 */ {    6.760,  3.036,  2.428,  2.192, 2.068, 1.992, 1.940, 1.903, 1.875, 1.854, 1.836, 1.822, 1.810, 1.800, 1.791, 1.783, 1.777, 1.771, 1.766, 1.761, 1.757, 1.753, 1.750, 1.747, 1.744, 1.741, 1.739, 1.736, 1.734, 1.732, 1.718, 1.710, 1.704, 1.700, 1.697, 1.695, 1.693, 1.685, 1.683, 1.681, 1.680, 1.680, 1.680, 1.679, 1.679, 1.679 },
/* 0.0945 */ {    6.687,  3.018,  2.416,  2.182, 2.059, 1.984, 1.933, 1.896, 1.869, 1.847, 1.830, 1.816, 1.804, 1.794, 1.785, 1.777, 1.771, 1.765, 1.760, 1.755, 1.751, 1.747, 1.744, 1.741, 1.738, 1.735, 1.733, 1.731, 1.729, 1.727, 1.713, 1.704, 1.699, 1.695, 1.692, 1.690, 1.688, 1.680, 1.677, 1.676, 1.675, 1.675, 1.674, 1.674, 1.674, 1.674 },
/* 0.0955 */ {    6.616,  2.999,  2.404,  2.173, 2.051, 1.976, 1.926, 1.889, 1.862, 1.841, 1.823, 1.809, 1.798, 1.788, 1.779, 1.772, 1.765, 1.759, 1.754, 1.750, 1.746, 1.742, 1.738, 1.735, 1.733, 1.730, 1.728, 1.725, 1.723, 1.721, 1.707, 1.699, 1.694, 1.690, 1.687, 1.685, 1.683, 1.675, 1.672, 1.671, 1.670, 1.670, 1.669, 1.669, 1.669, 1.669 },
/* 0.0965 */ {    6.546,  2.981,  2.393,  2.164, 2.043, 1.969, 1.919, 1.883, 1.856, 1.834, 1.817, 1.803, 1.792, 1.782, 1.773, 1.766, 1.759, 1.754, 1.749, 1.744, 1.740, 1.736, 1.733, 1.730, 1.727, 1.724, 1.722, 1.720, 1.718, 1.716, 1.702, 1.694, 1.689, 1.685, 1.682, 1.680, 1.678, 1.670, 1.667, 1.666, 1.665, 1.665, 1.664, 1.664, 1.664, 1.664 },
/* 0.0975 */ {    6.478,  2.963,  2.381,  2.154, 2.035, 1.961, 1.912, 1.876, 1.849, 1.828, 1.811, 1.797, 1.786, 1.776, 1.767, 1.760, 1.754, 1.748, 1.743, 1.738, 1.734, 1.731, 1.727, 1.724, 1.722, 1.719, 1.717, 1.714, 1.712, 1.710, 1.697, 1.689, 1.683, 1.680, 1.677, 1.675, 1.673, 1.665, 1.662, 1.661, 1.660, 1.660, 1.659, 1.659, 1.659, 1.659 },
/* 0.0985 */ {    6.411,  2.946,  2.370,  2.145, 2.027, 1.954, 1.905, 1.869, 1.843, 1.822, 1.805, 1.791, 1.780, 1.770, 1.762, 1.754, 1.748, 1.742, 1.737, 1.733, 1.729, 1.725, 1.722, 1.719, 1.716, 1.714, 1.711, 1.709, 1.707, 1.705, 1.692, 1.684, 1.678, 1.674, 1.672, 1.669, 1.668, 1.660, 1.657, 1.656, 1.655, 1.655, 1.654, 1.654, 1.654, 1.654 },
/* 0.0995 */ {    6.346,  2.929,  2.359,  2.136, 2.019, 1.947, 1.898, 1.863, 1.836, 1.816, 1.799, 1.785, 1.774, 1.764, 1.756, 1.749, 1.742, 1.737, 1.732, 1.727, 1.723, 1.720, 1.717, 1.714, 1.711, 1.708, 1.706, 1.704, 1.702, 1.700, 1.686, 1.678, 1.673, 1.669, 1.667, 1.664, 1.663, 1.655, 1.652, 1.651, 1.650, 1.650, 1.649, 1.649, 1.649, 1.649 },
/* 0.1050 */ {    6.008,  2.838,  2.300,  2.089, 1.977, 1.908, 1.861, 1.828, 1.802, 1.782, 1.767, 1.753, 1.743, 1.733, 1.725, 1.718, 1.712, 1.707, 1.702, 1.698, 1.694, 1.691, 1.688, 1.685, 1.682, 1.680, 1.677, 1.675, 1.673, 1.672, 1.659, 1.651, 1.646, 1.642, 1.640, 1.638, 1.636, 1.628, 1.626, 1.625, 1.624, 1.624, 1.623, 1.623, 1.623, 1.623 },
/* 0.1150 */ {    5.475,  2.688,  2.202,  2.008, 1.906, 1.842, 1.799, 1.768, 1.745, 1.726, 1.712, 1.699, 1.689, 1.681, 1.673, 1.667, 1.661, 1.656, 1.652, 1.648, 1.644, 1.641, 1.638, 1.635, 1.633, 1.631, 1.629, 1.627, 1.625, 1.623, 1.611, 1.604, 1.599, 1.596, 1.593, 1.592, 1.590, 1.583, 1.581, 1.580, 1.579, 1.578, 1.578, 1.578, 1.578, 1.577 },
/* 0.1250 */ {    5.027,  2.556,  2.113,  1.936, 1.841, 1.782, 1.742, 1.713, 1.691, 1.674, 1.661, 1.649, 1.640, 1.632, 1.625, 1.619, 1.614, 1.609, 1.605, 1.601, 1.598, 1.595, 1.592, 1.590, 1.587, 1.585, 1.583, 1.581, 1.580, 1.578, 1.567, 1.560, 1.556, 1.553, 1.550, 1.549, 1.547, 1.541, 1.538, 1.537, 1.537, 1.536, 1.536, 1.536, 1.536, 1.535 },
/* 0.1350 */ {    4.645,  2.438,  2.033,  1.869, 1.781, 1.727, 1.689, 1.662, 1.642, 1.626, 1.613, 1.603, 1.594, 1.586, 1.580, 1.574, 1.569, 1.565, 1.561, 1.558, 1.555, 1.552, 1.549, 1.547, 1.545, 1.543, 1.541, 1.539, 1.538, 1.536, 1.526, 1.519, 1.515, 1.512, 1.510, 1.508, 1.507, 1.501, 1.499, 1.498, 1.497, 1.497, 1.496, 1.496, 1.496, 1.496 },
/* 0.1450 */ {    4.314,  2.331,  1.959,  1.807, 1.726, 1.675, 1.640, 1.615, 1.596, 1.581, 1.569, 1.559, 1.551, 1.544, 1.537, 1.532, 1.528, 1.524, 1.520, 1.517, 1.514, 1.511, 1.509, 1.506, 1.504, 1.503, 1.501, 1.499, 1.498, 1.496, 1.486, 1.481, 1.477, 1.474, 1.472, 1.470, 1.469, 1.463, 1.461, 1.460, 1.460, 1.459, 1.459, 1.459, 1.459, 1.459 },
/* 0.1550 */ {    4.026,  2.235,  1.891,  1.750, 1.674, 1.626, 1.594, 1.570, 1.552, 1.538, 1.527, 1.518, 1.510, 1.503, 1.498, 1.493, 1.488, 1.484, 1.481, 1.478, 1.475, 1.473, 1.470, 1.468, 1.466, 1.465, 1.463, 1.462, 1.460, 1.459, 1.449, 1.444, 1.440, 1.438, 1.436, 1.434, 1.433, 1.427, 1.426, 1.425, 1.424, 1.424, 1.424, 1.423, 1.423, 1.423 },
/* 0.1650 */ {    3.772,  2.146,  1.828,  1.697, 1.625, 1.581, 1.550, 1.528, 1.511, 1.498, 1.487, 1.479, 1.471, 1.465, 1.460, 1.455, 1.451, 1.447, 1.444, 1.441, 1.439, 1.436, 1.434, 1.432, 1.430, 1.429, 1.427, 1.426, 1.424, 1.423, 1.414, 1.409, 1.406, 1.403, 1.401, 1.400, 1.399, 1.394, 1.392, 1.391, 1.390, 1.390, 1.390, 1.390, 1.390, 1.389 },
/* 0.1750 */ {    3.546,  2.065,  1.769,  1.647, 1.580, 1.538, 1.509, 1.488, 1.472, 1.460, 1.450, 1.442, 1.435, 1.429, 1.424, 1.419, 1.415, 1.412, 1.409, 1.406, 1.404, 1.402, 1.400, 1.398, 1.396, 1.394, 1.393, 1.392, 1.390, 1.389, 1.381, 1.376, 1.373, 1.370, 1.368, 1.367, 1.366, 1.361, 1.360, 1.359, 1.358, 1.358, 1.358, 1.358, 1.357, 1.357 },
/* 0.1850 */ {    3.344,  1.989,  1.714,  1.599, 1.537, 1.497, 1.470, 1.450, 1.435, 1.424, 1.414, 1.406, 1.400, 1.394, 1.389, 1.385, 1.382, 1.378, 1.375, 1.373, 1.371, 1.368, 1.366, 1.365, 1.363, 1.362, 1.360, 1.359, 1.358, 1.357, 1.349, 1.344, 1.341, 1.339, 1.337, 1.336, 1.335, 1.330, 1.329, 1.328, 1.327, 1.327, 1.327, 1.327, 1.327, 1.326 },
/* 0.1950 */ {    3.162,  1.919,  1.662,  1.555, 1.496, 1.458, 1.433, 1.414, 1.400, 1.389, 1.380, 1.373, 1.366, 1.361, 1.357, 1.353, 1.349, 1.346, 1.343, 1.341, 1.339, 1.337, 1.335, 1.333, 1.332, 1.330, 1.329, 1.328, 1.327, 1.326, 1.318, 1.314, 1.311, 1.308, 1.307, 1.306, 1.305, 1.300, 1.299, 1.298, 1.298, 1.297, 1.297, 1.297, 1.297, 1.297 },
/* 0.2050 */ {    2.997,  1.853,  1.614,  1.512, 1.457, 1.422, 1.397, 1.380, 1.366, 1.356, 1.347, 1.340, 1.334, 1.329, 1.325, 1.321, 1.318, 1.315, 1.312, 1.310, 1.308, 1.306, 1.304, 1.303, 1.301, 1.300, 1.299, 1.298, 1.297, 1.296, 1.288, 1.284, 1.281, 1.279, 1.278, 1.277, 1.276, 1.272, 1.270, 1.270, 1.269, 1.269, 1.269, 1.268, 1.268, 1.268 },
/* 0.2150 */ {    2.848,  1.792,  1.567,  1.472, 1.419, 1.386, 1.363, 1.347, 1.334, 1.324, 1.316, 1.309, 1.304, 1.299, 1.295, 1.291, 1.288, 1.285, 1.283, 1.281, 1.279, 1.277, 1.275, 1.274, 1.272, 1.271, 1.270, 1.269, 1.268, 1.267, 1.260, 1.256, 1.253, 1.251, 1.250, 1.249, 1.248, 1.244, 1.243, 1.242, 1.242, 1.241, 1.241, 1.241, 1.241, 1.241 },
/* 0.2250 */ {    2.711,  1.734,  1.524,  1.434, 1.384, 1.352, 1.331, 1.315, 1.303, 1.293, 1.286, 1.279, 1.274, 1.269, 1.265, 1.262, 1.259, 1.256, 1.254, 1.252, 1.250, 1.248, 1.247, 1.245, 1.244, 1.243, 1.242, 1.241, 1.240, 1.239, 1.232, 1.229, 1.226, 1.224, 1.223, 1.222, 1.221, 1.217, 1.216, 1.215, 1.215, 1.215, 1.214, 1.214, 1.214, 1.214 },
/* 0.2350 */ {    2.585,  1.680,  1.482,  1.397, 1.350, 1.320, 1.299, 1.284, 1.273, 1.264, 1.256, 1.250, 1.245, 1.241, 1.237, 1.234, 1.231, 1.229, 1.226, 1.224, 1.223, 1.221, 1.220, 1.218, 1.217, 1.216, 1.215, 1.214, 1.213, 1.212, 1.206, 1.202, 1.200, 1.198, 1.197, 1.196, 1.195, 1.191, 1.190, 1.189, 1.189, 1.189, 1.189, 1.188, 1.188, 1.188 },
/* 0.2450 */ {    2.469,  1.628,  1.442,  1.361, 1.317, 1.289, 1.269, 1.255, 1.244, 1.235, 1.228, 1.222, 1.218, 1.214, 1.210, 1.207, 1.204, 1.202, 1.200, 1.198, 1.196, 1.195, 1.193, 1.192, 1.191, 1.189, 1.188, 1.188, 1.187, 1.186, 1.180, 1.176, 1.174, 1.172, 1.171, 1.170, 1.169, 1.166, 1.165, 1.164, 1.164, 1.164, 1.164, 1.163, 1.163, 1.163 },
/* 0.2550 */ {    2.362,  1.579,  1.404,  1.328, 1.285, 1.258, 1.240, 1.226, 1.216, 1.208, 1.201, 1.195, 1.191, 1.187, 1.184, 1.181, 1.178, 1.176, 1.174, 1.172, 1.170, 1.169, 1.167, 1.166, 1.165, 1.164, 1.163, 1.162, 1.161, 1.160, 1.155, 1.152, 1.149, 1.148, 1.147, 1.146, 1.145, 1.142, 1.140, 1.140, 1.140, 1.139, 1.139, 1.139, 1.139, 1.139 },
/* 0.2650 */ {    2.262,  1.533,  1.367,  1.295, 1.255, 1.229, 1.212, 1.199, 1.189, 1.181, 1.174, 1.169, 1.165, 1.161, 1.158, 1.155, 1.153, 1.150, 1.149, 1.147, 1.145, 1.144, 1.143, 1.141, 1.140, 1.139, 1.138, 1.137, 1.137, 1.136, 1.130, 1.127, 1.125, 1.124, 1.123, 1.122, 1.121, 1.118, 1.117, 1.116, 1.116, 1.116, 1.116, 1.115, 1.115, 1.115 },
/* 0.2750 */ {    2.169,  1.489,  1.332,  1.264, 1.225, 1.201, 1.184, 1.172, 1.162, 1.155, 1.149, 1.144, 1.140, 1.136, 1.133, 1.130, 1.128, 1.126, 1.124, 1.122, 1.121, 1.120, 1.118, 1.117, 1.116, 1.115, 1.114, 1.113, 1.113, 1.112, 1.107, 1.104, 1.102, 1.100, 1.099, 1.098, 1.098, 1.095, 1.094, 1.093, 1.093, 1.093, 1.092, 1.092, 1.092, 1.092 },
/* 0.2850 */ {    2.082,  1.446,  1.298,  1.233, 1.197, 1.174, 1.158, 1.146, 1.137, 1.130, 1.124, 1.119, 1.115, 1.112, 1.109, 1.106, 1.104, 1.102, 1.100, 1.099, 1.097, 1.096, 1.095, 1.094, 1.093, 1.092, 1.091, 1.090, 1.089, 1.089, 1.084, 1.081, 1.079, 1.077, 1.076, 1.076, 1.075, 1.072, 1.071, 1.071, 1.070, 1.070, 1.070, 1.070, 1.070, 1.070 },
/* 0.2950 */ {    2.001,  1.406,  1.266,  1.204, 1.169, 1.147, 1.132, 1.121, 1.112, 1.105, 1.100, 1.095, 1.091, 1.088, 1.085, 1.083, 1.081, 1.079, 1.077, 1.075, 1.074, 1.073, 1.072, 1.071, 1.070, 1.069, 1.068, 1.067, 1.066, 1.066, 1.061, 1.058, 1.056, 1.055, 1.054, 1.053, 1.053, 1.050, 1.049, 1.049, 1.048, 1.048, 1.048, 1.048, 1.048, 1.048 },
/* 0.3050 */ {    1.925,  1.367,  1.234,  1.175, 1.142, 1.121, 1.107, 1.096, 1.088, 1.081, 1.076, 1.072, 1.068, 1.065, 1.062, 1.060, 1.058, 1.056, 1.054, 1.053, 1.051, 1.050, 1.049, 1.048, 1.047, 1.046, 1.046, 1.045, 1.044, 1.044, 1.039, 1.036, 1.035, 1.033, 1.032, 1.032, 1.031, 1.028, 1.028, 1.027, 1.027, 1.027, 1.027, 1.026, 1.026, 1.026 },
/* 0.3150 */ {    1.853,  1.330,  1.204,  1.148, 1.116, 1.096, 1.082, 1.072, 1.064, 1.058, 1.053, 1.049, 1.045, 1.042, 1.040, 1.037, 1.035, 1.034, 1.032, 1.031, 1.029, 1.028, 1.027, 1.026, 1.025, 1.025, 1.024, 1.023, 1.022, 1.022, 1.018, 1.015, 1.013, 1.012, 1.011, 1.010, 1.010, 1.007, 1.006, 1.006, 1.006, 1.006, 1.006, 1.005, 1.005, 1.005 },
/* 0.3250 */ {    1.786,  1.294,  1.174,  1.121, 1.091, 1.072, 1.058, 1.049, 1.041, 1.035, 1.030, 1.026, 1.023, 1.020, 1.018, 1.015, 1.014, 1.012, 1.010, 1.009, 1.008, 1.007, 1.006, 1.005, 1.004, 1.003, 1.003, 1.002, 1.001, 1.001, 0.996, 0.994, 0.992, 0.991, 0.990, 0.990, 0.989, 0.987, 0.986, 0.985, 0.985, 0.985, 0.985, 0.985, 0.985, 0.985 },
/* 0.3350 */ {    1.722,  1.259,  1.146,  1.095, 1.066, 1.048, 1.035, 1.026, 1.019, 1.013, 1.008, 1.004, 1.001, 0.998, 0.996, 0.994, 0.992, 0.991, 0.989, 0.988, 0.987, 0.986, 0.985, 0.984, 0.983, 0.982, 0.982, 0.981, 0.980, 0.980, 0.976, 0.973, 0.972, 0.971, 0.970, 0.969, 0.969, 0.966, 0.966, 0.965, 0.965, 0.965, 0.965, 0.965, 0.965, 0.965 },
/* 0.3450 */ {    1.661,  1.226,  1.118,  1.070, 1.042, 1.025, 1.013, 1.004, 0.997, 0.991, 0.987, 0.983, 0.980, 0.977, 0.975, 0.973, 0.971, 0.970, 0.968, 0.967, 0.966, 0.965, 0.964, 0.963, 0.963, 0.962, 0.961, 0.961, 0.960, 0.959, 0.956, 0.953, 0.952, 0.951, 0.950, 0.949, 0.949, 0.947, 0.946, 0.945, 0.945, 0.945, 0.945, 0.945, 0.945, 0.945 },
/* 0.3550 */ {    1.603,  1.194,  1.091,  1.045, 1.019, 1.002, 0.990, 0.982, 0.975, 0.970, 0.966, 0.962, 0.959, 0.957, 0.954, 0.953, 0.951, 0.949, 0.948, 0.947, 0.946, 0.945, 0.944, 0.943, 0.942, 0.942, 0.941, 0.941, 0.940, 0.939, 0.936, 0.934, 0.932, 0.931, 0.930, 0.930, 0.929, 0.927, 0.926, 0.926, 0.926, 0.926, 0.926, 0.925, 0.925, 0.925 },
/* 0.3650 */ {    1.549,  1.162,  1.065,  1.021, 0.996, 0.980, 0.969, 0.960, 0.954, 0.949, 0.945, 0.942, 0.939, 0.936, 0.934, 0.932, 0.931, 0.929, 0.928, 0.927, 0.926, 0.925, 0.924, 0.923, 0.923, 0.922, 0.921, 0.921, 0.920, 0.920, 0.916, 0.914, 0.913, 0.912, 0.911, 0.910, 0.910, 0.908, 0.907, 0.907, 0.907, 0.907, 0.906, 0.906, 0.906, 0.906 },
/* 0.3750 */ {    1.497,  1.132,  1.039,  0.997, 0.974, 0.958, 0.947, 0.939, 0.933, 0.929, 0.925, 0.921, 0.919, 0.916, 0.914, 0.913, 0.911, 0.910, 0.908, 0.907, 0.906, 0.906, 0.905, 0.904, 0.903, 0.903, 0.902, 0.902, 0.901, 0.901, 0.897, 0.895, 0.894, 0.893, 0.892, 0.892, 0.891, 0.889, 0.888, 0.888, 0.888, 0.888, 0.888, 0.888, 0.888, 0.888 },
/* 0.3850 */ {    1.447,  1.103,  1.015,  0.974, 0.952, 0.937, 0.927, 0.919, 0.913, 0.908, 0.905, 0.902, 0.899, 0.897, 0.895, 0.893, 0.892, 0.890, 0.889, 0.888, 0.887, 0.886, 0.886, 0.885, 0.884, 0.884, 0.883, 0.883, 0.882, 0.882, 0.878, 0.876, 0.875, 0.874, 0.874, 0.873, 0.873, 0.871, 0.870, 0.870, 0.869, 0.869, 0.869, 0.869, 0.869, 0.869 },
/* 0.3950 */ {    1.399,  1.075,  0.990,  0.952, 0.930, 0.916, 0.906, 0.899, 0.893, 0.889, 0.885, 0.882, 0.880, 0.878, 0.876, 0.874, 0.873, 0.871, 0.870, 0.869, 0.868, 0.868, 0.867, 0.866, 0.865, 0.865, 0.864, 0.864, 0.863, 0.863, 0.860, 0.858, 0.857, 0.856, 0.855, 0.855, 0.854, 0.852, 0.852, 0.852, 0.851, 0.851, 0.851, 0.851, 0.851, 0.851 },
/* 0.4050 */ {    1.354,  1.047,  0.967,  0.930, 0.909, 0.896, 0.886, 0.879, 0.874, 0.869, 0.866, 0.863, 0.861, 0.859, 0.857, 0.855, 0.854, 0.853, 0.852, 0.851, 0.850, 0.849, 0.848, 0.848, 0.847, 0.846, 0.846, 0.845, 0.845, 0.845, 0.842, 0.840, 0.839, 0.838, 0.837, 0.837, 0.836, 0.834, 0.834, 0.834, 0.833, 0.833, 0.833, 0.833, 0.833, 0.833 },
/* 0.4150 */ {    1.310,  1.020,  0.944,  0.909, 0.888, 0.875, 0.866, 0.860, 0.854, 0.850, 0.847, 0.844, 0.842, 0.840, 0.838, 0.837, 0.836, 0.834, 0.833, 0.832, 0.832, 0.831, 0.830, 0.829, 0.829, 0.828, 0.828, 0.827, 0.827, 0.827, 0.824, 0.822, 0.821, 0.820, 0.819, 0.819, 0.819, 0.817, 0.816, 0.816, 0.816, 0.816, 0.816, 0.816, 0.816, 0.815 },
/* 0.4250 */ {    1.268,  0.994,  0.921,  0.887, 0.868, 0.856, 0.847, 0.841, 0.836, 0.832, 0.828, 0.826, 0.824, 0.822, 0.820, 0.819, 0.817, 0.816, 0.815, 0.814, 0.814, 0.813, 0.812, 0.812, 0.811, 0.811, 0.810, 0.810, 0.809, 0.809, 0.806, 0.804, 0.803, 0.802, 0.802, 0.801, 0.801, 0.799, 0.799, 0.799, 0.798, 0.798, 0.798, 0.798, 0.798, 0.798 },
/* 0.4350 */ {    1.228,  0.968,  0.899,  0.867, 0.848, 0.836, 0.828, 0.822, 0.817, 0.813, 0.810, 0.808, 0.806, 0.804, 0.802, 0.801, 0.800, 0.798, 0.798, 0.797, 0.796, 0.795, 0.795, 0.794, 0.793, 0.793, 0.792, 0.792, 0.792, 0.791, 0.789, 0.787, 0.786, 0.785, 0.785, 0.784, 0.784, 0.782, 0.782, 0.781, 0.781, 0.781, 0.781, 0.781, 0.781, 0.781 },
/* 0.4450 */ {    1.190,  0.944,  0.877,  0.846, 0.829, 0.817, 0.809, 0.803, 0.799, 0.795, 0.792, 0.790, 0.788, 0.786, 0.784, 0.783, 0.782, 0.781, 0.780, 0.779, 0.778, 0.778, 0.777, 0.777, 0.776, 0.776, 0.775, 0.775, 0.774, 0.774, 0.771, 0.770, 0.769, 0.768, 0.768, 0.767, 0.767, 0.765, 0.765, 0.765, 0.764, 0.764, 0.764, 0.764, 0.764, 0.764 },
/* 0.4550 */ {    1.152,  0.919,  0.856,  0.826, 0.810, 0.799, 0.791, 0.785, 0.781, 0.777, 0.774, 0.772, 0.770, 0.768, 0.767, 0.766, 0.765, 0.764, 0.763, 0.762, 0.761, 0.761, 0.760, 0.759, 0.759, 0.758, 0.758, 0.758, 0.757, 0.757, 0.754, 0.753, 0.752, 0.751, 0.751, 0.750, 0.750, 0.749, 0.748, 0.748, 0.748, 0.748, 0.748, 0.747, 0.747, 0.747 },
/* 0.4650 */ {    1.116,  0.896,  0.835,  0.807, 0.791, 0.780, 0.773, 0.767, 0.763, 0.760, 0.757, 0.755, 0.753, 0.751, 0.750, 0.749, 0.747, 0.747, 0.746, 0.745, 0.744, 0.744, 0.743, 0.742, 0.742, 0.742, 0.741, 0.741, 0.740, 0.740, 0.738, 0.736, 0.735, 0.735, 0.734, 0.734, 0.733, 0.732, 0.732, 0.731, 0.731, 0.731, 0.731, 0.731, 0.731, 0.731 },
/* 0.4750 */ {    1.082,  0.872,  0.815,  0.788, 0.772, 0.762, 0.755, 0.750, 0.745, 0.742, 0.740, 0.737, 0.736, 0.734, 0.733, 0.732, 0.731, 0.730, 0.729, 0.728, 0.727, 0.727, 0.726, 0.726, 0.725, 0.725, 0.724, 0.724, 0.724, 0.723, 0.721, 0.720, 0.719, 0.718, 0.718, 0.717, 0.717, 0.716, 0.715, 0.715, 0.715, 0.715, 0.715, 0.715, 0.715, 0.715 },
/* 0.4850 */ {    1.048,  0.850,  0.794,  0.769, 0.754, 0.744, 0.737, 0.732, 0.728, 0.725, 0.723, 0.721, 0.719, 0.717, 0.716, 0.715, 0.714, 0.713, 0.712, 0.711, 0.711, 0.710, 0.710, 0.709, 0.709, 0.708, 0.708, 0.708, 0.707, 0.707, 0.705, 0.704, 0.703, 0.702, 0.702, 0.701, 0.701, 0.700, 0.699, 0.699, 0.699, 0.699, 0.699, 0.699, 0.699, 0.699 },
/* 0.4950 */ {    1.016,  0.827,  0.775,  0.750, 0.736, 0.726, 0.720, 0.715, 0.711, 0.708, 0.706, 0.704, 0.702, 0.701, 0.699, 0.698, 0.697, 0.697, 0.696, 0.695, 0.694, 0.694, 0.693, 0.693, 0.693, 0.692, 0.692, 0.691, 0.691, 0.691, 0.689, 0.687, 0.687, 0.686, 0.686, 0.685, 0.685, 0.684, 0.683, 0.683, 0.683, 0.683, 0.683, 0.683, 0.683, 0.683 },
/* 0.5050 */ {    0.984,  0.806,  0.755,  0.732, 0.718, 0.709, 0.703, 0.698, 0.694, 0.691, 0.689, 0.687, 0.686, 0.684, 0.683, 0.682, 0.681, 0.680, 0.680, 0.679, 0.678, 0.678, 0.677, 0.677, 0.676, 0.676, 0.676, 0.675, 0.675, 0.675, 0.673, 0.671, 0.671, 0.670, 0.670, 0.669, 0.669, 0.668, 0.667, 0.667, 0.667, 0.667, 0.667, 0.667, 0.667, 0.667 },
/* 0.5150 */ {    0.954,  0.784,  0.736,  0.713, 0.700, 0.692, 0.686, 0.681, 0.678, 0.675, 0.673, 0.671, 0.669, 0.668, 0.667, 0.666, 0.665, 0.664, 0.663, 0.663, 0.662, 0.662, 0.661, 0.661, 0.660, 0.660, 0.660, 0.659, 0.659, 0.659, 0.657, 0.656, 0.655, 0.654, 0.654, 0.654, 0.653, 0.652, 0.652, 0.652, 0.652, 0.651, 0.651, 0.651, 0.651, 0.651 },
/* 0.5250 */ {    0.924,  0.763,  0.717,  0.696, 0.683, 0.675, 0.669, 0.665, 0.661, 0.659, 0.656, 0.655, 0.653, 0.652, 0.651, 0.650, 0.649, 0.648, 0.648, 0.647, 0.646, 0.646, 0.645, 0.645, 0.645, 0.644, 0.644, 0.644, 0.643, 0.643, 0.641, 0.640, 0.639, 0.639, 0.638, 0.638, 0.638, 0.637, 0.636, 0.636, 0.636, 0.636, 0.636, 0.636, 0.636, 0.636 },
/* 0.5350 */ {    0.896,  0.743,  0.699,  0.678, 0.666, 0.658, 0.652, 0.648, 0.645, 0.643, 0.640, 0.639, 0.637, 0.636, 0.635, 0.634, 0.633, 0.633, 0.632, 0.631, 0.631, 0.630, 0.630, 0.629, 0.629, 0.629, 0.628, 0.628, 0.628, 0.628, 0.626, 0.625, 0.624, 0.623, 0.623, 0.623, 0.623, 0.621, 0.621, 0.621, 0.621, 0.621, 0.621, 0.621, 0.621, 0.621 },
/* 0.5450 */ {    0.868,  0.723,  0.681,  0.661, 0.649, 0.641, 0.636, 0.632, 0.629, 0.627, 0.625, 0.623, 0.622, 0.620, 0.619, 0.618, 0.618, 0.617, 0.616, 0.616, 0.615, 0.615, 0.614, 0.614, 0.614, 0.613, 0.613, 0.613, 0.612, 0.612, 0.610, 0.609, 0.609, 0.608, 0.608, 0.608, 0.607, 0.606, 0.606, 0.606, 0.606, 0.606, 0.606, 0.606, 0.605, 0.605 },
/* 0.5550 */ {    0.841,  0.703,  0.663,  0.643, 0.632, 0.625, 0.620, 0.616, 0.613, 0.611, 0.609, 0.607, 0.606, 0.605, 0.604, 0.603, 0.602, 0.602, 0.601, 0.600, 0.600, 0.599, 0.599, 0.599, 0.598, 0.598, 0.598, 0.597, 0.597, 0.597, 0.595, 0.594, 0.594, 0.593, 0.593, 0.593, 0.592, 0.591, 0.591, 0.591, 0.591, 0.591, 0.591, 0.591, 0.591, 0.590 },
/* 0.5650 */ {    0.814,  0.683,  0.645,  0.626, 0.616, 0.609, 0.604, 0.600, 0.597, 0.595, 0.593, 0.592, 0.590, 0.589, 0.588, 0.588, 0.587, 0.586, 0.586, 0.585, 0.585, 0.584, 0.584, 0.584, 0.583, 0.583, 0.583, 0.582, 0.582, 0.582, 0.580, 0.579, 0.579, 0.578, 0.578, 0.578, 0.577, 0.576, 0.576, 0.576, 0.576, 0.576, 0.576, 0.576, 0.576, 0.576 },
/* 0.5750 */ {    0.788,  0.664,  0.627,  0.610, 0.599, 0.593, 0.588, 0.584, 0.582, 0.580, 0.578, 0.576, 0.575, 0.574, 0.573, 0.572, 0.572, 0.571, 0.571, 0.570, 0.570, 0.569, 0.569, 0.568, 0.568, 0.568, 0.568, 0.567, 0.567, 0.567, 0.565, 0.564, 0.564, 0.563, 0.563, 0.563, 0.563, 0.562, 0.561, 0.561, 0.561, 0.561, 0.561, 0.561, 0.561, 0.561 },
/* 0.5850 */ {    0.763,  0.645,  0.610,  0.593, 0.583, 0.577, 0.572, 0.569, 0.566, 0.564, 0.563, 0.561, 0.560, 0.559, 0.558, 0.557, 0.557, 0.556, 0.556, 0.555, 0.555, 0.554, 0.554, 0.554, 0.553, 0.553, 0.553, 0.552, 0.552, 0.552, 0.551, 0.550, 0.549, 0.549, 0.548, 0.548, 0.548, 0.547, 0.547, 0.547, 0.546, 0.546, 0.546, 0.546, 0.546, 0.546 },
/* 0.5950 */ {    0.739,  0.626,  0.593,  0.577, 0.567, 0.561, 0.557, 0.554, 0.551, 0.549, 0.547, 0.546, 0.545, 0.544, 0.543, 0.542, 0.542, 0.541, 0.541, 0.540, 0.540, 0.539, 0.539, 0.539, 0.538, 0.538, 0.538, 0.538, 0.538, 0.537, 0.536, 0.535, 0.534, 0.534, 0.534, 0.534, 0.533, 0.532, 0.532, 0.532, 0.532, 0.532, 0.532, 0.532, 0.532, 0.532 },
/* 0.6050 */ {    0.715,  0.608,  0.576,  0.561, 0.552, 0.546, 0.541, 0.538, 0.536, 0.534, 0.532, 0.531, 0.530, 0.529, 0.528, 0.528, 0.527, 0.526, 0.526, 0.526, 0.525, 0.525, 0.524, 0.524, 0.524, 0.524, 0.523, 0.523, 0.523, 0.523, 0.521, 0.521, 0.520, 0.520, 0.519, 0.519, 0.519, 0.518, 0.518, 0.518, 0.518, 0.517, 0.517, 0.517, 0.517, 0.517 },
/* 0.6150 */ {    0.691,  0.590,  0.559,  0.545, 0.536, 0.530, 0.526, 0.523, 0.521, 0.519, 0.518, 0.516, 0.515, 0.514, 0.514, 0.513, 0.512, 0.512, 0.511, 0.511, 0.511, 0.510, 0.510, 0.510, 0.509, 0.509, 0.509, 0.509, 0.508, 0.508, 0.507, 0.506, 0.506, 0.505, 0.505, 0.505, 0.505, 0.504, 0.503, 0.503, 0.503, 0.503, 0.503, 0.503, 0.503, 0.503 },
/* 0.6250 */ {    0.668,  0.572,  0.543,  0.529, 0.520, 0.515, 0.511, 0.508, 0.506, 0.504, 0.503, 0.502, 0.501, 0.500, 0.499, 0.498, 0.498, 0.497, 0.497, 0.496, 0.496, 0.496, 0.495, 0.495, 0.495, 0.495, 0.494, 0.494, 0.494, 0.494, 0.493, 0.492, 0.491, 0.491, 0.491, 0.490, 0.490, 0.490, 0.489, 0.489, 0.489, 0.489, 0.489, 0.489, 0.489, 0.489 },
/* 0.6350 */ {    0.646,  0.554,  0.526,  0.513, 0.505, 0.500, 0.496, 0.493, 0.491, 0.490, 0.488, 0.487, 0.486, 0.485, 0.485, 0.484, 0.483, 0.483, 0.482, 0.482, 0.482, 0.481, 0.481, 0.481, 0.481, 0.480, 0.480, 0.480, 0.480, 0.480, 0.478, 0.478, 0.477, 0.477, 0.477, 0.476, 0.476, 0.475, 0.475, 0.475, 0.475, 0.475, 0.475, 0.475, 0.475, 0.475 },
/* 0.6450 */ {    0.624,  0.537,  0.510,  0.497, 0.490, 0.485, 0.481, 0.479, 0.477, 0.475, 0.474, 0.473, 0.472, 0.471, 0.470, 0.470, 0.469, 0.469, 0.468, 0.468, 0.467, 0.467, 0.467, 0.467, 0.466, 0.466, 0.466, 0.466, 0.466, 0.465, 0.464, 0.464, 0.463, 0.463, 0.462, 0.462, 0.462, 0.461, 0.461, 0.461, 0.461, 0.461, 0.461, 0.461, 0.461, 0.461 },
/* 0.6550 */ {    0.602,  0.520,  0.494,  0.482, 0.475, 0.470, 0.467, 0.464, 0.462, 0.461, 0.459, 0.458, 0.457, 0.457, 0.456, 0.455, 0.455, 0.454, 0.454, 0.454, 0.453, 0.453, 0.453, 0.452, 0.452, 0.452, 0.452, 0.452, 0.451, 0.451, 0.450, 0.450, 0.449, 0.449, 0.449, 0.448, 0.448, 0.447, 0.447, 0.447, 0.447, 0.447, 0.447, 0.447, 0.447, 0.447 },
/* 0.6650 */ {    0.581,  0.503,  0.479,  0.467, 0.460, 0.455, 0.452, 0.449, 0.448, 0.446, 0.445, 0.444, 0.443, 0.442, 0.442, 0.441, 0.441, 0.440, 0.440, 0.440, 0.439, 0.439, 0.439, 0.438, 0.438, 0.438, 0.438, 0.438, 0.437, 0.437, 0.436, 0.436, 0.435, 0.435, 0.435, 0.434, 0.434, 0.434, 0.433, 0.433, 0.433, 0.433, 0.433, 0.433, 0.433, 0.433 },
/* 0.6750 */ {    0.560,  0.486,  0.463,  0.452, 0.445, 0.441, 0.437, 0.435, 0.433, 0.432, 0.431, 0.430, 0.429, 0.428, 0.428, 0.427, 0.427, 0.426, 0.426, 0.426, 0.425, 0.425, 0.425, 0.424, 0.424, 0.424, 0.424, 0.424, 0.424, 0.423, 0.422, 0.422, 0.421, 0.421, 0.421, 0.421, 0.421, 0.420, 0.420, 0.420, 0.420, 0.420, 0.419, 0.419, 0.419, 0.419 },
/* 0.6850 */ {    0.540,  0.469,  0.447,  0.437, 0.430, 0.426, 0.423, 0.421, 0.419, 0.418, 0.417, 0.416, 0.415, 0.414, 0.414, 0.413, 0.413, 0.412, 0.412, 0.412, 0.411, 0.411, 0.411, 0.411, 0.410, 0.410, 0.410, 0.410, 0.410, 0.410, 0.409, 0.408, 0.408, 0.407, 0.407, 0.407, 0.407, 0.406, 0.406, 0.406, 0.406, 0.406, 0.406, 0.406, 0.406, 0.406 },
/* 0.6950 */ {    0.519,  0.453,  0.432,  0.422, 0.416, 0.412, 0.409, 0.407, 0.405, 0.404, 0.403, 0.402, 0.401, 0.400, 0.400, 0.399, 0.399, 0.398, 0.398, 0.398, 0.398, 0.397, 0.397, 0.397, 0.397, 0.396, 0.396, 0.396, 0.396, 0.396, 0.395, 0.394, 0.394, 0.394, 0.393, 0.393, 0.393, 0.393, 0.392, 0.392, 0.392, 0.392, 0.392, 0.392, 0.392, 0.392 },
/* 0.7050 */ {    0.500,  0.437,  0.417,  0.407, 0.401, 0.397, 0.394, 0.392, 0.391, 0.390, 0.389, 0.388, 0.387, 0.386, 0.386, 0.385, 0.385, 0.385, 0.384, 0.384, 0.384, 0.384, 0.383, 0.383, 0.383, 0.383, 0.383, 0.382, 0.382, 0.382, 0.381, 0.381, 0.380, 0.380, 0.380, 0.380, 0.380, 0.379, 0.379, 0.379, 0.379, 0.379, 0.379, 0.379, 0.379, 0.379 },
/* 0.7150 */ {    0.480,  0.420,  0.401,  0.392, 0.387, 0.383, 0.380, 0.378, 0.377, 0.376, 0.375, 0.374, 0.373, 0.373, 0.372, 0.372, 0.371, 0.371, 0.371, 0.370, 0.370, 0.370, 0.370, 0.369, 0.369, 0.369, 0.369, 0.369, 0.369, 0.369, 0.368, 0.367, 0.367, 0.367, 0.366, 0.366, 0.366, 0.366, 0.365, 0.365, 0.365, 0.365, 0.365, 0.365, 0.365, 0.365 },
/* 0.7250 */ {    0.461,  0.405,  0.386,  0.377, 0.372, 0.369, 0.366, 0.364, 0.363, 0.362, 0.361, 0.360, 0.359, 0.359, 0.358, 0.358, 0.358, 0.357, 0.357, 0.357, 0.357, 0.356, 0.356, 0.356, 0.356, 0.356, 0.355, 0.355, 0.355, 0.355, 0.354, 0.354, 0.353, 0.353, 0.353, 0.353, 0.353, 0.352, 0.352, 0.352, 0.352, 0.352, 0.352, 0.352, 0.352, 0.352 },
/* 0.7350 */ {    0.442,  0.389,  0.371,  0.363, 0.358, 0.355, 0.352, 0.351, 0.349, 0.348, 0.347, 0.346, 0.346, 0.345, 0.345, 0.344, 0.344, 0.344, 0.343, 0.343, 0.343, 0.343, 0.343, 0.342, 0.342, 0.342, 0.342, 0.342, 0.342, 0.342, 0.341, 0.340, 0.340, 0.340, 0.340, 0.340, 0.339, 0.339, 0.339, 0.339, 0.339, 0.339, 0.339, 0.339, 0.339, 0.339 },
/* 0.7450 */ {    0.423,  0.373,  0.357,  0.349, 0.344, 0.341, 0.338, 0.337, 0.335, 0.334, 0.334, 0.333, 0.332, 0.332, 0.331, 0.331, 0.331, 0.330, 0.330, 0.330, 0.330, 0.329, 0.329, 0.329, 0.329, 0.329, 0.329, 0.328, 0.328, 0.328, 0.327, 0.327, 0.327, 0.327, 0.326, 0.326, 0.326, 0.326, 0.326, 0.325, 0.325, 0.325, 0.325, 0.325, 0.325, 0.325 },
/* 0.7550 */ {    0.405,  0.357,  0.342,  0.334, 0.330, 0.327, 0.325, 0.323, 0.322, 0.321, 0.320, 0.319, 0.319, 0.318, 0.318, 0.317, 0.317, 0.317, 0.317, 0.316, 0.316, 0.316, 0.316, 0.316, 0.316, 0.315, 0.315, 0.315, 0.315, 0.315, 0.314, 0.314, 0.313, 0.313, 0.313, 0.313, 0.313, 0.312, 0.312, 0.312, 0.312, 0.312, 0.312, 0.312, 0.312, 0.312 },
/* 0.7650 */ {    0.387,  0.342,  0.327,  0.320, 0.316, 0.313, 0.311, 0.309, 0.308, 0.307, 0.306, 0.306, 0.305, 0.305, 0.304, 0.304, 0.304, 0.303, 0.303, 0.303, 0.303, 0.303, 0.302, 0.302, 0.302, 0.302, 0.302, 0.302, 0.302, 0.302, 0.301, 0.301, 0.300, 0.300, 0.300, 0.300, 0.300, 0.299, 0.299, 0.299, 0.299, 0.299, 0.299, 0.299, 0.299, 0.299 },
/* 0.7750 */ {    0.369,  0.327,  0.313,  0.306, 0.302, 0.299, 0.297, 0.296, 0.295, 0.294, 0.293, 0.292, 0.292, 0.291, 0.291, 0.291, 0.290, 0.290, 0.290, 0.290, 0.290, 0.289, 0.289, 0.289, 0.289, 0.289, 0.289, 0.289, 0.289, 0.288, 0.288, 0.287, 0.287, 0.287, 0.287, 0.287, 0.287, 0.286, 0.286, 0.286, 0.286, 0.286, 0.286, 0.286, 0.286, 0.286 },
/* 0.7850 */ {    0.351,  0.311,  0.298,  0.292, 0.288, 0.285, 0.283, 0.282, 0.281, 0.280, 0.280, 0.279, 0.279, 0.278, 0.278, 0.277, 0.277, 0.277, 0.277, 0.277, 0.276, 0.276, 0.276, 0.276, 0.276, 0.276, 0.276, 0.275, 0.275, 0.275, 0.275, 0.274, 0.274, 0.274, 0.274, 0.274, 0.274, 0.273, 0.273, 0.273, 0.273, 0.273, 0.273, 0.273, 0.273, 0.273 },
/* 0.7950 */ {    0.334,  0.296,  0.284,  0.278, 0.274, 0.272, 0.270, 0.269, 0.268, 0.267, 0.266, 0.266, 0.265, 0.265, 0.264, 0.264, 0.264, 0.264, 0.264, 0.263, 0.263, 0.263, 0.263, 0.263, 0.263, 0.263, 0.262, 0.262, 0.262, 0.262, 0.262, 0.261, 0.261, 0.261, 0.261, 0.261, 0.261, 0.260, 0.260, 0.260, 0.260, 0.260, 0.260, 0.260, 0.260, 0.260 },
/* 0.8050 */ {    0.316,  0.281,  0.270,  0.264, 0.260, 0.258, 0.256, 0.255, 0.254, 0.254, 0.253, 0.252, 0.252, 0.252, 0.251, 0.251, 0.251, 0.251, 0.250, 0.250, 0.250, 0.250, 0.250, 0.250, 0.250, 0.249, 0.249, 0.249, 0.249, 0.249, 0.249, 0.248, 0.248, 0.248, 0.248, 0.248, 0.248, 0.247, 0.247, 0.247, 0.247, 0.247, 0.247, 0.247, 0.247, 0.247 },
/* 0.8150 */ {    0.299,  0.266,  0.255,  0.250, 0.247, 0.244, 0.243, 0.242, 0.241, 0.240, 0.240, 0.239, 0.239, 0.238, 0.238, 0.238, 0.238, 0.237, 0.237, 0.237, 0.237, 0.237, 0.237, 0.237, 0.236, 0.236, 0.236, 0.236, 0.236, 0.236, 0.236, 0.235, 0.235, 0.235, 0.235, 0.235, 0.235, 0.234, 0.234, 0.234, 0.234, 0.234, 0.234, 0.234, 0.234, 0.234 },
/* 0.8250 */ {    0.282,  0.251,  0.241,  0.236, 0.233, 0.231, 0.230, 0.228, 0.228, 0.227, 0.226, 0.226, 0.226, 0.225, 0.225, 0.225, 0.225, 0.224, 0.224, 0.224, 0.224, 0.224, 0.224, 0.224, 0.223, 0.223, 0.223, 0.223, 0.223, 0.223, 0.223, 0.222, 0.222, 0.222, 0.222, 0.222, 0.222, 0.221, 0.221, 0.221, 0.221, 0.221, 0.221, 0.221, 0.221, 0.221 },
/* 0.8350 */ {    0.265,  0.237,  0.227,  0.222, 0.219, 0.218, 0.216, 0.215, 0.214, 0.214, 0.213, 0.213, 0.213, 0.212, 0.212, 0.212, 0.212, 0.211, 0.211, 0.211, 0.211, 0.211, 0.211, 0.211, 0.210, 0.210, 0.210, 0.210, 0.210, 0.210, 0.210, 0.209, 0.209, 0.209, 0.209, 0.209, 0.209, 0.209, 0.208, 0.208, 0.208, 0.208, 0.208, 0.208, 0.208, 0.208 },
/* 0.8450 */ {    0.248,  0.222,  0.213,  0.209, 0.206, 0.204, 0.203, 0.202, 0.201, 0.201, 0.200, 0.200, 0.199, 0.199, 0.199, 0.199, 0.199, 0.198, 0.198, 0.198, 0.198, 0.198, 0.198, 0.198, 0.198, 0.197, 0.197, 0.197, 0.197, 0.197, 0.197, 0.197, 0.196, 0.196, 0.196, 0.196, 0.196, 0.196, 0.196, 0.196, 0.196, 0.196, 0.196, 0.196, 0.196, 0.196 },
/* 0.8550 */ {    0.232,  0.207,  0.199,  0.195, 0.192, 0.191, 0.190, 0.189, 0.188, 0.188, 0.187, 0.187, 0.186, 0.186, 0.186, 0.186, 0.186, 0.185, 0.185, 0.185, 0.185, 0.185, 0.185, 0.185, 0.185, 0.185, 0.185, 0.184, 0.184, 0.184, 0.184, 0.184, 0.184, 0.183, 0.183, 0.183, 0.183, 0.183, 0.183, 0.183, 0.183, 0.183, 0.183, 0.183, 0.183, 0.183 },
/* 0.8650 */ {    0.215,  0.193,  0.185,  0.181, 0.179, 0.177, 0.176, 0.176, 0.175, 0.174, 0.174, 0.174, 0.173, 0.173, 0.173, 0.173, 0.173, 0.172, 0.172, 0.172, 0.172, 0.172, 0.172, 0.172, 0.172, 0.172, 0.172, 0.172, 0.172, 0.171, 0.171, 0.171, 0.171, 0.171, 0.171, 0.170, 0.170, 0.170, 0.170, 0.170, 0.170, 0.170, 0.170, 0.170, 0.170, 0.170 },
/* 0.8750 */ {    0.199,  0.178,  0.171,  0.168, 0.166, 0.164, 0.163, 0.162, 0.162, 0.161, 0.161, 0.161, 0.160, 0.160, 0.160, 0.160, 0.160, 0.160, 0.159, 0.159, 0.159, 0.159, 0.159, 0.159, 0.159, 0.159, 0.159, 0.159, 0.159, 0.159, 0.158, 0.158, 0.158, 0.158, 0.158, 0.158, 0.158, 0.158, 0.157, 0.157, 0.157, 0.157, 0.157, 0.157, 0.157, 0.157 },
/* 0.8850 */ {    0.183,  0.164,  0.157,  0.154, 0.152, 0.151, 0.150, 0.149, 0.149, 0.148, 0.148, 0.148, 0.148, 0.147, 0.147, 0.147, 0.147, 0.147, 0.147, 0.146, 0.146, 0.146, 0.146, 0.146, 0.146, 0.146, 0.146, 0.146, 0.146, 0.146, 0.146, 0.145, 0.145, 0.145, 0.145, 0.145, 0.145, 0.145, 0.145, 0.145, 0.145, 0.145, 0.145, 0.145, 0.145, 0.145 },
/* 0.8950 */ {    0.166,  0.149,  0.143,  0.141, 0.139, 0.138, 0.137, 0.136, 0.136, 0.135, 0.135, 0.135, 0.135, 0.134, 0.134, 0.134, 0.134, 0.134, 0.134, 0.134, 0.134, 0.134, 0.133, 0.133, 0.133, 0.133, 0.133, 0.133, 0.133, 0.133, 0.133, 0.133, 0.133, 0.132, 0.132, 0.132, 0.132, 0.132, 0.132, 0.132, 0.132, 0.132, 0.132, 0.132, 0.132, 0.132 },
/* 0.9050 */ {    0.150,  0.135,  0.130,  0.127, 0.126, 0.124, 0.124, 0.123, 0.123, 0.122, 0.122, 0.122, 0.122, 0.122, 0.121, 0.121, 0.121, 0.121, 0.121, 0.121, 0.121, 0.121, 0.121, 0.121, 0.121, 0.121, 0.120, 0.120, 0.120, 0.120, 0.120, 0.120, 0.120, 0.120, 0.120, 0.120, 0.120, 0.119, 0.119, 0.119, 0.119, 0.119, 0.119, 0.119, 0.119, 0.119 },
/* 0.9150 */ {    0.134,  0.121,  0.116,  0.114, 0.112, 0.111, 0.111, 0.110, 0.110, 0.109, 0.109, 0.109, 0.109, 0.109, 0.109, 0.108, 0.108, 0.108, 0.108, 0.108, 0.108, 0.108, 0.108, 0.108, 0.108, 0.108, 0.108, 0.108, 0.108, 0.108, 0.107, 0.107, 0.107, 0.107, 0.107, 0.107, 0.107, 0.107, 0.107, 0.107, 0.107, 0.107, 0.107, 0.107, 0.107, 0.107 },
/* 0.9250 */ {    0.118,  0.106,  0.102,  0.100, 0.099, 0.098, 0.098, 0.097, 0.097, 0.097, 0.096, 0.096, 0.096, 0.096, 0.096, 0.096, 0.096, 0.095, 0.095, 0.095, 0.095, 0.095, 0.095, 0.095, 0.095, 0.095, 0.095, 0.095, 0.095, 0.095, 0.095, 0.095, 0.095, 0.094, 0.094, 0.094, 0.094, 0.094, 0.094, 0.094, 0.094, 0.094, 0.094, 0.094, 0.094, 0.094 },
/* 0.9350 */ {    0.102,  0.092,  0.089,  0.087, 0.086, 0.085, 0.085, 0.084, 0.084, 0.084, 0.083, 0.083, 0.083, 0.083, 0.083, 0.083, 0.083, 0.083, 0.083, 0.083, 0.083, 0.082, 0.082, 0.082, 0.082, 0.082, 0.082, 0.082, 0.082, 0.082, 0.082, 0.082, 0.082, 0.082, 0.082, 0.082, 0.082, 0.082, 0.082, 0.082, 0.082, 0.082, 0.082, 0.082, 0.082, 0.082 },
/* 0.9450 */ {    0.087,  0.078,  0.075,  0.073, 0.073, 0.072, 0.071, 0.071, 0.071, 0.071, 0.071, 0.070, 0.070, 0.070, 0.070, 0.070, 0.070, 0.070, 0.070, 0.070, 0.070, 0.070, 0.070, 0.070, 0.070, 0.070, 0.070, 0.070, 0.070, 0.070, 0.069, 0.069, 0.069, 0.069, 0.069, 0.069, 0.069, 0.069, 0.069, 0.069, 0.069, 0.069, 0.069, 0.069, 0.069, 0.069 },
/* 0.9550 */ {    0.071,  0.064,  0.061,  0.060, 0.059, 0.059, 0.058, 0.058, 0.058, 0.058, 0.058, 0.058, 0.058, 0.057, 0.057, 0.057, 0.057, 0.057, 0.057, 0.057, 0.057, 0.057, 0.057, 0.057, 0.057, 0.057, 0.057, 0.057, 0.057, 0.057, 0.057, 0.057, 0.057, 0.057, 0.057, 0.057, 0.057, 0.056, 0.056, 0.056, 0.056, 0.056, 0.056, 0.056, 0.056, 0.056 },
/* 0.9650 */ {    0.055,  0.050,  0.048,  0.047, 0.046, 0.046, 0.045, 0.045, 0.045, 0.045, 0.045, 0.045, 0.045, 0.045, 0.045, 0.045, 0.045, 0.044, 0.044, 0.044, 0.044, 0.044, 0.044, 0.044, 0.044, 0.044, 0.044, 0.044, 0.044, 0.044, 0.044, 0.044, 0.044, 0.044, 0.044, 0.044, 0.044, 0.044, 0.044, 0.044, 0.044, 0.044, 0.044, 0.044, 0.044, 0.044 },
/* 0.9750 */ {    0.039,  0.035,  0.034,  0.033, 0.033, 0.033, 0.032, 0.032, 0.032, 0.032, 0.032, 0.032, 0.032, 0.032, 0.032, 0.032, 0.032, 0.032, 0.032, 0.032, 0.032, 0.032, 0.032, 0.032, 0.032, 0.032, 0.032, 0.032, 0.032, 0.032, 0.032, 0.031, 0.031, 0.031, 0.031, 0.031, 0.031, 0.031, 0.031, 0.031, 0.031, 0.031, 0.031, 0.031, 0.031, 0.031 },
/* 0.9850 */ {    0.024,  0.021,  0.020,  0.020, 0.020, 0.020, 0.019, 0.019, 0.019, 0.019, 0.019, 0.019, 0.019, 0.019, 0.019, 0.019, 0.019, 0.019, 0.019, 0.019, 0.019, 0.019, 0.019, 0.019, 0.019, 0.019, 0.019, 0.019, 0.019, 0.019, 0.019, 0.019, 0.019, 0.019, 0.019, 0.019, 0.019, 0.019, 0.019, 0.019, 0.019, 0.019, 0.019, 0.019, 0.019, 0.019 },
/* 0.9950 */ {    0.008,  0.007,  0.007,  0.007, 0.007, 0.007, 0.006, 0.006, 0.006, 0.006, 0.006, 0.006, 0.006, 0.006, 0.006, 0.006, 0.006, 0.006, 0.006, 0.006, 0.006, 0.006, 0.006, 0.006, 0.006, 0.006, 0.006, 0.006, 0.006, 0.006, 0.006, 0.006, 0.006, 0.006, 0.006, 0.006, 0.006, 0.006, 0.006, 0.006, 0.006, 0.006, 0.006, 0.006, 0.006, 0.006 }};

static void df_to_index(float df, int *index1_p, float *weight1_p) {
	int index1;
	float indexf;

	assert(df >= 1);
	assert(index1_p);
	assert(weight1_p);

	/* as there are more degrees of freedom, the distribution resembles
	 * the normal distribution more and more so adding a single df matters
	 * less and less; hence the partial function and upper boundary here
	 */
	if (df <= 30) {
		indexf = df - 1;
	} else if (df <= 100) {
		indexf = (df - 30) / 10 + 29;
	} else {
		indexf = (df - 100) / 100 + 36;
	}

	index1 = (int) floor(indexf);
	if (index1 >= 45) {
		*index1_p = 44;
		*weight1_p = 0;
	} else {
		*index1_p = index1;
		*weight1_p = 1 - (indexf - index1);
	}
}

static float get_t(int p_index, int df_index1, float df_weight1) {
	/* get t-value from t_value_by_p_and_df, using linear interpolation for
	 * missing degrees of freedom values
	 */
	assert(p_index >= 0 && p_index < 190);
	assert(df_index1 >= 0 && df_index1 < 45);
	return t_value_by_p_and_df[p_index][df_index1] * df_weight1 +
		t_value_by_p_and_df[p_index][df_index1 + 1] * (1 - df_weight1);
}

static float index_to_p(int index) {
	if (index < 100) {
		return 0.0010 * index + 0.0005;
	} else {
		return 0.0100 * (index - 100) + 0.1050;
	}
}

static float linear(float x, float x1, float y1, float x2, float y2) {
	if (x2 == x1) {
		assert(x == x1);
		return (y1 + y2) / 2;
	} else {
		return (x - x1) / (x2 - x1) * (y2 - y1) + y1;
	}
}
