<?php
	require_once( realpath(dirname(__FILE__)).'/../../ezpdo_runtime.php');
	require_once( realpath(dirname(__FILE__)).'/../../src/compiler/epComment.php');
	require_once( realpath(dirname(__FILE__)).'/../../libs/simpletest/unit_tester.php');
	require_once( realpath(dirname(__FILE__)).'/../../libs/simpletest/reporter.php');
	
	class RelationShipParseTest extends UnitTestCase{
		function RelationShipParseTest(){
			$this->UnitTestCase('RelationShip Parse test');
		}
		
		function TestForeignKeyParse(){
			/*
	  		 * create fake var comment  
	  		 */	
	  		$comment = '/**';
	  		$comment .= '* @orm has one Author';
	  		$comment .= '* @dbva fk(authorID) id(autogenerate)';
	  		$comment .= '*/';
	  		$c = new epComment($comment);
	  		$value = $c->getTagValue('dbva');
	  		$this->assertTrue(stristr($value, 'fk(authorID)'));
	  		$t = new dbvaVarTag($value);
	  		$this->assertTrue($t);
	  		$this->assertTrue($t->get('fk'));
	  		
	  		$comment = '/**';
	  		$comment .= '* @orm has many Book';
	  		$comment .= '* @dbva id(assigned) inverse(authorvar)';
	  		$comment .= '*/';
	  		
	  		$c = new epComment($comment);
	  		$value = $c->getTagValue('dbva');
	  		$this->assertTrue(stristr($value, 'inverse(authorvar)'));
	  		$t = new dbvaVarTag($value);
	  		$this->assertTrue($t);
	  		$this->assertTrue($t->get('inverse'));
	  		$this->assertTrue($t->get('id') == true);
	  		$this->assertTrue($t->get('id_type') == 'assigned');
	  		
	  		$comment = '/**';
	  		$comment .= '* @orm has many Book';
	  		$comment .= '* @dbva fk(col,col2) id(assigned) jointable(abc)';
	  		$comment .= '*/';
	  		$c = new epComment($comment);
	  		$value = $c->getTagValue('dbva');
	  		$t = new dbvaVarTag($value);
	  		$this->assertTrue($t);
	  		$this->assertTrue($t->get('id'));
	  		$this->assertTrue($t->get('id_type') == 'assigned');
	  		$this->assertTrue($t->get('jointable') == 'abc');
	  		$this->assertTrue(is_array($t->get('fk')));
		}
	}
	$test = &new RelationShipParseTest();
  	$test->run(new HtmlReporter());
?>
