<?php
require_once (realpath(dirname(__FILE__)).'/../../ezpdo_runtime.php');
require_once (realpath(dirname(__FILE__)).'/../../src/compiler/epComment.php');
require_once (realpath(dirname(__FILE__)).'/../../libs/simpletest/unit_tester.php');
require_once (realpath(dirname(__FILE__)).'/../../libs/simpletest/reporter.php');

class PrimitiveArrayParseTest extends UnitTestCase {
	function PrimitiveArrayParseTest() {
		$this->UnitTestCase('Primitive Array Parse Test');
	}

	function testArrayParse() {
		$comment = '/**';
		$comment .= '* @var string';
		$comment .= '* @orm contactNo char';
		$comment .= '* @dbva array(keyColumn(a,b),index(p_index,int),p_table)';
		$comment .= '*/';

		$c = new epComment($comment);
		$value = $c->getTagValue('dbva');
		$this->assertTrue(stristr($value, 'array(keyColumn(a,b),index(p_index,int),p_table)'));

		$t = new dbvaVarTag($value);
		$this->assertTrue($t);
		$this->assertEqual($t->get('array_table'), 'p_table');
		$this->assertEqual($t->get('array_index'), 'p_index');
		$this->assertEqual($t->get('array_index_type'), 'int');
		echo 'index : '.$t->get('array_index').'<br>';
		print_r($t->get('array_fk'));
		
		
		$comment = '/**';
		$comment .= '* @var string';
		$comment .= '* @orm contactNo char';
		$comment .= '* @dbva array(keyColumn(a,b),index(p_index,int))';
		$comment .= '*/';
		
		$c = new epComment($comment);
		$value = $c->getTagValue('dbva');
		$this->assertTrue(stristr($value, 'array(keyColumn(a,b),index(p_index,int))'));

		$t = new dbvaVarTag($value);
		$this->assertTrue($t);
		$this->assertNull($t->get('array_table'));
		$this->assertEqual($t->get('array_index'), 'p_index');
		$this->assertEqual($t->get('array_index_type'), 'int');
		echo 'index : '.$t->get('array_index').'<br>';
		print_r($t->get('array_fk'));
	}
}
$test = & new PrimitiveArrayParseTest();
$test->run(new HtmlReporter());
?>




