<?php
require_once (realpath(dirname(__FILE__)).'/../../ezpdo_runtime.php');
require_once (realpath(dirname(__FILE__)).'/../../src/compiler/epComment.php');
require_once (realpath(dirname(__FILE__)).'/../../libs/simpletest/unit_tester.php');
require_once (realpath(dirname(__FILE__)).'/../../libs/simpletest/reporter.php');

class ORMImplementationParseTest extends UnitTestCase {
	function ORMImplementationParseTest() {
		$this->UnitTestCase('ORM Implementation Parse test');
	}
	
	function testClassCommentParseWithName() {
		$comment = '/**';
		$comment .= '* @dbva implementation(CustomerImpl)';
		$comment .= '*';
		$comment .= '*/';

		$c = new epComment($comment);
		$value = $c->getTagValue('dbva');
		$this->assertTrue(stristr($value, 'implementation(CustomerImpl)'));
		$t = new dbvaClassTag($value);
		$this->assertTrue($t);
		$this->assertTrue($t->get('implementation'));
	}
}
$test = & new ORMImplementationParseTest();
$test->run(new HtmlReporter());
?>






