<?php
require_once (realpath(dirname(__FILE__)).'/../../ezpdo_runtime.php');
require_once (realpath(dirname(__FILE__)).'/../../src/compiler/epComment.php');
require_once (realpath(dirname(__FILE__)).'/../../libs/simpletest/unit_tester.php');
require_once (realpath(dirname(__FILE__)).'/../../libs/simpletest/reporter.php');
class JoinTableParseTest extends UnitTestCase{
	public function JoinTableParseTest(){
		$this->UnitTestCase('Join table parse test');	
	}
	
	public function testClassTag(){
		$comment = '/**';
		$comment .= '* @dbva partialTable(ATable,fk(xx,yy))';
		$comment .= '*';
		$comment .= '*/';
		
		$c = new epComment($comment);
		$value = $c->getTagValue('dbva');
		$this->assertTrue(stristr($value, 'partialTable(ATable,fk(xx,yy))'));
		$t = new dbvaClassTag($value);
		$this->assertTrue($t->get('partialTable'));
		$j = $t->get('partialTable');
		foreach($j as $index => $vals){
			$this->assertEqual($index, 'ATable');
			for($i = 0; $i < count($vals); $i++){
				if($i == 0){
					$this->assertEqual($vals[$i], 'xx');
				}else{
					$this->assertEqual($vals[$i], 'yy');	
				}	
			}
		}	
	}
	
	public function testVarTag(){
		$comment = '/**';
		$comment .= '* @dbva partialTable(ATable)';
		$comment .= '*';
		$comment .= '*/';
		
		$c = new epComment($comment);
		$value = $c->getTagValue('dbva');
		$this->assertTrue(stristr($value, 'partialTable(ATable)'));
		$t = new dbvaVarTag($value);
		$this->assertEqual($t->get('partialTable'), 'ATable');
	}
}

$test = & new JoinTableParseTest();
$test->run(new HtmlReporter());
?>
