<?php
require_once (realpath(dirname(__FILE__)).'/../../ezpdo_runtime.php');
require_once (realpath(dirname(__FILE__)).'/../../src/compiler/epComment.php');
require_once (realpath(dirname(__FILE__)).'/../../libs/simpletest/unit_tester.php');
require_once (realpath(dirname(__FILE__)).'/../../libs/simpletest/reporter.php');

class InheritanceParseTest extends UnitTestCase{
	public function InheritanceParseTest(){
		$this->UnitTestCase("Inheritance Parse Test");
	}	
	
	public function testClassTag(){
		$comment = '/**';
		$comment .= ' * @dbva inherit(tablePerHierarchy)'; 			
 		$comment .= ' */';
 		
 		$c = new epComment($comment);
 		$value = $c->getTagValue('dbva');
 		$this->assertTrue(stristr($value, 'inherit(tablePerHierarchy)'));
 		$t = new dbvaClassTag($value);
 		$this->assertEqual($t->get('inherit'), 'tablePerHierarchy');
 		
 		$comment = '/**';
		$comment .= ' * @dbva inherit(tablePerSubClass)'; 			
 		$comment .= ' */';
 		
 		$c = new epComment($comment);
 		$value = $c->getTagValue('dbva');
 		$this->assertTrue(stristr($value, 'inherit(tablePerSubClass)'));
 		$t = new dbvaClassTag($value);
 		$this->assertEqual($t->get('inherit'), 'tablePerSubClass');
	}
}

$test = & new InheritanceParseTest();
$test->run(new HtmlReporter());
?>
