<?php
/*
 * Created on Jul 30, 2005 9:23:14 AM
 * author : mingkit
 */
	require_once( realpath(dirname(__FILE__)).'/../../ezpdo_runtime.php');
	require_once( realpath(dirname(__FILE__)).'/../../src/compiler/epComment.php');
	require_once( realpath(dirname(__FILE__)).'/../../libs/simpletest/unit_tester.php');
	require_once( realpath(dirname(__FILE__)).'/../../libs/simpletest/reporter.php');
	
  class AssignedIDParseTest extends UnitTestCase{
  	function AssignedIDParseTest(){
  		$this->UnitTestCase('Assigned ID Parse Test');	
  	}
  	
  	function testAssignedParse(){
  		$ID_CONSTANT = 'id';
  		$ASSIGNED_STRING_CONSTANT = 'assigned';
  		/*
  		 * create fake var comment  
  		 */	
  		$comment = '/**';
  		$comment .= '* @var string';
  		$comment .= '* @orm char(20)';
  		$comment .= '* @dbva '. $ID_CONSTANT . '('. $ASSIGNED_STRING_CONSTANT . ')';
  		$comment .= '*/';
  		
  		$c = new epComment($comment);
  		$value = $c->getTagValue('dbva');
  		$this->assertTrue(stristr($value, $ID_CONSTANT) !== false);
  		$this->assertTrue(stristr($value, $ASSIGNED_STRING_CONSTANT) !== false);
  		
  		$t = new dbvaVarTag($value);
  		$this->assertTrue($t);
  		
  		$this->assertTrue($t->get('id') == true);
  		$this->assertTrue($t->get('id_type') == $ASSIGNED_STRING_CONSTANT);
  	}
  	
  	function testAutoGenParse(){
  		$ID_CONSTANT = 'id';
  		$ASSIGNED_STRING_CONSTANT = 'autogenerate';
  		/*
  		 * create fake var comment  
  		 */	
  		$comment = '/**';
  		$comment .= '* @var string';
  		$comment .= '* @orm char(20)';
  		$comment .= '* @dbva '. $ID_CONSTANT . '('. $ASSIGNED_STRING_CONSTANT .')';
  		$comment .= '*/';
  		
  		$c = new epComment($comment);
  		$value = $c->getTagValue('dbva');
  		$this->assertTrue(stristr($value, $ID_CONSTANT) !== false);
  		$this->assertTrue(stristr($value, $ASSIGNED_STRING_CONSTANT) !== false);
  		
  		$t = new dbvaVarTag($value);
  		$this->assertTrue($t);
  		
  		$this->assertTrue($t->get('id') == true);
  		$this->assertTrue($t->get('id_type') == $ASSIGNED_STRING_CONSTANT);
  	}
  	
  	function testOnlyIDParse(){
  		$ID_CONSTANT = 'id';
  		/*
  		 * create fake var comment  
  		 */	
  		$comment = '/**';
  		$comment .= '* @var string';
  		$comment .= '* @orm char(20)';
  		$comment .= '* @dbva '. $ID_CONSTANT;
  		$comment .= '*/';
  		
  		$c = new epComment($comment);
  		$value = $c->getTagValue('dbva');
  		$this->assertTrue(stristr($value, $ID_CONSTANT) !== false);
  		
  		$t = new dbvaVarTag($value);
  		$this->assertTrue($t);
  		
  		$this->assertTrue($t->get('id'));
  		echo $t->get('id_type') . '<br>';
  		$this->assertTrue(is_null($t->get('id_type')));
  	}
  }//end class
  
  $test = &new AssignedIDParseTest();
  $test->run(new HtmlReporter());
?>
