<?php
require_once (realpath(dirname(__FILE__)).'/../../ezpdo_runtime.php');
require_once (realpath(dirname(__FILE__)).'/../../libs/simpletest/unit_tester.php');
require_once (realpath(dirname(__FILE__)).'/../../libs/simpletest/reporter.php');
class RelationShipTest extends UnitTestCase {
	function RelationShipTest() {
		$this->UnitTestCase('RelationShipTest');
		$this->_setUp();
	}

	function _setUp() {
		$link = mysql_connect('localhost', 'root', '');
		mysql_select_db('ezpdo', $link);
		//for one-to-one
		mysql_query('DROP TABLE `Child`;');
		mysql_query('CREATE TABLE `Child`(`childid` int auto_increment, `childName` varchar(60), PRIMARY KEY(childid))');

		mysql_query('DROP TABLE `Toy`;');
		mysql_query('CREATE TABLE `Toy`(`toyid` int auto_increment, `toyName` varchar(60), `childid` varchar(60), PRIMARY KEY(`toyid`))');

		mysql_query('DROP TABLE `Author`;');
		mysql_query('CREATE TABLE `Author`(`authorID` varchar(60), `authorName` varchar(60), PRIMARY KEY(authorID));');

		mysql_query('DROP TABLE `Book`;');
		mysql_query('CREATE TABLE `Book`(`eoid` int PRIMARY KEY auto_increment, `bookName` varchar(60), `author` varchar(60));');

		//many
		mysql_query('DROP TABLE `Course`;');
		mysql_query('CREATE TABLE `Course`(`id` char(60) primary key, `name` char(60))');

		mysql_query('DROP TABLE `Student`;');
		mysql_query('CREATE TABLE `Student`(`id` int(60) primary key, `name` char(60))');

		mysql_query('DROP TABLE `course_student`;');
		mysql_query('CREATE TABLE `course_student`(`studentID` int(60), `courseID` char(60), primary key(`studentID`, `courseID`))');

		//composite
		mysql_query('DROP TABLE `ComAuthor`;');
		mysql_query('CREATE TABLE `ComAuthor`(`authorID` varchar(60), `authorID2` int,  `authorName` varchar(60), PRIMARY KEY(`authorID`, `authorID2`));');

		mysql_query('DROP TABLE `ComBook`;');
		mysql_query('CREATE TABLE `ComBook`(`bookid` varchar(60), `bookid2` int, `bookName` varchar(60), `author` varchar(60), `author2` int, primary key(`bookid`, `bookid2`));');

		mysql_query('DROP TABLE `ComCourse`;');
		mysql_query('CREATE TABLE `ComCourse`(`id` char(60), `id2` int(60), `name` char(60), primary key(`id`, `id2`))');

		mysql_query('DROP TABLE `ComStudent`;');
		mysql_query('CREATE TABLE `ComStudent`(`id` char(60), `id2` int(60), `name` char(60), primary key(`id`, `id2`))');

		mysql_query('DROP TABLE `com_course_student`;');
		mysql_query('CREATE TABLE `com_course_student`(`courseID` char(60), `courseID2` int(60), `studentID` char(60), `studentID2` int(60), primary key(`courseID`, `courseID2`, `studentID`, `studentID2`))');

		mysql_close($link);
	}

	/**
	 * Test  correct parse the class files
	 */
//	function testAuthorClassParse() {
//		$m = epManager :: instance();
//		$cm = $m->getClassMap('Author');
//		$fms = $cm->getAllFields();
//		foreach ($fms as $fm) {
//			//books
//			if ($fm->getName() == 'books') {
//				$this->assertEqual($fm->getInverseAttribute(), 'authorvar');
//			}
//
//			//readers
//			if ($fm->getName() == 'readers') {
//				$this->assertEqual($fm->getJointable(), 'author_reader');
//				$fk = $fm->getFK();
//				$this->assertEqual($fk[0], 'authorID');
//			}
//		}
//	}
//
//	function testBookClassParse() {
//		$m = epManager :: instance();
//		$cm = $m->getClassMap('Book');
//		$fms = $cm->getAllFields();
//		foreach ($fms as $fm) {
//			if ($fm->getName() == 'authorvar') {
//				$fk = $fm->getFK();
//				$this->assertEqual($fk[0], 'author');
//			}
//		}
//	}
//
//	function testReaderClassParse() {
//		$m = epManager :: instance();
//		$cm = $m->getClassMap('Course');
//		$fms = $cm->getAllFields();
//		foreach ($fms as $fm) {
//			if ($fm->getName() == 'students') {
//				$this->assertEqual($fm->getJointable(), 'course_student');
//				$fk = $fm->getFK();
//				$this->assertEqual($fk[0], 'courseID');
//			}
//		}
//	}
	//End test parse

	/**
	 * Test one-to-one relationship
	 * Use Child -- Toy where fk is in Toy
	 */
	function testOneToOne() {
		$m = epManager :: instance();
		//insert
		$child = $m->create('Child');
		$child->childName = 'ChildA';
		//			$child->commit();

		$toy = $m->create('Toy');
		$toy->toyName = 'ToyA';
		//			$toy->commit();

		$toy2 = $m->create('Toy');
		$toy2->toyName = 'ToyB';
		$toy2->commit();

		$child->toy = $toy;
		$toy->childX = $child;
		$child->commit();
		$toy->commit();

		$m->clearAllCached();

		//force to get child from DB
		$rece_child = $m->get('Child', false, 1);
		$rece_toy = $rece_child[0]->toy;
		$this->assertEqual($rece_toy->toyName, 'ToyA');

		//change relationship
		$child = $m->create('Child');
		$child->childName = 'ChildC';
		$child->commit();

		$rece_toy->childX = $child;
		$child->toy = $rece_toy;
		$rece_toy->commit();
		$child->commit();
		
		$toy2->childX = $child;
		$child->toy = $toy2;
		$child->commit();
		$toy2->commit();
	}
//
//	/*
//	 * If check the lazy need to remove the create object part
//	 * because It will be cached......
//	 * example: author -> books will not achieve from db
//	 */
	function testOneToManyRelationShip() {
		$m = epManager :: instance();

		$author = $m->create('Author');
		$author->authorID = 'author1';
		$author->authorName = 'Rswmus Lerdorf';

		$book = $m->create('Book');
		$book->bookName = 'Programming PHP';
		$author->books[] = $book;
		$book->authorvar = $author;

		$book2 = $m->create('Book');
		$book2->bookName = 'Programming Java';
		$author->books[] = $book2;
		$book2->authorvar = $author;

		$author->commit();
		$m->clearAllCached();

		$author_rs = $m->get('Author', false, 1);
		$this->assertEqual($author_rs[0]->authorName, 'Rswmus Lerdorf');
		$this->assertEqual($author_rs[0]->books->count(), 2);
		$books = $author_rs[0]->books;
		if ($books[0]->bookName == 'Programming PHP') {
			$this->assertEqual($books[1]->bookName, 'Programming Java');
		} else
			if ($books[0]->bookName == 'Programming Java') {
				$this->assertEqual($books[1]->bookName, 'Programming PHP');
			} else {
				$this->fail();
			}
		foreach ($books as $b) {
			if ($b->bookName == 'Programming PHP') {
				echo 'true<br>';
			} else
				if ($b->bookName == 'Programming Java') {
					echo 'true<br>';
				} else {
					echo 'false<br>';
				}
		}

		$m->clearAllCached();

		$this->assertEqual($books[0]->authorvar->authorName, 'Rswmus Lerdorf');
		$this->assertEqual($books[0]->authorvar->authorID, 'author1');
		//			
		//change
		$m->clearAllCached();

		$author2 = $m->create('Author');
		$author2->authorID = 'author2';
		$author2->authorName = 'Kevin Tatroe';
		$author2->books[] = $books[0];
		//			$books[0]->authorvar = $authors2;
		$author2->commit();

		$m->clearAllCached();
		$this->assertEqual(count($author2->books), 1);
		//delete 
		$books[0]->delete();
//		$this->assertEqual(count($author2->books), 0);
		foreach($author2->books as $b)
			$this->assertTrue($b->epIsDeleted());
	}

	function testManyToManyRelationShip() {
		//insert the many to many relationship
		$m = epManager :: instance();
		$course = $m->create('Course');
		$course->courseID = 'IDA';
		$course->coursename = 'CA';

		$course2 = $m->create('Course');
		$course2->courseID = 'IDB';
		$course2->coursename = 'CB';

		$student = $m->create('Student');
		$student->studentID = 1;
		$student->studentname = 'studentA';

//		$course->students[] = $student;
//		$course2->students[] = $student;

		$student->courses[] = $course;
		$student->courses[] = $course2;
//		$course->commit();
		$student->commit();

		//select
		$m->clearAllCached();
		$rec_students = $m->get('Student', false, 1);
		$this->assertEqual($rec_students[0]->courses->count(), 2);
		foreach ($rec_students[0]->courses as $course) {
			if ($course->courseID == 'IDA') {
				$this->assertEqual($course->coursename, 'CA');
			} else
				if ($course->courseID == 'IDB') {
					$this->assertEqual($course->coursename, 'CB');
				} else {
					$this->fail();
				}
		}

		$m->clearAllCached();
		$rec_students = $m->get('Student', false, 1);
		$rec_students[0]->delete();

		$m->clearAllCached();
		$rec_courses = $m->get('Course', false, 1);
		foreach ($rec_courses as $course) {
			$this->assertEqual(count($course->students), 0);
		}

	}

	function testCompositeKeyOneToMany() {
		$m = epManager :: instance();

		$author = $m->create('ComAuthor');
		$author->authorID = 'authorID1';
		$author->authorID2 = 1;
		$author->authorName = 'Rswmus Lerdorf';

		$book = $m->create('ComBook');
		$book->bookid = 'book1';
		$book->bookid2 = 1;
		$book->bookName = 'Programming PHP';
		$author->books[] = $book;
		$book->authorvar = $author;

		$book2 = $m->create('ComBook');
		$book2->bookid = 'book2';
		$book2->bookid2 = 2;
		$book2->bookName = 'Programming Java';

		$author->books[] = $book2;
		$book2->authorvar = $author;
		$author->commit();
		//select
		$m->clearAllCached();

		$author_rs = $m->get('ComAuthor', false, 1);
		echo 'name = '.$author_rs[0]->authorName.'<br>';
		$this->assertEqual($author_rs[0]->authorName, 'Rswmus Lerdorf');
		$this->assertEqual($author_rs[0]->books->count(), 2);
		$books = $author_rs[0]->books;
		foreach ($books as $b) {
			if ($b->bookName == 'Programming PHP') {
				$this->assertEqual($b->bookid, 'book1');
				$this->assertEqual($b->bookid2, 1);
			} else
				if ($b->bookName == 'Programming Java') {
					$this->assertEqual($b->bookid, 'book2');
					$this->assertEqual($b->bookid2, 2);
				} else {
					$this->fail();
				}
		}

		$m->clearAllCached();
		//change
		$author2 = $m->create('ComAuthor');
		$author2->authorID = 'authorID2';
		$author2->authorID2 = 2;
		$author2->authorName = 'Kevin Tatroe';

		$author2->books[] = $books[0];
		$books[0]->authorvar = $author2;
		$author2->commit();

		$m->clearAllCached();

		$this->assertEqual($author2->books->count(), 1);
		//delete 
		$books[0]->delete();
//		$this->assertEqual($author2->books->count(), 0);
		foreach($author2->books as $b){
			$this->assertTrue($b->epIsDeleted());	
		}
	}

	function testCompositeKeyManyToMany() {
		$m = epManager :: instance();
		$course = $m->create('ComCourse');
		$course->courseID = 'course';
		$course->courseID2 = 1;
		$course->coursename = 'CA';

		$course2 = $m->create('ComCourse');
		$course2->courseID = 'course';
		$course2->courseID2 = 2;
		$course2->coursename = 'CB';

		$student = $m->create('ComStudent');
		$student->studentID = "student1";
		$student->studentID2 = 1;
		$student->studentname = 'studentA';

		$course->students[] = $student;
		$course2->students[] = $student;

		$student->courses[] = $course;
		$student->courses[] = $course2;

		$student->commit();

		$m->clearAllCached();
		$rec_students = $m->get('ComStudent', false, 1);
		$rec_students[0]->courses;

		$this->assertEqual($rec_students[0]->courses->count(), 2);
		foreach ($rec_students[0]->courses as $course) {
			echo 'Course ID : '.$course->courseID.'<br>';
			if ($course->courseID == 'course' && $course->courseID2 == 1) {
				$this->assertEqual($course->coursename, 'CA');
			} else
				if ($course->courseID == 'course' && $course->courseID2 == 2) {
					$this->assertEqual($course->coursename, 'CB');
				} else {
					$this->fail();
				}
		}

		$m->clearAllCached();
		$rec_students = $m->get('ComStudent', false, 1);
		$rec_students[0]->delete();

		$m->clearAllCached();

		$rec_courses = $m->get('ComCourse', false, 1);
		foreach ($rec_courses as $course) {
			$this->assertEqual(count($course->students), 0);
		}
	}
}

$test = & new RelationShipTest();
$test->run(new HtmlReporter());
?>

