<?php
require_once (realpath(dirname(__FILE__)).'/../../ezpdo_runtime.php');
require_once (realpath(dirname(__FILE__)).'/../../libs/simpletest/unit_tester.php');
require_once (realpath(dirname(__FILE__)).'/../../libs/simpletest/reporter.php');
class PrimitiveArrayTest extends UnitTestCase {
	function PrimitiveArrayTest(){
		$this->UnitTestCase('Primitive Array Test');
		$this->_setup();	
	}
	
	function _setup(){
		$link = mysql_connect('localhost', 'root', '');
		mysql_select_db('ezpdo', $link);
		
		mysql_query('DROP TABLE `Person`;');
		mysql_query('DROP TABLE `person_contact`;');
		mysql_query('DROP TABLE `AddressBookEntry`;');
		mysql_query('DROP TABLE `AddressBookEntry_phoneNumber`');
		mysql_query('CREATE TABLE `Person`(`eoid` int PRIMARY KEY auto_increment, `name` varchar(60), `address` varchar(60))');
		mysql_query('CREATE TABLE `person_contact`(`id` int, `contactIndex` int(2), `contactNo` varchar(60))');
		mysql_query('CREATE TABLE `AddressBookEntry`(`id` varchar(60) PRIMARY KEY, `name` varchar(60))');
		mysql_query('CREATE TABLE `AddressBookEntry_phoneNumber`(`id` varchar(60), `phoneNumIndex` varchar(60), `contactNo` varchar(60))');
		mysql_close($link);
	}
	
	function testArrayParseResult(){
		$m = epManager::instance();
		$person_cm = $m->getClassMap('Person');
		$p_fm = $person_cm->getField('contactNo');
		$this->assertEqual($p_fm->getArrayIndexColumn(), 'contactIndex');
		$this->assertEqual($p_fm->getArrayTable(), 'person_contact');
//		print_r($p_fm->getArrayKeyColumns());
		echo '<br>';
		
		$addressBookE = $m->getClassMap('AddressBookEntry');
		$addressBE_fm = $addressBookE->getField('phoneNumber');
		$this->assertTrue($addressBE_fm->isPrimitiveArray());
		$this->assertNotNull($addressBE_fm);
		$this->assertEqual($addressBE_fm->getArrayIndexColumn(), 'phoneNumIndex');
		$this->assertEqual($addressBE_fm->getArrayIndexType(), 'char');
		$this->assertEqual($addressBE_fm->getArrayTable(), 'AddressBookEntry_phoneNumber');
	}
	
	function testArrayProcess(){
		$m = epManager::instance();
		$person = $m->create('Person');
		$person->pName = 'ABC ppl';
		$person->address = 'xxx road';
//		$person->contactNo = array(12345678, 99999999); 
		$person->contactNo[0] = 12345678;
		$person->contactNo[1] = 99999999;
		$person->commit();
		
		$m->clearAllCached();
		$ps = $m->get('Person', false, 1);
		$this->assertEqual($ps[0]->pName, 'ABC ppl');
		$contact = $ps[0]->contactNo;
		$this->assertEqual($contact->count(), 2);
		$this->assertEqual($contact[0], 12345678);
		$this->assertEqual($contact[1], 99999999);
//		foreach($contact as $c){
//			echo 'contact : ' . $c . '<br>';	
//		}
		$contact[2] = 44444444;
		$contact[0] = 55599778;
		unset($contact[0]);
		unset($contact[1]);
		$this->assertEqual($contact->count(), 1);
		$ps[0]->commit();
		
		$m->clearAllCached();
		$ps = $m->get('Person', false, 1);
		$this->assertEqual($ps[0]->pName, 'ABC ppl');
		$contact = $ps[0]->contactNo;
		$this->assertEqual($contact[2], 44444444);
		
		// Test empty array bug
		unset($contact[2]);
		$ps[0]->commit();
		$m->clearAllCached();
		$psx = $m->get('Person', false, 1);
		$this->assertEqual($psx[0]->contactNo->count(), 0);

	}
	
	function testAssignId(){
		$m = epManager::instance();
		$add_be = $m->create('AddressBookEntry');
		$add_be->addID = 'a1';
		$add_be->aname = 'add_book1';
		$add_be->phoneNumber['phone1'] = '3333';
		$add_be->phoneNumber['phone2'] = '4444';
		$add_be->commit();
		
		$m->clearAllCached();
		$add_be = $m->get('AddressBookEntry', false, 1);
		$this->assertEqual($add_be[0]->aname, 'add_book1');
		$phoneNumbers = $add_be[0]->phoneNumber;
		$this->assertEqual($phoneNumbers->count(), 2);
		$this->assertEqual($phoneNumbers['phone1'], '3333');
		$this->assertEqual($phoneNumbers['phone2'], '4444');
		unset($phoneNumbers['phone1']);
		$phoneNumbers['phone2'] = '6666';
		$add_be[0]->commit();
		
		$m->clearAllCached();
		$add_be = $m->get('AddressBookEntry', false, 1);
		$this->assertEqual($add_be[0]->aname, 'add_book1');
		$this->assertEqual($phoneNumbers->count(), 1);
		$this->assertEqual($add_be[0]->phoneNumber['phone2'], '6666');
	}
}
	
	$test = & new PrimitiveArrayTest();
	$test->run(new HtmlReporter());
?>
