<?php
require_once (realpath(dirname(__FILE__)).'/../../ezpdo_runtime.php');
require_once (realpath(dirname(__FILE__)).'/../../libs/simpletest/unit_tester.php');
require_once (realpath(dirname(__FILE__)).'/../../libs/simpletest/reporter.php');
class PrimaryForeignKeyTest extends UnitTestCase {
	function PrimaryForeignKeyTest() {
		$this->UnitTestCase('Primary Foreign Key Test');
		$this->_setUp();
	}

	function _setUp() {
		$link = mysql_connect('localhost', 'root', '');
		mysql_select_db('ezpdo', $link);

		mysql_query('DROP TABLE `Order`;');
		mysql_query('create table `Order` (id int not null, primary key (id));');

		mysql_query('DROP TABLE Product;');
		mysql_query('create table Product (id int not null, primary key (id));');

		mysql_query('DROP TABLE Orderline;');
		mysql_query('create table Orderline (Orderid int not null, Productid int not null, quantity int not null, unitPrice double not null, primary key (Orderid, Productid));');

		mysql_query('drop table if exists Order2;');
		mysql_query('create table Order2 (id int not null, primary key (id));');

		mysql_query('drop table if exists Product2;');
		mysql_query('create table Product2 (id int not null auto_increment, primary key (id));');

		mysql_query('drop table if exists Orderline2;');
		mysql_query('create table Orderline2 (Order2id int not null, Product2id int not null, quantity int, unitPrice float, primary key (Order2id, Product2id));');

		mysql_close($link);
	}

	/**
	 * Test Primary Foreign Key
	 */
	function testPrimaryForeignKey() {
		$m = epManager :: instance();

		$order = $m->create('Order');
		$order->setId(1);
		$order->commit();

		$product = $m->create('Product');
		$product->setId(1);
		$product->commit();

		$orderline = $m->create('Orderline');
		$orderline->setQuantity(1);
		$orderline->setUnitPrice(100);
		$orderline->commit();

		$orderline->setOrder($order);
		$orderline->setProduct($product);
		$orderline->commit();

		$m->clearAllCached();

		$orderSearch = $m->create('Order');
		$orderSearch->setId(1);
		$orderFind = $m->find($orderSearch);
		$this->assertEqual(count($orderFind), 1);

		$orderline = $order->getOrderline();
		$this->assertEqual(is_null($orderline), false);

		$product = $orderline->getProduct();
		$this->assertEqual($product->getId(), 1);
	}

	/**
	 * Test Primary Foreign Key 2
	 */
	function testPrimaryForeignKey2() {
		$m = epManager :: instance();

		$order = $m->create('Order2');
		$order->setId(1);
		$order->commit();

		$product = $m->create('Product2');
		$product->setId(1);
		$product->commit();

		$orderline = $m->create('Orderline2');
		$orderline->setQuantity(1);
		$orderline->setUnitPrice(100);
		$orderline->commit();

		$orderline->setOrder2($order);
		$orderline->setProduct2($product);
		$orderline->commit();

		$m->clearAllCached();

		$orderSearch = $m->create('Order2');
		$orderSearch->setId(1);
		$orderFind = $m->find($orderSearch);
		$this->assertEqual(count($orderFind), 1);

		$orderline = $order->getOrderline2();
		$this->assertEqual(count($orderline), 1);

		$product = $orderline[0]->getProduct2();
		$this->assertEqual($product->getId(), 1);
	}
}

$test = & new PrimaryForeignKeyTest();
$test->run(new HtmlReporter());
?>

