<?php
require_once (realpath(dirname(__FILE__)).'/../../ezpdo_runtime.php');
require_once (realpath(dirname(__FILE__)).'/../../libs/simpletest/unit_tester.php');
require_once (realpath(dirname(__FILE__)).'/../../libs/simpletest/reporter.php');

class PartialTableTest extends UnitTestCase{
	public function PartialTableTest(){
		$this->UnitTestCase('Partial Table test');
		$this->_setup();
	}
	
	public function _setup(){
		$link = mysql_connect('localhost', 'root', '');
		mysql_select_db('ezpdo', $link);
		mysql_query('DROP TABLE `User`;');
		mysql_query('DROP TABLE `extraInf`;');
		mysql_query('DROP TABLE `extraInf2`;');
		mysql_query('CREATE TABLE `User`(`userID` int(2) PRIMARY KEY auto_increment, `username` varchar(60))');
		//partial Table
		mysql_query('CREATE TABLE `extraInf`(`id` int(2), address varchar(60))');
		mysql_query('CREATE TABLE `extraInf2`(`id` int(2),phone varchar(60))');
		mysql_close($link);
	}
	
	public function testParseResult(){
		$m = epManager::instance();
		$user_cm = $m->getClassMap('User');
		$this->assertNotNull($user_cm->getPartialTables());
		
		$phone_fm = $user_cm->getField('phone');
		$this->assertEqual($phone_fm->getPartialTable(), 'extraInf2');
		
		$address_fm = $user_cm->getField('address');
		$this->assertEqual($address_fm->getPartialTable(), 'extraInf');
	}
	
	public function testPartialTable(){
		//create User;
		$m = epManager::instance();
		$user = $m->create('User');
		$user->username = 'mingkit';
		$user->address = '5a';
		$user->phone = '99999999';
		$user->commit();
		
		//select user from db
		$m->clearAllCached();
		$users = $m->get('User', false, 1);
		$this->assertEqual($users[0]->username, 'mingkit');
		$this->assertEqual($users[0]->address, '5a');
		$this->assertEqual($users[0]->phone, '99999999');
		
		//modified user 
		$m->clearAllCached();
		$users = $m->get('User', false, 1);
		$users[0]->username = 'abc';
		$users[0]->address = '444';
		$users[0]->phone = '00000000';
		$users[0]->commit();
		
		$m->clearAllCached();
		$users = $m->get('User', false, 1);
		$this->assertEqual($users[0]->username, 'abc');
		$this->assertEqual($users[0]->address, '444');
		$this->assertEqual($users[0]->phone, '00000000');
		
//		$users[0]->delete();
	}
}
$test = & new PartialTableTest();
$test->run(new HtmlReporter());
?>
