<?php
require_once (realpath(dirname(__FILE__)).'/../../ezpdo_runtime.php');
require_once (realpath(dirname(__FILE__)).'/../../libs/simpletest/unit_tester.php');
require_once (realpath(dirname(__FILE__)).'/../../libs/simpletest/reporter.php');
class OrderedCollectionTest extends UnitTestCase {
	function OrderedCollectionTest() {
		$this->UnitTestCase('Ordered Collection test');
		$this->_setUp();
	}

	function _setUp() {
		$link = mysql_connect('localhost', 'root', '');
		mysql_select_db('ezpdo', $link);
		//int for index
		mysql_query('DROP TABLE `AuthorList`;');
		mysql_query('CREATE TABLE `AuthorList`(`authorID` varchar(60), `authorName` varchar(60), PRIMARY KEY(authorID));');

		mysql_query('DROP TABLE `BookList`;');
		mysql_query('CREATE TABLE `BookList`(`eoid` int PRIMARY KEY auto_increment, `bookName` varchar(60), `author` varchar(60), `authorIndex` int(10));');

		//string for index
		mysql_query('DROP TABLE `AuthorStrIndex`;');
		mysql_query('CREATE TABLE `AuthorStrIndex`(`authorID` varchar(60), `authorName` varchar(60), PRIMARY KEY(authorID));');

		mysql_query('DROP TABLE `BookStrIndex`;');
		mysql_query('CREATE TABLE `BookStrIndex`(`eoid` int PRIMARY KEY auto_increment, `bookName` varchar(60), `author` varchar(60), `authorIndex` varchar(60));');

		mysql_close($link);
	}

	function testCreate() {
		echo '<br>';
		echo '<strong>create</strong><br>';
		$m = epManager :: instance();

		$book1 = $m->create('BookList');
		$book1->bookName = 'book1';

		$book2 = $m->create('BookList');
		$book2->bookName = 'book2';

		$book3 = $m->create('BookList');
		$book3->bookName = 'book3';

		$author = $m->create('AuthorList');
		$author->authorID = 'a1';
		$author->authorName = 'author1';

		$author->books[2] = $book1;
		$author->books[4] = $book2;
		$author->books[6] = $book3;

		$author->commit();
		echo '<br>';
		
		echo '<br>';
		echo '<strong>start to test Cache Select </strong><br>';
		$m = epManager :: instance();
		$authors = $m->get('AuthorList', false, 1);
		$books = $authors[0]->books;
		$this->assertEqual($books[2]->bookName, 'book1');
		$this->assertEqual($books[6]->bookName, 'book3');
		$this->assertEqual($books[4]->bookName, 'book2');
		echo '<br>';
		
		echo '<br>';
		echo '<strong>start to test no Cache Select </strong><br>';
		$m = epManager :: instance();
		$authors = $m->get('AuthorList', false, 1);
		$m->clearAllCached();
		$books = $authors[0]->books;
		$this->assertEqual($books[2]->bookName, 'book1');
		$this->assertEqual($books[6]->bookName, 'book3');
		$this->assertEqual($books[4]->bookName, 'book2');
		echo '<br>';
		
		echo '<br>';
		echo '<strong>start to test Change Object</strong><br>';
		$m = epManager :: instance();
		$authors = $m->get('AuthorList', false, 1);
		$books = $authors[0]->books;

		//that mean book2 remove from the array
		//book1 overwrite by book2
		//so book1 will be no relationship with author

		$book4 = $books[4];
		unset ($books[4]);
		$book2 = $books[2];
		$books[2] = $book4;
		$books = $authors[0]->books;
		$authors[0]->commit();

		$book2->commit();
		$this->assertEqual($books[2]->bookName, 'book2');
		$this->assertNull($book2->authorvar);
		echo '<br>';
		
		echo '<br>';
		echo '<strong>start to test delete obj</strong><br>';
		$m = epManager :: instance();
		$authors = $m->get('AuthorList', false, 1);
		$books = $authors[0]->books;
		$books[6]->delete();
		echo '<br>';
	}
	
	function testStrCreate() {
		echo '<br>';
		echo '<strong>create</strong><br>';
		$m = epManager :: instance();

		$book1 = $m->create('BookStrIndex');
		$book1->bookName = 'book1';

		$book2 = $m->create('BookStrIndex');
		$book2->bookName = 'book2';

		$book3 = $m->create('BookStrIndex');
		$book3->bookName = 'book3';

		$author = $m->create('AuthorStrIndex');
		$author->authorID = 'a1';
		$author->authorName = 'author1';

		$author->books['index1'] = $book1;
		$author->books['index2'] = $book2;
		$author->books['index3'] = $book3;

		$author->commit();
		echo '<br>';
		
		echo '<br>';
		echo '<strong>start to test Cache Select </strong><br>';
		$m = epManager :: instance();
		$authors = $m->get('AuthorStrIndex', false, 1);
		$books = $authors[0]->books;
		$this->assertEqual($books['index1']->bookName, 'book1');
		$this->assertEqual($books['index3']->bookName, 'book3');
		$this->assertEqual($books['index2']->bookName, 'book2');
		echo '<br>';
		
		echo '<br>';
		echo '<strong>start to test no Cache Select </strong><br>';
		$m = epManager :: instance();
		$authors = $m->get('AuthorStrIndex', false, 1);
		$m->clearAllCached();
		$books = $authors[0]->books;
		$this->assertEqual($books['index1']->bookName, 'book1');
		$this->assertEqual($books['index3']->bookName, 'book3');
		$this->assertEqual($books['index2']->bookName, 'book2');
		echo '<br>';
		
		echo '<br>';
		echo '<strong>start to test str index Change Object</strong><br>';
		$m = epManager :: instance();
		$authors = $m->get('AuthorStrIndex', false, 1);
		$books = $authors[0]->books;

		//that mean book2 remove from the array
		//book1 overwrite by book2
		//so book1 will be no relationship with author

		$book2 = $books['index2'];
		unset ($books['index2']);
		$book = $books['index1'];
		$books['index1'] = $book2;
		$authors[0]->commit();

		$book->commit();
		echo '<br>';
		
		echo '<br>';
		echo '<strong>start to test delete obj</strong><br>';
		$m = epManager :: instance();
		$authors = $m->get('AuthorStrIndex', false, 1);
		$books = $authors[0]->books;
		$books['index3']->delete();
		
		$books = $m->get('BookStrIndex', false, 1);
		$this->assertEqual(count($books), 2);
		echo '<br>';
	}
}
$test = & new OrderedCollectionTest();
$test->run(new HtmlReporter());
?>




