<?php
require_once (realpath(dirname(__FILE__)).'/../../ezpdo_runtime.php');
require_once (realpath(dirname(__FILE__)).'/../../libs/simpletest/unit_tester.php');
require_once (realpath(dirname(__FILE__)).'/../../libs/simpletest/reporter.php');

class InheritanceTest extends UnitTestCase{
	function InheritanceTest(){
		$this->UnitTestCase("Inheritance test");
		$this->_setup();
	}
	
	function _setup(){
		$link = mysql_connect('localhost', 'root', '');
		mysql_select_db('ezpdo', $link);
		
		mysql_query('DROP TABLE `PersonX`;');
		mysql_query('DROP TABLE `XMen`');
		mysql_query('CREATE TABLE `PersonX`(`eoid` int PRIMARY KEY auto_increment, `dis` varchar(60), `name` varchar(60), `address` varchar(60), `contactNo` varchar(60), `salary` int(10))');
		mysql_query('CREATE TABLE `XMen`(`id` int PRIMARY KEY, `xxx` varchar(60))');
		mysql_close($link);
	}
	
	function testInheritance(){
		$m = epManager :: instance();
		
		$person = $m->create('PersonX');
		$person->pName = 'person1';
		$person->address = 'persona';
		$person->contactNo = '1233456';
		$person->commit();
		
		$xmen = $m->create('XMen');
		$xmen->pName = 'abc';
		$xmen->address = 'aaaaa';
		$xmen->xxx = 'var';
		$xmen->commit();
		
		$prof = $m->create('Professor');
		$prof->pName = 'p';
		$prof->address = 'pa';
		$prof->salary = 10000;
		$prof->commit();
		
		$m->clearAllCached();
		$prs = $m->get('Professor');
		$this->assertEqual(count($prs), 1);
		$this->assertEqual($prs[0]->pName, 'p');
		$this->assertEqual($prs[0]->address, 'pa');
		$this->assertEqual($prs[0]->salary, 10000);
		
		$m->clearAllCached();
		$xs = $m->get('XMen');
		$this->assertEqual(count($xs), 1);
		$this->assertEqual($xs[0]->pName, 'abc');
		$this->assertEqual($xs[0]->address, 'aaaaa');
		$this->assertEqual($xs[0]->xxx, 'var');
		
		$m->clearAllCached();
		$ps = $m->get('PersonX');
		$this->assertEqual(count($ps), 1);
		$this->assertEqual($ps[0]->pName, 'person1');
		$this->assertEqual($ps[0]->address, 'persona');
		$this->assertEqual($ps[0]->contactNo, '1233456');
	}
}
$test = & new InheritanceTest();
$test->run(new HtmlReporter());
?>
