<?php
require_once (realpath(dirname(__FILE__)).'/../../ezpdo_runtime.php');
require_once (realpath(dirname(__FILE__)).'/../../libs/simpletest/unit_tester.php');
require_once (realpath(dirname(__FILE__)).'/../../libs/simpletest/reporter.php');
class FindTest extends UnitTestCase {
	function FindTest() {
		$this->UnitTestCase('Find Test');
		$this->_setUp();
	}

	function _setUp() {
		$link = mysql_connect('localhost', 'root', '');
		mysql_select_db('ezpdo', $link);

		mysql_query('DROP TABLE `RoyUser`;');
		mysql_query('create table RoyUser (userId varchar(60) not null, userName varchar(100), primary key (userId));');

		mysql_query('DROP TABLE `RoyAddress`;');
		mysql_query('create table RoyAddress (addressId varchar(60) not null, addressName varchar(100), RoyUseruserId varchar(60) not null, primary key (addressId));');

		mysql_query('DROP TABLE RoyCountry;');
		mysql_query('create table RoyCountry (countryId varchar(60) not null, countryName varchar(100), RoyAddressaddressId varchar(60) not null, primary key (countryId));');

		mysql_close($link);
	}

	/**
	 * Test Find
	 */
	function testFind() {
		$m = epManager :: instance();

		// User1 -> Address1 -> Country1
		// User2 -> AddressA -> Country2
		// User3 -> AddressA -> CountryA
		// User4 -> Address4 -> CountryA

		$user1 = $m->create('RoyUser');
		$user1->userId = 'User1';
		$user1->userName = 'User1';
		$user1->commit();

		$user2 = $m->create('RoyUser');
		$user2->userId = 'User2';
		$user2->userName = 'User2';
		$user2->commit();

		$user3 = $m->create('RoyUser');
		$user3->userId = 'User3';
		$user3->userName = 'User3';
		$user3->commit();

		$user4 = $m->create('RoyUser');
		$user4->userId = 'User4';
		$user4->userName = 'User4';
		$user4->commit();

		$address1 = $m->create('RoyAddress');
		$address1->addressId = 'Address1';
		$address1->addressName = 'Address1';
		$address1->royUser = $user1;
		$address1->commit();

		$address2 = $m->create('RoyAddress');
		$address2->addressId = 'Address2';
		$address2->addressName = 'AddressA';
		$address2->royUser = $user2;
		$address2->commit();

		$address3 = $m->create('RoyAddress');
		$address3->addressId = 'Address3';
		$address3->addressName = 'AddressA';
		$address3->royUser = $user3;
		$address3->commit();

		$address4 = $m->create('RoyAddress');
		$address4->addressId = 'Address4';
		$address4->addressName = 'Address4';
		$address4->royUser = $user4;
		$address4->commit();

		$country1 = $m->create('RoyCountry');
		$country1->countryId = 'Country1';
		$country1->countryName = 'Country1';
		$country1->royAddress = $address1;
		$country1->commit();

		$country2 = $m->create('RoyCountry');
		$country2->countryId = 'Country2';
		$country2->countryName = 'Country2';
		$country2->royAddress = $address2;
		$country2->commit();

		$country3 = $m->create('RoyCountry');
		$country3->countryId = 'Country3';
		$country3->countryName = 'CountryA';
		$country3->royAddress = $address3;
		$country3->commit();

		$country4 = $m->create('RoyCountry');
		$country4->countryId = 'Country4';
		$country4->countryName = 'CountryA';
		$country4->royAddress = $address4;
		$country4->commit();

		$m->clearAllCached();

		$userSearch = $m->create('RoyUser');
		$addressSearch = $m->create('RoyAddress');
		$countrySearch = $m->create('RoyCountry');

		$addressSearch->royUser = $userSearch;
		$countrySearch->royAddress = $addressSearch;

		$countrySearch->countryName = 'CountryX';
		$userFind = $m->find($userSearch);
		$this->assertEqual(count($userFind), 0);

		$countrySearch->countryName = 'Country1';
		$userFind = $m->find($userSearch);
		$this->assertEqual(count($userFind), 1);
		$this->assertEqual($userFind[0]->userName, 'User1');

		$countrySearch->countryName = 'CountryA';
		$userFind = $m->find($userSearch);
		$this->assertEqual(count($userFind), 2);
		$this->assertEqual($userFind[0]->userName, 'User3');
		$this->assertEqual($userFind[1]->userName, 'User4');

		$addressSearch->addressName = 'AddressA';
		$countrySearch->countryName = null;
		$userFind = $m->find($userSearch);
		$this->assertEqual(count($userFind), 2);
		$this->assertEqual($userFind[0]->userName, 'User2');
		$this->assertEqual($userFind[1]->userName, 'User3');
	}
}

$test = & new FindTest();
$test->run(new HtmlReporter());
?>

