<?php
/*
 * Created on Jul 30, 2005
 *
 */
 	require_once( realpath(dirname(__FILE__)).'/../../ezpdo_runtime.php');
 	require_once( realpath(dirname(__FILE__)).'/../../libs/simpletest/unit_tester.php');
  	require_once( realpath(dirname(__FILE__)).'/../../libs/simpletest/reporter.php');
  	
  	class AssignedIDTest extends UnitTestCase{
  		function AssignedIDTest(){
  			$this->UnitTestCase('Assigned ID Test');
  			$this->_setUp();
  		}
  		
  		function _setUp(){
  			$link = mysql_connect('localhost', 'root', '');		
			mysql_select_db('ezpdo', $link);
			mysql_query('DROP TABLE `AssignedIDOrginalTestObj`;');
			mysql_query('CREATE TABLE `AssignedIDOrginalTestObj`(`eoid` int primary key auto_increment, `name` char(60));');
			
			mysql_query('DROP TABLE `AutoGenIntIDTestObj`;');
			mysql_query('CREATE TABLE `AutoGenIntIDTestObj`(`id` int primary key auto_increment, `name` char(60));');
			
			mysql_query('DROP TABLE `AssignedIntIDTestObj`;');
			mysql_query('CREATE TABLE `AssignedIntIDTestObj`(`id` int primary key, `name` char(60));');
			
			mysql_query('DROP TABLE `AssignedIDStringTestObj`;');
			mysql_query('CREATE TABLE `AssignedIDStringTestObj`(`id` char(60), `name` char(60));');
			
			mysql_close($link);
  		}
  		
  		/*
  		 * Test orginal id to create oid (that is auto increase and get from the database)
  		 */
  		 function testOrginalID(){
  		 	$m = epManager::instance();
  		 	$cm = $m->getClassMap('AssignedIDOrginalTestObj');
  		 	$fms =$cm->getAllFields();
  		 	foreach($fms as  $fm){
  		 			$this->assertFalse($fm->isID());
  		 			echo $fm->getIDType() . '<br>';
  		 			$this->assertFalse($fm->getIDType(), 'autogenerate');	
  		 	}
  		 }
  		 
		 /*
		  * Test id to auto generate
		  * It contain the id variable and decarle to auto gen. 
		  */
		  function testAutoGenID(){
		  	$m = epManager::instance();
  		 	$cm = $m->getClassMap('AutoGenIntIDTestObj');
  		 	$fms =$cm->getAllFields();
  		 	foreach($fms as  $fm){
  		 		if($fm->getName() == 'id'){
  		 			$this->assertTrue($fm->isID());
	 				$this->assertEqual($fm->getIDType(), 'autogenerate');	
  		 		}
  		 	}
		  }
  		  
		/*
		 * Test assigned id to int 
		 */
		function testAssignedIntID(){
			$m = epManager::instance();
  		 	$cm = $m->getClassMap('AssignedIntIDTestObj');
  		 	$fms =$cm->getAllFields();
  		 	foreach($fms as  $fm){
  		 		if($fm->getName() == 'id'){
  		 			$this->assertTrue($fm->isID());
	 				$this->assertEqual($fm->getIDType(), 'assigned');	
  		 		}
  		 	}
		}
  		   
   /*
	* Test assigned id to String
	*/
	function testAssignedStringID(){
		$m = epManager::instance();
  		 	$cm = $m->getClassMap('AssignedIDStringTestObj');
  		 	$fms =$cm->getAllFields();
  		 	foreach($fms as  $fm){
  		 		if($fm->getName() == 'id'){
  		 			$this->assertTrue($fm->isID());
	 				$this->assertEqual($fm->getIDType(), 'assigned');	
  		 		}
  		 	}	
	}
	
	/*
	 * test orginal ID to insert and select
	 */
	function testOrginalIDProcess(){
		$m = epManager::instance();
		$autoObj = $m->create('AssignedIDOrginalTestObj');
		$autoObj->name = 'abc';
		$autoObj->commit();
		
		$autoObjs = $m->get('AssignedIDOrginalTestObj');
		$this->assertTrue($autoObjs[0]->name == 'abc');
		
		$autoObjs[0]->name = 'AssignedIDOrginalTestObj';
		$autoObjs[0]->commit();
	}
	
	/*
	 * testAutoGenID class to insert --> select -->update
	 */
	function testAutoGenIDProcess(){
		$m = epManager::instance();
		$autoObj = $m->create('AutoGenIntIDTestObj');
		$autoObj->name = 'abc';
		$autoObj->commit();
		
		$autoObjs = $m->get('AutoGenIntIDTestObj');
		$this->assertNotNull($autoObjs[0]->id);
		$this->assertTrue($autoObjs[0]->name == 'abc');
		
		$autoObjs[0]->name = 'AutoGenIntIDTestObj';
		$autoObjs[0]->commit();
	}
	
	/*
	 * testAutoGenID class to insert and select
	 */
	function testAssignIntIDProcess(){					
		$m = epManager::instance();
		$autoObj = $m->create('AssignedIntIDTestObj');
		$autoObj->id = 11;
		$autoObj->name = 'abc';
		$autoObj->commit();
	
		$autoObjs = $m->get('AssignedIntIDTestObj', false, 3);
		$this->assertTrue($autoObjs[0]->id == 11);
		$this->assertTrue($autoObjs[0]->name == 'abc');
		
		$autoObjs[0]->name = 'xxxx';
		$autoObjs[0]->commit();
	}
	
	
	/*
	 * testAutoGenID class to insert and select
	 */
	function testAssignStringIDProcess(){
		$m = epManager::instance();
		$autoObj = $m->create('AssignedIDStringTestObj');
		$autoObj->id = 'id_a';
		$autoObj->name = 'abc';
		$autoObj->commit();
		
		$autoObjs = $m->get('AssignedIDStringTestObj');
		$this->assertTrue($autoObjs[0]->id == 'id_a');
		$this->assertTrue($autoObjs[0]->name == 'abc');
		
		$autoObjs[0]->name = 'AssignedIDStringTestObj';
		$autoObjs[0]->commit();
	}

}//end AssignedIDTest
  	$test = &new AssignedIDTest();
 	$test->run(new HtmlReporter());
?>
