<?xml version="1.0" encoding="UTF-8"?>
<!DOCTYPE xsl:stylesheet [<!ENTITY nbsp "&#160;">]>

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:redirect="http://xml.apache.org/xalan/redirect"
    xmlns:xalan="http://xml.apache.org/xalan"
    extension-element-prefixes="redirect"
    exclude-result-prefixes="xalan"
    version="1.0"
>

	
	<xsl:template match="Diagram[@diagramType='TextualAnalysis']">
		<p/>
		<table width = "100%" border="0" cellpadding="0" cellspacing="0">
			<tr><td class="Category"><xsl:value-of select="$st_Problem_Statement"/></td></tr>
			<tr><td style="height: 5px"></td></tr>
		</table>
		<table width="100%"  border="0" cellpadding="0" cellspacing="0">
				<tr><td class="TableHeaderLine"/></tr>
				<tr><td class="TableHeaderLine1"/></tr>
				<tr>
					<td><span class="TableContent">
						<xsl:value-of select="./DiagramProperties/StringProperty[@name='problemStatement']/@value" disable-output-escaping="yes"/>
					</span></td>
				</tr>
				<tr><td class="TableHeaderLine2"/></tr>
		</table>
		<table width = "100%" border="0" cellpadding="0" cellspacing="0">
			<tr><td style="height: 1px"/></tr>
			<tr><td class="TableFooter"/></tr>
		</table>
		<p/>
		
		
		<!-- Candidate item table -->
		<xsl:if test="count(./CandidateItems/Model[@modelType = 'CandidateItem']) > 0">
			<p/>
			<table width = "100%" border="0" cellpadding="0" cellspacing="0">
				<tr><td class="Category"><xsl:value-of select="$st_Candidate_items"/></td></tr>
				<tr><td style="height: 5px"></td></tr>
			</table>
			<table width="100%"  border="0" cellpadding="0" cellspacing="0">
				<tr><td class="TableHeaderLine" colspan="8"/></tr>
				<tr><td class="TableHeaderLine1" colspan="8"/></tr>
				<tr class="TableHeader">
					<td style="width: 10px"/>
					<td width="25%"><span class="TableHeaderText"><xsl:value-of select="$st_Candidate_Class"/></span></td>
					<td style="width: 20px"/>
					<td><span class="TableHeaderText"><xsl:value-of select="$st_Extracted_Text"/></span></td>
					<td style="width: 20px"/>
					<td><span class="TableHeaderText"><xsl:value-of select="$st_Type"/></span></td>
					<td style="width: 20px"/>
					<td><span class="TableHeaderText"><xsl:value-of select="$st_Class_Description"/></span></td>
				</tr>
				<tr><td class="TableHeaderLine2" colspan="8"/></tr>
				<xsl:for-each select="./CandidateItems/Model[@modelType = 'CandidateItem']">
					<tr>
						<xsl:choose>
							<xsl:when test="position() mod 2 = 1">
								<xsl:attribute name="class">TableRow1</xsl:attribute> 
							</xsl:when>
							<xsl:otherwise>
								<xsl:attribute name="class">TableRow2</xsl:attribute> 
							</xsl:otherwise>
						</xsl:choose>
						<td/>
						<td><span class="TableContent"><xsl:value-of select="./@name" /></span></td>
						<td/>
						<td><span class="TableContent"><xsl:value-of select="./ModelProperties/StringProperty[@name='candidateItemText']/@value" disable-output-escaping="yes"/></span></td>
						<td/>
						<td><span class="TableContent"><xsl:value-of select="./ModelProperties/StringProperty[@name='candidateItemType']/@value"/></span></td>
						<td/>
						<td><span class="TableContent"><xsl:value-of select="./ModelProperties/StringProperty[@name='candidateItemDescription']/@value" disable-output-escaping="yes"/></span></td>
					</tr>
				</xsl:for-each>
			</table>
			<table width = "100%" border="0" cellpadding="0" cellspacing="0">
				<tr><td style="height: 1px"/></tr>
				<tr><td class="TableFooter"/></tr>
			</table>
			<p/>			
		</xsl:if>
	</xsl:template>
	
</xsl:stylesheet>
