<?xml version="1.0" encoding="UTF-8"?>
<!DOCTYPE xsl:stylesheet [<!ENTITY nbsp "&#160;">]>

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:redirect="http://xml.apache.org/xalan/redirect"
    xmlns:xalan="http://xml.apache.org/xalan"
    extension-element-prefixes="redirect"
    exclude-result-prefixes="xalan"
    version="1.0"
>
	<xsl:include href="diagram/diagram_general.xsl" />
	<xsl:include href="diagram/diagram_erd.xsl" />
	<xsl:include href="diagram/diagram_textual_analysis.xsl" />
	<xsl:include href="diagram/area.xsl" />

	<xsl:template name="printDiagramContentPage">
		<xsl:for-each select="//Project/Diagrams/Diagram">
			<xsl:variable name="diagram_type" select="@diagramType" />
			<xsl:variable name="display_diagram_type" select="@displayDiagramType" />
			<xsl:variable name="diagram_id" select="@id" />
			<xsl:variable name="diagram_name" select="@name" />
			
			<xsl:variable name="filename" select="concat($content_dir_base_path, '/', $diagram_type, '_', $diagram_id, '.html')" />
			<redirect:write file="{$filename}">
				<html>
				<head>
				<xsl:if test="@documentation != ''">
					<META name="Description" content="{@documentation}"/>
				</xsl:if>
				<link rel="stylesheet" type="text/css" href="{concat('../', $content_dir_name, '/', $style_sheet_file_name)}" />
				<title><xsl:value-of select="$display_diagram_type"/> - <xsl:value-of select="$diagram_name"/></title>
				<script type="text/javascript" src="{$javascript_file_name1}"></script>
				<script type="text/javascript" src="{$javascript_file_name2}"></script>
				<script type="text/javascript" src="{$javascript_file_name3}"></script>
				</head>
				<body style="margin-left: 10px; margin-right: 10px; margin-top: 10px; margin-bottom: 10px;" onload="initPage()">
					<div id="spotlight" style="position:absolute; width:100px; height:100px; z-index:1; visibility:hidden">
						<table border="0" onClick="updateCursorPos(event);adjustPopupPositionForSpotLightTable();clearSpotLight()" id="spotLightTable" style="border-style:solid; border-width:3px; border-color:#FF0000">
							<tr><td id="spotLightCell">&nbsp;</td></tr>
						</table>
					</div>
					<div id="spotLightResourcesTop" style="position:absolute; width:100px; height:100px; z-index:1; visibility:hidden">
						<table border="0">
							<tr>
								<td><a href="#top"><img style="border:none" src="{concat('../', $icon_dir_relative_path, '/', $back_to_top_file_name)}" alt="Back to top"/></a></td>
								<td><a href="javascript:clearSpotLightFromOpenSpecButton();"><img style="border:none" src="{concat('../', $icon_dir_relative_path, '/', $open_specification_file_name)}" alt="Open specification"/></a></td>
							</tr>
						</table>
					</div>
					<div id="spotLightResourcesRight" style="position:absolute; width:100px; height:100px; z-index:1; visibility:hidden">
						<table border="0">
							<tr><td><a href="#top"><img style="border:none" src="{concat('../', $icon_dir_relative_path, '/', $back_to_top_file_name)}" alt="Back to top"/></a></td></tr>
							<tr><td><a href="javascript:clearSpotLightFromOpenSpecButton();"><img style="border:none" src="{concat('../', $icon_dir_relative_path, '/', $open_specification_file_name)}" alt="Open specification"/></a></td></tr>
						</table>
					</div>
					
					<!-- url popup -->
			    <div style="position:absolute;z-index:2;visibility:hidden" id="linkPopupMenuLayer">
			      <table style="border-style:solid; border-width:1px; border-color:#000000; background:#FFFFFF; width:250px" id="linkPopupMenuTable"  border="0">
			      </table>
			    </div>
			    
					<!-- reference -->
			    <div style="position:absolute; z-index:1; visibility:hidden" id="referenceIconLayer">
			      <table border="0"><tr><td><img src="{concat('../', $icon_dir_relative_path, '/', $ref_icon_file_name)}" style="border:none" onclick="movePopupPositionToReferenceIconPosition();resetPopupForReference();switchPopupShowHideStatus();"/></td></tr></table>
			    </div>
					
					
					<!-- subdiagram -->
			    <div style="position:absolute; z-index:1; visibility:hidden" id="subdiagramIconLayer">
			      <table border="0"><tr><td><img src="{concat('../', $icon_dir_relative_path, '/', $subdiagram_icon_file_name)}" style="border:none" onclick="movePopupPositionToSubdiagramIconPosition();resetPopupForSubdiagram();switchPopupShowHideStatus();"/></td></tr></table>
			    </div>
			    					
					<xsl:if test="$opt_is_generate_page_header = 'true'">
						<xsl:call-template name="drawContentPageHeader">
							<xsl:with-param name="report_name" select="$report_name"/>
						</xsl:call-template>
					</xsl:if>
					<!-- Page parent title -->
					<p>
						<xsl:if test="count(./DiagramProperties/ModelRefProperty[@name='parentModel']/ModelRef) > 0">
							<xsl:apply-templates mode="printParentModelElementlink" select="."/>
						</xsl:if>
					</p>
					
					<xsl:if test="$opt_is_display_diagram_page_title = 'true'">
						<p class="PageTitle"><xsl:value-of select="$display_diagram_type"/> - <xsl:value-of select="$diagram_name"/></p>
					</xsl:if>
					
					<!-- Main content -->
					<xsl:apply-templates select="."/>
					
					<!-- Footer -->
					<xsl:if test="$opt_is_generate_page_footer = 'true'">
						<xsl:call-template name="drawContentPageFooter">
							<xsl:with-param name="report_name" select="$report_name"/>
						</xsl:call-template>
					</xsl:if>
				</body>
				</html>
			</redirect:write>
		</xsl:for-each>
	</xsl:template>

	<xsl:template name="constructJumpToDropDownMenu">
		<xsl:param name="r"/>
		<table width="100%"  border="0" cellpadding="0" cellspacing="0">
			<tr>
				<td>
					<span class="TableContent"><xsl:value-of select="$st_Jump_to"/>&nbsp;</span>
					<select class="TableContent" onChange="scrollWin(this.value);showSpotLight(this.value)">
						<option value="">Please select a model element</option>
						<xsl:for-each select="./Shapes//Shape[@shapeType != 'LostFoundMessageEnd' and @shapeType != 'Freehand' and @model != '']">
							<xsl:sort select="modelType"/>
							<xsl:variable name="opt_drill_down">
								<xsl:choose>
									<xsl:when test="@modelType='BPSubProcess'">
										<xsl:value-of select="$opt_drill_down_effect_for_business_subprocess"/>
									</xsl:when>
									<xsl:when test="@modelType='PMProcess'">
										<xsl:value-of select="$opt_drill_down_effect_for_process_map_process"/>
									</xsl:when>
									<xsl:when test="@modelType='BPStartEvent'">
										<xsl:value-of select="$opt_drill_down_effect_for_bpmn_events"/>
									</xsl:when>
									<xsl:when test="@modelType='BPIntermediateEvent'">
										<xsl:value-of select="$opt_drill_down_effect_for_bpmn_events"/>
									</xsl:when>
									<xsl:when test="@modelType='BPEndEvent'">
										<xsl:value-of select="$opt_drill_down_effect_for_bpmn_events"/>
									</xsl:when>
									<xsl:when test="@modelType='InteractionOccurrence'">
										<xsl:value-of select="$opt_drill_down_effect_for_diagram_overview"/>
									</xsl:when>
									<xsl:when test="@modelType='DiagramOverview'">
										<xsl:value-of select="$opt_drill_down_effect_for_diagram_overview"/>
									</xsl:when>
									<xsl:otherwise>
										<xsl:value-of select="$opt_drill_down_effect_for_general_model"/>
									</xsl:otherwise>
								</xsl:choose>
							</xsl:variable>
							
							<xsl:variable name = "x" select = "@x * $r"/>
							<xsl:variable name = "y" select = "@y * $r"/>
							<xsl:variable name = "width" select = "@width * $r"/>
							<xsl:variable name = "height" select = "@height * $r"/>
							
							<xsl:variable name = "model_id" select = "@model"/>
							<xsl:variable name = "model_name" select = "@name"/>
							<xsl:variable name = "model_type" select = "@modelType"/>
							<xsl:variable name = "display_model_type" select = "@displayModelType"/>

							<xsl:variable name = "url-for-spec" select = "concat($model_type, '_', $model_id, '.html')"/>
							
							<xsl:choose>
								<xsl:when test="$opt_drill_down='Open model specification page'">
									<option value="{concat($x, '|', $y, '|', $width, '|', $height, '|', $url-for-spec, '|', $url-for-spec, '|', @id)}"><xsl:value-of select="$model_name"/> : <xsl:value-of select="$display_model_type"/></option>
								</xsl:when>
								<xsl:when test="$opt_drill_down='Open subdiagrams' and count(./SubDiagrams/DiagramRef)=1">
									<xsl:variable name="subDiagramNode" select="./SubDiagrams/DiagramRef"/>
									<xsl:variable name = "url" select = "concat($subDiagramNode/@diagramType, '_', $subDiagramNode/@id, '.html')"/>
									<option value="{concat($x, '|', $y, '|', $width, '|', $height, '|', $url, '|', $url-for-spec, '|', @id)}"><xsl:value-of select="$model_name"/> : <xsl:value-of select="$display_model_type"/></option>
								</xsl:when>
								<xsl:when test="$opt_drill_down='Open subdiagrams' and count(./SubDiagrams/DiagramRef) &gt; 1">
									<xsl:variable name = "url-for-imgmap" select = "'javascript:resetPopupForSubdiagram();showLinkPopup();'"/>
									<option value="{concat($x, '|', $y, '|', $width, '|', $height, '|', $url-for-imgmap, '|', $url-for-spec, '|', @id)}"><xsl:value-of select="$model_name"/> : <xsl:value-of select="$display_model_type"/></option>
								</xsl:when>
								<xsl:when test="$opt_drill_down='Open process diagram page' and count(./DiagramElementProperties/DiagramRefProperty[@name='diagramId']/DiagramRef) &gt; 0">
									<xsl:variable name="subProcessDiagramNode" select="./DiagramElementProperties/DiagramRefProperty[@name='diagramId']/DiagramRef"/>
									<xsl:variable name = "url" select = "concat($subProcessDiagramNode/@diagramType, '_', $subProcessDiagramNode/@id, '.html')"/>
									<option value="{concat($x, '|', $y, '|', $width, '|', $height, '|', $url, '|', $url-for-spec, '|', @id)}"><xsl:value-of select="$model_name"/> : <xsl:value-of select="$display_model_type"/></option>
								</xsl:when>
								<xsl:when test="$opt_drill_down='Open overview diagram page' and count(./DiagramElementProperties/DiagramRefProperty[@name='diagramId']/DiagramRef) &gt; 0">
									<xsl:variable name="overviewDiagramNode" select="./DiagramElementProperties/DiagramRefProperty[@name='diagramId']/DiagramRef"/>
									<xsl:variable name = "url" select = "concat($overviewDiagramNode/@diagramType, '_', $overviewDiagramNode/@id, '.html')"/>
									<option value="{concat($x, '|', $y, '|', $width, '|', $height, '|', $url, '|', $url-for-spec, '|', @id)}"><xsl:value-of select="$model_name"/> : <xsl:value-of select="$display_model_type"/></option>
								</xsl:when>
								<xsl:when test="$opt_drill_down='Open references' and count(./DiagramElementProperties/DiagramElementRefsProperty[@name='references']/*) + count(./DiagramElementProperties/ModelsProperty/Model[@modelType='Reference']) + count(./DiagramElementProperties/DiagramRefsProperty/DiagramRef) = 1">
									<xsl:variable name="refs_string">
										<xsl:value-of select="'javascript:'"/>
										
										<xsl:for-each select="./DiagramElementProperties/ModelsProperty/Model[@modelType='Reference']/ModelProperties/StringProperty[@name='type' and @value='File']">
											<xsl:value-of select="'window.open('"/>
											<xsl:text>'</xsl:text>
										  <xsl:variable name="convertedURL">
										    <xsl:call-template name="replaceChars">
										      <xsl:with-param name="s" select="concat('file:///', ../StringProperty[@name='url']/@value)"/>
										      <xsl:with-param name="charsIn" select="'\'"/>
										      <xsl:with-param name="charsOut" select="'/'"/>
										    </xsl:call-template>
										  </xsl:variable>
											<xsl:value-of select="$convertedURL"/>
											<xsl:text>','</xsl:text>
											<xsl:value-of select="'_blank'"/>
											<xsl:text>');void(0);</xsl:text>
										</xsl:for-each>
										
										<xsl:for-each select="./DiagramElementProperties/ModelsProperty/Model[@modelType='Reference']/ModelProperties/StringProperty[@name='type' and @value='Folder']">
											<xsl:value-of select="'window.open('"/>
											<xsl:text>'</xsl:text>
										  <xsl:variable name="convertedURL">
										    <xsl:call-template name="replaceChars">
										      <xsl:with-param name="s" select="concat('file:///', ../StringProperty[@name='url']/@value)"/>
										      <xsl:with-param name="charsIn" select="'\'"/>
										      <xsl:with-param name="charsOut" select="'/'"/>
										    </xsl:call-template>
										  </xsl:variable>
											<xsl:value-of select="$convertedURL"/>
											<xsl:text>','</xsl:text>
											<xsl:value-of select="'_blank'"/>
											<xsl:text>');void(0);</xsl:text>
										</xsl:for-each>
										
										<xsl:for-each select="./DiagramElementProperties/ModelsProperty/Model[@modelType='Reference']/ModelProperties/StringProperty[@name='type' and @value='URL']">
											<xsl:value-of select="'window.open('"/>
											<xsl:text>'</xsl:text>
										  <xsl:variable name="convertedURL">
										    <xsl:call-template name="replaceChars">
										      <xsl:with-param name="s" select="../StringProperty[@name='url']/@value"/>
										      <xsl:with-param name="charsIn" select="'\'"/>
										      <xsl:with-param name="charsOut" select="'/'"/>
										    </xsl:call-template>
										  </xsl:variable>
											<xsl:value-of select="$convertedURL"/>
											<xsl:text>','</xsl:text>
											<xsl:value-of select="'_blank'"/>
											<xsl:text>');void(0);</xsl:text>
										</xsl:for-each>
										
										<xsl:for-each select="./DiagramElementProperties/DiagramRefsProperty[@name='references']/DiagramRef">
											<xsl:value-of select="'window.open('"/>
											<xsl:text>'</xsl:text>
											<xsl:value-of select = "concat(@diagramType, '_', @id, '.html')"/>
											<xsl:text>','</xsl:text>
											<xsl:value-of select="'_content_pane'"/>
											<xsl:text>');</xsl:text>
										</xsl:for-each>
		
										<xsl:for-each select="./DiagramElementProperties/DiagramElementRefsProperty/DiagramElementRef">
											<xsl:variable name="isContentPageAvailable">
												<xsl:call-template name="isContentPageAvailable">
										      <xsl:with-param name="model_node" select="."/>
												</xsl:call-template>
											</xsl:variable>
											<xsl:if test="$isContentPageAvailable = 'true'">
												<xsl:value-of select="'window.open('"/>
												<xsl:text>'</xsl:text>
												<xsl:value-of select = "concat(@modelType, '_', @model, '.html')"/>
												<xsl:text>','</xsl:text>
												<xsl:value-of select="'_content_pane'"/>
												<xsl:text>');</xsl:text>
											</xsl:if>
										</xsl:for-each>
									</xsl:variable>

									<option value="{concat($x, '|', $y, '|', $width, '|', $height, '|', $refs_string, '|', $url-for-spec, '|', @id)}"><xsl:value-of select="$model_name"/> : <xsl:value-of select="$display_model_type"/></option>
								</xsl:when>
								<xsl:when test="$opt_drill_down='Open references' and count(./DiagramElementProperties/DiagramElementRefsProperty[@name='references']/*) + count(./DiagramElementProperties/ModelsProperty/Model[@modelType='Reference']) + count(./DiagramElementProperties/DiagramRefsProperty/DiagramRef) &gt; 1">
									<xsl:variable name = "url-for-imgmap" select = "'javascript:resetPopupForReference();showLinkPopup();'"/>
									<option value="{concat($x, '|', $y, '|', $width, '|', $height, '|', $url-for-imgmap, '|', $url-for-spec, '|', @id)}"><xsl:value-of select="$model_name"/> : <xsl:value-of select="$display_model_type"/></option>
								</xsl:when>
								<xsl:otherwise>
									<option value="{concat($x, '|', $y, '|', $width, '|', $height, '|', $url-for-spec, '|', $url-for-spec, '|', @id)}"><xsl:value-of select="$model_name"/> : <xsl:value-of select="$display_model_type"/></option>
								</xsl:otherwise>
							</xsl:choose>
						</xsl:for-each>
					</select>
				</td>
			</tr>
		</table>	
	</xsl:template>
	
	
	<xsl:template name="constructImage">
		<xsl:param name="r"/>
		<table>
			<tr>
				<td>
					<img id = "diagram" src = "{concat('../', $image_dir_name, '/', @imageFileName)}" usemap="#diagram_map" class="Image" width="{@imageWidth}" height="{@imageHeight}"/>
					<map name = "diagram_map">
						<xsl:for-each select=".//Shape[@shapeType != 'LostFoundMessageEnd' and @shapeType != 'Freehand' and @model != '']">
							<xsl:sort select="@zorder" data-type="number"/>
							
							<xsl:variable name="opt_drill_down">
								<xsl:choose>
									<xsl:when test="@modelType='BPSubProcess'">
										<xsl:value-of select="$opt_drill_down_effect_for_business_subprocess"/>
									</xsl:when>
									<xsl:when test="@modelType='PMProcess'">
										<xsl:value-of select="$opt_drill_down_effect_for_process_map_process"/>
									</xsl:when>
									<xsl:when test="@modelType='BPStartEvent'">
										<xsl:value-of select="$opt_drill_down_effect_for_bpmn_events"/>
									</xsl:when>
									<xsl:when test="@modelType='BPIntermediateEvent'">
										<xsl:value-of select="$opt_drill_down_effect_for_bpmn_events"/>
									</xsl:when>
									<xsl:when test="@modelType='BPEndEvent'">
										<xsl:value-of select="$opt_drill_down_effect_for_bpmn_events"/>
									</xsl:when>
									<xsl:when test="@modelType='InteractionOccurrence'">
										<xsl:value-of select="$opt_drill_down_effect_for_diagram_overview"/>
									</xsl:when>
									<xsl:when test="@modelType='DiagramOverview'">
										<xsl:value-of select="$opt_drill_down_effect_for_diagram_overview"/>
									</xsl:when>
									<xsl:otherwise>
										<xsl:value-of select="$opt_drill_down_effect_for_general_model"/>
									</xsl:otherwise>
								</xsl:choose>
							</xsl:variable>
							
							<xsl:variable name = "x" select = "@x * $r"/>
							<xsl:variable name = "y" select = "@y * $r"/>
							<xsl:variable name = "width" select = "$x + (@width * $r)"/>
							<xsl:variable name = "height" select = "$y + (@height * $r)"/>
							
							<xsl:variable name = "model_id" select = "@model"/>
							<xsl:variable name = "model_name" select = "@name"/>
							<xsl:variable name = "model_display_type" select = "@displayModelType"/>
							<xsl:variable name = "model_type" select = "@modelType"/>	
							<xsl:choose>
								<xsl:when test="$opt_drill_down='Open model specification page'">
									<xsl:variable name = "url">
										<xsl:call-template name="getTargetShapeURL">
							     		<xsl:with-param name="shape_node" select="."/>
										</xsl:call-template>
									</xsl:variable>
									<xsl:variable name = "alt" select = "concat($model_name, ' : ', $model_display_type)"/>
									<xsl:call-template name="printAreaElement">
							      <xsl:with-param name="shape_element" select="."/>
							      <xsl:with-param name="r" select="$r"/>
							      <xsl:with-param name="url" select="$url"/>
							      <xsl:with-param name="alt" select="$alt"/>
									</xsl:call-template>
								</xsl:when>
								<xsl:when test="$opt_drill_down='Open subdiagrams' and count(./SubDiagrams/DiagramRef)=1">
									<xsl:variable name="subDiagramNode" select="./SubDiagrams/DiagramRef"/>
									<xsl:variable name = "url" select = "concat($subDiagramNode/@diagramType, '_', $subDiagramNode/@id, '.html')"/>
									<xsl:variable name = "alt" select = "concat($model_name, ' : ', $model_display_type)"/>
									<xsl:call-template name="printAreaElement">
							      <xsl:with-param name="shape_element" select="."/>
							      <xsl:with-param name="r" select="$r"/>
							      <xsl:with-param name="url" select="$url"/>
							      <xsl:with-param name="alt" select="$alt"/>
									</xsl:call-template>
								</xsl:when>				
								<xsl:when test="$opt_drill_down='Open subdiagrams'and count(./SubDiagrams/DiagramRef) &gt; 1">
									<xsl:variable name = "url">
										<xsl:call-template name="getTargetShapeURL">
							     		<xsl:with-param name="shape_node" select="."/>
										</xsl:call-template>
									</xsl:variable>
									<xsl:variable name = "alt" select = "concat($model_name, ' : ', $model_display_type)"/>
									<xsl:call-template name="printAreaElement">
							      <xsl:with-param name="shape_element" select="."/>
							      <xsl:with-param name="r" select="$r"/>
							      <xsl:with-param name="url" select="$url"/>
							      <xsl:with-param name="alt" select="$alt"/>
							      <xsl:with-param name="showSubdiagramsPopupWhenClickOnShape" select="'true'"/>
									</xsl:call-template>
								</xsl:when>
								<xsl:when test="$opt_drill_down='Open process diagram page' and count(./DiagramElementProperties/DiagramRefProperty[@name='diagramId']/DiagramRef) &gt; 0">
									<xsl:variable name="subProcessDiagramNode" select="./DiagramElementProperties/DiagramRefProperty[@name='diagramId']/DiagramRef"/>
									<xsl:variable name = "url" select = "concat($subProcessDiagramNode/@diagramType, '_', $subProcessDiagramNode/@id, '.html')"/>
									<xsl:variable name = "alt" select = "concat($model_name, ' : ', $model_display_type)"/>
									<xsl:call-template name="printAreaElement">
							      <xsl:with-param name="shape_element" select="."/>
							      <xsl:with-param name="r" select="$r"/>
							      <xsl:with-param name="url" select="$url"/>
							      <xsl:with-param name="alt" select="$alt"/>
									</xsl:call-template>
								</xsl:when>
								<xsl:when test="$opt_drill_down='Open overview diagram page' and count(./DiagramElementProperties/DiagramRefProperty[@name='diagramId']/DiagramRef) &gt; 0">
									<xsl:variable name="overviewDiagramNode" select="./DiagramElementProperties/DiagramRefProperty[@name='diagramId']/DiagramRef"/>
									<xsl:variable name = "url" select = "concat($overviewDiagramNode/@diagramType, '_', $overviewDiagramNode/@id, '.html')"/>
									<xsl:variable name = "alt" select = "concat($model_name, ' : ', $model_display_type)"/>
									<xsl:call-template name="printAreaElement">
							      <xsl:with-param name="shape_element" select="."/>
							      <xsl:with-param name="r" select="$r"/>
							      <xsl:with-param name="url" select="$url"/>
							      <xsl:with-param name="alt" select="$alt"/>
									</xsl:call-template>
								</xsl:when>
								<xsl:when test="$opt_drill_down='Open references' and count(./DiagramElementProperties/DiagramElementRefsProperty[@name='references']/*) + count(./DiagramElementProperties/ModelsProperty/Model[@modelType='Reference']) + count(./DiagramElementProperties/DiagramRefsProperty[@name='references']/DiagramRef) = 1">
									<xsl:variable name="refs_string">
										<xsl:variable name="refs_string2">
											<xsl:value-of select="'javascript:'"/>
											
											<xsl:for-each select="./DiagramElementProperties/ModelsProperty/Model[@modelType='Reference']/ModelProperties/StringProperty[@name='type' and @value='File']">
												<xsl:value-of select="'window.open('"/>
												<xsl:text>'</xsl:text>
											  <xsl:variable name="convertedURL">
											    <xsl:call-template name="replaceChars">
											      <xsl:with-param name="s" select="concat('file:///', ../StringProperty[@name='url']/@value)"/>
											      <xsl:with-param name="charsIn" select="'\'"/>
											      <xsl:with-param name="charsOut" select="'/'"/>
											    </xsl:call-template>
											  </xsl:variable>
												<xsl:value-of select="$convertedURL"/>
												<xsl:text>','</xsl:text>
												<xsl:value-of select="'_blank'"/>
												<xsl:text>');void(0);</xsl:text>
											</xsl:for-each>
											
											<xsl:for-each select="./DiagramElementProperties/ModelsProperty/Model[@modelType='Reference']/ModelProperties/StringProperty[@name='type' and @value='Folder']">
												<xsl:value-of select="'window.open('"/>
												<xsl:text>'</xsl:text>
											  <xsl:variable name="convertedURL">
											    <xsl:call-template name="replaceChars">
											      <xsl:with-param name="s" select="concat('file:///', ../StringProperty[@name='url']/@value)"/>
											      <xsl:with-param name="charsIn" select="'\'"/>
											      <xsl:with-param name="charsOut" select="'/'"/>
											    </xsl:call-template>
											  </xsl:variable>
												<xsl:value-of select="$convertedURL"/>
												<xsl:text>','</xsl:text>
												<xsl:value-of select="'_blank'"/>
												<xsl:text>');void(0);</xsl:text>
											</xsl:for-each>
											
											<xsl:for-each select="./DiagramElementProperties/ModelsProperty/Model[@modelType='Reference']/ModelProperties/StringProperty[@name='type' and @value='URL']">
												<xsl:value-of select="'window.open('"/>
												<xsl:text>'</xsl:text>
											  <xsl:variable name="convertedURL">
											    <xsl:call-template name="replaceChars">
											      <xsl:with-param name="s" select="../StringProperty[@name='url']/@value"/>
											      <xsl:with-param name="charsIn" select="'\'"/>
											      <xsl:with-param name="charsOut" select="'/'"/>
											    </xsl:call-template>
											  </xsl:variable>
												<xsl:value-of select="$convertedURL"/>
												<xsl:text>','</xsl:text>
												<xsl:value-of select="'_blank'"/>
												<xsl:text>');void(0);</xsl:text>
											</xsl:for-each>
											
											<xsl:for-each select="./DiagramElementProperties/DiagramRefsProperty[@name='references']/DiagramRef">
												<xsl:value-of select="'window.open('"/>
												<xsl:text>'</xsl:text>
												<xsl:value-of select = "concat(@diagramType, '_', @id, '.html')"/>
												<xsl:text>','</xsl:text>
												<xsl:value-of select="'_content_pane'"/>
												<xsl:text>');</xsl:text>
											</xsl:for-each>
			
											<xsl:for-each select="./DiagramElementProperties/DiagramElementRefsProperty/DiagramElementRef">
												<xsl:variable name="isContentPageAvailable">
													<xsl:call-template name="isContentPageAvailable">
											      <xsl:with-param name="model_node" select="."/>
													</xsl:call-template>
												</xsl:variable>
												<xsl:if test="$isContentPageAvailable = 'true'">
													<xsl:value-of select="'window.open('"/>
													<xsl:text>'</xsl:text>
													<xsl:value-of select = "concat(@modelType, '_', @model, '.html')"/>
													<xsl:text>','</xsl:text>
													<xsl:value-of select="'_content_pane'"/>
													<xsl:text>');</xsl:text>
												</xsl:if>
											</xsl:for-each>
										</xsl:variable>
										<xsl:choose>
											<xsl:when test="$refs_string2='javascript:'">
												<xsl:text></xsl:text>
											</xsl:when>
											<xsl:otherwise>
												<xsl:value-of select="$refs_string2"/>
											</xsl:otherwise>
										</xsl:choose>
									</xsl:variable>
									
									<xsl:call-template name="printAreaElement">
							      <xsl:with-param name="shape_element" select="."/>
							      <xsl:with-param name="r" select="$r"/>
							      <xsl:with-param name="url" select="$refs_string"/>
							      <xsl:with-param name="alt" select="''"/>
									</xsl:call-template>
		
								</xsl:when>					
								<xsl:when test="$opt_drill_down='Open references' and count(./DiagramElementProperties/DiagramElementRefsProperty[@name='references']/*) + count(./DiagramElementProperties/ModelsProperty/Model[@modelType='Reference']) + count(./DiagramElementProperties/DiagramRefsProperty/DiagramRef) &gt; 1">
									<xsl:variable name = "url">
										<xsl:call-template name="getTargetShapeURL">
							     		<xsl:with-param name="shape_node" select="."/>
										</xsl:call-template>
									</xsl:variable>
									<xsl:variable name = "alt" select = "concat($model_name, ' : ', $model_display_type)"/>
									<xsl:call-template name="printAreaElement">
							      <xsl:with-param name="shape_element" select="."/>
							      <xsl:with-param name="r" select="$r"/>
							      <xsl:with-param name="url" select="$url"/>
							      <xsl:with-param name="alt" select="$alt"/>
							      <xsl:with-param name="showReferencesPopupWhenClickOnShape" select="'true'"/>
									</xsl:call-template>
								</xsl:when>
								<xsl:otherwise>
									<xsl:variable name = "url">
										<xsl:call-template name="getTargetShapeURL">
							     		<xsl:with-param name="shape_node" select="."/>
										</xsl:call-template>
									</xsl:variable>
									<xsl:variable name = "alt" select = "concat($model_name, ' : ', $model_display_type)"/>
									<xsl:call-template name="printAreaElement">
							      <xsl:with-param name="shape_element" select="."/>
							      <xsl:with-param name="r" select="$r"/>
							      <xsl:with-param name="url" select="$url"/>
							      <xsl:with-param name="alt" select="$alt"/>
									</xsl:call-template>
								</xsl:otherwise>
							</xsl:choose>
						</xsl:for-each>
					</map>
				</td>
			</tr>
		</table>
		<p/>
	</xsl:template>
	
	<xsl:template name="getTargetShapeURL">
		<xsl:param name = "shape_node"/>
		<xsl:choose>
			<xsl:when test="$shape_node/@modelType='Attribute'">
				<xsl:value-of select = "concat($shape_node/../../@modelType, '_', $shape_node/../../@model, '.html#', $shape_node/@model)"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select = "concat($shape_node/@modelType, '_', $shape_node/@model, '.html')"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<!-- Comments table -->
	<xsl:template name="printDiagramCommentTable">
		<xsl:if test="count(./DiagramComments/DiagramComment) > 0" >
			<p/>
			<table width = "100%" border="0" cellpadding="0" cellspacing="0">
				<tr><td class="Category"><xsl:value-of select="$st_Comments"/></td></tr>
				<tr><td style="height: 5px"></td></tr>
			</table>

			<!--  each comment is a table -->
			<xsl:for-each select="./DiagramComments/DiagramComment">
				<!-- place the anchor name here -->
				<a name="{@id}"/>
				
				<table width = "100%" border="0" cellpadding="0" cellspacing="0">
					<tr><td style="height: 5px"></td></tr>
				</table>
				<table width="100%"  border="0" cellpadding="0" cellspacing="0">
					<tr><td class="TableHeaderLine" colspan="4"/></tr>
					<tr><td class="TableHeaderLine1" colspan="4"/></tr>
					<tr class="TableHeader">
						<td style="width: 10px"/>
						<td width="25%"><span class="TableHeaderText"><xsl:value-of select="$st_Name"/></span></td>
						<td style="width: 20px"/>
						<td><span class="TableHeaderText"><xsl:value-of select="$st_Value"/></span></td>
					</tr>
					<tr><td class="TableHeaderLine2" colspan="4"/></tr>
					
					<xsl:for-each select="./DiagramCommentProperties/*[(@value != '' and @name!='modelType') ]">
						<tr>
							<xsl:choose>
								<xsl:when test="position() mod 2 = 1">
									<xsl:attribute name="class">TableRow1</xsl:attribute> 
								</xsl:when>
								<xsl:otherwise>
									<xsl:attribute name="class">TableRow2</xsl:attribute> 
								</xsl:otherwise>
							</xsl:choose>
							<xsl:choose>
								<xsl:when test="@name = 'content'">
									<td/>
									<td><span class="TableContent"><xsl:value-of select="@displayName" /></span></td>
									<td/>
									<td><span class="TableContent"><xsl:value-of select="@rtfValue" disable-output-escaping="yes"/></span></td>
								</xsl:when>
								<xsl:otherwise>
									<td/>
									<td><span class="TableContent"><xsl:value-of select="@displayName" /></span></td>
									<td/>
									<td><span class="TableContent"><xsl:value-of select="@value" disable-output-escaping="yes"/></span></td>
								</xsl:otherwise>
							</xsl:choose>
						</tr>
					</xsl:for-each>
				</table>
				<table width = "100%" border="0" cellpadding="0" cellspacing="0">
					<tr><td style="height: 1px"/></tr>
					<tr><td class="TableFooter"/></tr>
				</table>
				<p/>
			</xsl:for-each>
		</xsl:if>
	</xsl:template>		
		
</xsl:stylesheet>
