<?xml version="1.0" encoding="UTF-8"?>
<!DOCTYPE xsl:stylesheet [<!ENTITY nbsp "&#160;">]>

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:redirect="http://xml.apache.org/xalan/redirect"
    xmlns:xalan="http://xml.apache.org/xalan"
    extension-element-prefixes="redirect"
    exclude-result-prefixes="xalan"
    version="1.0"
>

	
	<xsl:template name="printGeneralDiagramContentPage" match="Diagram">
		<xsl:variable name="r" select="@imageScale"/>
		<xsl:if test="$opt_is_display_jump_to='true'">
			<xsl:call-template name="constructJumpToDropDownMenu">
				<xsl:with-param name="r" select="$r"/>
			</xsl:call-template>
		</xsl:if>
		<xsl:call-template name="constructImage">
			<xsl:with-param name="r" select="$r"/>
		</xsl:call-template>
		
		<!-- print the diagram documentation (if any) -->
		<xsl:if test="@documentation != ''">
			<p>
				<table width="100%"  border="0" cellpadding="0" cellspacing="0">
					<tr><td><span class="TableContent"><xsl:value-of select="@rtfDocumentation" disable-output-escaping="yes"/></span></td></tr>
				</table>
			</p>
		</xsl:if>

		<!-- print the models summary -->
		<xsl:if test="$opt_is_generate_model_list_in_diagram_page='true'">
			<table width = "100%" border="0" cellpadding="0" cellspacing="0">
				<tr><td class="Category"><xsl:value-of select="$st_Models"/></td></tr>
				<tr><td style="height: 5px"></td></tr>
			</table> 
			<table width = "100%" border="0" cellpadding="0" cellspacing="0">
				<tr><td class="TableHeaderLine" colspan="4"/></tr>
				<tr><td class="TableHeaderLine1" colspan="4"/></tr>
				<tr class="TableHeader">
					<td style="width: 10px"/>
					<td width="30%"><span class="TableHeaderText"><xsl:value-of select="$st_Name"/></span></td>
					<td style="width: 20px"/>
					<td><span class="TableHeaderText"><xsl:value-of select="$st_Documentation"/></span></td>
				</tr>
				<tr><td class="TableHeaderLine2" colspan="4"/></tr>
				<xsl:for-each select="./Shapes//Shape[@shapeType != 'LostFoundMessageEnd' and @model != '' and @shapeType != 'Callout' and @shapeType != 'Rectangle' and @shapeType != 'Oval' and @shapeType != 'Polygon' and @shapeType != 'Freehand']">
					<xsl:sort select="@shapeType"/>
					<xsl:variable name = "model_id" select = "@model"/>
					<tr>
						<xsl:choose>
							<xsl:when test="position() mod 2 = 1">
								<xsl:attribute name="class">TableRow1</xsl:attribute> 
							</xsl:when>
							<xsl:otherwise>
								<xsl:attribute name="class">TableRow2</xsl:attribute> 
							</xsl:otherwise>
						</xsl:choose>
						<td style="width: 10px"/>
						<td><span class="TableContent">
						<xsl:choose>
							<xsl:when test="@name = '' and @modelType = 'InteractionLifeLine' and @classifier != ''">
								<div style="float: left; width: 18px !important;height: 18px !important;background-image:url({concat('../', $icon_dir_relative_path, '/', @modelType, '.png')}) !important; background-image:url(''); filter:progid:DXImageTransform.Microsoft.AlphaImageLoader(src='{concat('../', $icon_dir_relative_path, '/', @modelType, '.png')}');"/>&nbsp;
								<a href = "{concat(@modelType, '_', @model, '.html')}" target = "{@CONTENT_PANE_NAME}" class="ItemLink">
									:<xsl:value-of select="@classifier"/> : <xsl:value-of select="@displayModelType"/>
								</a>
							</xsl:when>
							<xsl:when test="@modelType = 'GraphicShape' and @graphicShapeType != ''">
								<div style="float: left; width: 18px !important;height: 18px !important;background-image:url({concat('../', $icon_dir_relative_path, '/', @modelType, @graphicShapeType, '.png')}) !important; background-image:url(''); filter:progid:DXImageTransform.Microsoft.AlphaImageLoader(src='{concat('../', $icon_dir_relative_path, '/', @modelType, @graphicShapeType, '.png')}');"/>&nbsp;
								<a href = "{concat(@modelType, '_', @model, '.html')}" target = "{@CONTENT_PANE_NAME}" class="ItemLink">
									<xsl:value-of select="@name"/> : <xsl:value-of select="@displayModelType"/>
								</a>
							</xsl:when>
							<xsl:when test="@gatewayType != ''">
								<div style="float: left; width: 18px !important;height: 18px !important;background-image:url({concat('../', $icon_dir_relative_path, '/', @modelType, '.png')}) !important; background-image:url(''); filter:progid:DXImageTransform.Microsoft.AlphaImageLoader(src='{concat('../', $icon_dir_relative_path, '/', @modelType, '.png')}');"/>&nbsp;
								<a href = "{concat(@modelType, '_', @model, '.html')}" target = "{@CONTENT_PANE_NAME}" class="ItemLink">
									<xsl:value-of select="@name"/> : <xsl:value-of select="@gatewayType"/>
								</a>
							</xsl:when>
							<xsl:when test="@taskType != ''">
								<div style="float: left; width: 18px !important;height: 18px !important;background-image:url({concat('../', $icon_dir_relative_path, '/', @modelType, '.png')}) !important; background-image:url(''); filter:progid:DXImageTransform.Microsoft.AlphaImageLoader(src='{concat('../', $icon_dir_relative_path, '/', @modelType, '.png')}');"/>&nbsp;
								<a href = "{concat(@modelType, '_', @model, '.html')}" target = "{@CONTENT_PANE_NAME}" class="ItemLink">
									<xsl:value-of select="@name"/> : <xsl:value-of select="@taskType"/>
								</a>
							</xsl:when>
							<xsl:when test="@subProcessType != ''">
								<div style="float: left; width: 18px !important;height: 18px !important;background-image:url({concat('../', $icon_dir_relative_path, '/', @modelType, '.png')}) !important; background-image:url(''); filter:progid:DXImageTransform.Microsoft.AlphaImageLoader(src='{concat('../', $icon_dir_relative_path, '/', @modelType, '.png')}');"/>&nbsp;
								<a href = "{concat(@modelType, '_', @model, '.html')}" target = "{@CONTENT_PANE_NAME}" class="ItemLink">
									<xsl:value-of select="@name"/> : <xsl:value-of select="@subProcessType"/>
								</a>
							</xsl:when>
							<xsl:when test="@triggerType != ''">
								<div style="float: left; width: 18px !important;height: 18px !important;background-image:url({concat('../', $icon_dir_relative_path, '/', @modelType, '.png')}) !important; background-image:url(''); filter:progid:DXImageTransform.Microsoft.AlphaImageLoader(src='{concat('../', $icon_dir_relative_path, '/', @modelType, '.png')}');"/>&nbsp;
								<a href = "{concat(@modelType, '_', @model, '.html')}" target = "{@CONTENT_PANE_NAME}" class="ItemLink">
									<xsl:value-of select="@name"/> : <xsl:value-of select="@triggerType"/>
								</a>
							</xsl:when>
							<xsl:when test="@resultType != ''">
								<div style="float: left; width: 18px !important;height: 18px !important;background-image:url({concat('../', $icon_dir_relative_path, '/', @modelType, '.png')}) !important; background-image:url(''); filter:progid:DXImageTransform.Microsoft.AlphaImageLoader(src='{concat('../', $icon_dir_relative_path, '/', @modelType, '.png')}');"/>&nbsp;
								<a href = "{concat(@modelType, '_', @model, '.html')}" target = "{@CONTENT_PANE_NAME}" class="ItemLink">
									<xsl:value-of select="@name"/> : <xsl:value-of select="@resultType"/>
								</a>
							</xsl:when>
							<xsl:otherwise>
								<div style="float: left; width: 18px !important;height: 18px !important;background-image:url({concat('../', $icon_dir_relative_path, '/', @modelType, '.png')}) !important; background-image:url(''); filter:progid:DXImageTransform.Microsoft.AlphaImageLoader(src='{concat('../', $icon_dir_relative_path, '/', @modelType, '.png')}');"/>&nbsp;
								<a href = "{concat(@modelType, '_', @model, '.html')}" target = "{@CONTENT_PANE_NAME}" class="ItemLink">
									<xsl:value-of select="@name"/> : <xsl:value-of select="@displayModelType"/>
								</a>
							</xsl:otherwise>
						</xsl:choose>
						</span></td>
						<td style="width: 20px"/>
						<td><span class="TableContent"><xsl:value-of select="@documentation" disable-output-escaping="yes"/>&nbsp;</span></td>
					</tr>
				</xsl:for-each>
			</table>
			<table width = "100%" border="0" cellpadding="0" cellspacing="0">
				<tr><td style="height: 1px"/></tr>
				<tr><td class="TableFooter"/></tr>
			</table>
		</xsl:if>
		
		<!-- Comments detail -->
		<xsl:call-template name="printDiagramCommentTable"/>
			
	</xsl:template>
	
</xsl:stylesheet>
