<?xml version="1.0" encoding="UTF-8"?>
<!DOCTYPE xsl:stylesheet [<!ENTITY nbsp "&#160;">]>

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:redirect="http://xml.apache.org/xalan/redirect"
    xmlns:xalan="http://xml.apache.org/xalan"
    extension-element-prefixes="redirect"
    exclude-result-prefixes="xalan"
    version="1.0"
>
	
	<xsl:template match="Diagram[@diagramType='ERDiagram']">
		<xsl:variable name="r" select="@imageScale"/>
		<xsl:if test="$opt_is_display_jump_to='true'">
			<xsl:call-template name="constructJumpToDropDownMenu">
				<xsl:with-param name="r" select="$r"/>
			</xsl:call-template>
		</xsl:if>
		<xsl:call-template name="constructImage">
			<xsl:with-param name="r" select="$r"/>
		</xsl:call-template>
		
		<!-- print the diagram documentation (if any) -->
		<xsl:if test="@documentation != ''">
			<p>
				<table width="100%"  border="0" cellpadding="0" cellspacing="0">
					<tr><td><span class="TableContent"><xsl:value-of select="@rtfDocumentation" disable-output-escaping="yes"/></span></td></tr>
				</table>
			</p>
		</xsl:if>
		
		<!-- print the database table summary -->
		<p/>
		<table width = "100%" border="0" cellpadding="0" cellspacing="0">
			<tr><td class="Category">Database Tables</td></tr>
			<tr><td style="height: 5px"></td></tr>
		</table>
		<table width = "100%" border="0" cellpadding="0" cellspacing="0">
			<tr><td class="TableHeaderLine" colspan="4"/></tr>
			<tr><td class="TableHeaderLine1" colspan="4"/></tr>
			<tr class="TableHeader">
				<td style="width: 10px"/>
				<td width="30%"><span class="TableHeaderText"><xsl:value-of select="$st_Name"/></span></td>
				<td style="width: 20px"/>
				<td><span class="TableHeaderText"><xsl:value-of select="$st_Documentation"/></span></td>
			</tr>
			<tr><td class="TableHeaderLine2" colspan="4"/></tr>
			<xsl:for-each select="./Shapes//Shape[@shapeType = 'DBTable']">
				<xsl:variable name = "model_id" select = "@model"/>
				<tr>
					<xsl:choose>
						<xsl:when test="position() mod 2 = 1">
							<xsl:attribute name="class">TableRow1</xsl:attribute> 
						</xsl:when>
						<xsl:otherwise>
							<xsl:attribute name="class">TableRow2</xsl:attribute> 
						</xsl:otherwise>
					</xsl:choose>
					<td style="width: 10px"/>
					<td>
					<span class="TableContent">
						<div style="float: left; width: 18px !important;height: 18px !important;background-image:url({concat('../', $icon_dir_relative_path, '/', @modelType, '.png')}) !important; background-image:url(''); filter:progid:DXImageTransform.Microsoft.AlphaImageLoader(src='{concat('../', $icon_dir_relative_path, '/', @modelType, '.png')}');"/>&nbsp;
						<a href = "{concat(@modelType, '_', @model, '.html')}" target = "{@CONTENT_PANE_NAME}" class="ItemLink">
							<xsl:value-of select="@name"/> : <xsl:value-of select="@displayModelType"/>
						</a>
					</span></td>
					<td style="width: 20px"/>
						<td><span class="TableContent"><xsl:value-of select="@documentation" disable-output-escaping="yes"/>&nbsp;</span></td>
				</tr>
			</xsl:for-each>
		</table>
		<table width = "100%" border="0" cellpadding="0" cellspacing="0">
			<tr><td style="height: 1px"/></tr>
			<tr><td class="TableFooter"/></tr>
		</table>
		<p/>
		
		<!-- print the columns spec. -->
		<xsl:for-each select="./Shapes//Shape[@shapeType = 'DBTable']">
			<xsl:variable name="table_node" select="."/>
			<p/>
			<table width = "100%" border="0" cellpadding="0" cellspacing="0">
				<tr><td class="Category"><a name="{@model}"/><xsl:value-of select="@name"/> Table</td></tr>
				<tr><td style="height: 5px"></td></tr>
			</table>
			<table width = "100%" border="0" cellpadding="0" cellspacing="0">
				<tr><td class="TableHeaderLine" colspan="10"/></tr>
				<tr><td class="TableHeaderLine1" colspan="10"/></tr>
				<tr class="TableHeader">
					<td style="width: 10px"/>
					<td width="15%"><span class="TableHeaderText"><xsl:value-of select="$st_Column_Name"/></span></td>
					<td style="width: 20px"/>
					<td width="10%"><span class="TableHeaderText"><xsl:value-of select="$st_Data_Type"/></span></td>
					<td style="width: 20px"/>
					<td width="7%"><span class="TableHeaderText">PK / FK</span></td>
					<td style="width: 20px"/>
					<td width="5%"><span class="TableHeaderText"><xsl:value-of select="$st_Nullable"/></span></td>
					<td style="width: 20px"/>
					<td width="*"><span class="TableHeaderText"><xsl:value-of select="$st_Documentation"/></span></td>
				</tr>
				<tr><td class="TableHeaderLine2" colspan="10"/></tr>
				<xsl:for-each select="./Models/Model[@modelType = 'DBColumn']">
					<tr>
						<xsl:choose>
							<xsl:when test="position() mod 2 = 1">
								<xsl:attribute name="class">TableRow1</xsl:attribute> 
							</xsl:when>
							<xsl:otherwise>
								<xsl:attribute name="class">TableRow2</xsl:attribute> 
							</xsl:otherwise>
						</xsl:choose>
						<td style="width: 10px"/>
						<td><span class="TableContent">
							<a href = "{concat($table_node/@modelType, '_', $table_node/@model, '.html', '#', @id)}" target = "{@CONTENT_PANE_NAME}" class="ItemLink">
								<xsl:value-of select="@name"/>
							</a>
						</span></td>
						<td style="width: 20px"/>
						<xsl:variable name="type" select="concat(./ModelProperties/StringProperty[@name='type']/@value, '(', ./ModelProperties/IntegerProperty[@name='length']/@value, ')')"/>
						<td><span class="TableContent"><xsl:value-of select="$type"/></span></td>
						<td style="width: 20px"/>
						<xsl:choose>
							<xsl:when test="./ModelProperties/BooleanProperty[@name='primaryKey']/@value = 'true'">
								<td><span class="TableContent">PK
								<xsl:if test="count(./ModelProperties/ModelsProperty[@name='foreignKeyConstraints']/Model) > 0">
									 / FK
								</xsl:if>
								</span></td>
							</xsl:when>
							<xsl:otherwise>
								<td><span class="TableContent">
									<xsl:if test="count(./ModelProperties/ModelsProperty[@name='foreignKeyConstraints']/Model) > 0">
										FK
									</xsl:if>
								</span></td>
							</xsl:otherwise>
						</xsl:choose>
						<td style="width: 20px"/>
						<xsl:choose>
							<xsl:when test="./ModelProperties/BooleanProperty[@name='nullable']/@value = 'true'">
								<td><span class="TableContent"><xsl:value-of select="$st_Yes"/></span></td>
							</xsl:when>
							<xsl:otherwise>
								<td><span class="TableContent"><xsl:value-of select="$st_No"/></span></td>
							</xsl:otherwise>
						</xsl:choose>
						<td style="width: 20px"/>
						<td><span class="TableContent"><xsl:value-of select="./ModelProperties/HTMLProperty[@name='documentation']/@value" disable-output-escaping="yes"/>&nbsp;</span></td>
					</tr>
				</xsl:for-each>
			</table>
			<table width = "100%" border="0" cellpadding="0" cellspacing="0">
				<tr><td style="height: 1px"/></tr>
				<tr><td class="TableFooter"/></tr>
			</table>
			<p/>
		</xsl:for-each>
				
		<!-- Comments detail -->
		<xsl:call-template name="printDiagramCommentTable"/>
	</xsl:template>
	
</xsl:stylesheet>
